/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.router.tasks;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.router.tasks.RoutedTask;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.transaction.ServerTransaction;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;

public abstract class RequestRoutedTask
extends RoutedTask {
    private static final LogMgr c_logger = Log.get(RequestRoutedTask.class);
    protected SipServletRequestImpl _request;
    protected ServerTransaction _serverTransaction;

    public RequestRoutedTask(TransactionUserWrapper transactionUser, SipServletRequestImpl request, ServerTransaction serverTransaction) {
        super(transactionUser);
        this._request = request;
        this._serverTransaction = serverTransaction;
    }

    @Override
    public String getMethod() {
        return this._request.getMethod();
    }

    public boolean isAck() {
        return this._request.getMethod().equals("ACK");
    }

    public SipServletRequestImpl getRequest() {
        return this._request;
    }

    @Override
    protected void doTask() {
        if (this._transactionUser.isTransactionUserInvalidated() || this._transactionUser.isInvalidating()) {
            if (this.isAck()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "doTask", "ACK request (callid=" + this._request.getCallId() + ")will not be processed since " + this._transactionUser + " was already invalidated");
                }
                return;
            }
            SipRouter.sendErrorResponse(this._request, 481);
        } else {
            this._request.setTransactionUser(this._transactionUser);
            this._serverTransaction.setTransactionListener(this._transactionUser);
            this._serverTransaction.processRequest(this._request);
        }
    }
}

