/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.rules;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.rules.Condition;
import com.ibm.ws.sip.container.rules.PhoneComparison;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TelURL;
import javax.servlet.sip.URI;

public abstract class Operator
implements Condition {
    private static final LogMgr c_logger = Log.get(Operator.class);
    private static final String PHONE = "phone";
    private static final String SCHEME_SIP = "sip";
    private static final String SCHEME_TEL = "tel";
    private static final String URI = ".uri";
    private static final String SCHEME = ".scheme";
    private static final String USER = ".user";
    private static final String HOST = ".host";
    private static final String PORT = ".port";
    private static final String TEL = ".tel";
    private static final String PARAM = ".param";
    private static final String DISPLAY_NAME = ".display-name";
    private static final String REQUEST_TO = "request.to";
    private static final String REQUEST_FROM = "request.from";
    private static final String REQUEST_URI = "request.uri";
    private static final String REQUEST_METHOD = "request.method";
    private static final String REQUEST_HEADER_PREFIX = "request.header.";
    private static final String REQUEST_ADDRESS_PREFIX = "request.address.";
    private final String m_var;

    protected Operator(String var) {
        this.m_var = var;
    }

    protected String getVariable() {
        return this.m_var;
    }

    protected Object getObjectForVar(String varParam, SipServletRequest req) {
        String var;
        Object rValue;
        block30: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{varParam, req.getMethod()};
                c_logger.traceEntry((Object)this, "getObjectForVar", params);
            }
            rValue = null;
            var = varParam.toLowerCase();
            if (var.equals(REQUEST_METHOD)) {
                rValue = req.getMethod();
            } else if (var.startsWith(REQUEST_URI)) {
                String suffix = var.substring(REQUEST_URI.length());
                rValue = this.getObjectForVar(req.getRequestURI(), suffix, varParam);
            } else if (var.startsWith(REQUEST_FROM)) {
                String suffix = var.substring(REQUEST_FROM.length());
                rValue = this.getObjectForVar(req.getFrom(), suffix, varParam);
            } else if (var.startsWith(REQUEST_TO)) {
                String suffix = var.substring(REQUEST_TO.length());
                rValue = this.getObjectForVar(req.getTo(), suffix, varParam);
            } else {
                if (var.startsWith(REQUEST_ADDRESS_PREFIX)) {
                    String componentName;
                    String headerName;
                    boolean top;
                    String suffix = var.substring(REQUEST_ADDRESS_PREFIX.length());
                    int dot = suffix.indexOf(46);
                    int end = suffix.length();
                    if (dot < 1) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("error in servlet descriptor - no scope specified in variable [" + var + ']');
                        }
                        return null;
                    }
                    String scopeSuffix = suffix.substring(0, dot);
                    if (scopeSuffix.equalsIgnoreCase("top")) {
                        top = true;
                    } else if (scopeSuffix.equalsIgnoreCase("any")) {
                        top = false;
                    } else {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("error in servlet descriptor - unknown scope specified in variable [" + var + ']');
                        }
                        return null;
                    }
                    suffix = suffix.substring(dot + 1, end);
                    dot = suffix.indexOf(46);
                    end = suffix.length();
                    if (dot < 1) {
                        headerName = suffix;
                        componentName = "";
                    } else {
                        headerName = suffix.substring(0, dot);
                        componentName = suffix.substring(dot, end);
                    }
                    try {
                        LinkedList<Object> addresses;
                        if (top) {
                            Address header = req.getAddressHeader(headerName);
                            rValue = header == null ? null : this.getObjectForVar(header, componentName, varParam);
                            break block30;
                        }
                        ListIterator iHeader = req.getAddressHeaders(headerName);
                        if (iHeader.hasNext()) {
                            addresses = new LinkedList<Object>();
                            while (iHeader.hasNext()) {
                                Address header = (Address)iHeader.next();
                                Object address = this.getObjectForVar(header, componentName, varParam);
                                addresses.add(address);
                            }
                        } else {
                            addresses = null;
                        }
                        rValue = addresses;
                    }
                    catch (ServletParseException e2) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "getObjectForVar", "ServletParseException", (Throwable)((Object)e2));
                        }
                        break block30;
                    }
                }
                if (var.startsWith(REQUEST_HEADER_PREFIX)) {
                    String headerSuffix = var.substring(REQUEST_HEADER_PREFIX.length());
                    rValue = req.getHeader(headerSuffix);
                } else if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{var};
                    c_logger.error("error.invalid.operator.var", "Request", args);
                }
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buffer = new StringBuffer(16);
            buffer.append("Var: ");
            buffer.append(var);
            buffer.append(", Value:");
            buffer.append(rValue);
            c_logger.traceDebug(this, "getObjectForVar", buffer.toString());
        }
        return rValue;
    }

    private Object getObjectForVar(Address address, String suffix, String fullVar) {
        Object rValue = null;
        if (suffix.length() == 0) {
            rValue = address.toString();
        } else if (suffix.equals(DISPLAY_NAME)) {
            rValue = address.getDisplayName();
        } else if (suffix.startsWith(URI)) {
            String suffix2 = suffix.substring(URI.length());
            rValue = this.getObjectForVar(address.getURI(), suffix2, fullVar);
        } else if (c_logger.isErrorEnabled()) {
            Object[] args = new Object[]{fullVar};
            c_logger.error("error.invalid.operator.var", "Request", args);
        }
        return rValue;
    }

    private Object getObjectForVar(URI requestURI, String suffix, String fullVar) {
        Object rValue = null;
        if (suffix.length() == 0) {
            rValue = requestURI.toString();
        } else if (suffix.equals(SCHEME)) {
            rValue = requestURI.getScheme().toLowerCase();
        } else if (suffix.equals(USER)) {
            if (requestURI.isSipURI()) {
                rValue = ((SipURI)requestURI).getUser();
            }
        } else if (suffix.equals(HOST)) {
            if (requestURI.isSipURI()) {
                rValue = ((SipURI)requestURI).getHost();
            }
        } else if (suffix.equals(PORT)) {
            rValue = this.getPort(requestURI);
        } else if (suffix.equals(TEL)) {
            rValue = this.getTelephoneNumber(requestURI);
        } else if (suffix.startsWith(PARAM)) {
            String param = suffix.substring(PARAM.length() + 1);
            rValue = this.getParam(requestURI, param);
        } else if (c_logger.isErrorEnabled()) {
            Object[] args = new Object[]{fullVar};
            c_logger.error("error.invalid.operator.var", "Request", args);
        }
        return rValue;
    }

    private String getParam(URI uri, String param) {
        String rValue = null;
        if (uri.isSipURI()) {
            rValue = ((SipURI)uri).getParameter(param);
        } else if (uri.getScheme().equalsIgnoreCase(SCHEME_TEL)) {
            rValue = ((TelURL)uri).getParameter(param);
        }
        return rValue;
    }

    private String getPort(URI uri) {
        String rValue = null;
        if (uri.isSipURI()) {
            int port = ((SipURI)uri).getPort();
            rValue = port < 0 ? (uri.getScheme().equalsIgnoreCase(SCHEME_SIP) ? "5060" : "5061") : Integer.toString(port);
        }
        return rValue;
    }

    private PhoneComparison getTelephoneNumber(URI uri) {
        if (uri.isSipURI()) {
            SipURI sipURI = (SipURI)uri;
            if (PHONE.equals(sipURI.getUserParam())) {
                try {
                    return new PhoneComparison(sipURI.getUser());
                }
                catch (IllegalArgumentException e2) {
                    return null;
                }
            }
        } else if (uri instanceof TelURL) {
            return new PhoneComparison(((TelURL)uri).getPhoneNumber());
        }
        return null;
    }

    @Override
    public boolean evaluate(SipServletRequest request) {
        Object value = this.getObjectForVar(this.m_var, request);
        return this.evaluate(value);
    }

    private boolean evaluate(Object value) {
        if (value == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "evaluate", "null value evaluated to false");
            }
            return false;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            for (Object o : values) {
                if (!this.evaluate(o)) continue;
                return true;
            }
            return false;
        }
        if (value instanceof PhoneComparison) {
            PhoneComparison phone = (PhoneComparison)value;
            return this.evaluate(phone);
        }
        String string = value.toString();
        return this.evaluate(string);
    }

    protected abstract boolean evaluate(String var1);

    protected abstract boolean evaluate(PhoneComparison var1);
}

