/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.router.SipAppDescManager;
import com.ibm.ws.sip.container.util.SipLogExtension;
import com.ibm.ws.webcontainer.osgi.metadata.WebModuleMetaDataImpl;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(configurationPolicy=ConfigurationPolicy.IGNORE, configurationPid={"com.ibm.ws.sip.container.was.SipModuleMetadataListener"}, service={ModuleMetaDataListener.class}, property={"service.vendor=IBM"})
public class SipModuleMetadataListener
implements ModuleMetaDataListener {
    private static final TraceComponent tc = Tr.register(SipModuleMetadataListener.class);
    private SipAppDescManager _appDescMangar = null;

    protected void activate(ComponentContext context, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"activated", (Object[])new Object[]{properties});
        }
        this._appDescMangar = SipAppDescManager.getInstance();
    }

    public void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SipModuleMetadataListener deactivated, reason=" + reason), (Object[])new Object[0]);
        }
        this._appDescMangar = null;
    }

    protected void modified(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"modified", (Object[])new Object[]{properties});
        }
    }

    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) {
        ModuleMetaData metaData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"moduleMetaDataCreated start", (Object[])new Object[0]);
        }
        if ((metaData = (ModuleMetaData)event.getMetaData()) instanceof WebModuleMetaDataImpl) {
            WebModuleMetaDataImpl webMetaData = (WebModuleMetaDataImpl)metaData;
            WebAppConfiguration webConfig = (WebAppConfiguration)webMetaData.getConfiguration();
            WebApp webApp = webConfig.getWebApp();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("moduleMetaDataCreated looking for app name: " + webApp.getName()), (Object[])new Object[0]);
            }
            SipAppDesc appDesc = this._appDescMangar.updateWebApp(webApp);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("moduleMetaDataCreated got appDesc: " + appDesc), (Object[])new Object[0]);
            }
            if (appDesc == null) {
                return;
            }
            SipContainer sipCon = SipContainer.getInstance();
            if (sipCon.getRouter().isInitialized()) {
                sipCon.getRouter().loadAppConfiguration(webApp);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"moduleMetaDataCreated done installing app", (Object[])new Object[]{webApp.getName()});
            }
        }
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        ModuleMetaData metaData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"moduleMetaDataDestoyed start", (Object[])new Object[0]);
        }
        if ((metaData = (ModuleMetaData)event.getMetaData()) instanceof WebModuleMetaDataImpl) {
            WebModuleMetaDataImpl webMetaData = (WebModuleMetaDataImpl)metaData;
            WebAppConfiguration webConfig = (WebAppConfiguration)webMetaData.getConfiguration();
            WebApp webApp = webConfig.getWebApp();
            this._appDescMangar.removeApp(webApp);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"moduleMetaDataDestoyed removed app: ", (Object[])new Object[]{webApp.getName()});
            }
        }
        if (this._appDescMangar.getSipAppDescs().size() == 0) {
            PerformanceMgr perfMgr;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"stopping", (Object[])new Object[]{"setting server weight to 0"});
            }
            if ((perfMgr = PerformanceMgr.getInstance()) != null) {
                perfMgr.setServerWeight(0);
                perfMgr.stopTimers();
            }
            SipLogExtension.destroy();
        }
    }
}

