/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.dar.selector.impl;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.dar.ext.SipApplicationRouterInfoStrartOrder;
import com.ibm.ws.sip.dar.selector.ApplicationSelector;
import com.ibm.ws.sip.dar.util.StateInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;

public class StartOrderApplicationSelector
implements ApplicationSelector {
    private static final LogMgr c_logger = Log.get(StartOrderApplicationSelector.class);
    private SipApplicationRouterInfo nullApplication = new SipApplicationRouterInfo(null, null, null, null, null, null);
    private List<SipApplicationRouterInfoStrartOrder> appInfoList = new ArrayList<SipApplicationRouterInfoStrartOrder>();

    public StartOrderApplicationSelector(List<SipApplicationRouterInfoStrartOrder> appInfoList) {
        this.appInfoList = appInfoList;
    }

    @Override
    public SipApplicationRouterInfo getNextApplication(SipServletRequest initialRequest, SipApplicationRoutingRegion region, SipApplicationRoutingDirective directive, Serializable stateInfo) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("getNextApplication: ");
        }
        SipApplicationRouterInfo nextApplicationForMatch = null;
        nextApplicationForMatch = ((SipServletRequestImpl)initialRequest).isAppInvoked116Type() ? this.findApplicationAccordingJSR116((SipServletRequestImpl)initialRequest) : (directive.equals((Object)SipApplicationRoutingDirective.NEW) ? this.performNewDirective(stateInfo) : this.performContinueDirective(stateInfo));
        if (c_logger.isTraceDebugEnabled()) {
            String application = null;
            if (nextApplicationForMatch != null) {
                application = nextApplicationForMatch.getNextApplicationName();
            }
            c_logger.traceDebug("Next application to try siplet match - " + application);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("getNextApplication");
        }
        return nextApplicationForMatch;
    }

    private SipApplicationRouterInfo performContinueDirective(Serializable stateInfo) {
        if (stateInfo == null) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.dar.selector.1");
            }
            return null;
        }
        ((StateInfo)stateInfo).increaseLastIndex();
        int lastIndex = ((StateInfo)stateInfo).getIndex();
        if (lastIndex >= this.appInfoList.size()) {
            return this.nullApplication;
        }
        SipApplicationRouterInfoStrartOrder nextApp = this.appInfoList.get(lastIndex);
        ((StateInfo)stateInfo).setIndex(lastIndex);
        SipApplicationRouterInfoStrartOrder returnVal = new SipApplicationRouterInfoStrartOrder(nextApp.getNextApplicationName(), null, nextApp.getRoutes(), nextApp.getRoutingRegion(), nextApp.getRouteModifier(), stateInfo);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("CWSCT0408I: Default application router, weight strategy, next application has been selected: " + nextApp.getNextApplicationName() + ", chain index: " + ((StateInfo)stateInfo).getIndex() + ". ");
        }
        return returnVal;
    }

    private SipApplicationRouterInfo findApplicationAccordingJSR116(SipServletRequestImpl initialRequest) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("findApplicationAccordingJSR116");
        }
        StateInfo stateInfo = null;
        if (initialRequest.getStateInfo() != null) {
            stateInfo = (StateInfo)initialRequest.getStateInfo();
        } else {
            initialRequest.setDirective(SipApplicationRoutingDirective.CONTINUE);
            String appInvokedName = initialRequest.getAppInvokedName();
            if ("Unknown application".equals(appInvokedName)) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("unknown application is used, probably async request,  the routing procedure will be skipped");
                }
                return null;
            }
            int appIndex = 0;
            for (SipApplicationRouterInfoStrartOrder currApp : this.appInfoList) {
                if (currApp.getNextApplicationName().equals(appInvokedName)) {
                    stateInfo = new StateInfo();
                    stateInfo.setIndex(appIndex);
                    initialRequest.setStateInfo(stateInfo);
                }
                ++appIndex;
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("findApplicationAccordingJSR116");
        }
        return this.performContinueDirective(stateInfo);
    }

    private SipApplicationRouterInfo performNewDirective(Serializable stateInfo) {
        StateInfo newStateInfo = new StateInfo();
        newStateInfo.setIndex(0);
        if (0 >= this.appInfoList.size()) {
            return this.nullApplication;
        }
        SipApplicationRouterInfoStrartOrder nextApp = this.appInfoList.get(0);
        SipApplicationRouterInfoStrartOrder returnVal = new SipApplicationRouterInfoStrartOrder(nextApp.getNextApplicationName(), null, nextApp.getRoutes(), nextApp.getRoutingRegion(), nextApp.getRouteModifier(), (Serializable)newStateInfo);
        if (c_logger.isTraceDebugEnabled()) {
            String application = null;
            if (nextApp != null) {
                application = nextApp.getNextApplicationName();
            }
            c_logger.traceDebug("Default application router, start order strategy, next application has been selected: " + application + ". ");
        }
        return returnVal;
    }

    public String toString() {
        StringBuffer objectString = new StringBuffer();
        for (SipApplicationRouterInfoStrartOrder app : this.appInfoList) {
            objectString.append(app).append("\n");
        }
        return objectString.toString();
    }
}

