/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser;

import com.ibm.ws.sip.parser.Coder;
import com.ibm.ws.sip.parser.Separators;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.LRUStringCache;
import jain.protocol.ip.sip.SipParseException;

public class Lexer
implements Separators {
    private char[] m_buffer;
    private int m_length;
    private int m_index = 0;
    private static LRUStringCache m_cache = LRUStringCache.getInstance();

    public void rewind() {
        this.m_index = 0;
    }

    public int mark() {
        return this.m_index;
    }

    public void rewind(int mark) {
        this.m_index = mark;
    }

    public void setSrc(char[] src, int length) {
        this.setSrc(src, 0, length);
    }

    public void setSrc(char[] src, int offset, int length) {
        this.m_buffer = src;
        this.m_length = offset + length;
        this.rewind(offset);
    }

    public char getChar(int index) {
        return this.m_buffer[index];
    }

    public int length() {
        return this.m_length;
    }

    public String nextToken(char delim) {
        char c;
        this.lws();
        int start = this.m_index;
        int end = -1;
        int length = this.length();
        while (this.m_index < length && (c = this.LA()) != delim) {
            if (c != ' ') {
                end = this.m_index;
            }
            ++this.m_index;
        }
        int len = end == -1 ? 0 : end - start + 1;
        return m_cache.get(this.m_buffer, start, len);
    }

    public String quotedString() throws SipParseException {
        char c;
        int i;
        this.match('\"');
        boolean escaped = false;
        for (i = this.m_index; i < this.m_length && ((c = this.m_buffer[i]) != '\"' || escaped); ++i) {
            escaped = !escaped && c == '\\';
        }
        int len = i - this.m_index;
        String s = m_cache.get(this.m_buffer, this.m_index, len);
        s = Lexer.unescapeQuotedString(s);
        this.m_index = i + 1;
        return s;
    }

    public static String unescapeQuotedString(String s) {
        StringBuilder b = null;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c2;
            int quoted = -1;
            char c1 = s.charAt(i);
            if (c1 == '\\' && i < length - 1 && ('\u000e' <= (c2 = s.charAt(i + 1)) && c2 <= '\u007f' || '\u000b' <= c2 && c2 <= '\f' || '\u0000' <= c2 && c2 <= '\t')) {
                quoted = c2;
            }
            if (quoted != -1) {
                if (b == null) {
                    b = new StringBuilder(64);
                    if (i > 0) {
                        b.append(s, 0, i);
                    }
                }
                b.append((char)quoted);
                ++i;
                continue;
            }
            if (b == null) continue;
            b.append(c1);
        }
        return b == null ? s : b.toString();
    }

    public static void writeNoQuotes(CharSequence string, CharsBuffer buffer) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    c = ' ';
                    break;
                }
                default: {
                    if (!Lexer.needEscaping(c)) break;
                    buffer.append('\\');
                }
            }
            buffer.append(c);
        }
    }

    public static boolean needEscaping(char c) {
        return c == '\"' || c == '\\' || '\u0000' <= c && c <= '\u0019' || c == '\u007f';
    }

    public String nextToken(char[] delims) {
        char c;
        int start;
        this.lws();
        int end = start = this.m_index;
        int length = this.length();
        while (this.m_index < length && !Lexer.delimited(c = this.LA(), delims)) {
            if (c != ' ') {
                end = this.m_index + 1;
            }
            ++this.m_index;
        }
        int len = end - start;
        return m_cache.get(this.m_buffer, start, len);
    }

    private static boolean delimited(char c, char[] delims) {
        for (int i = 0; i < delims.length; ++i) {
            if (c != delims[i]) continue;
            return true;
        }
        return false;
    }

    public char LA() {
        return this.LA(1);
    }

    public char LA(int k) {
        if (this.m_index + k - 1 < this.length()) {
            return this.getChar(this.m_index + k - 1);
        }
        return '\u0000';
    }

    public void consume() {
        this.consume(1);
    }

    public void consume(int k) {
        this.m_index += k;
    }

    public void match(char chr) throws SipParseException {
        if (this.LA() != chr) {
            StringBuffer buf = new StringBuffer("Expected [");
            buf.append(chr).append("] but got ");
            if (this.m_index < this.length()) {
                buf.append('[');
                buf.append(this.getChar(this.m_index));
                buf.append(']');
            } else {
                buf.append("index out of buffer");
            }
            throw new SipParseException(buf.toString(), "");
        }
        this.consume();
    }

    public void match(String str) throws SipParseException {
        int orig = this.m_index;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (this.LA() != str.charAt(i)) {
                StringBuffer buf = new StringBuffer("Expected [");
                buf.append(str);
                buf.append("] but got [");
                buf.append(this.getChar(this.m_index));
                buf.append("] on [");
                buf.append(this.m_index);
                buf.append("] char");
                this.m_index = orig;
                throw new SipParseException(buf.toString(), "");
            }
            this.consume();
        }
    }

    public int number() throws SipParseException {
        char digit = this.LA();
        if (!Character.isDigit(digit)) {
            throw new SipParseException("Expected a number but got [" + digit + ']', "");
        }
        int result = 0;
        do {
            this.consume();
            int d = Character.digit(digit, 10);
            int check = result;
            result *= 10;
            if ((result += d) >= check) continue;
            throw new SipParseException("Number too big");
        } while (Character.isDigit(digit = this.LA()));
        return result;
    }

    public long longNumber() throws SipParseException {
        char digit = this.LA();
        if (!Character.isDigit(digit)) {
            throw new SipParseException("Expected a number but got [" + digit + ']', "");
        }
        long result = 0L;
        do {
            this.consume();
            int d = Character.digit(digit, 10);
            long check = result;
            result *= 10L;
            if ((result += (long)d) >= check) continue;
            throw new SipParseException("Number too big");
        } while (Character.isDigit(digit = this.LA()));
        return result;
    }

    public short shortNumber() throws SipParseException {
        char digit = this.LA();
        if (!Character.isDigit(digit)) {
            throw new SipParseException("Expected a number but got [" + digit + ']', "");
        }
        short result = 0;
        do {
            this.consume();
            int d = Character.digit(digit, 10);
            short check = result;
            result = (short)(result * 10);
            result = (short)(result + d);
            if (result >= check) continue;
            throw new SipParseException("Number too big");
        } while (Character.isDigit(digit = this.LA()));
        return result;
    }

    public void lws() {
        int n = 0;
        int lastWhitespace = 0;
        block4: while (true) {
            char c = this.LA(n + 1);
            switch (c) {
                case '\t': 
                case ' ': {
                    lastWhitespace = ++n;
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    ++n;
                    continue block4;
                }
            }
            break;
        }
        this.consume(lastWhitespace);
    }

    public String sipToken() {
        char chr;
        int offset = this.m_index;
        while (this.LA() != '\u0000' && (Character.isLetterOrDigit(chr = this.LA()) || chr == '.' || chr == '+' || chr == '!' || chr == '~' || chr == '%' || chr == '*' || chr == '-' || chr == '_' || chr == '\'' || chr == '`')) {
            this.consume();
        }
        return m_cache.get(this.m_buffer, offset, this.m_index - offset);
    }

    public String sipWord() {
        char chr;
        int offset = this.m_index;
        while (this.LA() != '\u0000' && (Character.isLetterOrDigit(chr = this.LA()) || chr == '.' || chr == '+' || chr == '!' || chr == '~' || chr == '%' || chr == '*' || chr == '-' || chr == '_' || chr == '(' || chr == ')' || chr == '<' || chr == '>' || chr == ':' || chr == '\\' || chr == '\"' || chr == '/' || chr == '[' || chr == ']' || chr == '?' || chr == '{' || chr == '}')) {
            this.consume();
        }
        return m_cache.get(this.m_buffer, offset, this.m_index - offset);
    }

    public String sipParam() {
        char chr;
        int offset = this.m_index;
        while (this.LA() != '\u0000' && (Character.isLetterOrDigit(chr = this.LA()) || chr == '.' || chr == '+' || chr == '!' || chr == '~' || chr == '@' || chr == '%' || chr == '*' || chr == '-' || chr == '_' || chr == '(' || chr == ')' || chr == ':' || chr == '\\' || chr == '\"' || chr == '/' || chr == '[' || chr == ']' || chr == '\'' || chr == '`' || chr == '{' || chr == '}')) {
            this.consume();
        }
        return m_cache.get(this.m_buffer, offset, this.m_index - offset);
    }

    public String sipUriParam() {
        char chr;
        int offset = this.m_index;
        while (this.LA() != '\u0000' && (Coder.isParamUnreserved(chr = this.LA()) || Coder.isUnreserved(chr) || chr == '%')) {
            this.consume();
        }
        return m_cache.get(this.m_buffer, offset, this.m_index - offset);
    }

    public int find(char chr) {
        int i = 1;
        while (this.LA(i) != '\u0000') {
            if (this.LA(i) == chr) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void skip(char chr) {
        int pos = this.find(chr);
        if (pos > 0) {
            this.consume(pos);
        }
    }

    public String toString() {
        return m_cache.get(this.m_buffer, 0, this.m_length);
    }
}

