/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.message.KeepalivePong;
import com.ibm.ws.sip.parser.MessageParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.context.MessageContextFactory;
import com.ibm.ws.sip.stack.transaction.transport.UseCompactHeaders;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import jain.protocol.ip.sip.message.Message;
import java.io.IOException;

public class StreamMessageParser
extends MessageParser {
    private static final LogMgr s_logger = Log.get(StreamMessageParser.class);
    private static final int STATE_STARTLINE = 0;
    private static final int STATE_HEADERS = 1;
    private static final int STATE_BODY = 2;
    private int m_state = 0;
    private SipMessageByteBuffer m_buffer = null;
    private Message m_message = null;
    private boolean m_waiting = false;
    private boolean m_checkRemainingBytesInBuffer;
    private int m_crlfReceived = 0;
    private boolean m_isMessageCrlf;
    private final SIPConnection m_connection;
    private static final KeepalivePong s_keepalivePong = new KeepalivePong();

    public StreamMessageParser(SIPConnection connection) {
        this.m_connection = connection;
        this.m_checkRemainingBytesInBuffer = false;
        this.m_isMessageCrlf = false;
    }

    @Override
    public Message parse(SipMessageByteBuffer buffer) {
        if (this.m_buffer != buffer) {
            if (this.m_waiting) {
                if (this.m_buffer == null) {
                    // empty if block
                }
                this.m_buffer.put(buffer.getBytes(), buffer.getReadPos(), buffer.getRemaining());
                buffer.init();
                buffer.put(this.m_buffer.getBytes(), this.m_buffer.getReadPos(), this.m_buffer.getRemaining());
            }
            if (this.m_buffer != null) {
                this.m_buffer.reset();
            }
            this.m_buffer = buffer;
        }
        CharsBuffer line = null;
        if (this.m_state == 0) {
            line = CharsBuffersPool.getBuffer();
            this.m_message = this.parseStartLine(this.m_buffer, line);
            if (this.m_startLineHuntingMode) {
                while (this.m_message == null && this.getErrorCode() != 0) {
                    this.m_message = this.parseStartLine(this.m_buffer, line);
                }
            }
            if (this.m_message == null) {
                if (this.m_isMessageCrlf) {
                    this.m_isMessageCrlf = false;
                    this.m_checkRemainingBytesInBuffer = false;
                    this.m_waiting = false;
                } else {
                    this.m_waiting = true;
                    this.m_checkRemainingBytesInBuffer = !this.m_checkRemainingBytesInBuffer;
                }
                CharsBuffersPool.putBufferBack(line);
                return null;
            }
            this.m_state = 1;
        }
        if (this.m_state == 1) {
            if (line == null) {
                line = CharsBuffersPool.getBuffer();
            }
            if (!this.parseHeaders(this.m_buffer, this.m_message, line)) {
                this.m_waiting = true;
                CharsBuffersPool.putBufferBack(line);
                return null;
            }
            this.m_state = 2;
        }
        if (line != null) {
            CharsBuffersPool.putBufferBack(line);
        }
        if (this.m_state == 2) {
            if (!this.parseBody(this.m_buffer, this.m_message)) {
                this.m_waiting = true;
                return null;
            }
            this.m_state = 0;
            this.m_waiting = false;
            this.m_checkRemainingBytesInBuffer = false;
        }
        return this.m_message;
    }

    @Override
    public boolean hasMore() {
        if (!this.m_waiting) {
            return this.m_buffer != null && this.m_buffer.hasMore();
        }
        return this.m_checkRemainingBytesInBuffer && this.m_buffer != null && this.m_buffer.hasMore();
    }

    @Override
    protected boolean contentLengthHeaderRequired() {
        return true;
    }

    @Override
    protected void crlfReceived(boolean empty) {
        if (empty) {
            if (++this.m_crlfReceived == 2) {
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug(this, "crlfReceived", "received a keepalive ping - sending pong");
                }
                this.m_crlfReceived = 0;
                this.m_isMessageCrlf = !this.m_buffer.hasMore();
                MessageContextFactory messageContextFactory = MessageContextFactory.instance();
                MessageContext messageContext = messageContextFactory.getMessageContext(s_keepalivePong);
                messageContext.setSipConnection(this.m_connection);
                try {
                    this.m_connection.write(messageContext, false, UseCompactHeaders.NEVER);
                }
                catch (IOException e2) {
                    if (s_logger.isTraceFailureEnabled()) {
                        s_logger.traceFailure(this, "crlfReceived", "", e2);
                    }
                }
            }
        } else {
            this.m_crlfReceived = 0;
        }
    }
}

