/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.context;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.message.KeepalivePong;
import com.ibm.ws.sip.parser.util.ObjectPool;
import com.ibm.ws.sip.stack.context.KeepalivePongContext;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.context.RequestContext;
import com.ibm.ws.sip.stack.context.ResponseContext;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransaction;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;

public class MessageContextFactory {
    private static final LogMgr c_logger = Log.get(MessageContextFactory.class);
    public static MessageContextFactory s_instance = null;
    private ObjectPool s_requestContextPool = null;
    private ObjectPool s_responseContextPool = null;
    private ObjectPool s_keepalivePongContextPool = null;

    private MessageContextFactory() {
        int maxPoolSize = ApplicationProperties.getProperties().getInt("maxMsgContextPoolSize");
        this.s_requestContextPool = new ObjectPool(RequestContext.class, null, maxPoolSize);
        this.s_responseContextPool = new ObjectPool(ResponseContext.class, null, maxPoolSize);
        this.s_keepalivePongContextPool = new ObjectPool(KeepalivePongContext.class, null, maxPoolSize);
    }

    public MessageContext getMessageContext(Message message) {
        if (message instanceof Request) {
            Request request = (Request)message;
            return this.getMessageContext(request);
        }
        if (message instanceof Response) {
            Response response = (Response)message;
            return this.getMessageContext(response);
        }
        if (message instanceof KeepalivePong) {
            KeepalivePong keepalivePong = (KeepalivePong)message;
            return this.getMessageContext(keepalivePong);
        }
        return null;
    }

    public MessageContext getMessageContext(Message message, SIPTransaction sipTransaction) {
        if (message instanceof Request) {
            Request request = (Request)message;
            return this.getMessageContext(request, sipTransaction);
        }
        if (message instanceof Response) {
            Response response = (Response)message;
            return this.getMessageContext(response, sipTransaction);
        }
        return null;
    }

    public MessageContext getMessageContext(Request request) {
        MessageContext messageContext = null;
        messageContext = (MessageContext)this.s_requestContextPool.get();
        if (messageContext == null) {
            return null;
        }
        messageContext.setSipMessage(request);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getMessageContext", "Message context supplied: " + messageContext);
        }
        return messageContext;
    }

    public MessageContext getMessageContext(Response response) {
        MessageContext messageContext = null;
        messageContext = (MessageContext)this.s_responseContextPool.get();
        if (messageContext == null) {
            return null;
        }
        messageContext.setSipMessage(response);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getMessageContext", "Message context supplied: " + messageContext);
        }
        return messageContext;
    }

    public MessageContext getMessageContext(Request request, SIPTransaction sipTransaction) {
        MessageContext messageContext = this.getMessageContext(request);
        messageContext.setSipTransaction(sipTransaction);
        return messageContext;
    }

    public MessageContext getMessageContext(Response response, SIPTransaction sipTransaction) {
        MessageContext messageContext = this.getMessageContext(response);
        messageContext.setSipTransaction(sipTransaction);
        return messageContext;
    }

    public MessageContext getMessageContext(KeepalivePong keepalivePong) {
        MessageContext messageContext = (MessageContext)this.s_keepalivePongContextPool.get();
        if (messageContext == null) {
            return null;
        }
        messageContext.setSipMessage(keepalivePong);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getMessageContext", "Message context supplied: " + messageContext);
        }
        return messageContext;
    }

    public void finishToUseContext(MessageContext messageContext) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "finishToUseContext", "Message context about to be cleaned and returned to Pool: " + messageContext);
        }
        messageContext.cleanItself();
        if (messageContext instanceof RequestContext) {
            this.s_requestContextPool.putBack(messageContext);
            return;
        }
        if (messageContext instanceof ResponseContext) {
            this.s_responseContextPool.putBack(messageContext);
            return;
        }
        if (messageContext instanceof KeepalivePongContext) {
            this.s_keepalivePongContextPool.putBack(messageContext);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageContextFactory instance() {
        if (s_instance != null) return s_instance;
        Class<MessageContextFactory> clazz = MessageContextFactory.class;
        synchronized (MessageContextFactory.class) {
            if (s_instance != null) return s_instance;
            s_instance = new MessageContextFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_instance;
        }
    }
}

