/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.naptr;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.SipJainFactories;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.internalapi.NaptrRequestListener;
import com.ibm.ws.sip.stack.naptr.INaptrSender;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.util.SipStackUtil;
import com.ibm.wsspi.sip.channel.resolver.SIPUri;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.AddressFactory;
import jain.protocol.ip.sip.address.SipURL;
import java.util.List;

public class NaptrHandler
implements NaptrRequestListener {
    private static final LogMgr c_logger = Log.get(NaptrHandler.class);
    private final INaptrSender _sender;
    private List<SIPUri> _naptrResults = null;
    private boolean _naptrUsed = false;
    private SipURL _target = null;
    private SipURL _latestDestination = null;
    private MessageContext _messageContext = null;

    public NaptrHandler(INaptrSender sender) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "NaptrHandler", "New NaptrSender created  = " + this.toString());
        }
        this._sender = sender;
    }

    public void cleanSelf() {
        this._naptrResults = null;
        this._latestDestination = null;
        this._naptrUsed = false;
        this._target = null;
        this._messageContext = null;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "cleanItself", " Clean NaptrHandler = " + this.toString());
        }
    }

    @Override
    public void error(Exception e2) {
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Error was received from NAPTR for SIPUrl = ");
            buff.append(this._target);
            buff.append(" Exception ");
            buff.append(e2);
            c_logger.traceDebug(this, "error", buff.toString());
        }
        this.reportError(this._messageContext);
    }

    public SipURL getLastUsedDestination() {
        return this._latestDestination;
    }

    @Override
    public void handleResolve(List<SIPUri> results) {
        if (this._naptrResults == null) {
            this._naptrResults = results;
            if (c_logger.isTraceDebugEnabled()) {
                SIPUri result = null;
                StringBuffer buff = new StringBuffer();
                for (int i = 0; i < results.size(); ++i) {
                    result = results.get(i);
                    buff.append("\n\r");
                    buff.append("Destination =  ");
                    buff.append(result.getScheme());
                    buff.append(":");
                    buff.append(result.getUserInfo());
                    buff.append("@");
                    buff.append(result.getHost());
                    buff.append(":");
                    buff.append(result.getPort());
                }
                c_logger.traceDebug(this, "handleNAPTRResults", "Got Results " + buff.toString());
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "handleNAPTRResults", "We already received NAPTR results for " + this._target);
        }
        this.sendToNextDestination(this._messageContext, this._target);
    }

    public void sendToNextDestination(MessageContext messageContext, SipURL target) {
        try {
            this.setMessage(messageContext);
            this.setTarget(target);
        }
        catch (SipParseException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer();
                buff.append("Error ocurred while preparing message for NAPTR for SIPUrl = ");
                buff.append(target);
                buff.append(" Exception ");
                buff.append(e2);
                c_logger.traceDebug(this, "error", buff.toString());
            }
            this.reportError(messageContext);
            return;
        }
        if (this._naptrUsed) {
            if (this._naptrResults != null) {
                boolean sendSuccessful = this.sendToNextHop();
                if (!sendSuccessful) {
                    this.reportError(messageContext);
                }
            } else {
                this.reportError(messageContext);
            }
        } else {
            this.useNaptr();
        }
    }

    private boolean sendToNextHop() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "sendToNextHop");
        }
        boolean isNewDestination = false;
        SIPUri nextDestination = null;
        while (this._naptrResults.size() > 0 && !isNewDestination) {
            nextDestination = this._naptrResults.remove(0);
            isNewDestination = this.checkIfNewDestination(nextDestination, this._messageContext.getSipConnection());
        }
        if (nextDestination == null) {
            return false;
        }
        try {
            this._latestDestination.setHost(nextDestination.getHost());
            this._latestDestination.setPort(nextDestination.getPortInt());
            String transport = nextDestination.getTransport();
            if (transport != null) {
                this._latestDestination.setTransport(transport);
            }
            try {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("calling static method setDestinationHeader to -  " + this._latestDestination);
                }
                SipStackUtil.setDestinationHeader(this._latestDestination, this._messageContext.getSipMessage());
            }
            catch (SipParseException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("error setting destination header for message ");
                    buff.append(this._messageContext);
                    c_logger.traceDebug(this, "sendToNextDestination", buff.toString(), e2);
                }
                return false;
            }
            this._sender.sendMessage(this._messageContext, this._target.getTransport());
        }
        catch (SipParseException e3) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "sendToNextDestination", "error in URI [" + nextDestination + ']', e3);
            }
            return false;
        }
        return true;
    }

    public boolean sendWithoutLookup(MessageContext messageContext, SipURL target) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "sendWithoutLookup", (Object)target);
        }
        try {
            this.setMessage(messageContext);
            this.setTarget(target);
        }
        catch (SipParseException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer();
                buff.append("Error ocurred while preparing message for NAPTR for SIPUrl = ");
                buff.append(target);
                buff.append(" Exception ");
                buff.append(e2);
                c_logger.traceDebug(this, "error", buff.toString());
            }
            this.reportError(messageContext);
            return false;
        }
        this._sender.sendMessage(this._messageContext, this._target.getTransport());
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "sendWithoutLookup", true);
        }
        return true;
    }

    private boolean checkIfNewDestination(SIPUri nextDestination, SIPConnection sipConnection) {
        if (sipConnection == null) {
            return true;
        }
        if (nextDestination == null) {
            return false;
        }
        boolean sameHost = false;
        boolean samePort = false;
        String previousConnectionHost = sipConnection.getRemoteHost();
        int previousConnectionPort = sipConnection.getRemotePort();
        String nextDestHost = nextDestination.getHost();
        int nextDestPort = nextDestination.getPortInt();
        if (previousConnectionHost == null && nextDestHost == null) {
            sameHost = true;
        } else if (previousConnectionHost != null) {
            sameHost = previousConnectionHost.equals(nextDestHost);
        }
        if (previousConnectionPort == nextDestPort) {
            samePort = true;
        }
        if (sameHost && samePort) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "checkIfNewDestination", "the destination returned: " + nextDestination + " is not new. An attempt to send the message to this destination was already made.");
            }
            return false;
        }
        return true;
    }

    private void reportError(MessageContext messageContext) {
        this._sender.error(messageContext);
    }

    private void useNaptr() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "useNaptr", "Call to NAPTR resolve the targetUrl = " + this._target);
        }
        if (this._messageContext.isNaptrCalled()) {
            return;
        }
        this._naptrUsed = true;
        this._messageContext.setNaptrCalled(true);
        SIPUri suri = SIPUri.createSIPUri(this._target.toString());
        suri.setHost(this._target.getHost());
        suri.setScheme(this._target.getScheme());
        suri.setPortInt(this._target.getPort());
        suri.setTransport(this._target.getTransport());
        SipContainerComponent.getDomainResolverService().lookupDestination(suri, this);
    }

    private void setMessage(MessageContext messageContext) {
        this._messageContext = messageContext;
    }

    private void setTarget(SipURL target) throws IllegalArgumentException, SipParseException {
        AddressFactory addressFactory = SipJainFactories.getInstance().getAddressFactory();
        this._latestDestination = addressFactory.createSipURL("", "");
        this._latestDestination.setScheme(target.getScheme());
        this._target = target;
    }
}

