/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.naptr;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.naptr.INaptrSender;
import com.ibm.ws.sip.stack.naptr.NaptrHandler;
import com.ibm.ws.sip.stack.properties.StackProperties;
import com.ibm.ws.sip.stack.transaction.transport.BackupMessageSenderBase;
import com.ibm.ws.sip.stack.transaction.transport.TransportCommLayerMgr;
import com.ibm.ws.sip.stack.util.SipStackUtil;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.SipURL;

public class NaptrSenderStack
extends BackupMessageSenderBase
implements INaptrSender {
    private static final LogMgr c_logger = Log.get(NaptrSenderStack.class);
    private final NaptrHandler _naptrHandler;
    private MessageContext _messageContext;

    public NaptrSenderStack() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "NaptrSender", "New NaptrSender created  = " + this.toString());
        }
        this._naptrHandler = new NaptrHandler(this);
        this._messageContext = null;
    }

    @Override
    public void cleanItself() {
        this._naptrHandler.cleanSelf();
        this._messageContext = null;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "cleanItself", " Clean NaptrSender = " + this.toString());
        }
    }

    @Override
    public void sendMessageToBackup(MessageContext messageContext) {
        this._messageContext = messageContext;
        this.sendToNextDestination();
    }

    private void sendToNextDestination() {
        SipURL target = null;
        try {
            target = SipStackUtil.createTargetFromMessage(this._messageContext.getSipMessage());
            this._naptrHandler.sendToNextDestination(this._messageContext, target);
        }
        catch (Exception e2) {
            this.error(this._messageContext);
        }
    }

    @Override
    public void error(MessageContext messageContext) {
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Failed to send response to any destination for message: ");
            buff.append(this._messageContext);
            c_logger.traceDebug(this, "error", buff.toString());
        }
        MessageContext.doneWithContext(messageContext);
    }

    @Override
    public void sendMessage(MessageContext messageContext, String transport) {
        block7: {
            try {
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("Sending message to the next destination = ");
                    buff.append(this._naptrHandler.getLastUsedDestination());
                    c_logger.traceDebug(this, "sendRequestDownstream", buff.toString());
                }
                SipProvider provider = StackProperties.getInstance().getProvider(transport);
                TransportCommLayerMgr.instance().sendMessage(messageContext, provider, null);
            }
            catch (Exception e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("Exception when sending message. try next destination for message: ");
                    buff.append(messageContext);
                    c_logger.traceDebug(this, "sendToNextDestination", buff.toString());
                }
                try {
                    this.sendToNextDestination();
                }
                catch (Exception e1) {
                    if (messageContext != null) {
                        messageContext.writeError(e1);
                    }
                    if (!c_logger.isTraceDebugEnabled()) break block7;
                    StringBuffer buff = new StringBuffer();
                    buff.append("IOException when trying to send message to next destination for message: ");
                    buff.append(messageContext);
                    c_logger.traceDebug(this, "sendMessage", buff.toString());
                }
            }
        }
    }
}

