/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.connections.tls;

public class SSLRepertoire {
    private static String KEY_STORE_SYSTEM_KEY = "javax.net.ssl.keyStore";
    private static String KEY_STORE_PASSWORD_SYSTEM_KEY = "javax.net.ssl.keyStorePassword";
    private static String TRUST_STORE_SYSTEM_KEY = "javax.net.ssl.trustStore";
    private static String TRUST_STORE_PASSWORD_SYSTEM_KEY = "javax.net.ssl.trustStorePassword";
    private String m_protocol;
    private String m_contextProvider;
    private boolean m_isClientAuthenticationEnabled;
    private String m_keyStoreFile;
    private String m_keyStorePassword;
    private String m_keyManagerName;
    private String m_keyStoreProvider;
    private String m_keyStoreType;
    private String m_trustStoreFile;
    private String m_trustStorePassword;
    private String m_trustManagerName;
    private String m_trustStoreProvider;
    private String m_trustStoreType;
    private String m_jsseProviderClassName;

    public SSLRepertoire(String protocol, String contextProvider, boolean isClientAuthenticationEnabled, String keyStoreFile, String keyStorePassword, String keyManagerName, String keyStoreProvider, String keyStoreType, String trustStoreFile, String trustStorePassword, String trustManagerName, String trustStoreProvider, String trustStoreType, String jsseProviderClassName) {
        this.m_protocol = protocol != null ? protocol : "TLS";
        this.m_contextProvider = contextProvider != null ? contextProvider : "IBMJSSE";
        this.m_isClientAuthenticationEnabled = isClientAuthenticationEnabled;
        if (keyStoreFile == null) {
            keyStoreFile = System.getProperty(KEY_STORE_SYSTEM_KEY);
        }
        if (keyStoreFile == null) {
            throw new IllegalArgumentException("keyStore File must be set!!!");
        }
        this.m_keyStoreFile = keyStoreFile;
        if (keyStorePassword == null) {
            keyStorePassword = System.getProperty(KEY_STORE_PASSWORD_SYSTEM_KEY);
        }
        if (keyStorePassword == null) {
            throw new IllegalArgumentException("keyStore Password must be set!!!");
        }
        this.m_keyStorePassword = keyStorePassword;
        this.m_keyManagerName = keyManagerName != null ? keyManagerName : "IbmX509";
        this.m_keyStoreProvider = keyStoreProvider != null ? keyStoreProvider : "IBMJCE";
        String string = this.m_keyStoreType = keyStoreType != null ? keyStoreType : "JKS";
        if (trustStoreFile == null) {
            trustStoreFile = System.getProperty(TRUST_STORE_SYSTEM_KEY);
        }
        if (trustStoreFile == null) {
            throw new IllegalArgumentException("trustStore File must be set!!!");
        }
        this.m_trustStoreFile = trustStoreFile;
        if (trustStorePassword == null) {
            trustStorePassword = System.getProperty(TRUST_STORE_PASSWORD_SYSTEM_KEY);
        }
        if (trustStorePassword == null) {
            throw new IllegalArgumentException("trustStore Password must be set!!!");
        }
        this.m_trustStorePassword = trustStorePassword;
        this.m_trustManagerName = trustManagerName != null ? trustManagerName : "IbmX509";
        this.m_trustStoreProvider = trustStoreProvider != null ? trustStoreProvider : "IBMJCE";
        this.m_trustStoreType = trustStoreType != null ? trustStoreType : "JKS";
        this.m_jsseProviderClassName = jsseProviderClassName != null ? jsseProviderClassName : "com.ibm.jsse.IBMJSSEProvider";
    }

    public String getContextProvider() {
        return this.m_contextProvider;
    }

    public boolean isClientAuthenticationEnabled() {
        return this.m_isClientAuthenticationEnabled;
    }

    public String getKeyManagerName() {
        return this.m_keyManagerName;
    }

    public String getKeyStoreFile() {
        return this.m_keyStoreFile;
    }

    public String getKeyStoreProvider() {
        return this.m_keyStoreProvider;
    }

    public String getKeyStoreType() {
        return this.m_keyStoreType;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public String getTrustStoreFile() {
        return this.m_trustStoreFile;
    }

    public String getTrustStorePassword() {
        return this.m_trustStorePassword;
    }

    public String getTrustStoreProvider() {
        return this.m_trustStoreProvider;
    }

    public String getTrustStoreType() {
        return this.m_trustStoreType;
    }

    public String getKeyStorePassword() {
        return this.m_keyStorePassword;
    }

    public String getTrustManagerName() {
        return this.m_trustManagerName;
    }

    public String getJsseProviderClassName() {
        return this.m_jsseProviderClassName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("SIP SSL Repertoire is:\n");
        buf.append("protocol [" + this.m_protocol + "]\n");
        buf.append("contextProvider [" + this.m_contextProvider + "]\n");
        buf.append("isClientAuthenticationEnabled [" + this.m_isClientAuthenticationEnabled + "]\n");
        buf.append("keyStoreFile [" + this.m_keyStoreFile + "]\n");
        buf.append("keyManagerName [" + this.m_keyManagerName + "]\n");
        buf.append("keyStoreProvider [" + this.m_keyStoreProvider + "]\n");
        buf.append("keyStoreType [" + this.m_keyStoreType + "]\n");
        buf.append("trustStoreFile [" + this.m_trustStoreFile + "]\n");
        buf.append("trustManagerName [" + this.m_trustManagerName + "]\n");
        buf.append("trustStoreProvider [" + this.m_trustStoreProvider + "]\n");
        buf.append("trustStoreType [" + this.m_trustStoreType + "]\n");
        buf.append("jsseProviderClassName [" + this.m_jsseProviderClassName + "]\n");
        return buf.toString();
    }
}

