/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.routers;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.header.GenericNameAddressHeaderImpl;
import com.ibm.ws.sip.stack.transaction.transport.Hop;
import com.ibm.ws.sip.stack.transaction.transport.routers.Router;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.message.Request;
import java.util.ArrayList;
import java.util.List;

public class StandaloneRouter
implements Router {
    private static final LogMgr c_logger = Log.get(StandaloneRouter.class);
    private Hop m_defaultHop;

    @Override
    public List getNextHops(Request sipRequest) {
        Hop nextHop;
        if (this.m_defaultHop != null) {
            nextHop = this.m_defaultHop;
        } else {
            try {
                URI uri;
                GenericNameAddressHeaderImpl nameAddress = (GenericNameAddressHeaderImpl)sipRequest.getHeader("IBM-Destination", true);
                if (nameAddress == null) {
                    NameAddressHeader topRoute = (NameAddressHeader)sipRequest.getHeader("Route", true);
                    if (topRoute == null) {
                        uri = sipRequest.getRequestURI();
                    } else {
                        uri = topRoute.getNameAddress().getAddress();
                        if (uri instanceof SipURL) {
                            SipURL url = (SipURL)uri;
                            boolean strictRouting = url.hasParameter("ibmsr");
                            if (strictRouting) {
                                url.removeParameter("ibmsr");
                                uri = sipRequest.getRequestURI();
                            }
                        } else {
                            if (c_logger.isTraceDebugEnabled()) {
                                c_logger.traceDebug("Error: getNextHops - top route uri is not a SipURL");
                            }
                            uri = null;
                        }
                    }
                } else {
                    uri = nameAddress.getNameAddress().getAddress();
                    sipRequest.removeHeader("IBM-Destination", true);
                }
                if (uri == null) {
                    nextHop = null;
                } else if (uri instanceof SipURL) {
                    SipURL reqUrl = (SipURL)uri;
                    nextHop = Hop.getHop(reqUrl);
                } else {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("Error: getNextHops - uri is not a SipURL");
                    }
                    nextHop = null;
                }
            }
            catch (SipParseException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getNextHops", e2.getMessage(), e2);
                }
                nextHop = null;
            }
        }
        ArrayList<Hop> hops = new ArrayList<Hop>(1);
        if (nextHop != null) {
            hops.add(nextHop);
        }
        return hops;
    }

    @Override
    public Hop getOutboundProxy() {
        return this.m_defaultHop;
    }

    @Override
    public void setOutboundProxy(Hop outProxy) {
        this.m_defaultHop = outProxy;
    }

    @Override
    public void processRequest(Request req) throws SipParseException {
    }

    @Override
    public void removeConnectionHop(Hop value) {
    }
}

