/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.rest.client.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.rest.client.cdi.LibertyRestClientExtension;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.microprofile.client.CxfTypeSafeClientBuilder;
import org.apache.cxf.microprofile.client.config.ConfigFacade;
import org.eclipse.microprofile.rest.client.inject.RestClient;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyRestClientBean
implements Bean<Object>,
PassivationCapable {
    private static final TraceComponent tc = Tr.register(LibertyRestClientExtension.class, null, null);
    public static final String REST_URL_FORMAT = "%s/mp-rest/url";
    public static final String REST_SCOPE_FORMAT = "%s/mp-rest/scope";
    private static final Default DEFAULT_LITERAL = new DefaultLiteral();
    private final Class<?> clientInterface;
    private final Class<? extends Annotation> scope;
    private final BeanManager beanManager;
    static final long serialVersionUID = 6753199825926216061L;

    public LibertyRestClientBean(Class<?> clientInterface, BeanManager beanManager) {
        this.clientInterface = clientInterface;
        this.beanManager = beanManager;
        this.scope = this.readScope();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init> - clientInterface=" + clientInterface + " beanManager=" + beanManager + " scope=" + this.scope), (Object[])new Object[0]);
        }
    }

    public String getId() {
        return this.clientInterface.getName();
    }

    public Class<?> getBeanClass() {
        return this.clientInterface;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public Object create(CreationalContext<Object> creationalContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("create - creationalContext=" + creationalContext), (Object[])new Object[0]);
        }
        CxfTypeSafeClientBuilder builder = new CxfTypeSafeClientBuilder();
        String baseUrl = this.getBaseUrl();
        Object client = null;
        try {
            client = builder.baseUrl(new URL(baseUrl)).build(this.clientInterface);
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.microprofile.rest.client.cdi.LibertyRestClientBean", (String)"99", (Object)this, (Object[])new Object[]{creationalContext});
            throw new IllegalArgumentException("The value of URL was invalid " + baseUrl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("create - creationalContext=" + creationalContext + " client=" + client + " baseUrl=" + baseUrl), (Object[])new Object[0]);
        }
        return client;
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroy - instance=" + instance + " creationalContext=" + creationalContext), (Object[])new Object[0]);
        }
        creationalContext.release();
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.clientInterface);
    }

    public Set<Annotation> getQualifiers() {
        return new HashSet<Annotation>(Arrays.asList(DEFAULT_LITERAL, RestClient.RestClientLiteral.LITERAL));
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.clientInterface.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    private String getBaseUrl() {
        String property = String.format(REST_URL_FORMAT, this.clientInterface.getName());
        String baseURL = (String)ConfigFacade.getValue((String)property, String.class);
        if (baseURL == null) {
            throw new IllegalStateException("Unable to determine base URL from configuration");
        }
        return baseURL;
    }

    /*
     * WARNING - void declaration
     */
    private Class<? extends Annotation> readScope() {
        Annotation[] annotations;
        String property = String.format(REST_SCOPE_FORMAT, this.clientInterface.getName());
        String configuredScope = ConfigFacade.getOptionalValue((String)property, String.class).orElse(null);
        if (configuredScope != null) {
            try {
                return ClassLoaderUtils.loadClass((String)configuredScope, this.getClass(), Annotation.class);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.rest.client.cdi.LibertyRestClientBean", (String)"162", (Object)this, (Object[])new Object[0]);
                throw new IllegalArgumentException("The scope " + configuredScope + " is invalid", (Throwable)e);
            }
        }
        ArrayList<Annotation> possibleScopes = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = this.clientInterface.getDeclaredAnnotations()) {
            if (!this.beanManager.isScope(annotation.annotationType())) continue;
            possibleScopes.add(annotation);
        }
        if (possibleScopes.isEmpty()) {
            return Dependent.class;
        }
        if (possibleScopes.size() == 1) {
            return ((Annotation)possibleScopes.get(0)).annotationType();
        }
        throw new IllegalArgumentException("The client interface " + this.clientInterface + " has multiple scopes defined " + possibleScopes);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class DefaultLiteral
    extends AnnotationLiteral<Default>
    implements Default {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DefaultLiteral() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.rest.client.cdi.LibertyRestClientBean$DefaultLiteral", DefaultLiteral.class, null, null);
        }
    }
}

