/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.writer;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.Constants;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics.helper.Util;
import com.ibm.ws.microprofile.metrics.writer.OutputWriter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JSONMetricWriter
implements OutputWriter {
    private final Writer writer;
    private static final TraceComponent tc = Tr.register(JSONMetricWriter.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = -8635740353788796013L;

    public JSONMetricWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void write(String registryName, String metricName) throws NoSuchRegistryException, NoSuchMetricException, IOException, EmptyRegistryException {
        this.serialize(this.getMetricsAsJson(registryName, metricName));
    }

    @Override
    public void write(String registryName) throws NoSuchRegistryException, EmptyRegistryException, IOException {
        this.serialize(this.getMetricsAsJson(registryName));
    }

    @Override
    @FFDCIgnore(value={EmptyRegistryException.class, NoSuchRegistryException.class})
    public void write() throws IOException {
        JSONObject payload = new JSONObject();
        for (String registryName : Constants.REGISTRY_NAMES_LIST) {
            try {
                payload.put((Object)registryName, (Object)this.getMetricsAsJson(registryName));
            }
            catch (NoSuchRegistryException noSuchRegistryException) {
            }
            catch (EmptyRegistryException emptyRegistryException) {}
        }
        this.serialize(payload);
    }

    private JSONObject getMetricsAsJson(String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        return this.getJsonFromMetricMap(Util.getMetricsAsMap(registryName), Util.getMetricsMetadataAsMap(registryName));
    }

    private JSONObject getMetricsAsJson(String registryName, String metricName) throws NoSuchRegistryException, NoSuchMetricException, EmptyRegistryException {
        return this.getJsonFromMetricMap(Util.getMetricsAsMap(registryName, metricName), Util.getMetricsMetadataAsMap(registryName, metricName));
    }

    /*
     * Could not resolve type clashes
     */
    @FFDCIgnore(value={IllegalStateException.class})
    protected JSONObject getJsonFromMetricMap(Map<MetricID, Metric> metricMap, Map<String, Metadata> metricMetadataMap) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<MetricID, Metric> entry : metricMap.entrySet()) {
            Metric metric;
            String metricName;
            MetricID metricID = entry.getKey();
            Map tagsMap = metricID.getTags();
            String metricNameWithTags = metricName = metricID.getName();
            String tags = "";
            Metadata metricMetaData = metricMetadataMap.get(metricName);
            String unit = (String)metricMetaData.getUnit().get();
            double conversionFactor = 1.0;
            switch (unit) {
                case "nanoseconds": {
                    conversionFactor = 1.0;
                    break;
                }
                case "microseconds": {
                    conversionFactor = 1000.0;
                    break;
                }
                case "milliseconds": {
                    conversionFactor = 1000000.0;
                    break;
                }
                case "seconds": {
                    conversionFactor = 1.0E9;
                    break;
                }
                case "minutes": {
                    conversionFactor = 6.0E10;
                    break;
                }
                case "hours": {
                    conversionFactor = 3.6E12;
                    break;
                }
                case "days": {
                    conversionFactor = 8.64E13;
                }
            }
            if (tagsMap.size() != 0) {
                for (Map.Entry tagsMapEntrySet : tagsMap.entrySet()) {
                    String tagValue = (String)tagsMapEntrySet.getValue();
                    if (tagValue.contains(";")) {
                        tagValue = tagValue.replaceAll(";", "_");
                    }
                    tags = tags + ";" + (String)tagsMapEntrySet.getKey() + "=" + tagValue;
                }
                metricNameWithTags = metricName + tags;
            }
            if (Counter.class.isInstance(metric = entry.getValue())) {
                jsonObject.put((Object)metricNameWithTags, (Object)((Counter)metric).getCount());
                continue;
            }
            if (ConcurrentGauge.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util.getConcurrentGaugeNumbers((ConcurrentGauge)metric, tags), metricName, jsonObject));
                continue;
            }
            if (Gauge.class.isInstance(metric)) {
                try {
                    jsonObject.put((Object)metricNameWithTags, ((Gauge)metric).getValue());
                }
                catch (IllegalStateException illegalStateException) {}
                continue;
            }
            if (Timer.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util.getTimerNumbers((Timer)metric, tags, conversionFactor), metricName, jsonObject));
                continue;
            }
            if (Histogram.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util.getHistogramNumbers((Histogram)metric, tags), metricName, jsonObject));
                continue;
            }
            if (Meter.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util.getMeterNumbers((Meter)metric, tags), metricName, jsonObject));
                continue;
            }
            Tr.event((TraceComponent)tc, (String)("Metric type '" + metric.getClass() + " for " + metricName + " is invalid."), (Object[])new Object[0]);
        }
        return jsonObject;
    }

    protected JSONObject getJsonFromMap(Map<String, Number> metricMap, String metricName, JSONObject parentJSONObject) {
        JSONObject jsonObject = parentJSONObject.containsKey((Object)metricName) ? (JSONObject)parentJSONObject.get((Object)metricName) : new JSONObject();
        for (Map.Entry<String, Number> entry : metricMap.entrySet()) {
            jsonObject.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return jsonObject;
    }

    private void serialize(JSONObject payload) throws IOException {
        payload.serialize(this.writer);
    }
}

