/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.managedobject;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.impl.managedobject.CDIManagedObject;
import com.ibm.ws.cdi.internal.interfaces.CDIRuntime;
import com.ibm.ws.cdi.internal.interfaces.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.cdi.internal.interfaces.WebSphereInjectionServices;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectInvocationContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.manager.api.WeldInjectionTargetFactory;
import org.jboss.weld.manager.api.WeldManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractManagedObjectFactory<T>
implements ManagedObjectFactory<T> {
    private static final TraceComponent tc = Tr.register(AbstractManagedObjectFactory.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private final CDIRuntime cdiRuntime;
    private final Class<T> managedClass;
    private Bean<T> bean;
    private boolean beanLookupComplete = false;
    private WeldManager beanManager;
    private WebSphereBeanDeploymentArchive bda;
    private final boolean requestManagingInjectionAndInterceptors;
    private ReferenceContext referenceContext = null;
    private WebSphereInjectionServices injectionServices;
    static final long serialVersionUID = 2624058130118513066L;

    public AbstractManagedObjectFactory(Class<T> classToManage, CDIRuntime cdiRuntime, boolean requestManagingInjectionAndInterceptors) {
        this.managedClass = classToManage;
        this.cdiRuntime = cdiRuntime;
        this.requestManagingInjectionAndInterceptors = requestManagingInjectionAndInterceptors;
    }

    public AbstractManagedObjectFactory(Class<T> classToManage, CDIRuntime cdiRuntime, boolean requestManagingInjectionAndInterceptors, ReferenceContext referenceContext) {
        this.managedClass = classToManage;
        this.cdiRuntime = cdiRuntime;
        this.requestManagingInjectionAndInterceptors = requestManagingInjectionAndInterceptors;
        this.referenceContext = referenceContext;
    }

    public boolean managesInjectionAndInterceptors() {
        return this.requestManagingInjectionAndInterceptors;
    }

    public Class<T> getManagedObjectClass() {
        return this.managedClass;
    }

    public boolean isManaged() {
        return true;
    }

    protected synchronized WeldManager getBeanManager() {
        if (this.beanManager == null) {
            this.beanManager = (WeldManager)this.cdiRuntime.getClassBeanManager(this.getManagedObjectClass());
            if (this.beanManager == null) {
                this.beanManager = (WeldManager)this.cdiRuntime.getCurrentModuleBeanManager();
            }
        }
        return this.beanManager;
    }

    protected synchronized WebSphereBeanDeploymentArchive getCurrentBeanDeploymentArchive() {
        if (this.bda == null) {
            this.bda = this.cdiRuntime.getClassBeanDeploymentArchive(this.getManagedObjectClass());
        }
        return this.bda;
    }

    protected synchronized WebSphereInjectionServices getWebSphereInjectionServices() {
        if (this.injectionServices == null) {
            this.injectionServices = this.cdiRuntime.getCurrentDeployment().getInjectionServices();
        }
        return this.injectionServices;
    }

    protected synchronized Bean<T> getBean() throws ManagedObjectException {
        if (!this.beanLookupComplete) {
            WeldManager beanManager = this.getBeanManager();
            Set beans = beanManager.getBeans(this.getManagedObjectClass(), new Annotation[0]);
            if (beans.size() == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No Beans found for managed class: " + this.getManagedObjectClass()), (Object[])new Object[0]);
                }
            } else {
                this.bean = beanManager.resolve(beans);
            }
            this.beanLookupComplete = true;
            if (this.bean != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found a bean of class : " + this.bean.getBeanClass()), (Object[])new Object[0]);
                }
                if (!this.bean.getBeanClass().equals(this.getManagedObjectClass())) {
                    throw new ManagedObjectException("Managed Class {" + this.getManagedObjectClass().getName() + "} does not match Bean Class {" + this.bean.getBeanClass().getName() + "}");
                }
            }
        }
        return this.bean;
    }

    public ManagedObject<T> existingInstance(T instance) throws ManagedObjectException {
        throw new UnsupportedOperationException();
    }

    public ManagedObjectContext createContext() throws ManagedObjectException {
        throw new UnsupportedOperationException();
    }

    public Constructor<T> getConstructor() {
        throw new UnsupportedOperationException();
    }

    public CDIRuntime getCDIRuntime() {
        return this.cdiRuntime;
    }

    public ManagedObject<T> createManagedObject() throws ManagedObjectException {
        throw new UnsupportedOperationException();
    }

    protected InjectionTarget<T> getInjectionTarget(boolean nonContextual) throws ManagedObjectException {
        InjectionTarget injectionTarget = null;
        Class<T> clazz = this.getManagedObjectClass();
        WebSphereBeanDeploymentArchive bda = this.getCurrentBeanDeploymentArchive();
        if (bda != null) {
            injectionTarget = bda.getJEEComponentInjectionTarget(clazz);
        }
        if (injectionTarget == null) {
            AnnotatedType<T> annotatedType = this.getAnnotatedType(clazz, nonContextual);
            WeldManager beanManager = this.getBeanManager();
            WeldInjectionTargetFactory itFactory = beanManager.getInjectionTargetFactory(annotatedType);
            Bean<T> bean = nonContextual ? null : this.getBean();
            injectionTarget = itFactory.createInjectionTarget(bean);
            if (bda != null) {
                if (bean == null) {
                    injectionTarget = beanManager.fireProcessInjectionTarget(annotatedType, injectionTarget);
                }
                bda.addJEEComponentInjectionTarget(clazz, injectionTarget);
            }
        }
        return injectionTarget;
    }

    protected AnnotatedType<T> getAnnotatedType(Class<T> clazz, boolean nonContextual) {
        WeldManager beanManager = this.getBeanManager();
        AnnotatedType annotatedType = null;
        annotatedType = nonContextual ? beanManager.createAnnotatedType(clazz, clazz.getName() + ": " + clazz.hashCode()) : beanManager.createAnnotatedType(clazz);
        return annotatedType;
    }

    protected abstract WeldCreationalContext<T> getCreationalContext(ManagedObjectInvocationContext<T> var1) throws ManagedObjectException;

    protected WeldCreationalContext<T> getCreationalContext(ManagedObjectInvocationContext<T> invocationContext, boolean nonContextual) throws ManagedObjectException {
        return this.getCreationalContext(invocationContext);
    }

    public final ManagedObject<T> createManagedObject(T instance, ManagedObjectInvocationContext<T> invocationContext) throws ManagedObjectException {
        WeldManager beanManager = this.getBeanManager();
        if (beanManager == null) {
            throw new IllegalStateException("Unable to obtain BeanManager");
        }
        boolean nonContextual = invocationContext == null;
        InjectionTarget<T> injectionTarget = this.getInjectionTarget(nonContextual);
        WeldCreationalContext<T> creationalContext = this.getCreationalContext(invocationContext, nonContextual);
        ManagedObject<T> mo = this.createManagedObject(instance, creationalContext, injectionTarget, nonContextual);
        return mo;
    }

    public ManagedObject<T> createManagedObject(ManagedObjectInvocationContext<T> invocationContext) throws ManagedObjectException {
        ManagedObject<Object> mo = this.createManagedObject(null, invocationContext);
        return mo;
    }

    private ManagedObject<T> createManagedObject(T instance, WeldCreationalContext<T> creationalContext, InjectionTarget<T> injectionTarget, boolean nonContextual) throws ManagedObjectException {
        CDIRuntime cdiRuntime = this.getCDIRuntime();
        WebSphereCDIDeployment deployment = cdiRuntime.getCurrentDeployment();
        WebSphereInjectionServices webSphereInjectionServices = deployment.getInjectionServices();
        if (instance == null) {
            instance = this.createInstance(injectionTarget, creationalContext);
        }
        CDIManagedObject<T> mo = new CDIManagedObject<T>(instance, creationalContext, injectionTarget, this.getBeanScope(nonContextual), webSphereInjectionServices);
        if (this.managesInjectionAndInterceptors()) {
            mo.inject(this.referenceContext);
            injectionTarget.postConstruct(mo.getObject());
        }
        return mo;
    }

    private String getBeanScope(boolean nonContextual) throws ManagedObjectException {
        Bean<T> bean;
        String beanScope = null;
        if (!nonContextual && (bean = this.getBean()) != null) {
            beanScope = bean.getScope().getCanonicalName();
        }
        return beanScope;
    }

    private T createInstance(final InjectionTarget<T> injectionTarget, final WeldCreationalContext<T> creationalContext) {
        Object instance = AccessController.doPrivileged(new PrivilegedAction<T>(){
            static final long serialVersionUID = 3792764950999350447L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public T run() {
                return injectionTarget.produce((CreationalContext)creationalContext);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.cdi.impl.managedobject.AbstractManagedObjectFactory$1", 1.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
            }
        });
        return instance;
    }
}

