/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.injection.InjectionRuntimeContextHelper;
import com.ibm.ws.jaxrs20.injection.metadata.InjectionRuntimeContext;
import com.ibm.ws.jaxrs20.injection.metadata.ParamInjectionMetadata;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionSimpleBinding;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractParamInjectionBinding<A extends Annotation>
extends InjectionSimpleBinding<A> {
    private static final TraceComponent tc = Tr.register(AbstractParamInjectionBinding.class, (String)"JaxRsCommon", (String)"com.ibm.ws.jaxrs20.internal.resources.JaxRsCommonMessages");
    static final long serialVersionUID = -2416758966647454325L;

    public AbstractParamInjectionBinding(A annotation, ComponentNameSpaceConfiguration nameSpaceConfig) {
        super(annotation, nameSpaceConfig);
    }

    public boolean isResolved() {
        return true;
    }

    protected abstract Object getJAXRSValueFromContext(A var1, Class<?> var2, Type var3, Annotation[] var4, Member var5, ParamInjectionMetadata var6) throws IOException;

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public Object getInjectionObject(Object target, InjectionTargetContext targetContext) throws InjectionException {
        InjectionRuntimeContext irc;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInjectionObject", (Object[])new Object[0]);
        }
        InjectionTarget it = this.getInjectionTarget();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Injection target {0} for this {1} injection binding", (Object[])new Object[]{it, this});
        }
        if ((irc = InjectionRuntimeContextHelper.getRuntimeContext()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not get Injection Runtime Context so not injecting for injection binding {0}", (Object[])new Object[]{this});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInjectionObject");
            }
            return null;
        }
        ParamInjectionMetadata pimd = (ParamInjectionMetadata)irc.getRuntimeCtxObject(ParamInjectionMetadata.class.getName());
        if (pimd == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not get Param Injection Metadata so not injecting for injection binding {0}", (Object[])new Object[]{this});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInjectionObject");
            }
            return null;
        }
        Object value = null;
        Member itMember = it.getMember();
        Annotation[] annotations = new Annotation[]{};
        Type t = null;
        if (itMember instanceof Field) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"itMember was a field instance", (Object[])new Object[0]);
            }
            Field f = (Field)itMember;
            annotations = f.getAnnotations();
            t = f.getGenericType();
        } else if (itMember instanceof Method) {
            Method m;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"itMember was a method instance", (Object[])new Object[0]);
            }
            if ((annotations = (m = (Method)itMember).getParameterAnnotations()[0]) == null || annotations.length == 0) {
                annotations = m.getAnnotations();
            }
            t = m.getGenericParameterTypes()[0];
        }
        try {
            value = this.getJAXRSValueFromContext(this.getAnnotation(), it.getInjectionClassType(), t, annotations, it.getMember(), pimd);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"value from instance was {0}", (Object[])new Object[]{value});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInjectionObject", (Object)new Object[]{value});
            }
            return value;
        }
        catch (IOException m) {
            FFDCFilter.processException((Throwable)m, (String)"com.ibm.ws.jaxrs20.injection.AbstractParamInjectionBinding", (String)"150", (Object)((Object)this), (Object[])new Object[]{target, targetContext});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Could not inject into the member {0}, " + e.getMessage()), (Object[])new Object[]{it.getMember()});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInjectionObject", (Object)new Object[]{value});
            }
            return value;
        }
    }

    protected Object getInjectedObjectFromCXF(Class<?> classType, Type genericType, Annotation[] memberAnnotations, ParamInjectionMetadata paramInjectionMetadata) {
        Parameter p = ResourceUtils.getParameter(0, memberAnnotations, classType);
        Object injectedObject = null;
        Message message = paramInjectionMetadata.getInMessage();
        OperationResourceInfo ori = paramInjectionMetadata.getOperationResourceInfo();
        ClassResourceInfo cri = ori.getClassResourceInfo();
        MultivaluedMap values = (MultivaluedMap)message.get("jaxrs.template.parameters");
        injectedObject = p.getType() == ParameterType.BEAN && cri instanceof ClassResourceInfo ? JAXRSUtils.createBeanParamValue(message, classType, ori) : JAXRSUtils.createHttpParameterValue(p, classType, genericType, memberAnnotations, message, (MultivaluedMap<String, String>)values, ori);
        return injectedObject;
    }
}

