/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.providers.multipart;

import com.ibm.websphere.jaxrs20.multipart.IAttachment;
import com.ibm.websphere.jaxrs20.multipart.IMultipartBody;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.multipart.impl.AttachmentImpl;
import com.ibm.ws.jaxrs20.multipart.impl.MultipartBodyImpl;
import com.ibm.ws.jaxrs20.providers.multipart.IBMParameterizedTypeImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.MultipartProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.MessageUtils;

@Provider
@Consumes(value={"multipart/related", "multipart/mixed", "multipart/alternative", "multipart/form-data"})
@Produces(value={"multipart/related", "multipart/mixed", "multipart/alternative", "multipart/form-data"})
@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class IBMMultipartProvider
extends AbstractConfigurableProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private final MultipartProvider multipartProvider;
    private static final String SUPPORT_TYPE_AS_MULTIPART = "support.type.as.multipart";
    private static final Set<String> MULTIPART_SUBTYPES;
    private static final Set<String> STR_WELL_KNOWN_MULTIPART_CLASSES;
    private static final String ACTIVE_JAXRS_PROVIDER_KEY = "active.jaxrs.provider";
    private static final Logger LOG;
    @Context
    private MessageContext mc;
    static final long serialVersionUID = 2464642981105538762L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IBMMultipartProvider() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "<init>", new Object[0]);
        }
        this.multipartProvider = new MultipartProvider();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "getSize", new Object[]{t, type, genericType, annotations, mediaType});
        }
        long l = -1L;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            l = l;
            LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "getSize", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "isWriteable", new Object[]{type, genericType, annotations, mt});
        }
        boolean bl = this.isSupported(type, genericType, annotations, mt);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "isWriteable", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeTo(Object obj, Class<?> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "writeTo", new Object[]{obj, type, genericType, anns, mt, headers, os});
        }
        if (Map.class.isAssignableFrom(obj.getClass())) {
            Map objects = CastUtils.cast((Map)obj);
            for (Map.Entry entry : objects.entrySet()) {
                Object value = entry.getValue();
                if (value == null || !AttachmentImpl.class.isAssignableFrom(value.getClass())) continue;
                entry.setValue(((AttachmentImpl)value).getAttachment());
            }
        } else if (List.class.isAssignableFrom(obj.getClass())) {
            List objects = (List)obj;
            for (int i = 0; i < objects.size(); ++i) {
                if (objects.get(i) == null || !AttachmentImpl.class.isAssignableFrom(objects.get(i).getClass())) continue;
                Attachment a = ((AttachmentImpl)objects.get(i)).getAttachment();
                objects.set(i, a);
            }
        } else if (MultipartBodyImpl.class.isAssignableFrom(obj.getClass())) {
            obj = ((MultipartBodyImpl)obj).getMultipartBody();
        } else if (AttachmentImpl.class.isAssignableFrom(obj.getClass())) {
            obj = ((AttachmentImpl)obj).getAttachment();
        }
        if (type.equals(AttachmentImpl.class)) {
            type = Attachment.class;
        } else if (type.equals(MultipartBodyImpl.class)) {
            type = MultipartBody.class;
        }
        if (genericType.equals(AttachmentImpl.class)) {
            genericType = Attachment.class;
        } else if (genericType.equals(MultipartBodyImpl.class)) {
            genericType = IMultipartBody.class;
        }
        this.multipartProvider.writeTo(obj, type, (Type)((Object)genericType), anns, mt, headers, os);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "writeTo");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "isReadable", new Object[]{type, genericType, annotations, mt});
        }
        boolean bl = this.isSupported(type, genericType, annotations, mt);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "isReadable", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isSupported(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "isSupported", new Object[]{type, genericType, anns, mt});
        }
        if (this.mediaTypeSupported(mt) && (STR_WELL_KNOWN_MULTIPART_CLASSES.contains(type.getName()) || Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) && type != MultivaluedMap.class || AnnotationUtils.getAnnotation(anns, Multipart.class) != null || MessageUtils.isTrue(this.mc.getContextualProperty(SUPPORT_TYPE_AS_MULTIPART)))) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "isSupported", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "isSupported", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean mediaTypeSupported(MediaType mt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "mediaTypeSupported", new Object[]{mt});
        }
        boolean bl = mt.getType().equals("multipart") && MULTIPART_SUBTYPES.contains(mt.getSubtype());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "mediaTypeSupported", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Class<?> getActualType(Type type, int pos) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "getActualType", new Object[]{type, pos});
        }
        Class<?> actual = null;
        try {
            actual = InjectionUtils.getActualType(type, pos);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", (String)"195", (Object)this, (Object[])new Object[]{type, pos});
        }
        Class clazz = actual != null && actual != Object.class ? actual : Attachment.class;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "getActualType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object readFrom(Class<Object> c, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "readFrom", new Object[]{c, t, anns, mt, headers, is});
        }
        this.multipartProvider.setMessageContext(this.mc);
        ParameterizedType origType = null;
        Type[] actualType = null;
        if (ParameterizedType.class.isAssignableFrom(t.getClass())) {
            origType = (ParameterizedType)t;
            actualType = origType.getActualTypeArguments();
            for (int i = 0; i < actualType.length; ++i) {
                if (actualType[i].equals(IAttachment.class)) {
                    actualType[i] = Attachment.class;
                    continue;
                }
                if (!actualType[i].equals(IMultipartBody.class)) continue;
                actualType[i] = MultipartBody.class;
            }
            if (actualType != null && origType != null) {
                t = IBMParameterizedTypeImpl.make(origType.getRawType().getClass(), actualType, origType.getOwnerType());
            }
        } else if (IMultipartBody.class.isAssignableFrom(this.getActualType((Type)t, 0))) {
            t = MultipartBody.class;
        }
        if (IAttachment.class.equals(c)) {
            c = Attachment.class;
        } else if (IMultipartBody.class.equals(c)) {
            c = MultipartBody.class;
        }
        if ("com.ibm.websphere.jaxrs20.multipart.IAttachment".equals(c.getName())) {
            c = Attachment.class;
        } else if ("com.ibm.websphere.jaxrs20.multipart.IMultipartBody".equals(c.getName())) {
            c = MultipartBody.class;
        }
        Object object = this.multipartProvider.readFrom(c, (Type)t, anns, mt, headers, is);
        if (object instanceof List) {
            List attList = (List)object;
            if (!attList.isEmpty()) {
                LinkedList<AttachmentImpl> attImplList = new LinkedList<AttachmentImpl>();
                for (Object obj : attList) {
                    if (obj == null || !(obj instanceof Attachment)) continue;
                    AttachmentImpl attachmentImpl = new AttachmentImpl((Attachment)obj);
                    attImplList.add(attachmentImpl);
                }
                LinkedList<AttachmentImpl> linkedList = attImplList;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    linkedList = linkedList;
                    LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "readFrom", linkedList);
                }
                return linkedList;
            }
            Object object2 = object;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object2 = object2;
                LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "readFrom", object2);
            }
            return object2;
        }
        if (object != null && Map.class.isAssignableFrom(object.getClass())) {
            Map attMap = (Map)object;
            if (!attMap.isEmpty()) {
                for (Map.Entry entry : attMap.entrySet()) {
                    List attList;
                    if (entry.getValue() == null || !List.class.isAssignableFrom(entry.getValue().getClass()) || (attList = (List)entry.getValue()).isEmpty()) continue;
                    LinkedList<AttachmentImpl> attImplList = new LinkedList<AttachmentImpl>();
                    for (Object obj : attList) {
                        if (obj == null || !Attachment.class.isAssignableFrom(obj.getClass())) continue;
                        AttachmentImpl attImpl = new AttachmentImpl((Attachment)obj);
                        attImplList.add(attImpl);
                    }
                    entry.setValue(attImplList);
                }
            }
            Map map = attMap;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                map = map;
                LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "readFrom", map);
            }
            return map;
        }
        if (object instanceof MultipartBody) {
            MultipartBodyImpl imbody;
            MultipartBodyImpl multipartBodyImpl = imbody = new MultipartBodyImpl((MultipartBody)object);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                multipartBodyImpl = multipartBodyImpl;
                LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "readFrom", multipartBodyImpl);
            }
            return multipartBodyImpl;
        }
        Object object3 = object;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object3 = object3;
            LOG.exiting("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", "readFrom", object3);
        }
        return object3;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        LOG = LogUtils.getL7dLogger(IBMMultipartProvider.class);
        STR_WELL_KNOWN_MULTIPART_CLASSES = new HashSet<String>();
        STR_WELL_KNOWN_MULTIPART_CLASSES.add("com.ibm.websphere.jaxrs20.multipart.IMultipartBody");
        STR_WELL_KNOWN_MULTIPART_CLASSES.add("com.ibm.websphere.jaxrs20.multipart.IAttachment");
        STR_WELL_KNOWN_MULTIPART_CLASSES.add("com.ibm.ws.jaxrs20.multipart.impl.MultipartBodyImpl");
        STR_WELL_KNOWN_MULTIPART_CLASSES.add("com.ibm.ws.jaxrs20.multipart.impl.AttachmentImpl");
        MULTIPART_SUBTYPES = new HashSet<String>();
        MULTIPART_SUBTYPES.add("form-data");
        MULTIPART_SUBTYPES.add("mixed");
        MULTIPART_SUBTYPES.add("related");
        MULTIPART_SUBTYPES.add("alternative");
    }
}

