/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.cache.CacheEntry;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.ESISupport;
import com.ibm.ws.cache.servlet.FragmentComposer;
import com.ibm.ws.cache.servlet.FragmentComposerMemento;
import com.ibm.ws.cache.servlet.FragmentInfo;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.cache.servlet.ServletWrapper;
import com.ibm.ws.cache.servlet.UnexternalizablePageException;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.cache.web.ExternalCacheFragment;
import com.ibm.ws.cache.web.ServletCacheServiceImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WSThreadLocal;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheHook {
    private static TraceComponent tc = Tr.register(CacheHook.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    static WSThreadLocal<FragmentComposer> threadLocalFragmentComposer = new WSThreadLocal();
    static WSThreadLocal<Boolean> threadLocalSkipCache = new WSThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleServlet(Servlet servlet, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleServlet", (Object[])new Object[]{request.getDispatcherType()});
        }
        ServletWrapper sw = null;
        try {
            sw = (ServletWrapper)servlet;
        }
        catch (ClassCastException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.CacheHook.handleServlet", (String)"112");
            Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object[])new Object[]{"incorrectly initialized " + servlet + ", couldn't find a ServletWrapper"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("wanted a ServletWrapper, got " + servlet + ". servicing as normal"), (Object[])new Object[0]);
            }
            servlet.service((ServletRequest)request, (ServletResponse)response);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleServlet");
            }
            return;
        }
        String relativeUri = null;
        String absoluteUri = null;
        String contextPath = null;
        String queryString = null;
        boolean namedDispatch = false;
        String servletName = null;
        String servletClassName = null;
        int portletMethod = 1;
        boolean include = false;
        boolean forward = false;
        DispatcherType dispatchType = request.getDispatcherType();
        if (dispatchType.equals((Object)DispatcherType.INCLUDE)) {
            include = true;
        } else if (dispatchType.equals((Object)DispatcherType.FORWARD)) {
            forward = true;
        }
        try {
            String servletPath;
            String pathInfo;
            String cp;
            if (include) {
                cp = (String)request.getAttribute("javax.servlet.include.context_path");
                if (cp == null) {
                    contextPath = "/" + servlet.getServletConfig().getServletContext().getServletContextName();
                    servletName = servlet.getServletConfig().getServletName();
                    String clazzName = ((ServletWrapper)servlet).getProxiedServlet().getClass().getName() + ".class";
                    servletClassName = request.getContextPath() == null ? clazzName : request.getContextPath() + "/" + clazzName;
                    namedDispatch = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Attribute javax.servlet.include.context_path was null.  Request was made using a NamedDispatcher", (Object[])new Object[0]);
                    }
                } else {
                    contextPath = cp;
                    absoluteUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                    pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                    servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
                    queryString = (String)request.getAttribute("javax.servlet.include.query_string");
                    String clazzName = ((ServletWrapper)servlet).getProxiedServlet().getClass().getName() + ".class";
                    String string = servletClassName = request.getContextPath() == null ? clazzName : request.getContextPath() + "/" + clazzName;
                    if (pathInfo != null) {
                        relativeUri = new StringBuffer(servletPath).append(pathInfo).toString();
                        if (queryString != null) {
                            relativeUri = new StringBuffer(relativeUri).append("?").append(queryString).toString();
                            absoluteUri = new StringBuffer(absoluteUri).append("?").append(queryString).toString();
                        }
                    } else {
                        relativeUri = servletPath;
                        if (queryString != null) {
                            relativeUri = new StringBuffer(relativeUri).append("?").append(queryString).toString();
                            absoluteUri = new StringBuffer(absoluteUri).append("?").append(queryString).toString();
                        }
                    }
                }
            } else {
                cp = (String)request.getAttribute("javax.servlet.forward.context_path");
                if (cp == null && forward) {
                    contextPath = "/" + servlet.getServletConfig().getServletContext().getServletContextName();
                    servletName = servlet.getServletConfig().getServletName();
                    String clazzName = ((ServletWrapper)servlet).getProxiedServlet().getClass().getName() + ".class";
                    servletClassName = request.getContextPath() == null ? clazzName : request.getContextPath() + "/" + clazzName;
                    namedDispatch = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Attribute javax.servlet.forward.context_path was null.  Request was made using a NamedDispatcher", (Object[])new Object[0]);
                    }
                } else {
                    contextPath = request.getContextPath();
                    absoluteUri = request.getRequestURI();
                    servletPath = request.getServletPath();
                    pathInfo = request.getPathInfo();
                    String clazzName = ((ServletWrapper)servlet).getProxiedServlet().getClass().getName() + ".class";
                    String string = servletClassName = request.getContextPath() == null ? clazzName : request.getContextPath() + "/" + clazzName;
                    if (forward) {
                        queryString = request.getQueryString();
                    }
                    if (pathInfo != null) {
                        relativeUri = new StringBuffer(servletPath).append(pathInfo).toString();
                        if (queryString != null) {
                            relativeUri = new StringBuffer(relativeUri).append("?").append(queryString).toString();
                            absoluteUri = new StringBuffer(absoluteUri).append("?").append(queryString).toString();
                        }
                    } else {
                        relativeUri = servletPath;
                        if (queryString != null) {
                            relativeUri = new StringBuffer(relativeUri).append("?").append(queryString).toString();
                            absoluteUri = new StringBuffer(absoluteUri).append("?").append(queryString).toString();
                        }
                    }
                }
            }
        }
        catch (ClassCastException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.CacheHook.handleServlet", (String)"89");
            Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object[])new Object[]{"Dynacache received unexpected HttpServletRequest:" + request + ". Expected WebAppDispatcherRequest"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("wanted a WebAppDispatcherRequest, got " + request + ". servicing as normal"), (Object[])new Object[0]);
            }
            sw.serviceProxied((ServletRequest)request, (ServletResponse)response);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleServlet");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String debugString2;
            String debugString1;
            if (portletMethod == 2) {
                debugString1 = "handlePortletCache";
                debugString2 = "portlet";
            } else {
                debugString1 = "handleServlet";
                debugString2 = "servlet";
            }
            Tr.debug((TraceComponent)tc, (String)(debugString1 + ": absoluteUri = " + absoluteUri + ", relativeURI=" + relativeUri + ", contextPath=" + contextPath + ", include=" + include), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(debugString1 + ": " + debugString2 + " = " + servlet + ", request = " + request + ", response = " + response), (Object[])new Object[0]);
        }
        FragmentComposer parentFragmentComposer = null;
        parentFragmentComposer = dispatchType.equals((Object)DispatcherType.ASYNC) ? ((CacheProxyRequest)request).getFragmentComposer() : (FragmentComposer)threadLocalFragmentComposer.get();
        CacheProxyRequest cacheProxyRequest = new CacheProxyRequest(request);
        if (response.getClass().getName().equals("org.apache.taglibs.standard.tag.common.core.ImportSupport$ImportResponseWrapper")) {
            parentFragmentComposer.setJSTLImport(true);
        }
        CacheHook.checkDiscardSkipCacheAttribute(request, parentFragmentComposer, cacheProxyRequest);
        cacheProxyRequest.setRequest((ServletRequest)request);
        cacheProxyRequest.setRelativeUri(relativeUri);
        cacheProxyRequest.setAbsoluteUri(absoluteUri);
        cacheProxyRequest.setInclude(include);
        cacheProxyRequest.setNamedDispatch(namedDispatch);
        cacheProxyRequest.setServletName(servletName);
        cacheProxyRequest.setServletClassName(servletClassName);
        cacheProxyRequest._setContextPath(contextPath);
        cacheProxyRequest.setPortletMethod(portletMethod);
        CacheProxyResponse cacheProxyResponse = ServletCacheServiceImpl.getInstance().cacheProxyResponseFactory.createCacheProxyResponse(response);
        try {
            CacheHook.handleFragment(sw, cacheProxyRequest, cacheProxyResponse, parentFragmentComposer);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("threadLocalFragmentComposer set to " + parentFragmentComposer), (Object[])new Object[0]);
            }
            threadLocalFragmentComposer.set((Object)parentFragmentComposer);
            CacheHook.cleanup(parentFragmentComposer, cacheProxyRequest, cacheProxyResponse);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleServlet");
        }
    }

    private static void cleanup(FragmentComposer parentFragmentComposer, CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanup", (Object[])new Object[]{parentFragmentComposer, cacheProxyRequest, cacheProxyResponse});
        }
        if (parentFragmentComposer == null) {
            CacheHook.setSkipCache(false);
            cacheProxyRequest.getFragmentComposer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanup");
        }
    }

    public static void putInCache(FragmentComposer fragmentComposer) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"putInCache", (Object[])new Object[]{fragmentComposer});
        }
        CacheProxyRequest request = fragmentComposer.getRequest();
        CacheProxyResponse response = fragmentComposer.getResponse();
        FragmentInfo fragInfo = fragmentComposer.getFragmentInfo();
        JSPCache jspCache = (JSPCache)ServerCache.getJspCache((String)fragmentComposer.getFragmentInfo().getInstanceName());
        String cacheGroup = fragInfo.getExternalCacheGroupId();
        FragmentComposerMemento memento = response.getFragmentComposer().getMemento(request);
        memento.setContainsESIContent(response.getContainsESIContent());
        fragmentComposer.setTimeStamp(System.currentTimeMillis());
        CacheHook.setValue(request, response, fragInfo, jspCache, fragmentComposer, memento, cacheGroup, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"putInCache");
        }
    }

    private static void checkDiscardSkipCacheAttribute(HttpServletRequest request, FragmentComposer parentFragmentComposer, CacheProxyRequest cacheProxyRequest) {
        if (parentFragmentComposer == null) {
            FragmentInfo fragmentInfo = (FragmentInfo)cacheProxyRequest.getFragmentInfo();
            String skipCacheAttribute = fragmentInfo.getSkipCacheAttribute();
            if (skipCacheAttribute != null && request.getAttribute(skipCacheAttribute) != null) {
                CacheHook.setSkipCache(true);
                return;
            }
            Object previewRequest = request.getAttribute("previewRequest");
            if (previewRequest == null) {
                return;
            }
            boolean isPreview = false;
            if (previewRequest instanceof Boolean) {
                isPreview = (Boolean)previewRequest;
            } else if (previewRequest instanceof String) {
                isPreview = Boolean.parseBoolean((String)previewRequest);
            }
            if (isPreview) {
                CacheHook.setSkipCache(isPreview);
            }
        }
    }

    public static void checkDiscardJSPContentAttribute(HttpServletRequest request, FragmentComposer fc) {
        Object discardJSPContent = request.getAttribute("discardJSPContent");
        if (discardJSPContent == null) {
            return;
        }
        Boolean toDiscard = null;
        if (discardJSPContent instanceof Boolean) {
            toDiscard = (Boolean)discardJSPContent;
        } else if (discardJSPContent instanceof String) {
            toDiscard = Boolean.parseBoolean((String)discardJSPContent);
        }
        if (toDiscard != null) {
            CacheHook.setDiscardJSPContent(fc, toDiscard);
        }
    }

    public static void setDiscardJSPContent(FragmentComposer fc, boolean discard) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setDiscardJSPContent", (Object[])new Object[]{fc, discard});
        }
        fc.setDiscardJSPContent(discard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleFragment(ServletWrapper servlet, CacheProxyRequest request, CacheProxyResponse response, FragmentComposer parentFragmentComposer) throws ServletException, IOException {
        boolean cacheable;
        boolean dncResult;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("handleFragment " + request + " " + response), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("parentFragmentComposer: " + parentFragmentComposer), (Object[])new Object[0]);
        }
        boolean isExternalPage = parentFragmentComposer == null;
        FragmentComposer fragmentComposer = CacheHook.getFragmentComposer(request, response, parentFragmentComposer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("threadLocalFragmentComposer set to " + fragmentComposer), (Object[])new Object[0]);
        }
        threadLocalFragmentComposer.set((Object)fragmentComposer);
        fragmentComposer.setParent(parentFragmentComposer);
        CacheHook.checkDiscardJSPContentAttribute(request, fragmentComposer);
        if (request.getNamedDispatch()) {
            fragmentComposer.setURI(request.getServletName());
        } else {
            fragmentComposer.setURI(request.getRelativeUri());
        }
        fragmentComposer.setServletClassName(request.getServletClassName());
        fragmentComposer.setExternalPage(isExternalPage);
        fragmentComposer.setInclude(request.getInclude());
        fragmentComposer.setNamedDispatch(request.getNamedDispatch());
        response.setFragmentComposer(fragmentComposer);
        request.setFragmentComposer(fragmentComposer);
        FragmentInfo fragmentInfo = (FragmentInfo)request.getFragmentInfo();
        fragmentInfo.setURI(request.getAbsoluteUri());
        fragmentComposer.setFragmentInfo(fragmentInfo);
        CacheHook.processRequestAttributes(request, fragmentComposer);
        servlet.prepareMetadata(request, response);
        fragmentComposer.setConsumeSubfragments(fragmentInfo == null ? false : fragmentInfo.getConsumeSubfragments());
        fragmentComposer.setDoNotConsume(fragmentInfo == null ? false : fragmentInfo.getDoNotConsume() || fragmentInfo.getDoNotCache());
        if (parentFragmentComposer != null && (parentFragmentComposer.getHasCacheableConsumingParent() || parentFragmentComposer.getConsumeSubfragments() && parentFragmentComposer.getRequest().getCaching())) {
            fragmentComposer.setHasCacheableConsumingParent(true);
            fragmentInfo.setHasCacheableConsumingParent(true);
        }
        String instanceName = fragmentInfo.getInstanceName();
        JSPCache jspCache = (JSPCache)ServerCache.getJspCache((String)instanceName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CACHE INSTANCE name:" + instanceName), (Object[])new Object[0]);
        }
        String id = fragmentInfo.getId();
        String requestType = request.getMethod();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Request Type:" + requestType), (Object[])new Object[0]);
        }
        if (request.getDispatcherType().equals((Object)DispatcherType.ASYNC) && parentFragmentComposer.getURI().equals(fragmentComposer.getURI())) {
            fragmentComposer.setAsyncDoubleDip(true);
        }
        boolean bl = dncResult = !fragmentInfo.getDoNotCache() || fragmentInfo.getDoNotCache() && fragmentInfo.isEdgeable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dncResult: " + dncResult + " skipCache: " + CacheHook.isSkipCache()), (Object[])new Object[0]);
        }
        boolean bl2 = cacheable = fragmentInfo.getId() != null && jspCache != null && !CacheHook.isSkipCache() && dncResult;
        if (!fragmentInfo.isIgnoreGetPost()) {
            cacheable = cacheable && id.indexOf("requestType=" + requestType) != -1;
        }
        boolean setCaching = cacheable;
        if (fragmentInfo.getDoNotCache() && fragmentInfo.isEdgeable()) {
            setCaching = false;
        }
        request.setCaching(setCaching);
        request.setUncacheable(!setCaching);
        if (jspCache.isAutoFlushIncludes()) {
            request.setAttribute("com.ibm.ws.cache.flush.imports", "true");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Automatically flushing include: " + fragmentComposer.getURI()), (Object[])new Object[0]);
            }
        }
        if (parentFragmentComposer != null) {
            parentFragmentComposer.startChildFragmentComposer(fragmentComposer);
        }
        boolean exceptionThrown = true;
        boolean handledSuccessfully = true;
        try {
            ESISupport.handleESIPreProcessing(request, response, fragmentInfo);
            if (cacheable) {
                if (isExternalPage) {
                    CacheHook.externalPreInvoke(fragmentInfo.externalCacheGroupId, request, response);
                }
                handledSuccessfully = false;
                CacheHook.handleCacheableFragment(servlet, request, response, fragmentInfo, jspCache);
                handledSuccessfully = true;
                exceptionThrown = !handledSuccessfully;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CACHE?  NO, servlet: " + servlet), (Object[])new Object[0]);
                }
                if (fragmentComposer.getHasCacheableConsumingParent()) {
                    fragmentComposer.setCacheType(2);
                    if (jspCache.isCascadeCachespecProperties()) {
                        CacheHook.cascadeFragmentInfoFromParent(fragmentComposer);
                    }
                } else {
                    fragmentComposer.setCacheType(0);
                }
                servlet.serviceProxied((ServletRequest)request, (ServletResponse)response);
                exceptionThrown = false;
            }
        }
        finally {
            if (!fragmentComposer.isAsyncDispatch()) {
                CacheHook.postProcess(request, response, fragmentComposer, cacheable, exceptionThrown);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleFragment");
        }
    }

    private static FragmentComposer getFragmentComposer(CacheProxyRequest req, CacheProxyResponse resp, FragmentComposer parentFC) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getFragmentComposer " + req.getRelativeUri()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SYNC INCLUDE " + req.getRelativeUri()), (Object[])new Object[0]);
        }
        FragmentComposer fragmentComposer = ServletCacheServiceImpl.getInstance().fragmentComposerFactory.createFragmentComposer();
        fragmentComposer.reset(req, resp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFragmentComposer", (Object)fragmentComposer);
        }
        return fragmentComposer;
    }

    static void postProcess(CacheProxyRequest request, CacheProxyResponse response, FragmentComposer fragmentComposer, boolean cacheable, boolean exceptionThrown) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postProcess", (Object[])new Object[]{fragmentComposer});
        }
        FragmentInfo fragmentInfo = fragmentComposer.getFragmentInfo();
        if (!fragmentComposer.isExternalPage()) {
            fragmentComposer.saveExternalInvalidationIds();
        }
        if (cacheable && fragmentComposer.isExternalPage()) {
            CacheHook.externalPostInvoke(fragmentInfo.externalCacheGroupId, request, response);
        }
        fragmentComposer.copyContentForParents();
        CacheHook.checkDiscardJSPContentAttribute(request, fragmentComposer);
        fragmentComposer.requestFinished();
        ESISupport.handleESIPostProcessing(response, fragmentInfo, exceptionThrown);
        FragmentComposer parentFragmentComposer = fragmentComposer.parent;
        if (null != parentFragmentComposer) {
            parentFragmentComposer.endChildFragmentComposer(fragmentComposer);
        }
        request.clearSetTable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postProcess");
        }
    }

    protected static void processRequestAttributes(CacheProxyRequest request, FragmentComposer fragmentComposer) throws IOException {
        FragmentComposer parentFragmentComposer = fragmentComposer.parent;
        if (parentFragmentComposer != null) {
            int cacheType = parentFragmentComposer.getCacheType();
            CacheProxyRequest parentCacheProxyRequest = parentFragmentComposer.getRequest();
            if (cacheType == 2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CacheHook: saving Attributes for parent" + parentFragmentComposer.getURI()), (Object[])new Object[0]);
                }
                CacheProxyRequest.Attribute[] saveList = parentFragmentComposer.getSaveAttributeList(parentCacheProxyRequest);
                if (!parentFragmentComposer.getFragmentInfo().isNotShared() && saveList != null) {
                    byte[] attributeTableBytes = CacheHook.getChangedAttributeBytes(parentCacheProxyRequest, saveList);
                    fragmentComposer.setAttributeTableBytes(attributeTableBytes);
                } else {
                    fragmentComposer.setAttributeTable(saveList);
                }
            }
            if (cacheType == 1) {
                CacheProxyRequest.Attribute[] attr;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"cacheType == FragmentComposer.WAS_CACHED", (Object[])new Object[0]);
                }
                if ((attr = parentCacheProxyRequest.removeAttributeTableUnReadied()) != null) {
                    request.setAttributeTableUnReadied(attr);
                } else {
                    request.setAttributeTableBytes(parentCacheProxyRequest.removeAttributeTableBytes());
                }
            }
            request.readyAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleCacheableFragment(ServletWrapper servlet, CacheProxyRequest request, CacheProxyResponse response, FragmentInfo fragmentInfo, JSPCache jspCache) throws ServletException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleCacheableFragment", (Object[])new Object[0]);
        }
        if (ESISupport.shouldBuildESIInclude(request, response, fragmentInfo)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleCacheableFragment");
            }
            return;
        }
        FragmentComposer fragmentComposer = response.getFragmentComposer();
        String id = fragmentInfo.getId();
        CacheEntry cacheEntry = null;
        try {
            Object fragmentValue = null;
            boolean didMiss = false;
            boolean isInvalidEntry = false;
            cacheEntry = fragmentComposer.isAsyncDoubleDip() ? jspCache.getEntry(fragmentInfo, true) : jspCache.getEntry(fragmentInfo);
            if (cacheEntry != null) {
                fragmentValue = cacheEntry.getValue();
                if (fragmentValue == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CACHE MISS id: " + id), (Object[])new Object[0]);
                    }
                    didMiss = true;
                    CacheHook.handleCacheMiss(servlet, request, response, fragmentInfo, fragmentComposer, jspCache, cacheEntry, fragmentValue);
                } else if (cacheEntry.isInvalid()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CACHE MISS? on invalid cache entry id: " + id), (Object[])new Object[0]);
                    }
                    didMiss = true;
                    isInvalidEntry = true;
                    CacheHook.handleCacheMiss(servlet, request, response, fragmentInfo, fragmentComposer, jspCache, cacheEntry, fragmentValue);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CACHE MISS id: " + id), (Object[])new Object[0]);
                }
                didMiss = true;
                CacheHook.handleCacheMiss(servlet, request, response, fragmentInfo, fragmentComposer, jspCache, cacheEntry, fragmentValue);
            }
            if (!didMiss) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CACHE HIT id:" + id), (Object[])new Object[0]);
                }
                CacheHook.handleCacheHit(servlet, request, response, fragmentInfo, fragmentComposer, jspCache, cacheEntry, fragmentValue, false);
            }
        }
        finally {
            if (cacheEntry != null) {
                cacheEntry.finish();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleCacheableFragment");
        }
    }

    private static final void handleCacheHit(ServletWrapper servlet, CacheProxyRequest request, CacheProxyResponse response, FragmentInfo fragmentInfo, FragmentComposer fragmentComposer, JSPCache jspCache, CacheEntry cacheEntry, Object fragmentValue, boolean isUseCachedContent) throws ServletException, IOException {
        fragmentComposer.setCacheType(1);
        FragmentComposerMemento memento = (FragmentComposerMemento)fragmentValue;
        memento.displayPage(servlet, request, response);
        fragmentComposer.setExpirationTime(cacheEntry.getExpirationTime());
        fragmentInfo.setExpirationTime(cacheEntry.getExpirationTime());
        fragmentComposer.setTimeStamp(cacheEntry.getTimeStamp());
        String externalCacheGroupId = fragmentInfo.getExternalCacheGroupId();
        if (isUseCachedContent) {
            jspCache.setValidatorExpirationTime(fragmentInfo, memento);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("USE_CACHED_CONTENT for vbc; setting validator expiration time to " + fragmentInfo.getValidatorExpirationTime()), (Object[])new Object[0]);
            }
        }
        if (!fragmentComposer.isExternalPage() || externalCacheGroupId == null || externalCacheGroupId.equals("")) {
            return;
        }
        Enumeration dataIdsEnum = cacheEntry.getDataIds();
        while (dataIdsEnum.hasMoreElements()) {
            Object dataId = dataIdsEnum.nextElement();
            fragmentInfo.addDataId(dataId);
        }
        Enumeration tempEnum = cacheEntry.getTemplates();
        while (tempEnum.hasMoreElements()) {
            String temp = (String)tempEnum.nextElement();
            fragmentInfo.addTemplate(temp);
        }
        CacheHook.setValue(request, response, fragmentInfo, jspCache, fragmentComposer, memento, externalCacheGroupId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean handleCacheMiss(ServletWrapper servlet, CacheProxyRequest request, CacheProxyResponse response, FragmentInfo fragmentInfo, FragmentComposer fragmentComposer, JSPCache jspCache, CacheEntry cacheEntry, Object fragmentValue) throws ServletException, IOException {
        String id;
        block22: {
            id = fragmentInfo.getId();
            fragmentComposer.setCacheType(2);
            boolean exceptionDuringService = true;
            boolean responseNotCacheable = false;
            Exception ex = null;
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("servicing " + id), (Object[])new Object[0]);
                }
                servlet.serviceProxied((ServletRequest)request, (ServletResponse)response);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("servicing " + id + " finished."), (Object[])new Object[0]);
                }
                exceptionDuringService = false;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CacheHook.class.getName() + ".handleCacheMiss()"), (String)"867");
                ex = e;
                return (boolean)ex;
            }
            finally {
                boolean wsHttpResponseIsCacheable;
                Object wsInvokeStatus = request.getAttribute("httpResponseIsCacheable");
                if (null != wsInvokeStatus && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("httpResponseIsCacheable: " + wsInvokeStatus), (Object[])new Object[0]);
                }
                if (wsInvokeStatus instanceof Boolean && !(wsHttpResponseIsCacheable = ((Boolean)wsInvokeStatus).booleanValue())) {
                    responseNotCacheable = true;
                }
                if (response.statusCode != 0) {
                    int[] filteredStatusCodes;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("handleCacheMiss: statusCode=" + response.statusCode), (Object[])new Object[0]);
                    }
                    if (null != (filteredStatusCodes = jspCache.getFilteredStatusCodes()) && filteredStatusCodes.length > 0) {
                        for (int i = 0; i < filteredStatusCodes.length; ++i) {
                            if (response.statusCode != filteredStatusCodes[i]) continue;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)("handleCacheMiss: returning false because statusCode is filtered. " + filteredStatusCodes[i]));
                            }
                            return false;
                        }
                    }
                }
                if (responseNotCacheable) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("response of " + id + " is not cacheable.  httpResponseIsCacheable is true."), (Object[])new Object[0]);
                    }
                    return false;
                }
                if (!exceptionDuringService) break block22;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("invocation of " + id + " threw an exception.  Not Caching."), (Object[])new Object[0]);
                }
                throw new ServletException((Throwable)ex);
            }
        }
        if (fragmentInfo.isUncacheable() || CacheHook.isSkipCache()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not Caching: " + id + " fragmentInfo.isUncacheable(): " + fragmentInfo.isUncacheable() + " isSkipCache(): " + CacheHook.isSkipCache()), (Object[])new Object[0]);
            }
            return false;
        }
        if (!fragmentComposer.isAsyncDispatch()) {
            CacheHook.putInCache(fragmentComposer);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Skipped putting in cache", (Object[])new Object[0]);
        }
        return true;
    }

    static final byte[] getChangedAttributeBytes(CacheProxyRequest request, CacheProxyRequest.Attribute[] attributes) {
        if (attributes == null) {
            return null;
        }
        byte[] array = null;
        try {
            array = SerializationUtility.serialize((Serializable)attributes);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.CacheHook.getChangedAttributeBytes", (String)"335");
            String id = request.getFragmentInfo().getId();
            ((FragmentInfo)request.getFragmentInfo()).setUncacheable(true);
            Tr.error((TraceComponent)tc, (String)"dynacache.notSerializable", (Object[])new Object[]{id + ":" + ex.getMessage()});
            return null;
        }
        return array;
    }

    static void setValue(CacheProxyRequest request, CacheProxyResponse response, FragmentInfo fragmentInfo, JSPCache jspCache, FragmentComposer fragmentComposer, FragmentComposerMemento memento, String externalCacheGroupId, boolean cacheHit) {
        ExternalCacheFragment externalCacheFragment;
        block16: {
            externalCacheFragment = null;
            if (fragmentComposer.isExternalPage() && externalCacheGroupId != null) {
                try {
                    ValueSet dataIds = fragmentComposer.getAllInvalidationIds();
                    ValueSet uris = fragmentComposer.getAllTemplates();
                    long expirationTime = fragmentComposer.getExpirationTime();
                    long timeStamp = fragmentComposer.getTimeStamp();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("dataIds: " + dataIds), (Object[])new Object[0]);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("uris: " + uris), (Object[])new Object[0]);
                    }
                    if (expirationTime >= 0L) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("expirationTime: " + new Date(expirationTime)), (Object[])new Object[0]);
                        }
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"no expiration", (Object[])new Object[0]);
                    }
                    byte[] content = fragmentComposer.toByteArray(response.getCharacterEncoding());
                    String queryString = request.getQueryString();
                    externalCacheFragment = new ExternalCacheFragment();
                    if (queryString != null) {
                        externalCacheFragment.setUri(fragmentInfo.getURI() + "?" + queryString);
                    } else {
                        externalCacheFragment.setUri(fragmentInfo.getURI());
                    }
                    externalCacheFragment.setExternalCacheGroupId(externalCacheGroupId);
                    externalCacheFragment.setHost(request.getHeader("host"));
                    externalCacheFragment.setInvalidationIds(dataIds);
                    externalCacheFragment.setTemplates(uris);
                    externalCacheFragment.setContent(content);
                    externalCacheFragment.setExpirationTime(expirationTime);
                    externalCacheFragment.setTimeStamp(timeStamp);
                    externalCacheFragment.setHeaderTable(response.getHeaderTable());
                }
                catch (UnexternalizablePageException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.CacheHook.setValue", (String)"804");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("cannot externalize page: " + fragmentInfo.getId()), (Object[])new Object[0]);
                    }
                }
                catch (IOException ioe) {
                    FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.cache.servlet.CacheHook.setValue", (String)"807");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                    Tr.debug((TraceComponent)tc, (String)("cannot externalize page: " + fragmentInfo.getId()), (Object[])new Object[0]);
                }
            }
        }
        if (cacheHit) {
            if (externalCacheFragment == null) {
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("republishing cache entry to external jspCache: " + fragmentInfo.getId()), (Object[])new Object[0]);
            }
            jspCache.setExternalCacheFragment(fragmentInfo.getId(), externalCacheFragment);
            return;
        }
        jspCache.setValue(fragmentInfo, memento, externalCacheFragment);
    }

    protected static void externalPreInvoke(String cacheGroup, CacheProxyRequest request, CacheProxyResponse response) {
        if (cacheGroup != null) {
            ((JSPCache)ServerCache.jspCache).preInvoke(cacheGroup, request, response);
        }
    }

    protected static void externalPostInvoke(String cacheGroup, CacheProxyRequest request, CacheProxyResponse response) {
        if (cacheGroup != null) {
            ((JSPCache)ServerCache.jspCache).postInvoke(cacheGroup, request, response);
        }
    }

    public static void setSkipCache(boolean skipCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setSkipCache: " + skipCache), (Object[])new Object[0]);
        }
        threadLocalSkipCache.set((Object)new Boolean(skipCache));
    }

    public static boolean isSkipCache() {
        Boolean b = (Boolean)threadLocalSkipCache.get();
        if (b == null) {
            b = new Boolean(false);
        }
        return b;
    }

    private static void cascadeFragmentInfoFromParent(FragmentComposer fragmentComposer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cascadeFragmentInfoFromParent", (Object[])new Object[]{fragmentComposer.getURI()});
        }
        FragmentComposer parentFragmentComposer = fragmentComposer.getParent();
        FragmentInfo pfi = null;
        if (null == parentFragmentComposer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Parent Fragment Composer is null !!! Orphan fragment", (Object[])new Object[0]);
                Tr.exit((TraceComponent)tc, (String)"cascadeFragmentInfoFromParent");
            }
            return;
        }
        pfi = parentFragmentComposer.getFragmentInfo();
        FragmentInfo fi = fragmentComposer.getFragmentInfo();
        if (null != pfi) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Applying " + pfi.getURI() + " attributes to " + fi.getURI()), (Object[])new Object[0]);
            }
            fi.setStoreAttributes(pfi.getStoreAttributes());
            fi.setAttributeExcludeList(pfi.getAttributeExcludeList());
            fi.setStoreCookies(pfi.getStoreCookies());
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"FragmentInfo of Parent Fragment Composer was null. Could NOT cascade info.", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cascadeFragmentInfoFromParent");
        }
    }
}

