/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.parser.ResolverCache;
import com.ibm.ws.microprofile.openapi.impl.parser.models.RefFormat;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ExternalRefProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.OperationProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ParameterProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.util.RefUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CallbackProcessor {
    private final ResolverCache cache;
    private final OperationProcessor operationProcessor;
    private final ParameterProcessor parameterProcessor;
    private final OpenAPI openAPI;
    private final ExternalRefProcessor externalRefProcessor;
    static final long serialVersionUID = 6455754389186895034L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CallbackProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.operationProcessor = new OperationProcessor(cache, openAPI);
        this.parameterProcessor = new ParameterProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.openAPI = openAPI;
    }

    public void processCallback(Callback callback) {
        if (callback.get((Object)"$ref") != null) {
            this.processReferenceCallback(callback);
        }
        for (String name : callback.keySet()) {
            PathItem pathItem = (PathItem)callback.get((Object)name);
            Map operationMap = pathItem.readOperationsMap();
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = (Operation)operationMap.get(httpMethod);
                this.operationProcessor.processOperation(operation);
            }
            List parameters = pathItem.getParameters();
            if (parameters == null) continue;
            for (Parameter parameter : parameters) {
                this.parameterProcessor.processParameter(parameter);
            }
        }
    }

    public void processReferenceCallback(Callback callback) {
        String newRef;
        String $ref = ((PathItem)callback.get((Object)"$ref")).getRef();
        RefFormat refFormat = RefUtils.computeRefFormat($ref);
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalCallback($ref, refFormat)) != null) {
            ((PathItem)callback.get((Object)"$ref")).setRef("#/components/callbacks/" + newRef);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.parser.processors.CallbackProcessor", CallbackProcessor.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }
}

