/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SchemaTypeUtil {
    private static final String TYPE = "type";
    private static final String FORMAT = "format";
    public static final String INTEGER_TYPE = "integer";
    public static final String NUMBER_TYPE = "number";
    public static final String STRING_TYPE = "string";
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String OBJECT_TYPE = "object";
    public static final String INTEGER32_FORMAT = "int32";
    public static final String INTEGER64_FORMAT = "int64";
    public static final String FLOAT_FORMAT = "float";
    public static final String DOUBLE_FORMAT = "double";
    public static final String BYTE_FORMAT = "byte";
    public static final String BINARY_FORMAT = "binary";
    public static final String DATE_FORMAT = "date";
    public static final String DATE_TIME_FORMAT = "date-time";
    public static final String PASSWORD_FORMAT = "password";
    public static final String EMAIL_FORMAT = "email";
    public static final String UUID_FORMAT = "uuid";
    static final long serialVersionUID = -3920586382227154327L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Schema createSchemaByType(ObjectNode node) {
        if (node == null) {
            return new SchemaImpl();
        }
        String type = SchemaTypeUtil.getNodeValue(node, TYPE);
        if (StringUtils.isBlank((CharSequence)type)) {
            return new SchemaImpl();
        }
        String format = SchemaTypeUtil.getNodeValue(node, FORMAT);
        return SchemaTypeUtil.createSchema(type, format);
    }

    public static Schema createSchema(String type, String format) {
        if (INTEGER_TYPE.equals(type)) {
            if (INTEGER64_FORMAT.equals(format)) {
                return new SchemaImpl().type(Schema.SchemaType.INTEGER).format(INTEGER64_FORMAT);
            }
            return new SchemaImpl().type(Schema.SchemaType.INTEGER);
        }
        if (NUMBER_TYPE.equals(type)) {
            if (FLOAT_FORMAT.equals(format)) {
                return new SchemaImpl().type(Schema.SchemaType.NUMBER).format(FLOAT_FORMAT);
            }
            if (DOUBLE_FORMAT.equals(format)) {
                return new SchemaImpl().type(Schema.SchemaType.NUMBER).format(DOUBLE_FORMAT);
            }
            return new SchemaImpl().type(Schema.SchemaType.NUMBER);
        }
        if (BOOLEAN_TYPE.equals(type)) {
            return new SchemaImpl().type(Schema.SchemaType.BOOLEAN);
        }
        if (STRING_TYPE.equals(type)) {
            return new SchemaImpl().type(Schema.SchemaType.STRING).format(format);
        }
        if (OBJECT_TYPE.equals(type)) {
            return new SchemaImpl().type(Schema.SchemaType.OBJECT);
        }
        return new SchemaImpl();
    }

    private static String getNodeValue(ObjectNode node, String field) {
        JsonNode jsonNode = node.get(field);
        if (jsonNode == null) {
            return null;
        }
        return jsonNode.textValue();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.parser.util.SchemaTypeUtil", SchemaTypeUtil.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }
}

