/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.productinfo;

import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class ProductInfo {
    public static final String VERSION_PROPERTY_DIRECTORY = "lib/versions";
    private static final String VERSION_PROPERTY_FILE_SUFFIX = ".properties";
    public static final String COM_IBM_WEBSPHERE_PRODUCTID_KEY = "com.ibm.websphere.productId";
    public static final String COM_IBM_WEBSPHERE_PRODUCTNAME_KEY = "com.ibm.websphere.productName";
    public static final String COM_IBM_WEBSPHERE_PRODUCTVERSION_KEY = "com.ibm.websphere.productVersion";
    public static final String COM_IBM_WEBSPHERE_PRODUCTEDITION_KEY = "com.ibm.websphere.productEdition";
    public static final String COM_IBM_WEBSPHERE_PRODUCTREPLACES_KEY = "com.ibm.websphere.productReplaces";
    public static final String COM_IBM_WEBSPHERE_LOG_REPLACED_PRODUCT = "com.ibm.websphere.logReplacedProduct";
    private static FileFilter versionFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(ProductInfo.VERSION_PROPERTY_FILE_SUFFIX);
        }
    };
    private final File file;
    private final String id;
    private final String name;
    private final String version;
    private final String edition;
    private final Properties properties;
    private ProductInfo replaces;
    private ProductInfo replacedBy;

    public static Map<String, ProductInfo> getAllProductInfo() throws ProductInfoParseException, DuplicateProductInfoException, ProductInfoReplaceException {
        return ProductInfo.getAllProductInfo(Utils.getInstallDir());
    }

    public static Map<String, ProductInfo> getAllProductInfo(File installDir) throws ProductInfoParseException, DuplicateProductInfoException, ProductInfoReplaceException {
        ProductInfo productInfo;
        File versionPropertyDirectory = new File(installDir, VERSION_PROPERTY_DIRECTORY);
        File[] coreFiles = versionPropertyDirectory.listFiles();
        if (coreFiles == null) {
            throw new IllegalArgumentException(versionPropertyDirectory.toString());
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(coreFiles));
        File[] userExtFiles = ProductInfo.getUserExtensionVersionFiles(installDir);
        if (userExtFiles != null) {
            list.addAll(Arrays.asList(userExtFiles));
        }
        Map<String, File[]> prodExtFiles = ProductInfo.getVersionFilesByProdExtension(installDir);
        for (Map.Entry<String, File[]> entry : prodExtFiles.entrySet()) {
            list.addAll(Arrays.asList((Object[])entry.getValue()));
        }
        HashMap<String, ProductInfo> productInfos = new HashMap<String, ProductInfo>();
        for (File file : list) {
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(VERSION_PROPERTY_FILE_SUFFIX)) continue;
            try {
                productInfo = ProductInfo.parseProductInfo(new FileReader(file), file);
            }
            catch (FileNotFoundException e) {
                throw new ProductInfoParseException(file, (Throwable)e);
            }
            ProductInfo existing = productInfos.put(productInfo.getId(), productInfo);
            if (existing == null) continue;
            throw new DuplicateProductInfoException(existing, productInfo);
        }
        for (Map.Entry entry : productInfos.entrySet()) {
            productInfo = (ProductInfo)entry.getValue();
            String replacesId = productInfo.getReplacesId();
            if (replacesId == null) continue;
            ProductInfo replaces = productInfos.get(replacesId);
            if (replaces == null || replaces == productInfo) {
                throw new ProductInfoReplaceException(productInfo);
            }
            productInfo.replaces = replaces;
            replaces.replacedBy = productInfo;
        }
        return productInfos;
    }

    public static ProductInfo parseProductInfo(Reader inReader, File file) throws ProductInfoParseException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(inReader);
            Properties properties = new Properties();
            properties.load(reader);
            String id = (String)properties.get(COM_IBM_WEBSPHERE_PRODUCTID_KEY);
            if (id == null) {
                throw new ProductInfoParseException(file, COM_IBM_WEBSPHERE_PRODUCTID_KEY);
            }
            String name = properties.getProperty(COM_IBM_WEBSPHERE_PRODUCTNAME_KEY);
            if (name == null) {
                throw new ProductInfoParseException(file, COM_IBM_WEBSPHERE_PRODUCTNAME_KEY);
            }
            String version = properties.getProperty(COM_IBM_WEBSPHERE_PRODUCTVERSION_KEY);
            if (version == null) {
                throw new ProductInfoParseException(file, COM_IBM_WEBSPHERE_PRODUCTVERSION_KEY);
            }
            String edition = properties.getProperty(COM_IBM_WEBSPHERE_PRODUCTEDITION_KEY);
            if (edition == null) {
                throw new ProductInfoParseException(file, COM_IBM_WEBSPHERE_PRODUCTEDITION_KEY);
            }
            ProductInfo productInfo = new ProductInfo(file, id, name, version, edition, properties);
            return productInfo;
        }
        catch (IOException e) {
            throw new ProductInfoParseException(file, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private ProductInfo(File file, String id, String name, String version, String edition, Properties properties) {
        this.file = file;
        this.id = id;
        this.name = name;
        this.version = version;
        this.edition = edition;
        this.properties = properties;
    }

    public File getFile() {
        return this.file;
    }

    public String getDisplayName() {
        return this.name + ' ' + this.version;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getEdition() {
        return this.edition;
    }

    public String getReplacesId() {
        return this.properties.getProperty(COM_IBM_WEBSPHERE_PRODUCTREPLACES_KEY);
    }

    public ProductInfo getReplaces() {
        return this.replaces;
    }

    public ProductInfo getReplacedBy() {
        return this.replacedBy;
    }

    public boolean isReplacedProductLogged() {
        return "true".equalsIgnoreCase(this.properties.getProperty(COM_IBM_WEBSPHERE_LOG_REPLACED_PRODUCT));
    }

    public String getProperty(String key) {
        if (key == null) {
            return null;
        }
        String value = this.properties.getProperty(key);
        if (value == null && this.replaces != null) {
            value = this.replaces.getProperty(key);
        }
        return value;
    }

    public static File[] getUserExtensionVersionFiles(File installDir) {
        File userExtVersionDir;
        File userDir;
        File[] versionFiles = null;
        String userDirLoc = System.getenv("WLP_USER_DIR");
        File file = userDirLoc != null ? new File(userDirLoc) : (userDir = installDir != null ? new File(installDir, "usr") : null);
        if (userDir != null && userDir.exists() && (userExtVersionDir = new File(userDir, "extension/lib/versions")).exists()) {
            versionFiles = userExtVersionDir.listFiles(versionFileFilter);
        }
        return versionFiles;
    }

    public static Map<String, File[]> getVersionFilesByProdExtension(File installDir) {
        TreeMap<String, File[]> versionFiles = new TreeMap<String, File[]>();
        Iterator<ProductExtensionInfo> productExtensions = ProductExtension.getProductExtensions().iterator();
        while (productExtensions != null && productExtensions.hasNext()) {
            File prodExtVersionDir;
            String prodExtLocation;
            ProductExtensionInfo prodExt = productExtensions.next();
            String prodExtName = prodExt.getName();
            if (0 == prodExtName.length() || (prodExtLocation = prodExt.getLocation()) == null) continue;
            String normalizedProdExtLoc = FileUtils.normalize(prodExtLocation);
            if (!FileUtils.pathIsAbsolute(normalizedProdExtLoc)) {
                String parentPath = installDir.getParentFile().getAbsolutePath();
                normalizedProdExtLoc = FileUtils.normalize(parentPath + "/" + prodExtLocation + "/");
            }
            if (!(prodExtVersionDir = new File(normalizedProdExtLoc, VERSION_PROPERTY_DIRECTORY)).exists()) continue;
            versionFiles.put(prodExtName, prodExtVersionDir.listFiles(versionFileFilter));
        }
        return versionFiles;
    }
}

