/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.sib.api.jms;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.JmsConnectionFactory;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsQueueConnectionFactory;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.websphere.sib.api.jms.JmsTopicConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;

public abstract class JmsFactoryFactory {
    private static TraceComponent tcInt = Tr.register(JmsFactoryFactory.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static JmsFactoryFactory instance = null;

    public static synchronized JmsFactoryFactory getInstance() throws JMSException {
        if (tcInt.isEntryEnabled()) {
            Tr.entry((TraceComponent)tcInt, (String)"getInstance", (Object[])new Object[0]);
        }
        if (instance == null) {
            try {
                Class<?> cls = Class.forName("com.ibm.ws.sib.api.jms.impl.JmsFactoryFactoryImpl");
                instance = (JmsFactoryFactory)cls.newInstance();
            }
            catch (Exception e) {
                if (tcInt.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tcInt, (String)"Unable to instantiate JmsFactoryFactory", (Object[])new Object[]{e});
                }
                if (tcInt.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tcInt, (String)"getInstance");
                }
                instance = null;
                JMSException jmse = new JMSException(nls.getFormattedMessage("UNABLE_TO_CREATE_FACTORY_CWSIA0001", new Object[]{"JmsFactoryFactoryImpl", "sib.api.jmsImpl.jar"}, "!!!Unable to instantiate JmsFactoryFactoryImpl"));
                jmse.setLinkedException(e);
                jmse.initCause((Throwable)e);
                throw jmse;
            }
        }
        if (tcInt.isEntryEnabled()) {
            Tr.exit((TraceComponent)tcInt, (String)"getInstance");
        }
        return instance;
    }

    public abstract JmsConnectionFactory createConnectionFactory() throws JMSException;

    public abstract JmsQueueConnectionFactory createQueueConnectionFactory() throws JMSException;

    public abstract JmsTopicConnectionFactory createTopicConnectionFactory() throws JMSException;

    public abstract JmsQueue createQueue(String var1) throws JMSException;

    public abstract JmsTopic createTopic(String var1) throws JMSException;

    public abstract ConnectionMetaData getMetaData() throws JMSException;
}

