/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.impl.ConsumerProperties;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicSubscriberImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;

public class JmsDurableSubscriberImpl
extends JmsTopicSubscriberImpl {
    private static TraceComponent tc = SibTr.register(JmsDurableSubscriberImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static byte NOT_TRIED = 1;
    private static byte COMPLETE = (byte)2;
    private static byte REQUEST_ALTER = (byte)3;
    private static byte TRY_CREATE = (byte)4;
    static final boolean DEVT_DEBUG = false;

    public JmsDurableSubscriberImpl(SICoreConnection coreConnection, JmsSessionImpl newSession, ConsumerProperties newProps) throws JMSException {
        super(coreConnection, newSession, newProps);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsDurableSubscriberImpl");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsDurableSubscriberImpl");
        }
    }

    @Override
    protected ConsumerSession createCoreConsumer(SICoreConnection _coreConn, ConsumerProperties _props) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createCoreConsumer", (Object)new Object[]{_coreConn, _props});
        }
        ConsumerSession dcs = null;
        String clientID = _props.getClientID();
        String subName = _props.getSubName();
        String durableSubHome = _props.getDurableSubscriptionHome();
        String coreSubscriptionName = JmsInternalsFactory.getSharedUtils().getCoreDurableSubName(clientID, subName);
        JmsDestinationImpl cccDest = (JmsDestinationImpl)_props.getJmsDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("subscriptionName: " + coreSubscriptionName + ", destName: " + cccDest.getDestName() + ", discrim: " + cccDest.getDestDiscrim() + ", selector: " + _props.getSelector()));
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("readAhead: " + _props.readAhead() + ", supportsMultiple: " + _props.supportsMultipleConsumers() + ", noLocal: " + _props.noLocal() + ", durableSubHome: " + _props.getDurableSubscriptionHome()));
            if (!(_props.supportsMultipleConsumers() ^ _props.readAhead())) {
                if (_props.supportsMultipleConsumers()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"WARNING: shareDurableSubs and readAhead are both ON. This could lead to all messages being streamed to a single consumer, which is inefficient.");
                } else {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"WARNING: shareDurableSubs and readAhead are both OFF.  This prevents the readAhead optimisation from taking place to pass messages pre-emptively to the single consumer.  Performance would be improved if readAhead was DEFAULT or ON");
                }
            }
        }
        byte create_state = NOT_TRIED;
        SIDestinationAddress sida = cccDest.getConsumerSIDestinationAddress();
        SelectionCriteria selectionCriteria = null;
        try {
            selectionCriteria = this.selectionCriteriaFactory.createSelectionCriteria(cccDest.getDestDiscrim(), _props.getSelector(), SelectorDomain.JMS);
        }
        catch (SIErrorException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0221", new Object[]{sice, "JmsDurableSubscriberImpl.createCoreConsumer (#10)"}, sice, "JmsDurableSubscriberImpl.createCoreConsumer#10", this, tc);
        }
        do {
            try {
                if (create_state == REQUEST_ALTER) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Try to delete subscription: " + coreSubscriptionName));
                    }
                    _coreConn.deleteDurableSubscription(coreSubscriptionName, durableSubHome);
                    create_state = TRY_CREATE;
                }
                if (create_state == TRY_CREATE) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Try to create subscription: " + coreSubscriptionName));
                    }
                    _coreConn.createDurableSubscription(coreSubscriptionName, durableSubHome, sida, selectionCriteria, _props.supportsMultipleConsumers(), _props.noLocal(), null);
                }
                dcs = _coreConn.createConsumerSessionForDurableSubscription(coreSubscriptionName, durableSubHome, sida, selectionCriteria, _props.supportsMultipleConsumers(), _props.noLocal(), null, _props.readAhead(), Reliability.NONE, false, null);
                create_state = COMPLETE;
            }
            catch (SIDurableSubscriptionMismatchException daee) {
                if (create_state != REQUEST_ALTER) {
                    create_state = REQUEST_ALTER;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception received from createDurableSubscription: ", (Object)((Object)daee));
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Now try to alter the subscription");
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"SHOULDN'T HAVE GOT HERE, PLEASE REPORT/INVESTIGATE");
                }
                throw (JMSException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "EXCEPTION_RECEIVED_CWSIA0221", new Object[]{daee, "JmsDurableSubscriberImpl.createCoreConsumer (#1)"}, daee, "JmsDurableSubscriberImpl.createCoreConsumer#1", this, tc);
            }
            catch (SIConnectionUnavailableException oce) {
                throw (JMSException)JmsErrorUtils.newThrowable(IllegalStateException.class, "CONN_CLOSED_CWSIA0222", null, oce, null, this, tc);
            }
            catch (SIDestinationLockedException dle) {
                throw (JMSException)JmsErrorUtils.newThrowable(IllegalStateException.class, "DEST_LOCKED_CWSIA0223", null, dle, null, this, tc);
            }
            catch (SIDurableSubscriptionNotFoundException dnfe) {
                if (create_state != TRY_CREATE) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"The durable subscription could not be found - create it");
                    }
                    create_state = TRY_CREATE;
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"The durable subscription was not found after create. Resetting to NOT_TRIED");
                }
                create_state = NOT_TRIED;
            }
            catch (SINotAuthorizedException nae) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "NOT_AUTH_CWSIA0224", null, nae, null, this, tc);
            }
            catch (SISelectorSyntaxException nae) {
                throw (JMSException)JmsErrorUtils.newThrowable(InvalidSelectorException.class, "BAD_SELECT_CWSIA0225", null, nae, null, this, tc);
            }
            catch (SIDurableSubscriptionAlreadyExistsException saee) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Subscription already exists - this may be a timing issue with multiple clients, since the first time we tried to connect to it, it didn't exist! Resetting create_state to NOT_TRIED");
                }
                create_state = NOT_TRIED;
            }
            catch (SINotPossibleInCurrentConfigurationException npcc) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"The topicSpace is non-permanent or does not exist.");
                }
                throw (JMSException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "BAD_TOPICSPACE_CWSIA0226", null, npcc, null, this, tc);
            }
            catch (SIException sice) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0221", new Object[]{sice, "JmsDurableSubscriberImpl.createCoreConsumer (#9)"}, sice, "JmsDurableSubscriberImpl.createCoreConsumer#9", this, tc);
            }
        } while (create_state != COMPLETE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createCoreConsumer(SICoreConnection, ConsumerProperties)", dcs);
        }
        return dcs;
    }
}

