/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.ServerTransportAcceptListener;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class GenericTransportReceiveListener
implements ConversationReceiveListener {
    private static String CLASS_NAME = GenericTransportReceiveListener.class.getName();
    private static final TraceComponent tc = SibTr.register(GenericTransportReceiveListener.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static GenericTransportReceiveListener instance;
    private static ServerTransportAcceptListener serverTransportAcceptListener;

    protected static GenericTransportReceiveListener getInstance() {
        return instance;
    }

    public ConversationReceiveListener dataReceived(WsByteBuffer data, int segmentType, int requestNumber, int priority, boolean allocatedFromBufferPool, boolean partOfExchange, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dataReceived");
        }
        ConversationReceiveListener listener = null;
        int connectionType = -1;
        ServerLinkLevelState lls = null;
        if (tc.isDebugEnabled()) {
            String LF = System.getProperty("line.separator");
            String debugInfo = LF + LF + "-------------------------------------------------------" + LF;
            debugInfo = debugInfo + " Segment type  : " + JFapChannelConstants.getSegmentName((int)segmentType) + " - " + segmentType + " (0x" + Integer.toHexString(segmentType) + ")" + LF;
            debugInfo = debugInfo + " Request number: " + requestNumber + LF;
            debugInfo = debugInfo + " Priority      : " + priority + LF;
            debugInfo = debugInfo + " Exchange?     : " + partOfExchange + LF;
            debugInfo = debugInfo + " From pool?    : " + allocatedFromBufferPool + LF;
            debugInfo = debugInfo + " Conversation  : " + conversation + LF;
            debugInfo = debugInfo + "-------------------------------------------------------" + LF;
            SibTr.debug((Object)this, (TraceComponent)tc, (String)debugInfo);
            SibTr.debug((Object)this, (TraceComponent)tc, (String)conversation.getFullSummary());
        }
        if (segmentType == 6) {
            data.flip();
            connectionType = data.get();
            switch (connectionType) {
                case 1: {
                    listener = serverTransportAcceptListener.acceptConnection(conversation);
                    lls = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
                    lls.setConnectionType(1);
                    break;
                }
                default: {
                    String nlsText = nls.getFormattedMessage("INVALID_PROP_SICO8008", new Object[]{"" + connectionType}, null);
                    SIConnectionLostException commsException = new SIConnectionLostException(nlsText);
                    StaticCATHelper.sendExceptionToClient((Throwable)commsException, null, conversation, requestNumber);
                    break;
                }
            }
        } else {
            lls = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
            connectionType = lls.getConnectionType();
            switch (connectionType) {
                case 1: {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Conversation was initiated by a Client. Filtering accordingly");
                    }
                    listener = serverTransportAcceptListener.acceptConnection(conversation);
                    break;
                }
                default: {
                    if (!tc.isDebugEnabled()) break;
                    SibTr.debug((TraceComponent)tc, (String)"Conversation was initiated by an unknown entity ", (Object)("" + connectionType));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dataReceived", (Object)listener);
        }
        return listener;
    }

    public void errorOccurred(SIConnectionLostException exception, int segmentType, int requestNumber, int priority, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"errorOccurred", (Object)new Object[]{exception, segmentType, requestNumber, priority, conversation});
        }
        FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".errorOccurred"), (String)"3-001-0001", (Object)this);
        if (tc.isDebugEnabled()) {
            Object[] debug = new Object[]{"Segment type  : " + segmentType + " (0x" + Integer.toHexString(segmentType) + ")", "Request number: " + requestNumber, "Priority      : " + priority};
            SibTr.debug((TraceComponent)tc, (String)"Received an error in the GenericTransportReceiveListener", (Object)debug);
            SibTr.debug((TraceComponent)tc, (String)"Primary exception:");
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"errorOccurred");
        }
    }

    public Dispatchable getThreadContext(Conversation conversation, WsByteBuffer data, int segmentType) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getThreadContext", (Object)new Object[]{conversation, data, segmentType});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getThreadContext", null);
        }
        return null;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/GenericTransportReceiveListener.java, SIB.comms, WASX.SIB, aa1225.01 1.33");
        }
        instance = new GenericTransportReceiveListener();
        serverTransportAcceptListener = ServerTransportAcceptListener.getInstance();
    }
}

