/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.krb5;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Krb5Common {
    private static final TraceComponent tc;
    public static Oid SPNEGO_MECH_OID;
    public static Oid KRB5_MECH_OID;
    public static boolean isJdk18OrUp;
    public static boolean isIBMJdk18OrLower;
    public static boolean isOracleJdk18OrHigher;
    private static boolean isJdk11OrUp;
    public static boolean isOtherSupportJDKs;
    public static final String KRB5_KDC = "java.security.krb5.kdc";
    public static final String KRB5_REALM = "java.security.krb5.realm";
    public static final String KRB5_CONF = "java.security.krb5.conf";
    public static final String KRB5_KTNAME = "KRB5_KTNAME";
    public static final String USE_SUBJECT_CREDS_ONLY = "javax.security.auth.useSubjectCredsOnly";
    public static final String KRB5_NAME = "javax.security.auth.login.name";
    public static final String KRB5_PWD = "javax.security.auth.login.password";
    public static final String IBM_KRB5_PRINCIPAL = "com.ibm.security.krb5.principal";
    public static final String SUN_KRB5_PRINCIPAL = "sun.security.krb5.principal";
    public static String KRB5_PRINCIPAL;
    static final long serialVersionUID = 8988049293866327992L;

    public static String setPropertyAsNeeded(final String propName, final String propValue) {
        String previousPropValue = (String)AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = -4834476390937924568L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public String run() {
                String oldPropValue = System.getProperty(propName);
                if (propValue == null) {
                    System.clearProperty(propName);
                } else if (!propValue.equalsIgnoreCase(oldPropValue)) {
                    System.setProperty(propName, propValue);
                }
                return oldPropValue;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.krb5.Krb5Common$1", 1.class, null, null);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(propName + " property previous: " + (previousPropValue != null ? previousPropValue : "<null>") + " and now: " + propValue), (Object[])new Object[0]);
        }
        return previousPropValue;
    }

    public static void restorePropertyAsNeeded(final String propName, final String oldPropValue, final String newPropValue) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){
            static final long serialVersionUID = 5100485159354019883L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() {
                if (oldPropValue == null) {
                    System.clearProperty(propName);
                } else if (!oldPropValue.equalsIgnoreCase(newPropValue)) {
                    System.setProperty(propName, oldPropValue);
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.krb5.Krb5Common$2", 2.class, null, null);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Restore property " + propName + " to previous value: " + oldPropValue), (Object[])new Object[0]);
        }
    }

    @Trivial
    public static String getSystemProperty(final String propName) {
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = 2741205965536647335L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Object run() {
                return System.getProperty(propName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.krb5.Krb5Common$3", 3.class, null, null);
            }
        });
        return value;
    }

    @Trivial
    public static void setSystemProperty(final String propName, final String propValue) {
        AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = 2230919050077830887L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Object run() {
                if (propValue == null) {
                    System.clearProperty(propName);
                } else {
                    System.setProperty(propName, propValue);
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.krb5.Krb5Common$4", 4.class, null, null);
            }
        });
    }

    public static void debugKrb5LoginModule(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String NULL = "null";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Krb5LoginModule ==> ", (Object[])new Object[]{"       subject: " + (subject == null ? NULL : subject.toString()), "       sharedState: " + (sharedState == null ? NULL : sharedState.toString()), "       options: " + (options == null ? NULL : options.toString()), "       javax.security.auth.login.name: " + Krb5Common.getSystemProperty(KRB5_NAME), "       " + KRB5_PRINCIPAL + ": " + Krb5Common.getSystemProperty(KRB5_PRINCIPAL), "       javax.security.auth.useSubjectCredsOnly: " + Krb5Common.getSystemProperty(USE_SUBJECT_CREDS_ONLY), "       java.security.krb5.kdc: " + Krb5Common.getSystemProperty(KRB5_KDC), "       java.security.krb5.realm: " + Krb5Common.getSystemProperty(KRB5_REALM), "       java.security.krb5.conf: " + Krb5Common.getSystemProperty(KRB5_CONF), "       KRB5_KTNAME: " + Krb5Common.getSystemProperty(KRB5_KTNAME)});
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        block4: {
            tc = Tr.register(Krb5Common.class, null, null);
            isJdk18OrUp = JavaInfo.majorVersion() >= 8;
            isIBMJdk18OrLower = JavaInfo.vendor() == JavaInfo.Vendor.IBM && JavaInfo.majorVersion() <= 8;
            isOracleJdk18OrHigher = JavaInfo.vendor() == JavaInfo.Vendor.ORACLE && JavaInfo.majorVersion() >= 8;
            isJdk11OrUp = JavaInfo.majorVersion() >= 11;
            isOtherSupportJDKs = isOracleJdk18OrHigher || isJdk11OrUp;
            KRB5_PRINCIPAL = IBM_KRB5_PRINCIPAL;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Jdk vendor: " + JavaInfo.vendor() + " and major version: " + JavaInfo.majorVersion()), (Object[])new Object[0]);
            }
            if (isOtherSupportJDKs) {
                KRB5_PRINCIPAL = SUN_KRB5_PRINCIPAL;
            }
            try {
                KRB5_MECH_OID = new Oid("1.2.840.113554.1.2.2");
                SPNEGO_MECH_OID = new Oid("1.3.6.1.5.5.2");
            }
            catch (GSSException gSSException) {
                void ex;
                FFDCFilter.processException((Throwable)gSSException, (String)"com.ibm.ws.security.krb5.Krb5Common", (String)"177", null, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Unexpected GSSExecption: " + ex), (Object[])new Object[0]);
            }
        }
    }
}

