/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.granttype.impl;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandler;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class OAuth20GrantTypeHandlerResourceOwnerCredentialsImpl
implements OAuth20GrantTypeHandler {
    static final String CLASS = OAuth20GrantTypeHandlerResourceOwnerCredentialsImpl.class.getName();
    private static Logger _log = Logger.getLogger(CLASS);

    @Override
    public List<String> getKeysGrantType(AttributeList attributeList) throws OAuthException {
        String methodName = "getKeysGrantType";
        _log.entering(CLASS, methodName);
        List<String> tokenKeys = null;
        _log.exiting(CLASS, methodName);
        return tokenKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateRequestGrantType(AttributeList attributeList, List<OAuth20Token> tokens) throws OAuthException {
        String methodName = "validateRequestGrantType";
        _log.entering(CLASS, methodName);
        try {
            String username = attributeList.getAttributeValueByNameAndType("username", "urn:ibm:names:body:param");
            String password = attributeList.getAttributeValueByNameAndType("password", "urn:ibm:names:body:param");
            if (username == null || username.length() <= 0) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "username", null);
            }
            if (password == null || password.length() <= 0) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "password", null);
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OAuth20Token> buildTokensGrantType(AttributeList attributeList, OAuth20TokenFactory tokenFactory, List<OAuth20Token> tokens) {
        String methodName = "buildTokensGrantType";
        _log.entering(CLASS, methodName);
        ArrayList<OAuth20Token> tokenList = null;
        try {
            String clientId = attributeList.getAttributeValueByName("client_id");
            String username = attributeList.getAttributeValueByName("username");
            String[] scope = attributeList.getAttributeValuesByNameAndType("scope", "urn:ibm:names:oauth:param:request");
            String stateId = OAuth20Util.generateUUID();
            Map<String, String[]> refreshTokenMap = tokenFactory.buildTokenMap(clientId, username, null, stateId, scope, null, "resource_owner");
            String key = "com.ibm.wsspi.security.oidc.external.claims:originalGrantType";
            refreshTokenMap.put(key, new String[]{"resource_owner"});
            OAuth20Token refresh = tokenFactory.createRefreshToken(refreshTokenMap);
            Map<String, String[]> tokenMap = tokenFactory.buildTokenMap(clientId, username, null, stateId, scope, null, "resource_owner");
            if (refresh != null) {
                tokenMap.put("refresh_key", new String[]{refresh.getId()});
            }
            OAuth20Util.populateJwtAccessTokenData(attributeList, tokenMap);
            String password = attributeList.getAttributeValueByName("password");
            tokenMap.put("password", new String[]{password});
            String proxy = attributeList.getAttributeValueByName("X-Forwarded-Host");
            tokenMap.put("X-Forwarded-Host", new String[]{proxy});
            OAuth20Token token = tokenFactory.createAccessToken(tokenMap);
            tokenList = new ArrayList<OAuth20Token>();
            tokenList.add(token);
            if (refresh != null) {
                tokenList.add(refresh);
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return tokenList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildResponseGrantType(AttributeList attributeList, List<OAuth20Token> tokens) {
        String methodName = "buildResponseGrantType";
        _log.entering(CLASS, methodName);
        try {
            OAuth20Token refresh;
            OAuth20Token token;
            if (tokens.size() >= 1 && (token = tokens.get(0)) != null) {
                String accessToken = token.getTokenString();
                attributeList.setAttribute("access_token", "urn:ibm:names:oauth:response:attribute", new String[]{accessToken});
                String accessTokenId = token.getId();
                attributeList.setAttribute("access_token_id", "urn:ibm:names:oauth:response:metadata", new String[]{accessTokenId});
                String type = token.getSubType();
                attributeList.setAttribute("token_type", "urn:ibm:names:oauth:response:attribute", new String[]{type});
                String expires = OAuth20TokenHelper.expiresInSeconds(token);
                attributeList.setAttribute("expires_in", "urn:ibm:names:oauth:response:attribute", new String[]{expires});
                String stateId = token.getStateId();
                attributeList.setAttribute("state_id", "urn:ibm:names:oauth:state", new String[]{stateId});
                String[] scope = token.getScope();
                attributeList.setAttribute("scope", "urn:ibm:names:oauth:response:attribute", scope);
            }
            if (tokens.size() >= 2 && (refresh = tokens.get(1)) != null) {
                String refreshToken = refresh.getTokenString();
                attributeList.setAttribute("refresh_token", "urn:ibm:names:oauth:response:attribute", new String[]{refreshToken});
                String refreshTokenId = refresh.getId();
                attributeList.setAttribute("refresh_token_id", "urn:ibm:names:oauth:response:metadata", new String[]{refreshTokenId});
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }
}

