/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.mp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.WSManagedExecutorService;
import com.ibm.ws.concurrent.mp.CancellableStageRef;
import com.ibm.ws.concurrent.mp.ContextualBiConsumer;
import com.ibm.ws.concurrent.mp.ContextualBiFunction;
import com.ibm.ws.concurrent.mp.ContextualConsumer;
import com.ibm.ws.concurrent.mp.ContextualFunction;
import com.ibm.ws.concurrent.mp.ContextualRunnable;
import com.ibm.ws.concurrent.mp.ContextualSupplier;
import com.ibm.ws.concurrent.mp.ContextualSupplierAction;
import com.ibm.ws.concurrent.mp.ManagedCompletionStage;
import com.ibm.ws.concurrent.mp.UnusableExecutor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.CancellableStage;
import com.ibm.ws.threading.PolicyExecutor;
import com.ibm.ws.threading.PolicyTaskFuture;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.concurrent.ManagedTask;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ManagedCompletableFuture<T>
extends CompletableFuture<T> {
    private static final TraceComponent tc = Tr.register(ManagedCompletableFuture.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.mp.resources.CWWKCMessages");
    static final boolean JAVA8;
    private static final MethodHandle super_exceptionallyAsync;
    private static final MethodHandle super_exceptionallyCompose;
    private static final MethodHandle super_exceptionallyComposeAsync;
    private static Map<String, String> XPROPS_SUSPEND_TRAN;
    private static PrivilegedAction<ScheduledExecutorService> getScheduledExecutorAction;
    final CompletableFuture<T> completableFuture;
    final Executor defaultExecutor;
    private final AtomicReference<Future<?>> futureRef;
    private static final ThreadLocal<FutureRefExecutor> futureRefLocal;
    static final long serialVersionUID = 750256648079227421L;

    ManagedCompletableFuture(CompletableFuture<T> completableFuture, Executor managedExecutor, FutureRefExecutor futureRef) {
        this.completableFuture = completableFuture;
        this.defaultExecutor = managedExecutor;
        this.futureRef = futureRef;
        completableFuture.whenComplete((T result, U failure) -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"whenComplete", (Object[])new Object[]{result, failure});
            }
            if (failure == null) {
                super.complete(result);
            } else {
                super.completeExceptionally((Throwable)failure);
            }
        });
        if (futureRef != null) {
            futureRef.cancellableStage.set(this);
        }
    }

    ManagedCompletableFuture(Executor managedExecutor, FutureRefExecutor futureRef) {
        this.completableFuture = null;
        this.defaultExecutor = managedExecutor;
        this.futureRef = futureRef;
        if (futureRef != null) {
            futureRef.cancellableStage.set(this);
        }
    }

    @Trivial
    public static <U> CompletableFuture<U> completedFuture(U value) {
        throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1156.not.supported", (Object[])new Object[]{"ManagedExecutor.completedFuture"}));
    }

    @Trivial
    static <U> CompletableFuture<U> completedFuture(U value, Executor executor) {
        if (JAVA8) {
            return new ManagedCompletableFuture<U>(CompletableFuture.completedFuture(value), executor, null);
        }
        ManagedCompletableFuture<U> future = new ManagedCompletableFuture<U>(executor, null);
        future.super_complete(value);
        return future;
    }

    @Trivial
    public static <U> CompletionStage<U> completedStage(U value) {
        throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1156.not.supported", (Object[])new Object[]{"ManagedExecutor.completedStage"}));
    }

    @Trivial
    static <U> CompletionStage<U> completedStage(U value, Executor executor) {
        if (JAVA8) {
            return new ManagedCompletionStage<U>(CompletableFuture.completedFuture(value), executor, null);
        }
        ManagedCompletionStage<U> stage = new ManagedCompletionStage<U>(executor);
        stage.super_complete(value);
        return stage;
    }

    @Trivial
    public static Executor delayedExecutor(long delay, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Trivial
    public static Executor delayedExecutor(long delay, TimeUnit unit, Executor executor) {
        throw new UnsupportedOperationException();
    }

    @Trivial
    public static <U> CompletableFuture<U> failedFuture(Throwable x) {
        throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1156.not.supported", (Object[])new Object[]{"ManagedExecutor.failedFuture"}));
    }

    @Trivial
    static <U> CompletableFuture<U> failedFuture(Throwable x, Executor executor) {
        if (JAVA8) {
            CompletableFuture failedFuture = new CompletableFuture();
            failedFuture.completeExceptionally(x);
            return new ManagedCompletableFuture(failedFuture, executor, null);
        }
        ManagedCompletableFuture future = new ManagedCompletableFuture(executor, null);
        future.super_completeExceptionally(x);
        return future;
    }

    @Trivial
    public static <U> CompletionStage<U> failedStage(Throwable x) {
        throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1156.not.supported", (Object[])new Object[]{"ManagedExecutor.failedStage"}));
    }

    @Trivial
    static <U> CompletionStage<U> failedStage(Throwable x, Executor executor) {
        if (JAVA8) {
            CompletableFuture failedFuture = new CompletableFuture();
            failedFuture.completeExceptionally(x);
            return new ManagedCompletionStage(failedFuture, executor, null);
        }
        ManagedCompletionStage stage = new ManagedCompletionStage(executor);
        stage.super_completeExceptionally(x);
        return stage;
    }

    public static <T> CompletableFuture<T> newIncompleteFuture(Executor executor) {
        if (JAVA8) {
            return new ManagedCompletableFuture(new CompletableFuture(), executor, null);
        }
        return new ManagedCompletableFuture<T>(executor, null);
    }

    @Trivial
    public static CompletableFuture<Void> runAsync(Runnable action) {
        throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1156.not.supported", (Object[])new Object[]{"ManagedExecutor.runAsync"}));
    }

    @Trivial
    public static CompletableFuture<Void> runAsync(Runnable action, Executor executor) {
        CompletableFuture completableFuture;
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (action instanceof ContextualSupplier) {
            ContextualRunnable r = (ContextualRunnable)action;
            contextDescriptor = r.getContextDescriptor();
            action = r.getAction();
        } else if (executor instanceof WSManagedExecutorService) {
            WSContextService contextSvc = ((WSManagedExecutorService)executor).getContextService();
            contextDescriptor = contextSvc.captureThreadContext(XPROPS_SUSPEND_TRAN, new Map[0]);
        } else {
            contextDescriptor = null;
        }
        if (JAVA8) {
            action = new ContextualRunnable(contextDescriptor, action);
            completableFuture = CompletableFuture.runAsync(action, futureExecutor == null ? executor : futureExecutor);
            return new ManagedCompletableFuture<Void>(completableFuture, executor, futureExecutor);
        }
        completableFuture = new ManagedCompletableFuture<Void>(executor, futureExecutor);
        action = new ContextualRunnable(contextDescriptor, action, (ManagedCompletableFuture<Void>)completableFuture);
        (futureExecutor == null ? executor : futureExecutor).execute(action);
        return completableFuture;
    }

    @Trivial
    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> action) {
        throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1156.not.supported", (Object[])new Object[]{"ManagedExecutor.supplyAsync"}));
    }

    @Trivial
    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> action, Executor executor) {
        CompletableFuture completableFuture;
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (action instanceof ContextualSupplier) {
            ContextualSupplier s = action;
            contextDescriptor = s.getContextDescriptor();
            action = s.getAction();
        } else if (executor instanceof WSManagedExecutorService) {
            WSContextService contextSvc = ((WSManagedExecutorService)executor).getContextService();
            contextDescriptor = contextSvc.captureThreadContext(XPROPS_SUSPEND_TRAN, new Map[0]);
        } else {
            contextDescriptor = null;
        }
        if (JAVA8) {
            if (contextDescriptor != null) {
                action = new ContextualSupplier(contextDescriptor, action);
            }
            completableFuture = CompletableFuture.supplyAsync(action, futureExecutor == null ? executor : futureExecutor);
            return new ManagedCompletableFuture(completableFuture, executor, futureExecutor);
        }
        completableFuture = new ManagedCompletableFuture(executor, futureExecutor);
        ContextualSupplierAction task = new ContextualSupplierAction(contextDescriptor, action, completableFuture, true);
        (futureExecutor == null ? executor : futureExecutor).execute(task);
        return completableFuture;
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualConsumer) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualConsumer<T>(contextDescriptor, action);
        }
        if (JAVA8) {
            if (other instanceof ManagedCompletableFuture) {
                other = ((ManagedCompletableFuture)other).completableFuture;
            }
            CompletionStage dependentStage = this.completableFuture.acceptEither((CompletionStage)other, (Consumer)action);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, null);
        }
        return super.acceptEither((CompletionStage)other, (Consumer)action);
    }

    @Override
    @Trivial
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.acceptEitherAsync((CompletionStage)other, (Consumer)action, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualConsumer) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualConsumer<T>(contextDescriptor, action);
        }
        if (JAVA8) {
            if (other instanceof ManagedCompletableFuture) {
                other = ((ManagedCompletableFuture)other).completableFuture;
            }
            CompletionStage dependentStage = this.completableFuture.acceptEitherAsync((CompletionStage)other, (Consumer)action, futureExecutor == null ? executor : futureExecutor);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, futureExecutor);
        }
        futureRefLocal.set(futureExecutor);
        try {
            CompletionStage completionStage = super.acceptEitherAsync((CompletionStage)other, (Consumer)action, futureExecutor == null ? executor : futureExecutor);
            return completionStage;
        }
        finally {
            futureRefLocal.remove();
        }
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualFunction) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualFunction<T, U>(contextDescriptor, action);
        }
        if (JAVA8) {
            if (other instanceof ManagedCompletableFuture) {
                other = ((ManagedCompletableFuture)other).completableFuture;
            }
            CompletionStage dependentStage = this.completableFuture.applyToEither((CompletionStage)other, action);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, null);
        }
        return super.applyToEither((CompletionStage)other, (Function)action);
    }

    @Override
    @Trivial
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> action) {
        return this.applyToEitherAsync((CompletionStage)other, (Function)action, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualFunction) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualFunction<T, U>(contextDescriptor, action);
        }
        if (JAVA8) {
            if (other instanceof ManagedCompletableFuture) {
                other = ((ManagedCompletableFuture)other).completableFuture;
            }
            CompletionStage dependentStage = this.completableFuture.applyToEitherAsync((CompletionStage)other, action, futureExecutor == null ? executor : futureExecutor);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, futureExecutor);
        }
        futureRefLocal.set(futureExecutor);
        try {
            CompletionStage completionStage = super.applyToEitherAsync((CompletionStage)other, (Function)action, futureExecutor == null ? executor : futureExecutor);
            return completionStage;
        }
        finally {
            futureRefLocal.remove();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Future<?> future;
        boolean canceled;
        boolean bl = canceled = JAVA8 ? this.completableFuture.cancel(mayInterruptIfRunning) : super.cancel(mayInterruptIfRunning);
        if (canceled && this.futureRef != null && (future = this.futureRef.get()) != null) {
            future.cancel(mayInterruptIfRunning);
        }
        return canceled;
    }

    private ThreadContextDescriptor captureThreadContext(Executor executor) {
        WSManagedExecutorService managedExecutor;
        Object object = this.defaultExecutor instanceof WSManagedExecutorService ? (WSManagedExecutorService)this.defaultExecutor : (managedExecutor = executor != this.defaultExecutor && executor instanceof WSManagedExecutorService ? (WSManagedExecutorService)executor : null);
        if (managedExecutor == null) {
            return null;
        }
        ThreadContextDescriptor contextDescriptor = managedExecutor.getContextService().captureThreadContext(XPROPS_SUSPEND_TRAN, new Map[0]);
        return contextDescriptor;
    }

    @Override
    public boolean complete(T value) {
        Future<?> future;
        boolean completedByThisMethod;
        boolean bl = completedByThisMethod = JAVA8 ? this.completableFuture.complete(value) : super.complete(value);
        if (completedByThisMethod && this.futureRef != null && (future = this.futureRef.get()) != null) {
            future.cancel(true);
        }
        return completedByThisMethod;
    }

    @Override
    @Trivial
    public CompletableFuture<T> completeAsync(Supplier<? extends T> action) {
        return this.completeAsync(action, this.defaultExecutor);
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> action, Executor executor) {
        if (JAVA8) {
            throw new UnsupportedOperationException();
        }
        if (!super.isDone()) {
            ThreadContextDescriptor contextDescriptor;
            if (action instanceof ManagedTask) {
                throw new IllegalArgumentException(ManagedTask.class.getName());
            }
            if (action instanceof ContextualSupplier) {
                ContextualSupplier s = (ContextualSupplier)action;
                contextDescriptor = s.getContextDescriptor();
                action = s.getAction();
            } else {
                contextDescriptor = this.captureThreadContext(executor);
            }
            if (!super.isDone()) {
                ContextualSupplierAction task = new ContextualSupplierAction(contextDescriptor, action, this, false);
                if (executor instanceof WSManagedExecutorService) {
                    executor = ((WSManagedExecutorService)executor).getNormalPolicyExecutor();
                }
                executor.execute(task);
            }
        }
        return this;
    }

    @Override
    public boolean completeExceptionally(Throwable x) {
        Future<?> future;
        boolean completedByThisMethod;
        boolean bl = completedByThisMethod = JAVA8 ? this.completableFuture.completeExceptionally(x) : super.completeExceptionally(x);
        if (completedByThisMethod && this.futureRef != null && (future = this.futureRef.get()) != null) {
            future.cancel(true);
        }
        return completedByThisMethod;
    }

    @Override
    public CompletableFuture<T> completeOnTimeout(T value, long timeout, TimeUnit unit) {
        if (JAVA8) {
            throw new UnsupportedOperationException();
        }
        ScheduledExecutorService scheduledExecutor = AccessController.doPrivileged(getScheduledExecutorAction);
        if (!super.isDone()) {
            scheduledExecutor.schedule(new Timeout(value), timeout, unit);
        }
        return this;
    }

    @Override
    public CompletableFuture<T> copy() {
        if (JAVA8) {
            throw new UnsupportedOperationException();
        }
        return super.thenApply(Function.identity());
    }

    @Override
    public Executor defaultExecutor() {
        if (JAVA8) {
            throw new UnsupportedOperationException();
        }
        return this.defaultExecutor;
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualFunction) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualFunction<Throwable, Throwable>(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.exceptionally(action);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, null);
        }
        return super.exceptionally((Function)action);
    }

    @Override
    @Trivial
    public CompletableFuture<T> exceptionallyAsync(Function<Throwable, ? extends T> action) {
        return this.exceptionallyAsync(action, this.defaultExecutor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<T> exceptionallyAsync(Function<Throwable, ? extends T> action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (super_exceptionallyAsync == null) {
            throw new UnsupportedOperationException();
        }
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualFunction) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualFunction<Throwable, Throwable>(contextDescriptor, action);
        }
        futureRefLocal.set(futureExecutor);
        try {
            Executor exec = futureExecutor == null ? executor : futureExecutor;
            CompletableFuture completableFuture = super_exceptionallyAsync.invokeExact(this, action, exec);
            return completableFuture;
        }
        catch (Error | RuntimeException exec) {
            void x;
            FFDCFilter.processException((Throwable)exec, (String)"com.ibm.ws.concurrent.mp.ManagedCompletableFuture", (String)"877", (Object)this, (Object[])new Object[]{action, executor});
            throw x;
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.mp.ManagedCompletableFuture", (String)"879", (Object)this, (Object[])new Object[]{action, executor});
            throw new RuntimeException(x);
        }
        finally {
            futureRefLocal.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<T> exceptionallyCompose(Function<Throwable, ? extends CompletionStage<T>> action) {
        ThreadContextDescriptor contextDescriptor22;
        if (super_exceptionallyCompose == null) {
            throw new UnsupportedOperationException();
        }
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualFunction) && (contextDescriptor22 = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualFunction<Throwable, CompletionStage<Throwable>>(contextDescriptor22, action);
        }
        try {
            return super_exceptionallyCompose.invokeExact(this, action);
        }
        catch (Error | RuntimeException contextDescriptor22) {
            void x;
            FFDCFilter.processException((Throwable)contextDescriptor22, (String)"com.ibm.ws.concurrent.mp.ManagedCompletableFuture", (String)"902", (Object)this, (Object[])new Object[]{action});
            throw x;
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.mp.ManagedCompletableFuture", (String)"904", (Object)this, (Object[])new Object[]{action});
            throw new RuntimeException(x);
        }
    }

    @Override
    @Trivial
    public CompletableFuture<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> action) {
        return this.exceptionallyComposeAsync(action, this.defaultExecutor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (super_exceptionallyComposeAsync == null) {
            throw new UnsupportedOperationException();
        }
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualFunction) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualFunction<Throwable, CompletionStage<Throwable>>(contextDescriptor, action);
        }
        futureRefLocal.set(futureExecutor);
        try {
            Executor exec = futureExecutor == null ? executor : futureExecutor;
            CompletableFuture completableFuture = super_exceptionallyComposeAsync.invokeExact(this, action, exec);
            return completableFuture;
        }
        catch (Error | RuntimeException exec) {
            void x;
            FFDCFilter.processException((Throwable)exec, (String)"com.ibm.ws.concurrent.mp.ManagedCompletableFuture", (String)"934", (Object)this, (Object[])new Object[]{action, executor});
            throw x;
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.mp.ManagedCompletableFuture", (String)"936", (Object)this, (Object[])new Object[]{action, executor});
            throw new RuntimeException(x);
        }
        finally {
            futureRefLocal.remove();
        }
    }

    @Override
    public T get() throws ExecutionException, InterruptedException {
        return JAVA8 ? this.completableFuture.get() : super.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return JAVA8 ? this.completableFuture.get(timeout, unit) : super.get(timeout, unit);
    }

    @Override
    public T getNow(T valueIfAbsent) {
        return JAVA8 ? this.completableFuture.getNow(valueIfAbsent) : super.getNow(valueIfAbsent);
    }

    @Override
    public int getNumberOfDependents() {
        if (JAVA8) {
            int count = this.completableFuture.getNumberOfDependents();
            return count > 1 ? count - 1 : 0;
        }
        return super.getNumberOfDependents();
    }

    @Override
    public <R> CompletableFuture<R> handle(BiFunction<? super T, Throwable, ? extends R> action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualBiFunction) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualBiFunction<T, Throwable, R>(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.handle(action);
            return this.newInstance((CompletableFuture<R>)dependentStage, this.defaultExecutor, null);
        }
        return super.handle(action);
    }

    @Override
    @Trivial
    public <R> CompletableFuture<R> handleAsync(BiFunction<? super T, Throwable, ? extends R> action) {
        return this.handleAsync((BiFunction)action, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> CompletableFuture<R> handleAsync(BiFunction<? super T, Throwable, ? extends R> action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualBiFunction) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualBiFunction<T, Throwable, R>(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.handleAsync(action, futureExecutor == null ? executor : futureExecutor);
            return this.newInstance((CompletableFuture<R>)dependentStage, this.defaultExecutor, futureExecutor);
        }
        futureRefLocal.set(futureExecutor);
        try {
            CompletionStage completionStage = super.handleAsync(action, futureExecutor == null ? executor : futureExecutor);
            return completionStage;
        }
        finally {
            futureRefLocal.remove();
        }
    }

    @Override
    public boolean isCancelled() {
        return JAVA8 ? this.completableFuture.isCancelled() : super.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return JAVA8 ? this.completableFuture.isCompletedExceptionally() : super.isCompletedExceptionally();
    }

    @Override
    public boolean isDone() {
        return JAVA8 ? this.completableFuture.isDone() : super.isDone();
    }

    @Override
    public T join() {
        return JAVA8 ? this.completableFuture.join() : super.join();
    }

    @Override
    public CompletionStage<T> minimalCompletionStage() {
        if (JAVA8) {
            throw new UnsupportedOperationException();
        }
        ManagedCompletionStage minimalStage = new ManagedCompletionStage(this.defaultExecutor);
        super.whenComplete((T result, U failure) -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"whenComplete", (Object[])new Object[]{result, failure});
            }
            if (failure == null) {
                minimalStage.super_complete(result);
            } else {
                minimalStage.super_completeExceptionally((Throwable)failure);
            }
        });
        return minimalStage;
    }

    @Override
    public CompletableFuture<T> newIncompleteFuture() {
        if (JAVA8) {
            return new ManagedCompletableFuture(new CompletableFuture(), this.defaultExecutor, null);
        }
        return new ManagedCompletableFuture<T>(this.defaultExecutor, futureRefLocal.get());
    }

    @Trivial
    <R> CompletableFuture<R> newInstance(CompletableFuture<R> completableFuture, Executor managedExecutor, FutureRefExecutor futureRef) {
        return new ManagedCompletableFuture<R>(completableFuture, managedExecutor, futureRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void obtrudeException(Throwable x) {
        Future<?> future;
        if (JAVA8) {
            CompletableFuture<T> completableFuture = this.completableFuture;
            synchronized (completableFuture) {
                super.obtrudeException(x);
                this.completableFuture.obtrudeException(x);
            }
        } else {
            super.obtrudeException(x);
        }
        if (this.futureRef != null && (future = this.futureRef.get()) != null) {
            future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void obtrudeValue(T value) {
        Future<?> future;
        if (JAVA8) {
            CompletableFuture<T> completableFuture = this.completableFuture;
            synchronized (completableFuture) {
                super.obtrudeValue(value);
                this.completableFuture.obtrudeValue(value);
            }
        } else {
            super.obtrudeValue(value);
        }
        if (this.futureRef != null && (future = this.futureRef.get()) != null) {
            future.cancel(true);
        }
    }

    @Override
    public CompletableFuture<T> orTimeout(long timeout, TimeUnit unit) {
        if (JAVA8) {
            throw new UnsupportedOperationException();
        }
        ScheduledExecutorService scheduledExecutor = AccessController.doPrivileged(getScheduledExecutorAction);
        if (!super.isDone()) {
            scheduledExecutor.schedule(new Timeout(), timeout, unit);
        }
        return this;
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualRunnable) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualRunnable(contextDescriptor, action);
        }
        if (JAVA8) {
            if (other instanceof ManagedCompletableFuture) {
                other = ((ManagedCompletableFuture)other).completableFuture;
            }
            CompletionStage dependentStage = this.completableFuture.runAfterBoth((CompletionStage)other, action);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, null);
        }
        return super.runAfterBoth((CompletionStage)other, action);
    }

    @Override
    @Trivial
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterBothAsync((CompletionStage)other, action, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualRunnable) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualRunnable(contextDescriptor, action);
        }
        if (JAVA8) {
            if (other instanceof ManagedCompletableFuture) {
                other = ((ManagedCompletableFuture)other).completableFuture;
            }
            CompletionStage dependentStage = this.completableFuture.runAfterBothAsync((CompletionStage)other, action, futureExecutor == null ? executor : futureExecutor);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, futureExecutor);
        }
        futureRefLocal.set(futureExecutor);
        try {
            CompletionStage completionStage = super.runAfterBothAsync((CompletionStage)other, action, futureExecutor == null ? executor : futureExecutor);
            return completionStage;
        }
        finally {
            futureRefLocal.remove();
        }
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualRunnable) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualRunnable(contextDescriptor, action);
        }
        if (JAVA8) {
            if (other instanceof ManagedCompletableFuture) {
                other = ((ManagedCompletableFuture)other).completableFuture;
            }
            CompletionStage dependentStage = this.completableFuture.runAfterEither((CompletionStage)other, action);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, null);
        }
        return super.runAfterEither((CompletionStage)other, action);
    }

    @Override
    @Trivial
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherAsync((CompletionStage)other, action, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualRunnable) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualRunnable(contextDescriptor, action);
        }
        if (JAVA8) {
            if (other instanceof ManagedCompletableFuture) {
                other = ((ManagedCompletableFuture)other).completableFuture;
            }
            CompletionStage dependentStage = this.completableFuture.runAfterEitherAsync((CompletionStage)other, action, futureExecutor == null ? executor : futureExecutor);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, futureExecutor);
        }
        futureRefLocal.set(futureExecutor);
        try {
            CompletionStage completionStage = super.runAfterEitherAsync((CompletionStage)other, action, futureExecutor == null ? executor : futureExecutor);
            return completionStage;
        }
        finally {
            futureRefLocal.remove();
        }
    }

    final boolean super_cancel(boolean mayInterruptIfRunning) {
        if (JAVA8) {
            return this.completableFuture.cancel(mayInterruptIfRunning);
        }
        return super.cancel(mayInterruptIfRunning);
    }

    final boolean super_complete(T value) {
        if (JAVA8) {
            return this.completableFuture.complete(value);
        }
        return super.complete(value);
    }

    final boolean super_completeExceptionally(Throwable x) {
        if (JAVA8) {
            return this.completableFuture.completeExceptionally(x);
        }
        return super.completeExceptionally(x);
    }

    @Trivial
    private static final FutureRefExecutor supportsAsync(Executor executor) {
        if (executor instanceof ExecutorService) {
            return new FutureRefExecutor((ExecutorService)executor);
        }
        if (executor instanceof UnusableExecutor) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualConsumer) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualConsumer<T>(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.thenAccept((Consumer)action);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, null);
        }
        return super.thenAccept((Consumer)action);
    }

    @Override
    @Trivial
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return this.thenAcceptAsync((Consumer)action, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualConsumer) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualConsumer<T>(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.thenAcceptAsync((Consumer)action, futureExecutor == null ? executor : futureExecutor);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, futureExecutor);
        }
        futureRefLocal.set(futureExecutor);
        try {
            CompletionStage completionStage = super.thenAcceptAsync((Consumer)action, futureExecutor == null ? executor : futureExecutor);
            return completionStage;
        }
        finally {
            futureRefLocal.remove();
        }
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualBiConsumer) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualBiConsumer<T, U>(contextDescriptor, action);
        }
        if (JAVA8) {
            if (other instanceof ManagedCompletableFuture) {
                other = ((ManagedCompletableFuture)other).completableFuture;
            }
            CompletionStage dependentStage = this.completableFuture.thenAcceptBoth(other, (BiConsumer)action);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, null);
        }
        return super.thenAcceptBoth((CompletionStage)other, (BiConsumer)action);
    }

    @Override
    @Trivial
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualBiConsumer) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualBiConsumer<T, U>(contextDescriptor, action);
        }
        if (JAVA8) {
            if (other instanceof ManagedCompletableFuture) {
                other = ((ManagedCompletableFuture)other).completableFuture;
            }
            CompletionStage dependentStage = this.completableFuture.thenAcceptBothAsync(other, (BiConsumer)action, futureExecutor == null ? executor : futureExecutor);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, futureExecutor);
        }
        futureRefLocal.set(futureExecutor);
        try {
            CompletionStage completionStage = super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, futureExecutor == null ? executor : futureExecutor);
            return completionStage;
        }
        finally {
            futureRefLocal.remove();
        }
    }

    @Override
    public <R> CompletableFuture<R> thenApply(Function<? super T, ? extends R> action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualFunction) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualFunction<T, R>(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.thenApply(action);
            return this.newInstance((CompletableFuture<R>)dependentStage, this.defaultExecutor, null);
        }
        return super.thenApply(action);
    }

    @Override
    @Trivial
    public <R> CompletableFuture<R> thenApplyAsync(Function<? super T, ? extends R> action) {
        return this.thenApplyAsync((Function)action, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> CompletableFuture<R> thenApplyAsync(Function<? super T, ? extends R> action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualFunction) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualFunction<T, R>(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.thenApplyAsync(action, futureExecutor == null ? executor : futureExecutor);
            return this.newInstance((CompletableFuture<R>)dependentStage, this.defaultExecutor, futureExecutor);
        }
        futureRefLocal.set(futureExecutor);
        try {
            CompletionStage completionStage = super.thenApplyAsync(action, futureExecutor == null ? executor : futureExecutor);
            return completionStage;
        }
        finally {
            futureRefLocal.remove();
        }
    }

    @Override
    public <U, R> CompletableFuture<R> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends R> action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualBiFunction) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualBiFunction<T, U, R>(contextDescriptor, action);
        }
        if (JAVA8) {
            if (other instanceof ManagedCompletableFuture) {
                other = ((ManagedCompletableFuture)other).completableFuture;
            }
            CompletionStage dependentStage = this.completableFuture.thenCombine(other, action);
            return this.newInstance((CompletableFuture<R>)dependentStage, this.defaultExecutor, null);
        }
        return super.thenCombine((CompletionStage)other, action);
    }

    @Override
    @Trivial
    public <U, R> CompletableFuture<R> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends R> action) {
        return this.thenCombineAsync((CompletionStage)other, (BiFunction)action, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <U, R> CompletableFuture<R> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends R> action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualBiFunction) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualBiFunction<T, U, R>(contextDescriptor, action);
        }
        if (JAVA8) {
            if (other instanceof ManagedCompletableFuture) {
                other = ((ManagedCompletableFuture)other).completableFuture;
            }
            CompletionStage dependentStage = this.completableFuture.thenCombineAsync(other, action, futureExecutor == null ? executor : futureExecutor);
            return this.newInstance((CompletableFuture<R>)dependentStage, this.defaultExecutor, futureExecutor);
        }
        futureRefLocal.set(futureExecutor);
        try {
            CompletionStage completionStage = super.thenCombineAsync((CompletionStage)other, action, futureExecutor == null ? executor : futureExecutor);
            return completionStage;
        }
        finally {
            futureRefLocal.remove();
        }
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualFunction) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualFunction<T, CompletionStage<U>>(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.thenCompose(action);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, null);
        }
        return super.thenCompose((Function)action);
    }

    @Override
    @Trivial
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> action) {
        return this.thenComposeAsync((Function)action, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualFunction) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualFunction<T, CompletionStage<U>>(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.thenComposeAsync(action, futureExecutor == null ? executor : futureExecutor);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, futureExecutor);
        }
        futureRefLocal.set(futureExecutor);
        try {
            CompletionStage completionStage = super.thenComposeAsync((Function)action, futureExecutor == null ? executor : futureExecutor);
            return completionStage;
        }
        finally {
            futureRefLocal.remove();
        }
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualRunnable) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualRunnable(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.thenRun(action);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, null);
        }
        return super.thenRun(action);
    }

    @Override
    @Trivial
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.thenRunAsync(action, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualRunnable) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualRunnable(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.thenRunAsync(action, futureExecutor == null ? executor : futureExecutor);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, futureExecutor);
        }
        futureRefLocal.set(futureExecutor);
        try {
            CompletionStage completionStage = super.thenRunAsync(action, futureExecutor == null ? executor : futureExecutor);
            return completionStage;
        }
        finally {
            futureRefLocal.remove();
        }
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this;
    }

    @Override
    @Trivial
    public String toString() {
        StringBuilder s = new StringBuilder(250).append(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        if (JAVA8) {
            s.append(Integer.toHexString(this.completableFuture.hashCode())).append(' ');
        }
        if (JAVA8 ? this.completableFuture.isDone() : super.isDone()) {
            if (JAVA8 ? this.completableFuture.isCompletedExceptionally() : super.isCompletedExceptionally()) {
                s.append("Completed exceptionally]");
            } else {
                s.append("Completed normally]");
            }
        } else {
            int d;
            s.append("Not completed");
            int n = d = JAVA8 ? this.completableFuture.getNumberOfDependents() - 1 : super.getNumberOfDependents();
            if (d > 0) {
                s.append(", ").append(d).append(" dependents]");
            } else {
                s.append(']');
            }
        }
        if (this.futureRef != null) {
            s.append(" via ").append(this.futureRef.get());
        }
        return s.toString();
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        if (!(action instanceof ContextualBiConsumer) && (contextDescriptor = this.captureThreadContext(this.defaultExecutor)) != null) {
            action = new ContextualBiConsumer<T, Throwable>(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.whenComplete(action);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, null);
        }
        return super.whenComplete((BiConsumer)action);
    }

    @Override
    @Trivial
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.whenCompleteAsync((BiConsumer)action, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        ThreadContextDescriptor contextDescriptor;
        if (action instanceof ManagedTask) {
            throw new IllegalArgumentException(ManagedTask.class.getName());
        }
        FutureRefExecutor futureExecutor = ManagedCompletableFuture.supportsAsync(executor);
        if (!(action instanceof ContextualBiConsumer) && (contextDescriptor = this.captureThreadContext(executor)) != null) {
            action = new ContextualBiConsumer<T, Throwable>(contextDescriptor, action);
        }
        if (JAVA8) {
            CompletionStage dependentStage = this.completableFuture.whenCompleteAsync(action, futureExecutor == null ? executor : futureExecutor);
            return this.newInstance((CompletableFuture)dependentStage, this.defaultExecutor, futureExecutor);
        }
        futureRefLocal.set(futureExecutor);
        try {
            CompletionStage completionStage = super.whenCompleteAsync((BiConsumer)action, futureExecutor == null ? executor : futureExecutor);
            return completionStage;
        }
        finally {
            futureRefLocal.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        int version = JavaInfo.majorVersion();
        boolean bl = JAVA8 = version == 8;
        if (version < 12) {
            super_exceptionallyComposeAsync = null;
            super_exceptionallyCompose = null;
            super_exceptionallyAsync = null;
        } else {
            MethodHandles.Lookup methods = MethodHandles.lookup();
            MethodHandle exceptionallyAsync = null;
            MethodHandle exceptionallyCompose = null;
            MethodHandle exceptionallyComposeAsync = null;
            try {
                exceptionallyAsync = methods.findSpecial(CompletableFuture.class, "exceptionallyAsync", MethodType.methodType(CompletableFuture.class, Function.class, Executor.class), ManagedCompletableFuture.class);
                exceptionallyCompose = methods.findSpecial(CompletableFuture.class, "exceptionallyCompose", MethodType.methodType(CompletableFuture.class, Function.class), ManagedCompletableFuture.class);
                exceptionallyComposeAsync = methods.findSpecial(CompletableFuture.class, "exceptionallyComposeAsync", MethodType.methodType(CompletableFuture.class, Function.class, Executor.class), ManagedCompletableFuture.class);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                void x;
                FFDCFilter.processException((Throwable)reflectiveOperationException, (String)"com.ibm.ws.concurrent.mp.ManagedCompletableFuture", (String)"109", null, (Object[])new Object[0]);
                throw new ExceptionInInitializerError((Throwable)x);
            }
            super_exceptionallyAsync = exceptionallyAsync;
            super_exceptionallyCompose = exceptionallyCompose;
            super_exceptionallyComposeAsync = exceptionallyComposeAsync;
        }
        XPROPS_SUSPEND_TRAN = Collections.singletonMap("javax.enterprise.concurrent.TRANSACTION", "SUSPEND");
        getScheduledExecutorAction = () -> {
            Collection refs;
            BundleContext bc = FrameworkUtil.getBundle(ManagedCompletableFuture.class).getBundleContext();
            try {
                refs = bc.getServiceReferences(ScheduledExecutorService.class, "(deferrable=false)");
            }
            catch (InvalidSyntaxException x) {
                throw new RuntimeException(x);
            }
            if (refs.isEmpty()) {
                throw new IllegalStateException("ScheduledExecutorService");
            }
            return (ScheduledExecutorService)bc.getService((ServiceReference)refs.iterator().next());
        };
        futureRefLocal = new ThreadLocal();
    }

    @Trivial
    private class Timeout
    implements Runnable {
        private final Object result;

        private Timeout() {
            this.result = Timeout.class;
        }

        private Timeout(T result) {
            this.result = result;
        }

        @Override
        public void run() {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)ManagedCompletableFuture.this, (TraceComponent)tc, (String)"run: complete on timeout", (Object[])new Object[]{this});
            }
            if (ManagedCompletableFuture.super.isDone()) {
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((Object)ManagedCompletableFuture.this, (TraceComponent)tc, (String)"run: complete on timeout - skipped because done");
                }
            } else if (this.result == Timeout.class) {
                boolean completed = ManagedCompletableFuture.this.completeExceptionally(new TimeoutException());
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((Object)ManagedCompletableFuture.this, (TraceComponent)tc, (String)("run: completed exceptionally on timeout? " + completed));
                }
            } else {
                boolean completed = ManagedCompletableFuture.this.complete(this.result);
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((Object)ManagedCompletableFuture.this, (TraceComponent)tc, (String)("run: completed on timeout? " + completed));
                }
            }
        }
    }

    @Trivial
    static class FutureRefExecutor
    extends AtomicReference<Future<?>>
    implements Executor {
        private static final long serialVersionUID = 1L;
        private final CancellableStageRef cancellableStage = new CancellableStageRef();
        private final ExecutorService executor;

        private FutureRefExecutor(ExecutorService executorService) {
            this.executor = executorService instanceof WSManagedExecutorService ? ((WSManagedExecutorService)executorService).getNormalPolicyExecutor() : executorService;
        }

        @Override
        public void execute(Runnable command) {
            PolicyTaskFuture future = this.executor instanceof PolicyExecutor ? ((PolicyExecutor)this.executor).submit((CancellableStage)this.cancellableStage, command) : this.executor.submit(command);
            this.set(future);
        }

        @Override
        public String toString() {
            return this.executor.toString() + ": " + this.get();
        }
    }
}

