/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Pattern {
    public static Object matchOne = new Object();
    public static char sqlMatchOne = (char)95;
    public static Object matchMany = new Object();
    public static char sqlMatchMany = (char)37;
    Clause prefix;
    Clause suffix;
    Clause[] midClauses;

    Pattern(Iterator tokens) {
        ArrayList clause = new ArrayList();
        boolean finalWild = this.getClause(tokens, clause);
        if (clause.size() > 0) {
            this.prefix = new Clause(clause.toArray());
        }
        if (!finalWild) {
            this.suffix = this.prefix;
            return;
        }
        ArrayList<Clause> mid = new ArrayList<Clause>();
        while (tokens.hasNext()) {
            clause.clear();
            finalWild = this.getClause(tokens, clause);
            if (!finalWild || clause.size() <= 0) continue;
            mid.add(new Clause(clause.toArray()));
        }
        if (!finalWild) {
            this.suffix = new Clause(clause.toArray());
        }
        if (mid.size() > 0) {
            this.midClauses = mid.toArray(new Clause[0]);
        }
    }

    private boolean getClause(Iterator tokens, List clause) {
        while (tokens.hasNext()) {
            Object token = tokens.next();
            if (token == matchMany) {
                return true;
            }
            clause.add(token);
        }
        return false;
    }

    public boolean equals(Object o) {
        Pattern other;
        boolean retVal = false;
        if (o instanceof Pattern && this.prefix == (other = (Pattern)o).getPrefix() && this.suffix == other.getSuffix()) {
            if (this.hasMidClauses() && other.hasMidClauses()) {
                if (this.midClauses.length == other.midClauses.length) {
                    retVal = true;
                    for (int i = 0; i < this.midClauses.length; ++i) {
                        if (this.midClauses[i] == other.midClauses[i]) continue;
                        retVal = false;
                        break;
                    }
                }
            } else if (!this.hasMidClauses() && !other.hasMidClauses()) {
                retVal = true;
            }
        }
        return retVal;
    }

    public Clause getPrefix() {
        return this.prefix;
    }

    public Clause getSuffix() {
        return this.suffix;
    }

    public boolean hasMidClauses() {
        return this.midClauses != null;
    }

    boolean match(String candidate) {
        int[] cursor;
        char[] chars = candidate.toCharArray();
        if (!this.checkPrefix(chars, cursor = new int[]{0, chars.length})) {
            return false;
        }
        if (this.prefix == this.suffix && this.midClauses == null) {
            return cursor[0] == cursor[1];
        }
        if (!this.checkSuffix(chars, cursor)) {
            return false;
        }
        return this.matchMiddle(chars, cursor[0], cursor[1]);
    }

    boolean checkPrefix(char[] chars, int[] cursor) {
        if (this.prefix == null) {
            return true;
        }
        return this.matchClause(this.prefix, chars, cursor);
    }

    private boolean matchClause(Clause clause, char[] chars, int[] cursor) {
        if (clause.minlen > cursor[1] - cursor[0]) {
            return false;
        }
        for (int i = 0; i < clause.items.length; ++i) {
            Object item = clause.items[i];
            if (item == matchOne) {
                cursor[0] = cursor[0] + 1;
                continue;
            }
            if (Pattern.matchForward(chars, (char[])item, cursor)) continue;
            return false;
        }
        return true;
    }

    static boolean matchForward(char[] chars, char[] pattern, int[] cursor) {
        if (pattern.length > cursor[1] - cursor[0]) {
            return false;
        }
        int index = 0;
        while (index < pattern.length) {
            int n = cursor[0];
            cursor[0] = n + 1;
            if (chars[n] == pattern[index++]) continue;
            return false;
        }
        return true;
    }

    boolean checkSuffix(char[] chars, int[] cursor) {
        if (this.suffix == null) {
            return true;
        }
        int start = cursor[1] - this.suffix.minlen;
        if (start < cursor[0]) {
            return false;
        }
        if (!this.matchClause(this.suffix, chars, new int[]{start, cursor[1]})) {
            return false;
        }
        cursor[1] = start;
        return true;
    }

    public boolean matchMiddle(char[] chars, int start, int end) {
        if (this.midClauses == null) {
            return true;
        }
        int[] cursor = new int[]{start, end};
        for (int i = 0; i < this.midClauses.length; ++i) {
            Clause clause = this.midClauses[i];
            if (this.find(clause, chars, cursor)) continue;
            return false;
        }
        return true;
    }

    private boolean find(Clause clause, char[] chars, int[] cursor) {
        int start = cursor[0];
        int end = cursor[1];
        while (end - start >= clause.minlen) {
            if (this.matchClause(clause, chars, cursor)) {
                return true;
            }
            cursor[0] = ++start;
        }
        return false;
    }

    public static Object parsePattern(String pattern, boolean escaped, char escape) {
        char[] accum = new char[pattern.length()];
        int finger = 0;
        ArrayList<Object> tokens = new ArrayList<Object>();
        boolean trivial = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == sqlMatchOne) {
                finger = Pattern.flush(accum, finger, tokens);
                tokens.add(matchOne);
                trivial = false;
                continue;
            }
            if (c == sqlMatchMany) {
                finger = Pattern.flush(accum, finger, tokens);
                tokens.add(matchMany);
                trivial = false;
                continue;
            }
            if (escaped && c == escape) {
                if (i == pattern.length() - 1) {
                    return null;
                }
                accum[finger++] = pattern.charAt(++i);
                continue;
            }
            accum[finger++] = c;
        }
        if (trivial) {
            return new String(accum, 0, finger);
        }
        Pattern.flush(accum, finger, tokens);
        if (tokens.size() == 1 && tokens.get(0) == matchMany) {
            return matchMany;
        }
        return new Pattern(tokens.iterator());
    }

    static int flush(char[] accum, int finger, List tokens) {
        if (finger > 0) {
            char[] token = new char[finger];
            System.arraycopy(accum, 0, token, 0, finger);
            tokens.add(token);
        }
        return 0;
    }

    public static class Clause {
        public Object[] items;
        public int minlen;

        Clause(Object[] items) {
            this.items = items;
            for (int i = 0; i < items.length; ++i) {
                Object item = items[i];
                if (item == matchOne) {
                    ++this.minlen;
                    continue;
                }
                this.minlen += ((char[])item).length;
            }
        }
    }
}

