/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.anycast;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.AOStream;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.TransmitMessageRequest;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;
import java.util.List;

public class AOStreamIterator
implements SIMPIterator {
    private static TraceComponent tc = SibTr.register(AOStreamIterator.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private AOStream aoStream;
    private Iterator msgIterator;
    private MessageProcessor messageProcessor;
    private AnycastOutputHandler aoh;

    public AOStreamIterator(AOStream aoStream, MessageProcessor messageProcessor, AnycastOutputHandler aoh) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AOStreamIterator", (Object)new Object[]{aoStream, messageProcessor, aoh});
        }
        this.aoStream = aoStream;
        List<Long> ticks = aoStream.getTicksOnStream();
        this.msgIterator = ticks.iterator();
        this.messageProcessor = messageProcessor;
        this.aoh = aoh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AOStreamIterator", (Object)this);
        }
    }

    public void finished() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"finished");
        }
        this.msgIterator = null;
        this.aoStream = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"finished");
        }
    }

    public boolean hasNext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasNext");
            SibTr.exit((TraceComponent)tc, (String)"hasNext");
        }
        return this.msgIterator.hasNext();
    }

    public Object next() {
        TransmitMessageRequest result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"next");
        }
        if (this.msgIterator.hasNext()) {
            Long valueStamp = (Long)this.msgIterator.next();
            result = new TransmitMessageRequest(valueStamp, this.aoStream.itemStream, this.aoStream, this.messageProcessor, this.aoh.getDestinationHandler());
        } else {
            result = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"next", result);
        }
        return result;
    }

    public void remove() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove");
        }
        if (this.msgIterator.hasNext()) {
            this.msgIterator.remove();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }
}

