/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.context;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.EndpointReferenceBuilder;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class WebServiceContextImpl
implements WebServiceContext {
    private static final Logger LOG = LogUtils.getL7dLogger(WebServiceContextImpl.class);
    private static ThreadLocal<MessageContext> context = new ThreadLocal();
    private final MessageContext localCtx;
    static final long serialVersionUID = 6163013440397159719L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WebServiceContextImpl() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.context.WebServiceContextImpl", "<init>", new Object[0]);
        }
        this.localCtx = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.context.WebServiceContextImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WebServiceContextImpl(MessageContext c) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.context.WebServiceContextImpl", "<init>", new Object[]{c});
        }
        this.localCtx = c;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.context.WebServiceContextImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final MessageContext getMessageContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.context.WebServiceContextImpl", "getMessageContext", new Object[0]);
        }
        MessageContext messageContext = this.localCtx == null ? context.get() : this.localCtx;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageContext = messageContext;
            LOG.exiting("org.apache.cxf.jaxws.context.WebServiceContextImpl", "getMessageContext", messageContext);
        }
        return messageContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final Principal getUserPrincipal() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.context.WebServiceContextImpl", "getUserPrincipal", new Object[0]);
        }
        SecurityContext ctx = (SecurityContext)this.getMessageContext().get((Object)SecurityContext.class.getName());
        if (ctx == null) {
            Principal principal = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                principal = principal;
                LOG.exiting("org.apache.cxf.jaxws.context.WebServiceContextImpl", "getUserPrincipal", principal);
            }
            return principal;
        }
        Principal principal = ctx.getUserPrincipal();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            principal = principal;
            LOG.exiting("org.apache.cxf.jaxws.context.WebServiceContextImpl", "getUserPrincipal", principal);
        }
        return principal;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final boolean isUserInRole(String role) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.context.WebServiceContextImpl", "isUserInRole", new Object[]{role});
        }
        SecurityContext ctx = (SecurityContext)this.getMessageContext().get((Object)SecurityContext.class.getName());
        if (ctx == null) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.context.WebServiceContextImpl", "isUserInRole", bl);
            }
            return bl;
        }
        boolean bl = ctx.isUserInRole(role);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.context.WebServiceContextImpl", "isUserInRole", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        W3CEndpointReference w3CEndpointReference;
        ClassLoader cl;
        block9: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.context.WebServiceContextImpl", "getEndpointReference", new Object[]{referenceParameters});
            }
            WrappedMessageContext ctx = (WrappedMessageContext)this.getMessageContext();
            Message msg = ctx.getWrappedMessage();
            Endpoint ep = (Endpoint)msg.getExchange().get(Endpoint.class);
            W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
            builder.address(ep.getEndpointInfo().getAddress());
            builder.serviceName(ep.getService().getName());
            builder.endpointName(ep.getEndpointInfo().getName());
            URI wsdlDescription = (URI)ep.getEndpointInfo().getProperty("URI", URI.class);
            if (wsdlDescription == null) {
                Element[] address = ep.getEndpointInfo().getAddress();
                try {
                    wsdlDescription = new URI((String)address + "?wsdl");
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                ep.getEndpointInfo().setProperty("URI", (Object)wsdlDescription);
            }
            builder.wsdlDocumentLocation(wsdlDescription.toString());
            if (referenceParameters != null) {
                for (Element referenceParameter : referenceParameters) {
                    builder.referenceParameter(referenceParameter);
                }
            }
            cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(EndpointReferenceBuilder.class.getClassLoader());
            W3CEndpointReference w3CEndpointReference2 = builder.build();
            w3CEndpointReference = w3CEndpointReference2;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
            w3CEndpointReference = w3CEndpointReference;
            LOG.exiting("org.apache.cxf.jaxws.context.WebServiceContextImpl", "getEndpointReference", w3CEndpointReference);
        }
        return w3CEndpointReference;
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.context.WebServiceContextImpl", "getEndpointReference", new Object[]{clazz, referenceParameters});
        }
        if (W3CEndpointReference.class.isAssignableFrom(clazz)) {
            EndpointReference endpointReference = (EndpointReference)clazz.cast(this.getEndpointReference(referenceParameters));
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                endpointReference = endpointReference;
                LOG.exiting("org.apache.cxf.jaxws.context.WebServiceContextImpl", "getEndpointReference", endpointReference);
            }
            return (T)endpointReference;
        }
        throw new WebServiceException(new org.apache.cxf.common.i18n.Message("ENDPOINTREFERENCE_TYPE_NOT_SUPPORTED", LOG, new Object[]{clazz.getName()}).toString());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static MessageContext setMessageContext(MessageContext ctx) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.context.WebServiceContextImpl", "setMessageContext", new Object[]{ctx});
        }
        MessageContext oldCtx = context.get();
        context.set(ctx);
        MessageContext messageContext = oldCtx;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageContext = messageContext;
            LOG.exiting("org.apache.cxf.jaxws.context.WebServiceContextImpl", "setMessageContext", messageContext);
        }
        return messageContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void clear() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.context.WebServiceContextImpl", "clear", new Object[0]);
        }
        context.remove();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.context.WebServiceContextImpl", "clear");
        }
    }
}

