/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.ErrorHandler;
import com.ibm.ws.security.saml.error.ErrorHandlerImpl;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.AssertionToSubject;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.UserData;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper;
import com.ibm.wsspi.security.tai.TAIResult;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Authenticator {
    public static final TraceComponent tc = Tr.register(Authenticator.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    WebProviderAuthenticatorHelper authHelper;
    private final String providerName;
    private SsoConfig ssoConfig = null;
    protected UserData userData;
    static final long serialVersionUID = 4183580889727043988L;

    public Authenticator(SsoSamlService samlService, UserData userData) {
        this.authHelper = samlService.getAuthHelper();
        this.userData = userData;
        this.providerName = samlService.getProviderId();
        this.ssoConfig = samlService.getConfig();
    }

    @FFDCIgnore(value={SamlException.class})
    public TAIResult authenticate(HttpServletRequest request, HttpServletResponse resp) throws WebTrustAssociationFailedException {
        TAIResult result = TAIResult.create((int)100);
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("userData: " + this.userData), (Object[])new Object[0]);
            }
            if (this.userData != null) {
                RequestUtil.removeCookie(request, resp, "WASSamlACS_" + SamlUtil.hash(this.providerName));
                Saml20Token saml20Token = this.userData.getSamlToken();
                SsoRequest samlRequest = (SsoRequest)request.getAttribute("Saml20Request");
                AssertionToSubject mapAssertToSubjectUtil = new AssertionToSubject(samlRequest, this.ssoConfig, saml20Token);
                String user = mapAssertToSubjectUtil.getUser();
                Hashtable<String, Object> hashtable = this.createHashtable(mapAssertToSubjectUtil, saml20Token, user);
                TAIResult taiResult = this.authenticateLogin(request, resp, saml20Token, hashtable, user);
                if (taiResult.getStatus() == 200) {
                    samlRequest.createSpCookieIfDisableLtpa(request, resp);
                }
                return taiResult;
            }
        }
        catch (SamlException e) {
            block9: {
                ErrorHandler errorHandler = ErrorHandlerImpl.getInstance();
                try {
                    errorHandler.handleException(request, resp, e);
                }
                catch (Exception mapAssertToSubjectUtil) {
                    FFDCFilter.processException((Throwable)mapAssertToSubjectUtil, (String)"com.ibm.ws.security.saml.sso20.internal.Authenticator", (String)"97", (Object)this, (Object[])new Object[]{request, resp});
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("Unexpceted exception during errorHandling" + e), (Object[])new Object[0]);
                }
            }
            result = TAIResult.create((int)403);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.internal.Authenticator", (String)"106", (Object)this, (Object[])new Object[]{request, resp});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unexpected exception, id:(" + this.providerName + "," + e + ")"), (Object[])new Object[0]);
            }
            result = TAIResult.create((int)403);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={SamlException.class})
    public TAIResult authenticateRS(HttpServletRequest request, HttpServletResponse resp, SsoRequest samlRequest) throws SamlException {
        TAIResult result;
        block9: {
            result = null;
            try {
                result = TAIResult.create((int)100);
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("userData: " + this.userData), (Object[])new Object[0]);
                    }
                    if (this.userData != null) {
                        Saml20Token saml20Token = this.userData.getSamlToken();
                        AssertionToSubject mapAssertToSubjectUtil = new AssertionToSubject(samlRequest, this.ssoConfig, saml20Token);
                        String user = mapAssertToSubjectUtil.getUser();
                        Hashtable<String, Object> hashtable = this.createHashtable(mapAssertToSubjectUtil, saml20Token, user);
                        TAIResult taiResult = this.authenticateLogin(request, resp, saml20Token, hashtable, user);
                        return taiResult;
                    }
                }
                catch (SamlException e) {
                    result = TAIResult.create((int)401);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.internal.Authenticator", (String)"145", (Object)this, (Object[])new Object[]{request, resp, samlRequest});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unexpected exception, id:(" + this.providerName + "," + e + ")"), (Object[])new Object[0]);
                }
                try {
                    result = TAIResult.create((int)401);
                }
                catch (WebTrustAssociationFailedException mapAssertToSubjectUtil) {
                    void we;
                    FFDCFilter.processException((Throwable)mapAssertToSubjectUtil, (String)"com.ibm.ws.security.saml.sso20.internal.Authenticator", (String)"151", (Object)this, (Object[])new Object[]{request, resp, samlRequest});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("Unexpected exception, id:(" + this.providerName + "," + we + ")"), (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    TAIResult authenticateLogin(HttpServletRequest request, HttpServletResponse resp, Saml20Token saml20Token, Hashtable<String, Object> hashtable, String user) throws WebTrustAssociationFailedException, SamlException {
        Subject subject = new Subject();
        if (this.ssoConfig.isIncludeTokenInSubject()) {
            subject.getPrivateCredentials().add(saml20Token);
        }
        AuthenticationResult authResult = null;
        authResult = this.authHelper.loginWithUserName(request, resp, user, subject, hashtable, Constants.MapToUserRegistry.User.equals((Object)this.ssoConfig.getMapToUserRegistry()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("authHelper authResult:" + authResult), (Object[])new Object[0]);
        }
        if (authResult.getStatus() == AuthResult.SUCCESS) {
            Subject authenticatedSubject = authResult.getSubject();
            return TAIResult.create((int)200, (String)RequestUtil.getUserName(authenticatedSubject), (Subject)authenticatedSubject);
        }
        throw new SamlException("SAML20_USER_CANNOT_AUTHENTICATED", null, new Object[]{user});
    }

    Hashtable<String, Object> createHashtable(AssertionToSubject mapAssertToSubject, Saml20Token saml20Token, String user) throws SamlException, WSSecurityException, RemoteException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String realm = null;
        String uniqueID = null;
        List<String> groups = null;
        switch (this.ssoConfig.getMapToUserRegistry()) {
            case No: {
                realm = mapAssertToSubject.getRealm();
                uniqueID = mapAssertToSubject.getUserUniqueIdentity(user, realm);
                groups = mapAssertToSubject.getGroupUniqueIdentity(realm);
                this.putValue(hashtable, "com.ibm.wsspi.security.cred.uniqueId", uniqueID);
                this.putValue(hashtable, "com.ibm.wsspi.security.cred.securityName", user);
                this.putValue(hashtable, "com.ibm.wsspi.security.cred.realm", realm);
                if (groups.isEmpty()) break;
                this.putValue(hashtable, "com.ibm.wsspi.security.cred.groups", groups);
                break;
            }
            case User: {
                this.putValue(hashtable, "com.ibm.wsspi.security.cred.userId", user);
                break;
            }
            case Group: {
                realm = mapAssertToSubject.getRealm();
                uniqueID = mapAssertToSubject.getUserUniqueIdentity(user, realm);
                groups = mapAssertToSubject.getGroupUniqueIdentityFromRegistry(realm);
                this.putValue(hashtable, "com.ibm.wsspi.security.cred.uniqueId", uniqueID);
                this.putValue(hashtable, "com.ibm.wsspi.security.cred.securityName", user);
                this.putValue(hashtable, "com.ibm.wsspi.security.cred.realm", realm);
                if (groups.isEmpty()) break;
                this.putValue(hashtable, "com.ibm.wsspi.security.cred.groups", groups);
            }
        }
        this.putValue(hashtable, "com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        if (this.ssoConfig.isAllowCustomCacheKey()) {
            String cache_key = mapAssertToSubject.getCustomCacheKeyValue(this.providerName);
            this.putValue(hashtable, "com.ibm.wsspi.security.cred.cacheKey", cache_key);
        }
        mapAssertToSubject.handleSessionNotOnOrAfter(hashtable, saml20Token);
        return hashtable;
    }

    void putValue(Hashtable<String, Object> hashtable, String key, Object value) {
        if (value == null) {
            return;
        }
        hashtable.put(key, value);
    }
}

