/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.sp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.utils.ForwardRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.wsspi.security.tai.TAIResult;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Unsolicited {
    public static final TraceComponent tc = Tr.register(Unsolicited.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    SsoSamlService ssoService = null;
    static final long serialVersionUID = -2817476404988678072L;

    public Unsolicited(SsoSamlService service) {
        this.ssoService = service;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unsolicited(" + service.getProviderId() + ")"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public TAIResult sendRequestToLoginPageUrl(HttpServletRequest req, HttpServletResponse resp, String loginPageUrl) throws WebTrustAssociationFailedException, SamlException {
        String decodedLoginPageUrl;
        try {
            decodedLoginPageUrl = URLDecoder.decode(loginPageUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.saml.sso20.sp.Unsolicited", (String)"66", (Object)this, (Object[])new Object[]{req, resp, loginPageUrl});
            throw new SamlException((Exception)e);
        }
        String targetId = SamlUtil.generateRandom();
        HttpRequestInfo cachingRequestInfo = new HttpRequestInfo(req);
        RequestUtil.cacheRequestInfo(targetId, this.ssoService, cachingRequestInfo);
        TAIResult result = this.redirectToUserDefinedLoginPageURL(req, resp, targetId, decodedLoginPageUrl, cachingRequestInfo);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    TAIResult redirectToUserDefinedLoginPageURL(HttpServletRequest req, HttpServletResponse resp, String targetId, String idpUrl, HttpRequestInfo cachingRequestInfo) throws WebTrustAssociationFailedException {
        String target = "idp_initial_" + targetId;
        try {
            resp.setStatus(200);
            ForwardRequestInfo requestInfo = new ForwardRequestInfo(idpUrl, "");
            requestInfo.setFragmentCookieId(cachingRequestInfo.getFragmentCookieId());
            requestInfo.redirectGetRequest(req, resp, "SAML20UnsolicitedState", target, true);
        }
        catch (SamlException requestInfo) {
            void e;
            FFDCFilter.processException((Throwable)requestInfo, (String)"com.ibm.ws.security.saml.sso20.sp.Unsolicited", (String)"110", (Object)this, (Object[])new Object[]{req, resp, targetId, idpUrl, cachingRequestInfo});
            WebTrustAssociationFailedException wtafe = new WebTrustAssociationFailedException(e.getMessage());
            wtafe.initCause((Throwable)e);
            throw wtafe;
        }
        return TAIResult.create((int)403);
    }
}

