/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health.services.impl;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.health.services.HealthCheckBeanCallException;
import com.ibm.ws.microprofile.health.services.HealthCheckCDIBeanInvoker;
import com.ibm.ws.microprofile.health.services.HealthExecutor;
import com.ibm.ws.microprofile.health.services.impl.AppModuleContextService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(service={HealthExecutor.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class HealthExecutorImpl
implements HealthExecutor {
    private AppModuleContextService appModuleContextService;
    private HealthCheckCDIBeanInvoker healthCheckCDIBeanInvoker;
    private J2EENameFactory j2eeNameFactory;
    private static final Logger logger = Logger.getLogger(HealthExecutorImpl.class.getName(), "com.ibm.ws.microprofile.health.resources.Health");
    private static final String MANAGEDTASK_IDENTITY_NAME = "javax.enterprise.concurrent.IDENTITY_NAME";
    private static final String HC_MANAGEDTASK_IDENTITY_NAME = "mp.healthcheck.proxy";
    private static final String HC_TASK_OWNER = "mp.healthcheck.runtime";
    private static final String ONLY_WAR_EJB_NOT_SUPPORTED = null;
    static final long serialVersionUID = -2944856812007735122L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HealthExecutorImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setAppModuleContextService(AppModuleContextService appModuleContextService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", "setAppModuleContextService", new Object[]{appModuleContextService});
        }
        this.appModuleContextService = appModuleContextService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", "setAppModuleContextService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setHealthCheckApplicationBeanInvoker(HealthCheckCDIBeanInvoker healthCheckCDIBeanInvoker) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", "setHealthCheckApplicationBeanInvoker", new Object[]{healthCheckCDIBeanInvoker});
        }
        this.healthCheckCDIBeanInvoker = healthCheckCDIBeanInvoker;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", "setHealthCheckApplicationBeanInvoker");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setJ2EENameFactory(J2EENameFactory j2eeNameFactory) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", "setJ2EENameFactory", new Object[]{j2eeNameFactory});
        }
        this.j2eeNameFactory = j2eeNameFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", "setJ2EENameFactory");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<HealthCheckResponse> runHealthChecks(String appName, String moduleName) throws HealthCheckBeanCallException {
        Set<HealthCheckResponse> retval;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", "runHealthChecks", new Object[]{appName, moduleName});
        }
        J2EEName j2eeName = this.j2eeNameFactory.create(appName, moduleName, ONLY_WAR_EJB_NOT_SUPPORTED);
        HashMap<String, String> execProps = new HashMap<String, String>();
        execProps.put(MANAGEDTASK_IDENTITY_NAME, HC_MANAGEDTASK_IDENTITY_NAME);
        execProps.put("com.ibm.ws.concurrent.TASK_OWNER", HC_TASK_OWNER);
        HealthCheckCDIBeanInvoker proxy = this.appModuleContextService.createContextualProxy(execProps, j2eeName, this.healthCheckCDIBeanInvoker, HealthCheckCDIBeanInvoker.class);
        try {
            retval = proxy.checkAllBeans(appName, moduleName);
        }
        catch (HealthCheckBeanCallException healthCheckBeanCallException) {
            void e;
            FFDCFilter.processException((Throwable)healthCheckBeanCallException, (String)"com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", (String)"74", (Object)this, (Object[])new Object[]{appName, moduleName});
            logger.log(Level.SEVERE, "healthcheck.bean.call.exception.CWMH0050E", new Object[]{e.getBeanName(), appName, moduleName, e.getCause().toString(), e.getMessage()});
            throw e;
        }
        for (HealthCheckResponse hcr : retval) {
            if (HealthCheckResponse.State.DOWN != hcr.getState()) continue;
            logger.log(Level.WARNING, "healthcheck.application.down.CWMH0051W", new Object[]{hcr.getClass().toString(), appName, moduleName, hcr.getState().toString(), hcr.getData() != null ? hcr.getData().toString() : "{NO DATA}"});
        }
        Set<HealthCheckResponse> set = retval;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", "runHealthChecks", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void removeModuleReferences(String appName, String moduleName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", "removeModuleReferences", new Object[]{appName, moduleName});
        }
        this.healthCheckCDIBeanInvoker.removeModuleReferences(appName, moduleName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.microprofile.health.services.impl.HealthExecutorImpl", "removeModuleReferences");
        }
    }
}

