/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.data;

import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.NameAliases;
import com.ibm.ws.logging.utils.SequenceNumber;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogTraceData
extends GenericData {
    static Pattern messagePattern = Pattern.compile("^([A-Z][\\dA-Z]{3,4})(\\d{4})([A-Z])(:)");
    private long rawSequenceNumber = -1L;
    public static final String[] NAMES1_1 = new String[]{"ibm_datetime", "ibm_messageId", "ibm_threadId", "module", "severity", "loglevel", "ibm_methodName", "ibm_className", "levelValue", "threadName", "correlationId", "org", "product", "component", "ibm_sequence", "throwable", "throwable_localized", "message", "formattedMsg", "extensions", "objectId", "host", "ibm_userDir", "ibm_serverName"};
    private static final String[] NAMES = new String[]{"datetime", "messageId", "threadId", "loggerName", "severity", "loglevel", "methodName", "className", "levelValue", "threadName", "correlationId", "org", "product", "component", "sequence", "throwable", "throwable_localized", "message", "formattedMsg", "extensions", "objectId"};
    public static String[] MESSAGE_NAMES1_1 = new String[]{"ibm_datetime", "ibm_messageId", "ibm_threadId", "module", "severity", "loglevel", "ibm_methodName", "ibm_className", "levelValue", "threadName", "correlationId", "org", "product", "component", "ibm_sequence", "throwable", "throwable_localized", "message", "formattedMsg", "extensions", "objectId", "host", "ibm_userDir", "ibm_serverName"};
    public static String[] TRACE_NAMES1_1 = new String[]{"ibm_datetime", "ibm_messageId", "ibm_threadId", "module", "severity", "loglevel", "ibm_methodName", "ibm_className", "levelValue", "threadName", "correlationId", "org", "product", "component", "ibm_sequence", "throwable", "throwable_localized", "message", "formattedMsg", "extensions", "objectId", "host", "ibm_userDir", "ibm_serverName"};
    private static NameAliases jsonLoggingNameAliasesMessages = new NameAliases(MESSAGE_NAMES1_1);
    private static NameAliases jsonLoggingNameAliasesTrace = new NameAliases(TRACE_NAMES1_1);

    public static void newJsonLoggingNameAliasesMessage(Map<String, String> newAliases) {
        jsonLoggingNameAliasesMessages.newAliases(newAliases);
    }

    public static void newJsonLoggingNameAliasesTrace(Map<String, String> newAliases) {
        jsonLoggingNameAliasesTrace.newAliases(newAliases);
    }

    public LogTraceData() {
        super(21);
    }

    private void setPair(int index, String s) {
        this.setPair(index, NAMES1_1[index], s);
    }

    private void setPair(int index, int i) {
        this.setPair(index, NAMES1_1[index], i);
    }

    private void setPair(int index, long l) {
        this.setPair(index, NAMES1_1[index], l);
    }

    private KeyValuePairList getValues(int index) {
        return (KeyValuePairList)this.getPairs()[index];
    }

    public void setDatetime(long l) {
        this.setPair(0, l);
    }

    public void setMessageId(String s) {
        this.setPair(1, s);
    }

    public void setThreadId(int i) {
        this.setPair(2, i);
    }

    public void setModule(String s) {
        this.setPair(3, s);
    }

    public void setSeverity(String s) {
        this.setPair(4, s);
    }

    public void setLoglevel(String s) {
        this.setPair(5, s);
    }

    public void setMethodName(String s) {
        this.setPair(6, s);
    }

    public void setClassName(String s) {
        this.setPair(7, s);
    }

    public void setLevelValue(int i) {
        this.setPair(8, i);
    }

    public void setThreadName(String s) {
        this.setPair(9, s);
    }

    public void setCorrelationId(String s) {
        this.setPair(10, s);
    }

    public void setOrg(String s) {
        this.setPair(11, s);
    }

    public void setProduct(String s) {
        this.setPair(12, s);
    }

    public void setComponent(String s) {
        this.setPair(13, s);
    }

    public void setSequence(String s) {
        this.setPair(14, s);
    }

    public void setThrowable(String s) {
        this.setPair(15, s);
    }

    public void setThrowableLocalized(String s) {
        this.setPair(16, s);
    }

    public void setMessage(String s) {
        this.setPair(17, s);
    }

    public void setFormattedMsg(String s) {
        this.setPair(18, s);
    }

    public void setExtensions(KeyValuePairList kvps) {
        this.setPair(19, kvps);
    }

    public void setObjectId(int i) {
        this.setPair(20, i);
    }

    public String getDatetimeKey() {
        return NAMES[0];
    }

    public String getMessageIdKey() {
        return NAMES[1];
    }

    public String getThreadIdKey() {
        return NAMES[2];
    }

    public String getModuleKey() {
        return NAMES[3];
    }

    public String getSeverityKey() {
        return NAMES[4];
    }

    public String getLoglevelKey() {
        return NAMES[5];
    }

    public String getMethodNameKey() {
        return NAMES[6];
    }

    public String getClassNameKey() {
        return NAMES[7];
    }

    public String getLevelValueKey() {
        return NAMES[8];
    }

    public String getThreadNameKey() {
        return NAMES[9];
    }

    public String getCorrelationIdKey() {
        return NAMES[10];
    }

    public String getOrgKey() {
        return NAMES[11];
    }

    public String getProductKey() {
        return NAMES[12];
    }

    public String getComponentKey() {
        return NAMES[13];
    }

    public String getSequenceKey() {
        return NAMES[14];
    }

    public String getThrowableKey() {
        return NAMES[15];
    }

    public String getThrowableLocalizedKey() {
        return NAMES[16];
    }

    public String getMessageKey() {
        return NAMES[17];
    }

    public String getFormattedMsgKey() {
        return NAMES[18];
    }

    public String getExtensionsKey() {
        return NAMES[19];
    }

    public String getObjectIdKey() {
        return NAMES[20];
    }

    public String getDatetimeKey1_1() {
        return NAMES1_1[0];
    }

    public String getMessageIdKey1_1() {
        return NAMES1_1[1];
    }

    public String getThreadIdKey1_1() {
        return NAMES1_1[2];
    }

    public String getModuleKey1_1() {
        return NAMES1_1[3];
    }

    public String getSeverityKey1_1() {
        return NAMES1_1[4];
    }

    public String getLoglevelKey1_1() {
        return NAMES1_1[5];
    }

    public String getMethodNameKey1_1() {
        return NAMES1_1[6];
    }

    public String getClassNameKey1_1() {
        return NAMES1_1[7];
    }

    public String getLevelValueKey1_1() {
        return NAMES1_1[8];
    }

    public String getThreadNameKey1_1() {
        return NAMES1_1[9];
    }

    public String getCorrelationIdKey1_1() {
        return NAMES1_1[10];
    }

    public String getOrgKey1_1() {
        return NAMES1_1[11];
    }

    public String getProductKey1_1() {
        return NAMES1_1[12];
    }

    public String getComponentKey1_1() {
        return NAMES1_1[13];
    }

    public String getSequenceKey1_1() {
        return NAMES1_1[14];
    }

    public String getThrowableKey1_1() {
        return NAMES1_1[15];
    }

    public String getThrowableLocalizedKey1_1() {
        return NAMES1_1[16];
    }

    public String getMessageKey1_1() {
        return NAMES1_1[17];
    }

    public String getFormattedMsgKey1_1() {
        return NAMES1_1[18];
    }

    public String getExtensionsKey1_1() {
        return NAMES1_1[19];
    }

    public String getObjectIdKey1_1() {
        return NAMES1_1[20];
    }

    public static String getDatetimeKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[0] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[0];
    }

    public static String getMessageIdKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[1] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[1];
    }

    public static String getThreadIdKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[2] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[2];
    }

    public static String getModuleKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[3] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[3];
    }

    public static String getSeverityKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[4] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[4];
    }

    public static String getLoglevelKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[5] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[5];
    }

    public static String getMethodNameKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[6] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[6];
    }

    public static String getClassNameKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[7] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[7];
    }

    public static String getLevelValueKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[8] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[8];
    }

    public static String getThreadNameKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[9] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[9];
    }

    public static String getCorrelationIdKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[10] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[10];
    }

    public static String getOrgKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[11] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[11];
    }

    public static String getProductKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[12] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[12];
    }

    public static String getComponentKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[13] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[13];
    }

    public static String getSequenceKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[14] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[14];
    }

    public static String getThrowableKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[15] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[15];
    }

    public static String getThrowableLocalizedKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[16] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[16];
    }

    public static String getMessageKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[17] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[17];
    }

    public static String getFormattedMsgKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[18] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[18];
    }

    public static String getExtensionsKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[19] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[19];
    }

    public static String getObjectIdKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[20] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[20];
    }

    public static String getHostKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[21] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[21];
    }

    public static String getUserDirKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[22] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[22];
    }

    public static String getServerNameKeyJSON(boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.aliases[23] : LogTraceData.jsonLoggingNameAliasesTrace.aliases[23];
    }

    public static String getExtensionNameKeyJSON(boolean isMessageEvent, String extKey) {
        ArrayList<String> tempExt = null;
        ArrayList<String> aliasesExt = null;
        if (isMessageEvent) {
            tempExt = LogTraceData.jsonLoggingNameAliasesMessages.originalExtensions;
            aliasesExt = LogTraceData.jsonLoggingNameAliasesMessages.aliasesExtensions;
        } else {
            tempExt = LogTraceData.jsonLoggingNameAliasesTrace.originalExtensions;
            aliasesExt = LogTraceData.jsonLoggingNameAliasesTrace.aliasesExtensions;
        }
        for (int i = 0; i < tempExt.size(); ++i) {
            if (!tempExt.get(i).equals(extKey)) continue;
            return aliasesExt.get(i);
        }
        return extKey;
    }

    public long getDatetime() {
        return this.getLongValue(0);
    }

    public String getMessageId() {
        String message;
        String messageId = this.getStringValue(1);
        if ((messageId == null || messageId.isEmpty()) && (message = this.getMessage()) != null) {
            messageId = this.parseMessageId(message);
            this.setPair(1, NAMES1_1[1], messageId);
        }
        return messageId;
    }

    public int getThreadId() {
        return this.getIntValue(2);
    }

    public String getModule() {
        return this.getStringValue(3);
    }

    public String getSeverity() {
        return this.getStringValue(4);
    }

    public String getLoglevel() {
        return this.getStringValue(5);
    }

    public String getMethodName() {
        return this.getStringValue(6);
    }

    public String getClassName() {
        return this.getStringValue(7);
    }

    public int getLevelValue() {
        return this.getIntValue(8);
    }

    public String getThreadName() {
        return this.getStringValue(9);
    }

    public String getCorrelationId() {
        return this.getStringValue(10);
    }

    public String getOrg() {
        return this.getStringValue(11);
    }

    public String getProduct() {
        return this.getStringValue(12);
    }

    public String getComponent() {
        return this.getStringValue(13);
    }

    public String getSequence() {
        String sequenceId = this.getStringValue(14);
        if (sequenceId == null || sequenceId.isEmpty()) {
            sequenceId = SequenceNumber.formatSequenceNumber(this.getDatetime(), this.rawSequenceNumber);
            this.setPair(14, NAMES1_1[14], sequenceId);
        }
        return sequenceId;
    }

    public String getThrowable() {
        return this.getStringValue(15);
    }

    public String getThrowableLocalized() {
        return this.getStringValue(16);
    }

    public String getMessage() {
        return this.getStringValue(17);
    }

    public String getFormattedMsg() {
        return this.getStringValue(18);
    }

    public KeyValuePairList getExtensions() {
        return this.getValues(19);
    }

    public int getObjectId() {
        return this.getIntValue(20);
    }

    public void setRawSequenceNumber(long l) {
        this.rawSequenceNumber = l;
    }

    public long getRawSequenceNumber(long l) {
        return this.rawSequenceNumber;
    }

    protected String parseMessageId(String msg) {
        String messageId = null;
        Matcher matcher = messagePattern.matcher(msg);
        if (matcher.find()) {
            messageId = msg.substring(matcher.start(), matcher.end() - 1);
        }
        return messageId;
    }
}

