/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.policy.PolicyCalculator;
import org.apache.cxf.policy.PolicyDataEngine;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.AbstractMultiplexDestination;
import org.apache.cxf.transport.Assertor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.Session;
import org.apache.cxf.transport.http.ContinuationProviderFactory;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.HttpServletRequestSnapshot;
import org.apache.cxf.transport.http.Servlet3ContinuationProvider;
import org.apache.cxf.transport.http.policy.impl.ServerPolicyCalculator;
import org.apache.cxf.transport.https.CertConstraints;
import org.apache.cxf.transport.https.CertConstraintsInterceptor;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.cxf.wsdl.WSDLLibrary;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public abstract class AbstractHTTPDestination
extends AbstractMultiplexDestination
implements Configurable,
Assertor {
    public static final String HTTP_REQUEST = "HTTP.REQUEST";
    public static final String HTTP_RESPONSE = "HTTP.RESPONSE";
    public static final String HTTP_CONTEXT = "HTTP.CONTEXT";
    public static final String HTTP_CONFIG = "HTTP.CONFIG";
    public static final String HTTP_CONTEXT_MATCH_STRATEGY = "HTTP_CONTEXT_MATCH_STRATEGY";
    public static final String RESPONSE_HEADERS_COPIED = "http.headers.copied";
    public static final String RESPONSE_COMMITED = "http.response.done";
    public static final String REQUEST_REDIRECTED = "http.request.redirected";
    public static final String CXF_CONTINUATION_MESSAGE = "cxf.continuation.message";
    public static final String CXF_ASYNC_CONTEXT = "cxf.async.context";
    public static final String SERVICE_REDIRECTION = "http.service.redirection";
    private static final String HTTP_BASE_PATH = "http.base.path";
    private static final String SSL_CIPHER_SUITE_ATTRIBUTE = "javax.servlet.request.cipher_suite";
    private static final String SSL_PEER_CERT_CHAIN_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractHTTPDestination.class);
    protected final Bus bus;
    protected DestinationRegistry registry;
    protected final String path;
    protected HTTPServerPolicy server;
    protected String contextMatchStrategy;
    protected boolean fixedParameterOrder;
    protected boolean multiplexWithAddress;
    protected CertConstraints certConstraints;
    protected boolean isServlet3;
    protected ContinuationProviderFactory cproviderFactory;
    static final long serialVersionUID = 3763365363775747686L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AbstractHTTPDestination(Bus b, DestinationRegistry registry, EndpointInfo ei, String path, boolean dp) throws IOException {
        super(b, AbstractHTTPDestination.getTargetReference((EndpointInfo)AbstractHTTPDestination.getAddressValue(ei, dp), (Bus)b), ei);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "<init>", new Object[]{b, registry, ei, path, dp});
        }
        this.contextMatchStrategy = "stem";
        this.bus = b;
        this.registry = registry;
        this.path = path;
        try {
            ServletRequest.class.getMethod("isAsyncSupported", new Class[0]);
            this.isServlet3 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.initConfig();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Bus getBus() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getBus", new Object[0]);
        }
        Bus bus = this.bus;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bus = bus;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getBus", bus);
        }
        return bus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private AuthorizationPolicy getAuthorizationPolicyFromMessage(String credentials) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getAuthorizationPolicyFromMessage", new Object[]{credentials});
        }
        if (credentials == null || StringUtils.isEmpty((String)credentials.trim())) {
            AuthorizationPolicy authorizationPolicy = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                authorizationPolicy = authorizationPolicy;
                LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getAuthorizationPolicyFromMessage", authorizationPolicy);
            }
            return authorizationPolicy;
        }
        String authType = credentials.split(" ")[0];
        if ("Basic".equals(authType)) {
            AuthorizationPolicy authorizationPolicy;
            block7: {
                String authEncoded = credentials.split(" ")[1];
                try {
                    String authDecoded = new String(Base64Utility.decode((String)authEncoded));
                    String[] authInfo = authDecoded.split(":");
                    String username = authInfo.length > 0 ? authInfo[0] : "";
                    String password = authInfo.length > 1 ? authInfo[1] : "";
                    AuthorizationPolicy policy = new AuthorizationPolicy();
                    policy.setUserName(username);
                    policy.setPassword(password);
                    authorizationPolicy = policy;
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block7;
                }
                catch (Base64Exception base64Exception) {
                    // empty catch block
                }
                authorizationPolicy = authorizationPolicy;
                LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getAuthorizationPolicyFromMessage", authorizationPolicy);
            }
            return authorizationPolicy;
        }
        AuthorizationPolicy authorizationPolicy = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            authorizationPolicy = authorizationPolicy;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getAuthorizationPolicyFromMessage", authorizationPolicy);
        }
        return authorizationPolicy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected final boolean isOneWay(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "isOneWay", new Object[]{message});
        }
        Exchange ex = message.getExchange();
        boolean bl = ex == null ? false : ex.isOneWay();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "isOneWay", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "invoke", new Object[]{config, context, req, resp});
            }
            Message inMessage = this.retrieveFromContinuation(req);
            if (inMessage == null) {
                LOG.fine("Create a new message for processing");
                inMessage = new MessageImpl();
                this.setupMessage(inMessage, config, context, req, resp);
                ExchangeImpl exchange = new ExchangeImpl();
                exchange.setInMessage(inMessage);
                exchange.setSession((Session)new HTTPSession(req));
                ((MessageImpl)inMessage).setDestination((Destination)this);
            } else {
                LOG.fine("Get the message from the request for processing");
            }
            this.copyKnownRequestParameters(req, inMessage);
            try {
                this.incomingObserver.onMessage(inMessage);
            }
            catch (SuspendedInvocationException ex) {
                if (ex.getRuntimeException() == null) break block6;
                throw ex.getRuntimeException();
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "invoke");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void copyKnownRequestParameters(HttpServletRequest request, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "copyKnownRequestParameters", new Object[]{request, message});
        }
        message.put((Object)SERVICE_REDIRECTION, (Object)request.getParameter(SERVICE_REDIRECTION));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "copyKnownRequestParameters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setupMessage(Message inMessage, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "setupMessage", new Object[]{inMessage, context, req, resp});
        }
        this.setupMessage(inMessage, null, context, req, resp);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "setupMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setupMessage(final Message inMessage, ServletConfig config, ServletContext context, final HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int index;
        String servletPath;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "setupMessage", new Object[]{inMessage, config, context, req, resp});
        }
        this.setupContinuation(inMessage, req, resp);
        DelegatingInputStream in = new DelegatingInputStream((InputStream)req.getInputStream()){
            static final long serialVersionUID = -1328373268957566285L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void cacheInput() {
                if (!this.cached && inMessage.getExchange().getOutMessage() == null) {
                    inMessage.put((Object)AbstractHTTPDestination.HTTP_REQUEST, (Object)new HttpServletRequestSnapshot(req));
                }
                super.cacheInput();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.AbstractHTTPDestination$1", 1.class, null, null);
            }
        };
        inMessage.setContent(DelegatingInputStream.class, (Object)in);
        inMessage.setContent(InputStream.class, (Object)in);
        inMessage.put((Object)HTTP_REQUEST, (Object)req);
        inMessage.put((Object)HTTP_RESPONSE, (Object)resp);
        inMessage.put((Object)HTTP_CONTEXT, (Object)context);
        inMessage.put((Object)HTTP_CONFIG, (Object)config);
        inMessage.put((Object)HTTP_CONTEXT_MATCH_STRATEGY, (Object)this.contextMatchStrategy);
        inMessage.put((Object)"org.apache.cxf.request.method", (Object)req.getMethod());
        String requestURI = req.getRequestURI();
        inMessage.put((Object)"org.apache.cxf.request.uri", (Object)requestURI);
        String requestURL = req.getRequestURL().toString();
        inMessage.put((Object)"org.apache.cxf.request.url", (Object)requestURL);
        String contextPath = req.getContextPath();
        if (contextPath == null) {
            contextPath = "";
        }
        if ((servletPath = req.getServletPath()) == null) {
            servletPath = "";
        }
        String contextServletPath = contextPath + servletPath;
        inMessage.put((Object)Message.PATH_INFO, (Object)(contextServletPath + req.getPathInfo()));
        if (!StringUtils.isEmpty((String)requestURI)) {
            index = requestURL.indexOf(requestURI);
            if (index > 0) {
                String schemaInfo = requestURL.substring(0, index);
                String basePathWithContextOnly = schemaInfo + contextPath;
                inMessage.put((Object)HTTP_BASE_PATH, (Object)basePathWithContextOnly);
            }
        } else if (!StringUtils.isEmpty((String)servletPath) && requestURL.endsWith(servletPath) && (index = requestURL.lastIndexOf(servletPath)) > 0) {
            inMessage.put((Object)HTTP_BASE_PATH, (Object)requestURL.substring(0, index));
        }
        String contentType = req.getContentType();
        inMessage.put((Object)"Content-Type", (Object)contentType);
        this.setEncoding(inMessage, req, contentType);
        inMessage.put((Object)Message.QUERY_STRING, (Object)req.getQueryString());
        inMessage.put((Object)"Accept", (Object)req.getHeader("Accept"));
        String basePath = this.getBasePath(contextServletPath);
        if (!StringUtils.isEmpty((String)basePath)) {
            inMessage.put((Object)Message.BASE_PATH, (Object)basePath);
        }
        inMessage.put((Object)Message.FIXED_PARAMETER_ORDER, (Object)this.isFixedParameterOrder());
        inMessage.put((Object)"org.apache.cxf.async.post.response.dispatch", (Object)Boolean.TRUE);
        inMessage.put(SecurityContext.class, (Object)new SecurityContext(){
            private Principal pp;
            static final long serialVersionUID = 7886231789225217921L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                this.pp = req.getUserPrincipal();
            }

            public Principal getUserPrincipal() {
                return this.pp;
            }

            public boolean isUserInRole(String role) {
                return req.isUserInRole(role);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.AbstractHTTPDestination$2", 2.class, null, null);
            }
        });
        Headers headers = new Headers(inMessage);
        headers.copyFromRequest(req);
        String credentials = headers.getAuthorization();
        AuthorizationPolicy authPolicy = this.getAuthorizationPolicyFromMessage(credentials);
        inMessage.put(AuthorizationPolicy.class, (Object)authPolicy);
        AbstractHTTPDestination.propogateSecureSession(req, inMessage);
        inMessage.put((Object)CertConstraints.class.getName(), (Object)this.certConstraints);
        inMessage.put((Object)Message.IN_INTERCEPTORS, Arrays.asList(new Interceptor[]{CertConstraintsInterceptor.INSTANCE}));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "setupMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void propogateSecureSession(HttpServletRequest request, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "propogateSecureSession", new Object[]{request, message});
        }
        String cipherSuite = (String)request.getAttribute(SSL_CIPHER_SUITE_ATTRIBUTE);
        if (cipherSuite != null) {
            Certificate[] certs = (Certificate[])request.getAttribute(SSL_PEER_CERT_CHAIN_ATTRIBUTE);
            message.put(TLSSessionInfo.class, (Object)new TLSSessionInfo(cipherSuite, null, certs));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "propogateSecureSession");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String setEncoding(Message inMessage, HttpServletRequest req, String contentType) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "setEncoding", new Object[]{inMessage, req, contentType});
        }
        String enc = HttpHeaderHelper.findCharset((String)contentType);
        if (enc == null) {
            enc = req.getCharacterEncoding();
        }
        if (enc != null && enc.endsWith("\"")) {
            enc = enc.substring(0, enc.length() - 1);
        }
        if (enc != null || "POST".equals(req.getMethod()) || "PUT".equals(req.getMethod())) {
            String normalizedEncoding = HttpHeaderHelper.mapCharset((String)enc);
            if (normalizedEncoding == null) {
                String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, new Object[]{enc}).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            inMessage.put((Object)Message.ENCODING, (Object)normalizedEncoding);
        }
        String string = contentType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "setEncoding", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Message retrieveFromContinuation(HttpServletRequest req) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "retrieveFromContinuation", new Object[]{req});
        }
        if (!this.isServlet3) {
            if (this.cproviderFactory != null) {
                Message message = this.cproviderFactory.retrieveFromContinuation(req);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    message = message;
                    LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "retrieveFromContinuation", message);
                }
                return message;
            }
            Message message = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                message = message;
                LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "retrieveFromContinuation", message);
            }
            return message;
        }
        Message message = this.retrieveFromServlet3Async(req);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            message = message;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "retrieveFromContinuation", message);
        }
        return message;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Message retrieveFromServlet3Async(HttpServletRequest req) {
        Message message;
        block4: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "retrieveFromServlet3Async", new Object[]{req});
            }
            try {
                message = (Message)req.getAttribute(CXF_CONTINUATION_MESSAGE);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (Throwable throwable) {
                Message message2 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    message2 = message2;
                    LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "retrieveFromServlet3Async", message2);
                }
                return message2;
            }
            message = message;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "retrieveFromServlet3Async", message);
        }
        return message;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setupContinuation(Message inMessage, HttpServletRequest req, HttpServletResponse resp) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "setupContinuation", new Object[]{inMessage, req, resp});
        }
        try {
            ContinuationProvider p;
            if (this.isServlet3 && req.isAsyncSupported()) {
                inMessage.put((Object)ContinuationProvider.class.getName(), (Object)new Servlet3ContinuationProvider(req, resp, inMessage));
            } else if (this.cproviderFactory != null && (p = this.cproviderFactory.createContinuationProvider(inMessage, req, resp)) != null) {
                inMessage.put((Object)ContinuationProvider.class.getName(), (Object)p);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "setupContinuation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getBasePath(String contextPath) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getBasePath", new Object[]{contextPath});
        }
        if (StringUtils.isEmpty((String)this.endpointInfo.getAddress())) {
            String string = "";
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getBasePath", string);
            }
            return string;
        }
        String string = new URL(this.endpointInfo.getAddress()).getPath();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getBasePath", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static EndpointInfo getAddressValue(EndpointInfo ei) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getAddressValue", new Object[]{ei});
        }
        EndpointInfo endpointInfo = AbstractHTTPDestination.getAddressValue(ei, true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointInfo = endpointInfo;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getAddressValue", endpointInfo);
        }
        return endpointInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static EndpointInfo getAddressValue(EndpointInfo ei, boolean dp) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getAddressValue", new Object[]{ei, dp});
        }
        if (dp) {
            String addr;
            String eiAddress = ei.getAddress();
            if (eiAddress == null) {
                EndpointInfo endpointInfo;
                block7: {
                    try {
                        ServerSocket s = new ServerSocket(0);
                        ei.setAddress("http://localhost:" + s.getLocalPort());
                        s.close();
                        endpointInfo = ei;
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block7;
                    }
                    catch (IOException ex) {
                        ei.setAddress("http://localhost");
                    }
                    endpointInfo = endpointInfo;
                    LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getAddressValue", endpointInfo);
                }
                return endpointInfo;
            }
            if ((addr = StringUtils.addDefaultPortIfMissing((String)ei.getAddress())) != null) {
                ei.setAddress(addr);
            }
        }
        EndpointInfo endpointInfo = ei;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointInfo = endpointInfo;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getAddressValue", endpointInfo);
        }
        return endpointInfo;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Conduit getInbuiltBackChannel(Message inMessage) {
        LOG.entering("AbstractHTTPDestination", "getInbuiltBackChannel");
        HttpServletResponse response = (HttpServletResponse)inMessage.get((Object)HTTP_RESPONSE);
        LOG.exiting("AbstractHTTPDestination", "getInbuiltBackChannel");
        return new BackChannelConduit(response);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initConfig() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "initConfig", new Object[0]);
        }
        PolicyDataEngine pde = (PolicyDataEngine)this.bus.getExtension(PolicyDataEngine.class);
        if (pde != null) {
            this.server = (HTTPServerPolicy)((Object)pde.getServerEndpointPolicy(this.endpointInfo, (Destination)this, (PolicyCalculator)new ServerPolicyCalculator()));
        }
        if (null == this.server && WSDLLibrary.isAvailable()) {
            this.server = (HTTPServerPolicy)((Object)this.endpointInfo.getTraversedExtensor((Object)new HTTPServerPolicy(), HTTPServerPolicy.class));
        }
        this.cproviderFactory = (ContinuationProviderFactory)this.bus.getExtension(ContinuationProviderFactory.class);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "initConfig");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void cacheInput(Message outMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "cacheInput", new Object[]{outMessage});
        }
        if (outMessage.getExchange() == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "cacheInput");
            }
            return;
        }
        Message inMessage = outMessage.getExchange().getInMessage();
        if (inMessage == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "cacheInput");
            }
            return;
        }
        Object o = inMessage.get((Object)"cxf.io.cacheinput");
        DelegatingInputStream in = (DelegatingInputStream)inMessage.getContent(DelegatingInputStream.class);
        if (MessageUtils.isTrue((Object)o)) {
            Collection atts = inMessage.getAttachments();
            if (atts != null) {
                for (Attachment a : atts) {
                    if (!(a.getDataHandler().getDataSource() instanceof AttachmentDataSource)) continue;
                    try {
                        ((AttachmentDataSource)a.getDataHandler().getDataSource()).cache(inMessage);
                    }
                    catch (IOException e) {
                        throw new Fault((Throwable)e);
                    }
                }
            }
            if (in != null) {
                in.cacheInput();
            }
        } else if (in != null) {
            try {
                IOUtils.consume((InputStream)in, (int)0x1000000);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "cacheInput");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected OutputStream flushHeaders(Message outMessage) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "flushHeaders", new Object[]{outMessage});
        }
        OutputStream outputStream = this.flushHeaders(outMessage, true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            outputStream = outputStream;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "flushHeaders", outputStream);
        }
        return outputStream;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected OutputStream flushHeaders(Message outMessage, boolean getStream) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "flushHeaders", new Object[]{outMessage, getStream});
        }
        if (this.isResponseRedirected(outMessage)) {
            OutputStream outputStream = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                outputStream = outputStream;
                LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "flushHeaders", outputStream);
            }
            return outputStream;
        }
        this.cacheInput(outMessage);
        Headers headers = null;
        if (this.server != null) {
            headers = new Headers(outMessage);
            headers.setFromServerPolicy(this.server);
        }
        ServletOutputStream responseStream = null;
        boolean oneWay = this.isOneWay(outMessage);
        HttpServletResponse response = this.getHttpResponseFromMessage(outMessage);
        int responseCode = this.getReponseCodeFromMessage(outMessage);
        response.setStatus(responseCode);
        if (headers == null) {
            headers = new Headers(outMessage);
        }
        if (500 == responseCode) {
            headers.removeContentType();
        }
        headers.copyToResponse(response);
        outMessage.put((Object)RESPONSE_HEADERS_COPIED, (Object)"true");
        if (this.hasNoResponseContent(outMessage)) {
            response.setContentLength(0);
            response.flushBuffer();
            response.getOutputStream().close();
        } else if (!getStream) {
            response.getOutputStream().close();
        } else {
            responseStream = response.getOutputStream();
        }
        if (oneWay) {
            outMessage.remove((Object)HTTP_RESPONSE);
        }
        ServletOutputStream servletOutputStream = responseStream;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            servletOutputStream = servletOutputStream;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "flushHeaders", servletOutputStream);
        }
        return servletOutputStream;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private int getReponseCodeFromMessage(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getReponseCodeFromMessage", new Object[]{message});
        }
        Integer i = (Integer)message.get((Object)Message.RESPONSE_CODE);
        if (i != null) {
            int n = i;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                n = n;
                LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getReponseCodeFromMessage", n);
            }
            return n;
        }
        if (this.hasNoResponseContent(message)) {
            int n = 202;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                n = n;
                LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getReponseCodeFromMessage", n);
            }
            return n;
        }
        int n = 200;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getReponseCodeFromMessage", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean hasNoResponseContent(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "hasNoResponseContent", new Object[]{message});
        }
        boolean ow = this.isOneWay(message);
        boolean pr = MessageUtils.isPartialResponse((Message)message);
        boolean epr = MessageUtils.isEmptyPartialResponse((Message)message);
        boolean bl = ow && (!pr || epr) || !ow && epr;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "hasNoResponseContent", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private HttpServletResponse getHttpResponseFromMessage(Message message) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getHttpResponseFromMessage", new Object[]{message});
        }
        Object responseObj = message.get((Object)HTTP_RESPONSE);
        if (responseObj instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)responseObj;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                httpServletResponse = httpServletResponse;
                LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getHttpResponseFromMessage", httpServletResponse);
            }
            return httpServletResponse;
        }
        if (null != responseObj) {
            String m = new org.apache.cxf.common.i18n.Message("UNEXPECTED_RESPONSE_TYPE_MSG", LOG, new Object[]{responseObj.getClass()}).toString();
            LOG.log(Level.WARNING, m);
            throw new IOException(m);
        }
        String m = new org.apache.cxf.common.i18n.Message("NULL_RESPONSE_MSG", LOG, new Object[0]).toString();
        LOG.log(Level.WARNING, m);
        throw new IOException(m);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isResponseRedirected(Message outMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "isResponseRedirected", new Object[]{outMessage});
        }
        boolean bl = Boolean.TRUE.equals(outMessage.get((Object)REQUEST_REDIRECTED));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "isResponseRedirected", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean contextMatchOnExact() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "contextMatchOnExact", new Object[0]);
        }
        boolean bl = "exact".equals(this.contextMatchStrategy);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "contextMatchOnExact", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void finalizeConfig() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "finalizeConfig", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "finalizeConfig");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getBeanName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getBeanName", new Object[0]);
        }
        String beanName = null;
        if (this.endpointInfo.getName() != null) {
            beanName = this.endpointInfo.getName().toString() + ".http-destination";
        }
        String string = beanName;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getBeanName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointReferenceType getAddressWithId(String id) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getAddressWithId", new Object[]{id});
        }
        EndpointReferenceType ref = null;
        if (this.isMultiplexWithAddress()) {
            String address = EndpointReferenceUtils.getAddress((EndpointReferenceType)this.reference);
            ref = EndpointReferenceUtils.duplicate((EndpointReferenceType)this.reference);
            if (address.endsWith("/")) {
                EndpointReferenceUtils.setAddress((EndpointReferenceType)ref, (String)(address + id));
            } else {
                EndpointReferenceUtils.setAddress((EndpointReferenceType)ref, (String)(address + "/" + id));
            }
        } else {
            ref = super.getAddressWithId(id);
        }
        EndpointReferenceType endpointReferenceType = ref;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointReferenceType = endpointReferenceType;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getAddressWithId", endpointReferenceType);
        }
        return endpointReferenceType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getId(Map<String, Object> context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getId", new Object[]{context});
        }
        String id = null;
        if (this.isMultiplexWithAddress()) {
            String address = (String)context.get(Message.PATH_INFO);
            if (null != address) {
                int afterLastSlashIndex = address.lastIndexOf("/") + 1;
                if (afterLastSlashIndex > 0 && afterLastSlashIndex < address.length()) {
                    id = address.substring(afterLastSlashIndex);
                }
            } else {
                this.getLogger().log(Level.WARNING, new org.apache.cxf.common.i18n.Message("MISSING_PATH_INFO", LOG, new Object[0]).toString());
            }
        } else {
            String string = super.getId(context);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getId", string);
            }
            return string;
        }
        String string = id;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getId", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getContextMatchStrategy() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getContextMatchStrategy", new Object[0]);
        }
        String string = this.contextMatchStrategy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getContextMatchStrategy", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setContextMatchStrategy(String contextMatchStrategy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "setContextMatchStrategy", new Object[]{contextMatchStrategy});
        }
        this.contextMatchStrategy = contextMatchStrategy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "setContextMatchStrategy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isFixedParameterOrder() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "isFixedParameterOrder", new Object[0]);
        }
        boolean bl = this.fixedParameterOrder;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "isFixedParameterOrder", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setFixedParameterOrder(boolean fixedParameterOrder) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "setFixedParameterOrder", new Object[]{fixedParameterOrder});
        }
        this.fixedParameterOrder = fixedParameterOrder;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "setFixedParameterOrder");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isMultiplexWithAddress() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "isMultiplexWithAddress", new Object[0]);
        }
        boolean bl = this.multiplexWithAddress;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "isMultiplexWithAddress", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setMultiplexWithAddress(boolean multiplexWithAddress) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "setMultiplexWithAddress", new Object[]{multiplexWithAddress});
        }
        this.multiplexWithAddress = multiplexWithAddress;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "setMultiplexWithAddress");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HTTPServerPolicy getServer() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getServer", new Object[0]);
        }
        HTTPServerPolicy hTTPServerPolicy = this.server;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hTTPServerPolicy = hTTPServerPolicy;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getServer", (Object)hTTPServerPolicy);
        }
        return hTTPServerPolicy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setServer(HTTPServerPolicy server) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "setServer", new Object[]{server});
        }
        this.server = server;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "setServer");
        }
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void assertMessage(Message message) {
        LOG.entering("AbstractHTTPDestination", "assertMessage");
        PolicyDataEngine pde = (PolicyDataEngine)this.bus.getExtension(PolicyDataEngine.class);
        pde.assertMessage(message, (Object)this.server, (PolicyCalculator)new ServerPolicyCalculator());
        LOG.exiting("AbstractHTTPDestination", "assertMessage");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean canAssert(QName type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "canAssert", new Object[]{type});
        }
        boolean bl = new ServerPolicyCalculator().getDataClassName().equals(type);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "canAssert", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void releaseRegistry() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "releaseRegistry", new Object[0]);
        }
        this.registry = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "releaseRegistry");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPath() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "getPath", new Object[0]);
        }
        String string = this.path;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "getPath", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void activate() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "activate", new Object[0]);
        }
        AbstractHTTPDestination abstractHTTPDestination = this;
        synchronized (abstractHTTPDestination) {
            if (this.registry != null) {
                this.registry.addDestination(this);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "activate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void deactivate() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "deactivate", new Object[0]);
        }
        AbstractHTTPDestination abstractHTTPDestination = this;
        synchronized (abstractHTTPDestination) {
            if (this.registry != null) {
                this.registry.removeDestination(this.path);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "deactivate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.AbstractHTTPDestination", "shutdown", new Object[0]);
        }
        AbstractHTTPDestination abstractHTTPDestination = this;
        synchronized (abstractHTTPDestination) {
            if (this.registry != null) {
                this.registry.removeDestination(this.path);
            }
        }
        super.shutdown();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.AbstractHTTPDestination", "shutdown");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private class WrappedOutputStream
    extends AbstractWrappedOutputStream {
        protected HttpServletResponse response;
        private Message outMessage;
        static final long serialVersionUID = 6029657078600811112L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        WrappedOutputStream(Message m, HttpServletResponse resp) {
            this.outMessage = m;
            this.response = resp;
        }

        protected void onFirstWrite() throws IOException {
            OutputStream responseStream = AbstractHTTPDestination.this.flushHeaders(this.outMessage);
            if (null != responseStream) {
                this.wrappedStream = responseStream;
            }
        }

        public void close() throws IOException {
            OutputStream responseStream;
            if (!this.written && this.wrappedStream == null && null != (responseStream = AbstractHTTPDestination.this.flushHeaders(this.outMessage, false))) {
                this.wrappedStream = responseStream;
            }
            if (this.wrappedStream != null) {
                this.wrappedStream.close();
                this.response.flushBuffer();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.AbstractHTTPDestination$WrappedOutputStream", WrappedOutputStream.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public class BackChannelConduit
    extends AbstractDestination.AbstractBackChannelConduit {
        protected HttpServletResponse response;
        static final long serialVersionUID = 328167629771177031L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        BackChannelConduit(HttpServletResponse resp) {
            super((AbstractDestination)AbstractHTTPDestination.this);
            this.response = resp;
        }

        public void prepare(Message message) throws IOException {
            message.put((Object)AbstractHTTPDestination.HTTP_RESPONSE, (Object)this.response);
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            if (os == null) {
                message.setContent(OutputStream.class, (Object)new WrappedOutputStream(message, this.response));
            }
        }

        public void close(Message msg) throws IOException {
            super.close(msg);
            if (msg.getExchange() == null) {
                return;
            }
            Message m = msg.getExchange().getInMessage();
            if (m == null) {
                return;
            }
            InputStream is = (InputStream)m.getContent(InputStream.class);
            if (is != null) {
                try {
                    is.close();
                    m.removeContent(InputStream.class);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.AbstractHTTPDestination$BackChannelConduit", BackChannelConduit.class, null, null);
        }
    }
}

