/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.configuration.jsse.SSLUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.transport.https.AliasedX509ExtendedKeyManager;
import org.apache.cxf.transport.https.CertificateHostnameVerifier;
import org.apache.cxf.transport.https.SSLSocketFactoryWrapper;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class HttpsURLConnectionFactory {
    public static final String HTTPS_URL_PROTOCOL_ID = "https";
    private static final Logger LOG = LogUtils.getL7dLogger(HttpsURLConnectionFactory.class);
    private static boolean weblogicWarned;
    SSLSocketFactory socketFactory;
    static final long serialVersionUID = -1336526326323661690L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HttpsURLConnectionFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HttpURLConnection createConnection(TLSClientParameters tlsClientParameters, java.net.Proxy proxy, URL url) throws IOException {
        HttpURLConnection connection;
        block10: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "createConnection", new Object[]{tlsClientParameters, proxy, url});
            }
            connection = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
            if (HTTPS_URL_PROTOCOL_ID.equals(url.getProtocol())) {
                if (tlsClientParameters == null) {
                    tlsClientParameters = new TLSClientParameters();
                }
                Exception ex = null;
                try {
                    this.decorateWithTLS(tlsClientParameters, connection);
                }
                catch (Exception e) {
                    ex = e;
                    return ex;
                }
                finally {
                    if (ex == null) break block10;
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    IOException ioException = new IOException("Error while initializing secure socket");
                    ioException.initCause(ex);
                    throw ioException;
                }
            }
        }
        HttpURLConnection httpURLConnection = connection;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            httpURLConnection = httpURLConnection;
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "createConnection", httpURLConnection);
        }
        return httpURLConnection;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected synchronized void decorateWithTLS(TLSClientParameters tlsClientParameters, HttpURLConnection connection) throws GeneralSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "decorateWithTLS", new Object[]{tlsClientParameters, connection});
        }
        if (tlsClientParameters.isUseHttpsURLConnectionDefaultSslSocketFactory()) {
            this.socketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        } else if (tlsClientParameters.getSSLSocketFactory() != null) {
            this.socketFactory = tlsClientParameters.getSSLSocketFactory();
        } else if (this.socketFactory == null) {
            String provider = tlsClientParameters.getJsseProvider();
            String protocol = tlsClientParameters.getSecureSocketProtocol() != null ? tlsClientParameters.getSecureSocketProtocol() : "TLS";
            SSLContext ctx = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
            ctx.getClientSessionContext().setSessionTimeout(tlsClientParameters.getSslCacheTimeout());
            KeyManager[] keyManagers = tlsClientParameters.getKeyManagers();
            if (tlsClientParameters.getCertAlias() != null) {
                this.getKeyManagersWithCertAlias(tlsClientParameters, keyManagers);
            }
            ctx.init(keyManagers, tlsClientParameters.getTrustManagers(), tlsClientParameters.getSecureRandom());
            String[] cipherSuites = SSLUtils.getCiphersuites((List)tlsClientParameters.getCipherSuites(), (String[])SSLUtils.getSupportedCipherSuites((SSLContext)ctx), (FiltersType)tlsClientParameters.getCipherSuitesFilter(), (Logger)LOG, (boolean)false);
            this.socketFactory = new SSLSocketFactoryWrapper(ctx.getSocketFactory(), cipherSuites, tlsClientParameters.getSecureSocketProtocol());
        }
        HostnameVerifier verifier = tlsClientParameters.isUseHttpsURLConnectionDefaultHostnameVerifier() ? HttpsURLConnection.getDefaultHostnameVerifier() : (tlsClientParameters.isDisableCNCheck() ? CertificateHostnameVerifier.ALLOW_ALL : CertificateHostnameVerifier.DEFAULT);
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection conn = (HttpsURLConnection)connection;
            conn.setHostnameVerifier(verifier);
            conn.setSSLSocketFactory(this.socketFactory);
        } else {
            try {
                Method method = connection.getClass().getMethod("getHostnameVerifier", new Class[0]);
                ReflectionInvokationHandler handler = new ReflectionInvokationHandler(verifier){
                    static final long serialVersionUID = -8610864853741363582L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        try {
                            return super.invoke(proxy, method, args);
                        }
                        catch (Exception ex) {
                            return false;
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.https.HttpsURLConnectionFactory$1", 1.class, null, null);
                    }
                };
                Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{method.getReturnType()}, (InvocationHandler)handler);
                method = connection.getClass().getMethod("setHostnameVerifier", method.getReturnType());
                method.invoke((Object)connection, proxy);
            }
            catch (Exception method) {
                // empty catch block
            }
            try {
                Method getSSLSocketFactory = connection.getClass().getMethod("getSSLSocketFactory", new Class[0]);
                Method setSSLSocketFactory = connection.getClass().getMethod("setSSLSocketFactory", getSSLSocketFactory.getReturnType());
                if (getSSLSocketFactory.getReturnType().isInstance(this.socketFactory)) {
                    setSSLSocketFactory.invoke((Object)connection, this.socketFactory);
                } else {
                    Constructor<?> c = getSSLSocketFactory.getReturnType().getDeclaredConstructor(SSLSocketFactory.class);
                    c.setAccessible(true);
                    setSSLSocketFactory.invoke((Object)connection, c.newInstance(this.socketFactory));
                }
            }
            catch (Exception ex) {
                if (connection.getClass().getName().contains("weblogic")) {
                    if (!weblogicWarned) {
                        weblogicWarned = true;
                        LOG.warning("Could not configure SSLSocketFactory on Weblogic.   Use the Weblogic control panel to configure the SSL settings.");
                    }
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "decorateWithTLS");
                    }
                    return;
                }
                throw new IllegalArgumentException("Error decorating connection class " + connection.getClass().getName(), ex);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "decorateWithTLS");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void addLogHandler(Handler handler) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "addLogHandler", new Object[]{handler});
        }
        LOG.addHandler(handler);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "addLogHandler");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void getKeyManagersWithCertAlias(TLSClientParameters tlsClientParameters, KeyManager[] keyManagers) throws GeneralSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "getKeyManagersWithCertAlias", new Object[]{tlsClientParameters, keyManagers});
        }
        if (tlsClientParameters.getCertAlias() != null) {
            for (int idx = 0; idx < keyManagers.length; ++idx) {
                if (!(keyManagers[idx] instanceof X509KeyManager)) continue;
                try {
                    keyManagers[idx] = new AliasedX509ExtendedKeyManager(tlsClientParameters.getCertAlias(), (X509KeyManager)keyManagers[idx]);
                    continue;
                }
                catch (Exception e) {
                    throw new GeneralSecurityException(e);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "getKeyManagersWithCertAlias");
        }
    }
}

