/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PemKeyUtil {
    private static final TraceComponent tc = Tr.register(PemKeyUtil.class, null, null);
    protected static final String BEGIN = "-----BEGIN PUBLIC KEY-----";
    protected static final String END = "-----END PUBLIC KEY-----";
    protected static final String BEGIN_RSA = "-----BEGIN RSA PUBLIC KEY-----";
    protected static final String END_RSA = "-----END RSA PUBLIC KEY-----";
    protected static final String BEGIN_EC = "-----BEGIN ECDSA PUBLIC KEY-----";
    protected static final String END_EC = "-----END ECDSA PUBLIC KEY-----";
    protected static final String LINE_SEPARATOR_UNIX = "\n";
    protected static final String LINE_SEPARATOR_MAC = "\r";
    protected static final String LINE_SEPARATOR_WINDOW = "\r\n";
    protected static final String RSA_KEY = "RSA";
    protected static final String EC_KEY = "EC";
    static final long serialVersionUID = 6458999190022859622L;

    public static PublicKey getPublicKey(String pkcs8pem) throws Exception {
        KeyType keyType = PemKeyUtil.getKeyType(pkcs8pem);
        String pemKey = PemKeyUtil.removeDelimiter(pkcs8pem);
        byte[] encodedKey = Base64.decodeBase64((String)pemKey);
        return PemKeyUtil.generatePublicKey(encodedKey, keyType);
    }

    private static KeyType getKeyType(String pkcs8pem) {
        if (pkcs8pem == null) {
            return KeyType.UNKNOWN;
        }
        if (pkcs8pem.contains(BEGIN_RSA)) {
            return KeyType.RSA;
        }
        if (pkcs8pem.contains(BEGIN_EC)) {
            return KeyType.EC;
        }
        if (pkcs8pem.contains(BEGIN)) {
            return KeyType.PUBLIC;
        }
        return KeyType.UNKNOWN;
    }

    private static String removeDelimiter(String pem) {
        pem = pem.replaceAll(BEGIN, "");
        pem = pem.replaceAll(END, "");
        pem = pem.replaceAll(BEGIN_RSA, "");
        pem = pem.replaceAll(END_RSA, "");
        pem = pem.replaceAll(BEGIN_EC, "");
        pem = pem.replaceAll(END_EC, "");
        pem = pem.replaceAll(LINE_SEPARATOR_UNIX, "");
        pem = pem.replaceAll(LINE_SEPARATOR_MAC, "");
        pem = pem.replaceAll(LINE_SEPARATOR_WINDOW, "");
        return pem.trim();
    }

    private static PublicKey generatePublicKey(byte[] encodedKey, KeyType keyType) throws Exception {
        if (keyType == KeyType.RSA) {
            return PemKeyUtil.generateRsaPublicKey(encodedKey);
        }
        if (keyType == KeyType.EC) {
            return PemKeyUtil.generateEcPublicKey(encodedKey);
        }
        if (keyType == KeyType.PUBLIC) {
            return PemKeyUtil.generateUnspecifiedPublicKey(encodedKey);
        }
        return null;
    }

    private static PublicKey generateRsaPublicKey(byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY);
        return keyFactory.generatePublic(keySpec);
    }

    private static PublicKey generateEcPublicKey(byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance(EC_KEY);
        return keyFactory.generatePublic(keySpec);
    }

    @FFDCIgnore(value={Exception.class})
    private static PublicKey generateUnspecifiedPublicKey(byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        try {
            return PemKeyUtil.generateRsaPublicKey(encodedKey);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to generate RSA public key. Will try to generate EC key instead. Exception was: " + e), (Object[])new Object[0]);
            }
            return PemKeyUtil.generateEcPublicKey(encodedKey);
        }
    }

    private static enum KeyType {
        RSA,
        EC,
        PUBLIC,
        UNKNOWN;

    }
}

