/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.reactive.messaging.kafka.ThresholdCounter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ThresholdCounterImpl
implements ThresholdCounter {
    private static final TraceComponent tc = Tr.register(ThresholdCounterImpl.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    private final int threshold;
    private final AtomicInteger counter;
    private CompletableFuture<Void> counterThresholdStage;
    static final long serialVersionUID = 4586848603809325997L;

    public ThresholdCounterImpl(int threshold) {
        this.threshold = threshold;
        this.counter = new AtomicInteger(0);
        this.counterThresholdStage = CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment() {
        AtomicInteger atomicInteger = this.counter;
        synchronized (atomicInteger) {
            int count = this.counter.incrementAndGet();
            if (count == this.threshold) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Too many outstanding unacked messages, stopping polling kafka. Current count: " + count), (Object[])new Object[0]);
                }
                this.counterThresholdStage = new CompletableFuture();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrement() {
        CompletableFuture<Void> thresholdStage;
        int count;
        AtomicInteger atomicInteger = this.counter;
        synchronized (atomicInteger) {
            count = this.counter.getAndDecrement();
            thresholdStage = this.counterThresholdStage;
        }
        if (count == this.threshold) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Outstanding unacked message count dropped below threshold, resuming polling kafka. Current count: " + count), (Object[])new Object[0]);
            }
            thresholdStage.complete(null);
        }
    }

    @Override
    public CompletionStage<Void> waitForBelowThreshold() {
        return this.counterThresholdStage;
    }
}

