/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.acme.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.acme.AcmeCaException;
import com.ibm.ws.security.acme.internal.util.AcmeConstants;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AcmeConfig {
    private static final TraceComponent tc = Tr.register(AcmeConfig.class, (String)"ACME", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
    private String directoryURI = null;
    private List<String> domains = null;
    private Long validForMs = null;
    private List<Rdn> subjectDN = new ArrayList<Rdn>();
    private Long challengePollTimeoutMs = 120000L;
    private Long orderPollTimeoutMs = 120000L;
    private String accountKeyFile = null;
    private List<String> accountContacts = null;
    private String domainKeyFile = null;
    private String protocol = null;
    private String trustStore = null;
    private SerializableProtectedString trustStorePassword = null;
    private String trustStoreType = null;
    private int httpConnectTimeout = AcmeConstants.HTTP_CONNECT_TIMEOUT_DEFAULT;
    private int httpReadTimeout = AcmeConstants.HTTP_READ_TIMEOUT_DEFAULT;
    private Long renewBeforeExpirationMs = AcmeConstants.RENEW_DEFAULT_MS;
    private boolean autoRenewOnExpiration = true;
    private URI ocspResponderUrl = null;
    private Boolean revocationCheckerEnabled = null;
    private Boolean preferCRLs = false;
    private Boolean disableFallback = false;
    private Long certCheckerScheduler = AcmeConstants.SCHEDULER_MS;
    private Long certCheckerErrorScheduler = AcmeConstants.SCHEDULER_ERROR_MS;
    private boolean disableMinRenewWindow = false;
    private boolean disableRenewOnNewHistory = false;
    private Long renewCertMin = 15000L;
    private Long startReadyTimeout = AcmeConstants.START_READY_TIMEOUT_DEFAULT;
    static final long serialVersionUID = 1659105284620069376L;

    public AcmeConfig(Map<String, Object> properties) throws AcmeCaException {
        this(properties, false);
    }

    public AcmeConfig(Map<String, Object> properties, boolean throwWarnings) throws AcmeCaException {
        this.directoryURI = AcmeConfig.getStringValue(properties, "directoryURI");
        if (this.directoryURI == null || this.directoryURI.trim().isEmpty()) {
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2008E", (Object[])new Object[]{this.directoryURI}));
        }
        this.domains = new ArrayList<String>();
        List<String> tempDomains = AcmeConfig.getStringList(properties, "domain");
        if (tempDomains != null && !tempDomains.isEmpty()) {
            for (String domain : tempDomains) {
                if (domain == null || domain.trim().isEmpty()) continue;
                this.domains.add(domain);
            }
        }
        if (this.domains.isEmpty()) {
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2037E", (Object[])new Object[0]));
        }
        Long certMin = AcmeConfig.getLongValue(properties, "renewCertMin", 15000L);
        this.renewCertMin = certMin <= 0L ? 15000L : certMin;
        this.setValidFor(AcmeConfig.getLongValue(properties, "validFor"));
        this.processSubjectDN(AcmeConfig.getStringValue(properties, "subjectDN"));
        Long temp = AcmeConfig.getLongValue(properties, "challengePollTimeout");
        this.challengePollTimeoutMs = Math.max(0L, temp == null ? 120000L : temp);
        temp = AcmeConfig.getLongValue(properties, "orderPollTimeout");
        this.orderPollTimeoutMs = Math.max(0L, temp == null ? 120000L : temp);
        this.accountContacts = AcmeConfig.getStringList(properties, "accountContact");
        if (this.accountContacts == null && throwWarnings) {
            Tr.warning((TraceComponent)tc, (String)"CWPKI2073W", (Object[])new Object[0]);
        }
        this.setCertCheckerScheduler(AcmeConfig.getLongValue(properties, "certCheckerSchedule"));
        this.setCertCheckerErrorScheduler(AcmeConfig.getLongValue(properties, "certCheckerErrorSchedule"));
        this.accountKeyFile = AcmeConfig.getStringValue(properties, "accountKeyFile");
        AcmeConfig.validateKeyFilePath(this.accountKeyFile, "account");
        this.domainKeyFile = AcmeConfig.getStringValue(properties, "domainKeyFile");
        AcmeConfig.validateKeyFilePath(this.domainKeyFile, "domain");
        List<Map<String, Object>> transportConfig = Nester.nest("acmeTransportConfig", properties);
        if (!transportConfig.isEmpty()) {
            Map<String, Object> transportProps = transportConfig.get(0);
            this.protocol = AcmeConfig.getStringValue(transportProps, "protocol");
            this.trustStore = AcmeConfig.getStringValue(transportProps, "trustStore");
            this.trustStorePassword = AcmeConfig.getSerializableProtectedStringValue(transportProps, "trustStorePassword");
            this.trustStoreType = AcmeConfig.getStringValue(transportProps, "trustStoreType");
            Long raw = AcmeConfig.getLongValue(transportProps, "httpConnectTimeout");
            Long modToInt = Math.max(0L, raw == null ? (long)AcmeConstants.HTTP_CONNECT_TIMEOUT_DEFAULT.intValue() : raw);
            this.httpConnectTimeout = (int)Math.min(modToInt, Integer.MAX_VALUE);
            raw = AcmeConfig.getLongValue(transportProps, "httpReadTimeout");
            modToInt = Math.max(0L, raw == null ? (long)AcmeConstants.HTTP_READ_TIMEOUT_DEFAULT.intValue() : raw);
            this.httpReadTimeout = (int)Math.min(modToInt, Integer.MAX_VALUE);
        }
        this.setRenewBeforeExpirationMs(AcmeConfig.getLongValue(properties, "renewBeforeExpiration"), true);
        this.disableMinRenewWindow = AcmeConfig.getBooleanValue(properties, "disableMinRenewWindow", false);
        this.disableRenewOnNewHistory = AcmeConfig.getBooleanValue(properties, "disableRenewOnNewHistory", false);
        Long startReady = AcmeConfig.getLongValue(properties, "startReadyTimeout", AcmeConstants.START_READY_TIMEOUT_DEFAULT);
        this.startReadyTimeout = startReady <= 0L ? AcmeConstants.START_READY_TIMEOUT_DEFAULT : startReady;
        List<Map<String, Object>> revocationChecker = Nester.nest("acmeRevocationChecker", properties);
        if (!revocationChecker.isEmpty()) {
            Map<String, Object> revocationProps = revocationChecker.get(0);
            String url = AcmeConfig.getStringValue(revocationProps, "ocspResponderUrl");
            if (url != null) {
                try {
                    this.ocspResponderUrl = URI.create(url);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.security.acme.internal.AcmeConfig", (String)"216", (Object)this, (Object[])new Object[]{properties, throwWarnings});
                    throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2062E", (Object[])new Object[]{url}));
                }
            }
            this.revocationCheckerEnabled = AcmeConfig.getBooleanValue(revocationProps, "enabled");
            this.preferCRLs = AcmeConfig.getBooleanValue(revocationProps, "preferCRLs");
            this.disableFallback = AcmeConfig.getBooleanValue(revocationProps, "disableFallback");
        }
    }

    @Trivial
    private static Boolean getBooleanValue(Map<String, Object> configProps, String property, boolean outcomeOnNull) {
        Object value = configProps.get(property);
        if (value == null) {
            return outcomeOnNull;
        }
        return (Boolean)value;
    }

    @Trivial
    private static Boolean getBooleanValue(Map<String, Object> configProps, String property) {
        Object value = configProps.get(property);
        if (value == null) {
            return null;
        }
        return (Boolean)value;
    }

    @Trivial
    private static Integer getIntegerValue(Map<String, Object> configProps, String property) {
        Object value = configProps.get(property);
        if (value == null) {
            return null;
        }
        return (Integer)value;
    }

    @Trivial
    private static Long getLongValue(Map<String, Object> configProps, String property) {
        Object value = configProps.get(property);
        if (value == null) {
            return null;
        }
        return (Long)value;
    }

    @Trivial
    private static Long getLongValue(Map<String, Object> configProps, String property, Long outcomeOnNull) {
        Object value = configProps.get(property);
        if (value == null) {
            return outcomeOnNull;
        }
        return (Long)value;
    }

    @Trivial
    private static List<String> getStringList(Map<String, Object> configProps, String property) {
        Object value = configProps.get(property);
        if (value == null) {
            return null;
        }
        if (!(value instanceof String[])) {
            return null;
        }
        String[] array = (String[])value;
        if (array.length == 0) {
            return null;
        }
        ArrayList<String> values = null;
        for (String item : array) {
            if (item == null || item.trim().isEmpty()) continue;
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.add(item);
        }
        return values;
    }

    @Trivial
    private static SerializableProtectedString getSerializableProtectedStringValue(Map<String, Object> configProps, String property) {
        Object value = configProps.get(property);
        if (value == null) {
            return null;
        }
        return (SerializableProtectedString)value;
    }

    @Trivial
    private static String getStringValue(Map<String, Object> configProps, String property) {
        Object value = configProps.get(property);
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    public String getDirectoryURI() {
        return this.directoryURI;
    }

    public Boolean isDisableFallback() {
        return this.disableFallback == null ? false : this.disableFallback;
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public Long getValidForMs() {
        return this.validForMs;
    }

    public Long getChallengePollTimeoutMs() {
        return this.challengePollTimeoutMs;
    }

    public URI getOcspResponderUrl() {
        return this.ocspResponderUrl;
    }

    public Long getOrderPollTimeoutMs() {
        return this.orderPollTimeoutMs;
    }

    public Boolean isPreferCrls() {
        return this.preferCRLs == null ? false : this.preferCRLs;
    }

    public String getAccountKeyFile() {
        return this.accountKeyFile;
    }

    public List<String> getAccountContacts() {
        return this.accountContacts;
    }

    public String getDomainKeyFile() {
        return this.domainKeyFile;
    }

    public Boolean isRevocationCheckerEnabled() {
        return this.revocationCheckerEnabled == null ? true : this.revocationCheckerEnabled;
    }

    public SSLConfig getSSLConfig() {
        SSLConfig sslConfig = new SSLConfig();
        if (this.protocol != null) {
            sslConfig.setProperty("com.ibm.ssl.protocol", this.protocol);
        }
        if (this.trustStore != null) {
            sslConfig.setProperty("com.ibm.ssl.trustStore", this.trustStore);
        }
        if (this.trustStorePassword != null) {
            sslConfig.setProperty("com.ibm.ssl.trustStorePassword", String.valueOf(this.trustStorePassword.getChars()));
        }
        if (this.trustStoreType != null) {
            sslConfig.setProperty("com.ibm.ssl.trustStoreType", this.trustStoreType);
        }
        sslConfig.setProperty("com.ibm.ws.ssl.trustDefaultCerts", "true");
        return sslConfig;
    }

    public List<Rdn> getSubjectDN() {
        return this.subjectDN;
    }

    @FFDCIgnore(value={InvalidNameException.class})
    private void processSubjectDN(String subjectDN) throws AcmeCaException {
        if (subjectDN != null && !subjectDN.isEmpty()) {
            try {
                this.subjectDN.addAll(new LdapName(subjectDN).getRdns());
                Collections.reverse(this.subjectDN);
                block16: for (int idx = 0; idx < this.subjectDN.size(); ++idx) {
                    Rdn rdn = this.subjectDN.get(idx);
                    switch (rdn.getType().toLowerCase()) {
                        case "cn": {
                            if (idx == 0) {
                                String cnValue = (String)rdn.getValue();
                                int dIdx = -1;
                                for (int jdx = 0; jdx < this.domains.size(); ++jdx) {
                                    if (!this.domains.get(jdx).equalsIgnoreCase(cnValue)) continue;
                                    dIdx = jdx;
                                    break;
                                }
                                if (dIdx == -1) {
                                    throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2039E", (Object[])new Object[]{subjectDN, cnValue}));
                                }
                                String domain = this.domains.remove(dIdx);
                                this.domains.add(0, domain);
                                continue block16;
                            }
                            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2040E", (Object[])null));
                        }
                        case "o": 
                        case "ou": 
                        case "c": 
                        case "st": 
                        case "l": {
                            continue block16;
                        }
                        default: {
                            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2041E", (Object[])new Object[]{rdn.getType()}));
                        }
                    }
                }
            }
            catch (InvalidNameException e) {
                throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2042E", (Object[])new Object[]{subjectDN, e.getMessage()}), e);
            }
        }
        if (this.subjectDN.isEmpty() || !"cn".equalsIgnoreCase(this.subjectDN.get(0).getType())) {
            try {
                this.subjectDN.add(0, new Rdn("cn", this.domains.get(0)));
            }
            catch (InvalidNameException e) {
                throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2043E", (Object[])new Object[]{"cn=" + this.domains.get(0), e.getMessage()}), e);
            }
        }
    }

    @Trivial
    protected void setRenewBeforeExpirationMs(Long ms, boolean printWarning) {
        this.autoRenewOnExpiration = true;
        if (ms != null) {
            if (ms <= 0L) {
                this.renewBeforeExpirationMs = 0L;
                this.autoRenewOnExpiration = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Auto renewal of the certificate is disabled, renewBeforeExpirationMs was configured to " + ms), (Object[])new Object[0]);
                }
            } else if (ms < this.renewCertMin) {
                this.renewBeforeExpirationMs = this.renewCertMin;
                Tr.warning((TraceComponent)tc, (String)"CWPKI2051W", (Object[])new Object[]{ms + "ms", this.renewCertMin + "ms"});
            } else {
                this.renewBeforeExpirationMs = ms;
                if (printWarning && ms < AcmeConstants.RENEW_CERT_MIN_WARN_LEVEL) {
                    Tr.warning((TraceComponent)tc, (String)"CWPKI2055W", (Object[])new Object[]{this.renewBeforeExpirationMs + "ms"});
                }
            }
        }
    }

    @Trivial
    private void setValidFor(Long validForMs) {
        if (validForMs != null && validForMs >= 0L) {
            this.validForMs = validForMs;
        }
    }

    public Long getRenewBeforeExpirationMs() {
        return this.renewBeforeExpirationMs;
    }

    public boolean isAutoRenewOnExpiration() {
        return this.autoRenewOnExpiration;
    }

    private static void validateKeyFilePath(String path, String type) throws AcmeCaException {
        if (path == null || path.trim().isEmpty()) {
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2027E", (Object[])new Object[]{type, path}));
        }
        File file = new File(path);
        if (file.exists() && !file.canRead()) {
            String messageId = "domain".equals(type) ? "CWPKI2020E" : "CWPKI2021E";
            String cause = Tr.formatMessage((TraceComponent)tc, (String)"FILE_NOT_READABLE", (Object[])new Object[0]);
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)messageId, (Object[])new Object[]{path, cause}));
        }
        if (!file.exists()) {
            File parentFile = file;
            while ((parentFile = parentFile.getParentFile()) != null) {
                if (parentFile.exists() && !parentFile.canWrite()) {
                    String messageId = "domain".equals(type) ? "CWPKI2022E" : "CWPKI2023E";
                    String cause = Tr.formatMessage((TraceComponent)tc, (String)"FILE_NOT_WRITABLE", (Object[])new Object[0]);
                    throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)messageId, (Object[])new Object[]{path, cause}));
                }
                if (!parentFile.exists()) continue;
                break;
            }
        }
    }

    @Trivial
    public Long getCertCheckerScheduler() {
        return this.certCheckerScheduler;
    }

    public void setCertCheckerScheduler(Long certCheckerScheduler) {
        if (certCheckerScheduler != null) {
            if (certCheckerScheduler <= 0L) {
                this.certCheckerScheduler = 0L;
            } else if (certCheckerScheduler < this.renewCertMin) {
                this.certCheckerScheduler = this.renewCertMin;
                Tr.warning((TraceComponent)tc, (String)"CWPKI2070W", (Object[])new Object[]{certCheckerScheduler, this.certCheckerScheduler + "ms"});
            } else {
                this.certCheckerScheduler = certCheckerScheduler;
            }
        }
    }

    @Trivial
    public Long getCertCheckerErrorScheduler() {
        return this.certCheckerErrorScheduler;
    }

    public void setCertCheckerErrorScheduler(Long certCheckerErrorScheduler) {
        if (certCheckerErrorScheduler != null) {
            if (certCheckerErrorScheduler < this.renewCertMin) {
                this.certCheckerErrorScheduler = this.renewCertMin;
                Tr.warning((TraceComponent)tc, (String)"CWPKI2071W", (Object[])new Object[]{certCheckerErrorScheduler, this.certCheckerErrorScheduler + "ms"});
            } else {
                this.certCheckerErrorScheduler = certCheckerErrorScheduler;
            }
        }
    }

    @Trivial
    public boolean isDisableMinRenewWindow() {
        return this.disableMinRenewWindow;
    }

    @Trivial
    public boolean isDisableRenewOnNewHistory() {
        return this.disableRenewOnNewHistory;
    }

    @Trivial
    public long getRenewCertMin() {
        return this.renewCertMin;
    }

    @Trivial
    public Integer getHTTPConnectTimeout() {
        return this.httpConnectTimeout;
    }

    @Trivial
    public Integer getHTTPReadTimeout() {
        return this.httpReadTimeout;
    }

    @Trivial
    public Long getStartReadyTimeout() {
        return this.startReadyTimeout;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(":{");
        sb.append("directoryURI=").append(this.directoryURI).append("\n");
        sb.append(", domains=").append(this.domains).append("\n");
        sb.append(", validForMs=").append(this.validForMs).append("\n");
        sb.append(", subjectDN=").append(this.subjectDN).append("\n");
        sb.append(", challengePollTimeoutMs=").append(this.challengePollTimeoutMs).append("\n");
        sb.append(", orderPollTimeoutMs=").append(this.orderPollTimeoutMs).append("\n");
        sb.append(", accountKeyFile=").append(this.accountKeyFile).append("\n");
        sb.append(", accountContacts=").append(this.accountContacts).append("\n");
        sb.append(", domainKeyFile=").append(this.domainKeyFile).append("\n");
        sb.append(", renewBeforeExpirationMs=").append(this.renewBeforeExpirationMs).append("\n");
        sb.append(", autoRenewOnExpiration=").append(this.autoRenewOnExpiration).append("\n");
        sb.append(", certCheckerScheduler=").append(this.certCheckerScheduler).append("\n");
        sb.append(", certCheckerErrorScheduler=").append(this.certCheckerErrorScheduler).append("\n");
        sb.append(", disableMinRenewWindow=").append(this.disableMinRenewWindow).append("\n");
        sb.append(", disableRenewOnNewHistory=").append(this.disableRenewOnNewHistory).append("\n");
        sb.append(", renewCertMin=").append(this.renewCertMin).append("\n");
        sb.append(", startReadyTimeout=").append(this.startReadyTimeout).append("\n");
        sb.append(" }");
        sb.append(", acmeTransportConfig{ protocol=").append(this.protocol).append("\n");
        sb.append(", trustStore=").append(this.trustStore).append("\n");
        sb.append(", trustStoreType=").append(this.trustStoreType).append("\n");
        sb.append(", httpConnectTimeout=").append(this.httpConnectTimeout).append("\n");
        sb.append(", httpReadTimeout=").append(this.httpReadTimeout).append("\n");
        sb.append(" }");
        sb.append(", acmeRevocationChecker{ ocspResponderUrl=").append(this.ocspResponderUrl).append("\n");
        sb.append(", revocationCheckerEnabled=").append(this.revocationCheckerEnabled).append("\n");
        sb.append(", preferCRLs=").append(this.preferCRLs).append("\n");
        sb.append(", disableFallback=").append(this.disableFallback).append("\n");
        sb.append(" }");
        sb.append("}");
        return sb.toString();
    }
}

