/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.acme.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.acme.AcmeCaException;
import com.ibm.ws.security.acme.AcmeCertificate;
import com.ibm.ws.security.acme.AcmeProvider;
import com.ibm.ws.security.acme.internal.AcmeApplicationStateListener;
import com.ibm.ws.security.acme.internal.AcmeCertCheckerTask;
import com.ibm.ws.security.acme.internal.AcmeClient;
import com.ibm.ws.security.acme.internal.AcmeConfig;
import com.ibm.ws.security.acme.internal.AcmeConfigService;
import com.ibm.ws.security.acme.internal.AcmeHistory;
import com.ibm.ws.security.acme.internal.CertificateRevocationChecker;
import com.ibm.ws.security.acme.internal.exceptions.CertificateRenewRequestBlockedException;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class AcmeProviderImpl
implements AcmeProvider {
    private static final TraceComponent tc = Tr.register(AcmeProviderImpl.class, (String)"ACME", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
    private static final AtomicReference<KeyStoreService> keyStoreServiceRef = new AtomicReference();
    private static final AtomicReference<AcmeApplicationStateListener> applicationStateListenerRef = new AtomicReference();
    private final AtomicServiceReference<ScheduledExecutorService> scheduledExecutorServiceRef = new AtomicServiceReference("scheduledExecutorService");
    private static AcmeClient acmeClient;
    private static AcmeConfig acmeConfig;
    private AcmeCertCheckerTask acmeCertChecker = null;
    private final ReadWriteLock rwRenewCertLock = new ReentrantReadWriteLock();
    private long lastCertificateRenewalTimestamp = -1L;
    private AcmeHistory acmeHistory = new AcmeHistory();
    @Reference
    private WsLocationAdmin wslocation;
    static final long serialVersionUID = 7473883614061662134L;

    public void activate(ComponentContext cc) {
        this.scheduledExecutorServiceRef.activate(cc);
    }

    @Override
    public void renewAccountKeyPair() throws AcmeCaException {
        acmeClient.renewAccountKeyPair();
    }

    @Override
    public void renewCertificate() throws AcmeCaException {
        this.checkAndInstallCertificate(true, null, null, null);
    }

    @Override
    public void revokeCertificate(String reason) throws AcmeCaException {
        this.revoke(this.getConfiguredDefaultCertificateChain(), reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @FFDCIgnore(value={AcmeCaException.class})
    private void checkAndInstallCertificate(boolean forceRefresh, KeyStore keyStore, File keyStoreFile, @Sensitive String password) throws AcmeCaException {
        this.acquireWriteLock();
        try {
            applicationStateListenerRef.get().waitUntilResourcesAvailable(acmeConfig);
            List<X509Certificate> existingCertChain = null;
            if (keyStore == null) {
                existingCertChain = this.getConfiguredDefaultCertificateChain();
            } else {
                try {
                    existingCertChain = this.convertToX509CertChain(keyStore.getCertificateChain("default"));
                }
                catch (KeyStoreException keyStoreException) {
                    void e;
                    Object[] objectArray = new Object[4];
                    objectArray[0] = forceRefresh;
                    objectArray[1] = keyStore;
                    objectArray[2] = keyStoreFile;
                    objectArray[3] = "<sensitive java.lang.String>";
                    FFDCFilter.processException((Throwable)keyStoreException, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"183", (Object)this, (Object[])objectArray);
                    throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2029E", (Object[])new Object[]{keyStoreFile, "default", e.getMessage()}), (Throwable)e);
                }
            }
            AcmeCertificate acmeCertificate = this.checkAndRetrieveCertificate(existingCertChain, forceRefresh);
            if (acmeCertificate != null) {
                block21: {
                    block20: {
                        Certificate[] chainArr = AcmeProviderImpl.convertChainToArray(acmeCertificate.getCertificateChain());
                        try {
                            if (keyStore == null) {
                                keyStoreServiceRef.get().setKeyEntryToKeyStore("defaultKeyStore", "default", (Key)acmeCertificate.getKeyPair().getPrivate(), chainArr);
                                break block20;
                            }
                            keyStore.setKeyEntry("default", acmeCertificate.getKeyPair().getPrivate(), password.toCharArray(), chainArr);
                            try (FileOutputStream fos = new FileOutputStream(keyStoreFile);){
                                keyStore.store(fos, password.toCharArray());
                            }
                        }
                        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException fos) {
                            void ex;
                            Object[] objectArray = new Object[4];
                            objectArray[0] = forceRefresh;
                            objectArray[1] = keyStore;
                            objectArray[2] = keyStoreFile;
                            objectArray[3] = "<sensitive java.lang.String>";
                            FFDCFilter.processException((Throwable)fos, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"218", (Object)this, (Object[])objectArray);
                            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2030E", (Object[])new Object[]{"default", "defaultKeyStore", ex.getMessage()}), (Throwable)ex);
                        }
                    }
                    if (!acmeConfig.isDisableMinRenewWindow()) {
                        this.lastCertificateRenewalTimestamp = System.currentTimeMillis();
                    }
                    if (existingCertChain != null) {
                        try {
                            this.revoke(existingCertChain, "SUPERSEDED");
                        }
                        catch (AcmeCaException e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block21;
                            Tr.debug((TraceComponent)tc, (String)"Failed to revoke the certificate.", (Object[])new Object[]{existingCertChain, e});
                        }
                    }
                }
                Tr.audit((TraceComponent)tc, (String)"CWPKI2007I", (Object[])new Object[]{acmeCertificate.getCertificate().getSerialNumber().toString(16), acmeConfig.getDirectoryURI(), acmeCertificate.getCertificate().getNotAfter().toInstant().toString()});
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Previous certificate requested from ACME CA server is still valid.", (Object[])new Object[0]);
            }
            this.acmeCertChecker.startCertificateChecker(this.getScheduledExecutorService());
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public String getHttp01Authorization(String token) throws AcmeCaException {
        return this.getAcmeClient().getHttp01Authorization(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revoke(List<X509Certificate> certificateChain, String reason) throws AcmeCaException {
        this.acquireWriteLock();
        try {
            X509Certificate certificate = AcmeProviderImpl.getLeafCertificate(certificateChain);
            if (certificate == null) {
                return;
            }
            String directoryURI = this.acmeHistory.getDirectoryURI(certificate.getSerialNumber().toString(16));
            if (directoryURI == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The certificate was not found in the AcmeHistory file. Use the configured directory URI to revoke.", (Object[])new Object[0]);
                }
                directoryURI = acmeConfig.getDirectoryURI();
            }
            this.getAcmeClient().revoke(certificate, reason, directoryURI);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Trivial
    private AcmeClient getAcmeClient() throws AcmeCaException {
        if (acmeClient == null) {
            throw new AcmeCaException("Internal error. ACME client was not initialized.");
        }
        return acmeClient;
    }

    @Trivial
    public static AcmeConfig getAcmeConfig() {
        return acmeConfig;
    }

    @Reference(name="keyStoreService", service=KeyStoreService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setKeyStoreService(KeyStoreService keyStoreService) {
        keyStoreServiceRef.set(keyStoreService);
    }

    protected void unsetKeyStoreService(KeyStoreService keyStoreService) {
        keyStoreServiceRef.compareAndSet(keyStoreService, null);
    }

    private boolean isCertificateRequired(List<X509Certificate> existingCertChain) throws AcmeCaException {
        boolean isExpired = false;
        if (this.isExpired(existingCertChain)) {
            X509Certificate x590Certificate = existingCertChain.get(0);
            if (acmeConfig.isAutoRenewOnExpiration()) {
                isExpired = true;
                Tr.info((TraceComponent)tc, (String)"CWPKI2052I", (Object[])new Object[]{x590Certificate.getSerialNumber().toString(16), x590Certificate.getNotAfter().toInstant().toString(), acmeConfig.getDirectoryURI()});
            } else {
                Tr.warning((TraceComponent)tc, (String)"CWPKI2053W", (Object[])new Object[]{x590Certificate.getSerialNumber().toString(16), x590Certificate.getNotAfter().toInstant().toString()});
            }
        }
        return existingCertChain == null || existingCertChain.isEmpty() || isExpired || this.hasWrongDomains(existingCertChain) || this.hasWrongSubjectRDNs(existingCertChain) || this.isRevoked(existingCertChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcmeCertificate checkAndRetrieveCertificate(List<X509Certificate> existingCertChain, boolean forceRefresh) throws AcmeCaException {
        this.acquireWriteLock();
        try {
            if (forceRefresh || this.isCertificateRequired(existingCertChain)) {
                AcmeCertificate acmeCertificate = this.fetchCertificate();
                return acmeCertificate;
            }
        }
        finally {
            this.releaseWriteLock();
        }
        return null;
    }

    private List<X509Certificate> convertToX509CertChain(Certificate[] certChain) throws AcmeCaException {
        ArrayList<X509Certificate> x509Chain = new ArrayList<X509Certificate>();
        if (certChain != null) {
            for (Certificate cert : certChain) {
                if (!(cert instanceof X509Certificate)) {
                    throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2044E", (Object[])new Object[]{cert.getType()}));
                }
                x509Chain.add((X509Certificate)cert);
            }
        }
        return x509Chain;
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasWrongDomains(List<X509Certificate> certificateChain) throws AcmeCaException {
        String methodName = "hasWrongDomains(List<X509Certificate>)";
        boolean hasWrongDomains = false;
        X509Certificate certificate = AcmeProviderImpl.getLeafCertificate(certificateChain);
        if (certificate == null) {
            return false;
        }
        try {
            LdapName dn = new LdapName(certificate.getSubjectX500Principal().getName());
            boolean cnMatches = false;
            block7: for (Rdn rdn : dn.getRdns()) {
                if (!"cn".equalsIgnoreCase(rdn.getType())) continue;
                for (String domain : acmeConfig.getDomains()) {
                    if (!domain.equalsIgnoreCase((String)rdn.getValue())) continue;
                    cnMatches = true;
                    break block7;
                }
            }
            if (!cnMatches) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"The certificate subject's common name does not match any of the domains."});
                }
                hasWrongDomains = true;
            }
        }
        catch (InvalidNameException dn) {
            void e;
            FFDCFilter.processException((Throwable)dn, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"501", (Object)this, (Object[])new Object[]{certificateChain});
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2031E", (Object[])new Object[]{certificate.getSubjectX500Principal().getName(), certificate.getSerialNumber().toString(16), e.getMessage()}), (Throwable)e);
        }
        if (!hasWrongDomains) {
            try {
                Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
                HashSet<String> dnsNames = new HashSet<String>();
                if (altNames != null) {
                    for (List list : altNames) {
                        if (list.size() < 2) continue;
                        switch ((Integer)list.get(0)) {
                            case 2: {
                                Object data = list.get(1);
                                if (!(data instanceof String)) break;
                                dnsNames.add((String)data);
                                break;
                            }
                        }
                    }
                }
                if (!dnsNames.containsAll(acmeConfig.getDomains())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"The certificate subject alternative names do not contain all of the configured domains."});
                    }
                    hasWrongDomains = true;
                }
            }
            catch (CertificateParsingException altNames) {
                void e;
                FFDCFilter.processException((Throwable)altNames, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"546", (Object)this, (Object[])new Object[]{certificateChain});
                throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2032E", (Object[])new Object[]{certificate.getSerialNumber().toString(16), e.getMessage()}), (Throwable)e);
            }
        }
        return hasWrongDomains;
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasWrongSubjectRDNs(List<X509Certificate> certificateChain) throws AcmeCaException {
        List<Rdn> certRdns;
        String methodName = "hasWrongSubjectRDNs(List<X509Certificate>)";
        boolean hasWrongSubjectRDNs = false;
        X509Certificate certificate = AcmeProviderImpl.getLeafCertificate(certificateChain);
        if (certificate == null) {
            return false;
        }
        List<Rdn> configuredRdns = acmeConfig.getSubjectDN();
        try {
            certRdns = new LdapName(certificate.getSubjectX500Principal().getName()).getRdns();
        }
        catch (InvalidNameException invalidNameException) {
            void e;
            FFDCFilter.processException((Throwable)invalidNameException, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"583", (Object)this, (Object[])new Object[]{certificateChain});
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2031E", (Object[])new Object[]{certificate.getSubjectX500Principal().getName(), certificate.getSerialNumber().toString(16), e.getMessage()}), (Throwable)e);
        }
        boolean rdnsMatch = true;
        if (certRdns.size() == 1) {
            rdnsMatch = certRdns.get(0).equals(configuredRdns.get(0));
        } else if (certRdns.size() == configuredRdns.size()) {
            for (int idx = 0; idx < certRdns.size(); ++idx) {
                if (certRdns.get(idx).equals(configuredRdns.get(idx))) continue;
                rdnsMatch = false;
                break;
            }
        } else {
            rdnsMatch = false;
        }
        if (!rdnsMatch) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"The certificate subject's RDNs do not match the configuration."});
            }
            hasWrongSubjectRDNs = true;
        }
        return hasWrongSubjectRDNs;
    }

    protected boolean isExpired(List<X509Certificate> certificateChain) {
        X509Certificate certificate = AcmeProviderImpl.getLeafCertificate(certificateChain);
        if (certificate == null) {
            return false;
        }
        Date notAfter = certificate.getNotAfter();
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        long refreshTime = notAfter.getTime() - acmeConfig.getRenewBeforeExpirationMs();
        cal.setTimeInMillis(refreshTime);
        Date refreshDate = cal.getTime();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isExpired: notAfter: " + notAfter + ", calculated renew Date: " + refreshDate + ", compared to now: " + now), (Object[])new Object[0]);
        }
        return now.compareTo(refreshDate) >= 0;
    }

    protected boolean isRevoked(List<X509Certificate> certificateChain) throws AcmeCaException {
        CertificateRevocationChecker checker = new CertificateRevocationChecker(acmeConfig);
        return checker.isRevoked(certificateChain);
    }

    private AcmeCertificate fetchCertificate() throws AcmeCaException {
        return this.getAcmeClient().fetchCertificate(false);
    }

    @Trivial
    private static Certificate[] convertChainToArray(List<X509Certificate> chainList) {
        Certificate[] chainArray = new X509Certificate[chainList.size()];
        int idx = 0;
        for (Certificate certificate : chainList) {
            chainArray[idx++] = certificate;
        }
        return chainArray;
    }

    @Override
    public AcmeClient.AcmeAccount getAccount() throws AcmeCaException {
        return acmeClient.getAccount();
    }

    public static X509Certificate getLeafCertificate(List<X509Certificate> certificateChain) {
        if (certificateChain != null && !certificateChain.isEmpty()) {
            return certificateChain.get(0);
        }
        return null;
    }

    @FFDCIgnore(value={CertificateException.class})
    protected List<X509Certificate> getConfiguredDefaultCertificateChain() throws AcmeCaException {
        try {
            Certificate[] certChain = keyStoreServiceRef.get().getCertificateChainFromKeyStore("defaultKeyStore", "default");
            return this.convertToX509CertChain(certChain);
        }
        catch (KeyStoreException | CertificateException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public File createDefaultSSLCertificate(String filePath, @Sensitive String password, String keyStoreType, String keyStoreProvider) throws CertificateException {
        try {
            applicationStateListenerRef.get().waitUntilResourcesAvailable(acmeConfig);
        }
        catch (AcmeCaException acmeCaException) {
            void e;
            Object[] objectArray = new Object[4];
            objectArray[0] = filePath;
            objectArray[1] = "<sensitive java.lang.String>";
            objectArray[2] = keyStoreType;
            objectArray[3] = keyStoreProvider;
            FFDCFilter.processException((Throwable)acmeCaException, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"775", (Object)this, (Object[])objectArray);
            throw new CertificateException(e.getMessage(), (Throwable)e);
        }
        try {
            AcmeCertificate acmeCertificate = this.fetchCertificate();
            File file = this.createKeyStore(filePath, acmeCertificate, password, keyStoreType, keyStoreProvider);
            if (!acmeConfig.isDisableMinRenewWindow()) {
                this.lastCertificateRenewalTimestamp = System.currentTimeMillis();
            }
            this.acmeHistory.updateAcmeFile(acmeCertificate, null, acmeConfig.getDirectoryURI(), acmeClient.getAccount().getLocation().toString(), this.wslocation);
            Tr.audit((TraceComponent)tc, (String)"CWPKI2007I", (Object[])new Object[]{acmeCertificate.getCertificate().getSerialNumber().toString(16), acmeConfig.getDirectoryURI(), acmeCertificate.getCertificate().getNotAfter().toInstant().toString()});
            this.acmeCertChecker.startCertificateChecker(this.getScheduledExecutorService());
            return file;
        }
        catch (AcmeCaException acmeCertificate) {
            void ace;
            Object[] objectArray = new Object[4];
            objectArray[0] = filePath;
            objectArray[1] = "<sensitive java.lang.String>";
            objectArray[2] = keyStoreType;
            objectArray[3] = keyStoreProvider;
            FFDCFilter.processException((Throwable)acmeCertificate, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"819", (Object)this, (Object[])objectArray);
            this.createKeyStore(filePath, null, password, keyStoreType, keyStoreProvider);
            throw new CertificateException(ace.getMessage(), (Throwable)ace);
        }
        catch (Exception ace) {
            void e;
            Object[] objectArray = new Object[4];
            objectArray[0] = filePath;
            objectArray[1] = "<sensitive java.lang.String>";
            objectArray[2] = keyStoreType;
            objectArray[3] = keyStoreProvider;
            FFDCFilter.processException((Throwable)ace, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"823", (Object)this, (Object[])objectArray);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private File createKeyStore(String filePath, AcmeCertificate acmeCertificate, @Sensitive String password, String type, String provider) throws CertificateException {
        KeyStore keyStore;
        try {
            keyStore = JSSEProviderFactory.getInstance().getKeyStoreInstance(type, provider);
            keyStore.load(null, password.toCharArray());
            if (acmeCertificate != null) {
                keyStore.setKeyEntry("default", acmeCertificate.getKeyPair().getPrivate(), password.toCharArray(), AcmeProviderImpl.convertChainToArray(acmeCertificate.getCertificateChain()));
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException exception) {
            void ee;
            Object[] objectArray = new Object[5];
            objectArray[0] = filePath;
            objectArray[1] = acmeCertificate;
            objectArray[2] = "<sensitive java.lang.String>";
            objectArray[3] = type;
            objectArray[4] = provider;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"863", (Object)this, (Object[])objectArray);
            throw new CertificateException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2034E", (Object[])new Object[]{ee.getMessage()}), (Throwable)ee);
        }
        File file = new File(filePath);
        try {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                keyStore.store(fos, password.toCharArray());
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException fos) {
            void e;
            Object[] objectArray = new Object[5];
            objectArray[0] = filePath;
            objectArray[1] = acmeCertificate;
            objectArray[2] = "<sensitive java.lang.String>";
            objectArray[3] = type;
            objectArray[4] = provider;
            FFDCFilter.processException((Throwable)fos, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"882", (Object)this, (Object[])objectArray);
            throw new CertificateException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2035E", (Object[])new Object[]{file.getName(), e.getMessage()}), (Throwable)e);
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateDefaultSSLCertificate(KeyStore keyStore, File keyStoreFile, @Sensitive String password) throws CertificateException {
        block7: {
            try {
                boolean dirURIChanged = this.acmeHistory.directoryURIChanged(acmeConfig.getDirectoryURI(), this.wslocation, acmeConfig.isDisableRenewOnNewHistory());
                this.checkAndInstallCertificate(dirURIChanged, keyStore, keyStoreFile, password);
                if (!dirURIChanged) break block7;
                List<X509Certificate> existingCertChain = null;
                if (keyStore == null) {
                    existingCertChain = this.getConfiguredDefaultCertificateChain();
                } else {
                    try {
                        existingCertChain = this.convertToX509CertChain(keyStore.getCertificateChain("default"));
                    }
                    catch (KeyStoreException keyStoreException) {
                        void e;
                        Object[] objectArray = new Object[3];
                        objectArray[0] = keyStore;
                        objectArray[1] = keyStoreFile;
                        objectArray[2] = "<sensitive java.lang.String>";
                        FFDCFilter.processException((Throwable)keyStoreException, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"909", (Object)this, (Object[])objectArray);
                        throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2029E", (Object[])new Object[]{keyStoreFile, "default", e.getMessage()}), (Throwable)e);
                    }
                }
                this.acmeHistory.updateAcmeFile(AcmeProviderImpl.getLeafCertificate(existingCertChain), acmeConfig.getDirectoryURI(), acmeClient.getAccount().getLocation().toString(), this.wslocation);
            }
            catch (AcmeCaException dirURIChanged) {
                void e;
                Object[] objectArray = new Object[3];
                objectArray[0] = keyStore;
                objectArray[1] = keyStoreFile;
                objectArray[2] = "<sensitive java.lang.String>";
                FFDCFilter.processException((Throwable)dirURIChanged, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"917", (Object)this, (Object[])objectArray);
                throw new CertificateException(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                Object[] objectArray = new Object[3];
                objectArray[0] = keyStore;
                objectArray[1] = keyStoreFile;
                objectArray[2] = "<sensitive java.lang.String>";
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"919", (Object)this, (Object[])objectArray);
                throw e;
            }
        }
    }

    public static SSLConfig getSSLConfig() {
        return acmeConfig.getSSLConfig();
    }

    /*
     * WARNING - void declaration
     */
    @Reference(cardinality=ReferenceCardinality.MANDATORY, updated="updateAcmeConfigService")
    public void setAcmeConfigService(AcmeConfigService acmeConfigService, Map<String, Object> properties) {
        try {
            acmeConfig = new AcmeConfig(properties);
            acmeClient = new AcmeClient(acmeConfig);
            acmeClient.updateAccount();
            this.acmeCertChecker = new AcmeCertCheckerTask(this);
        }
        catch (AcmeCaException acmeCaException) {
            void e;
            FFDCFilter.processException((Throwable)acmeCaException, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"963", (Object)this, (Object[])new Object[]{acmeConfigService, properties});
            Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    protected void unsetAcmeConfigService(AcmeConfigService acmeConfigService) {
        if (this.acmeCertChecker != null) {
            this.acmeCertChecker.stop();
        }
        acmeConfig = null;
        acmeClient = null;
    }

    /*
     * WARNING - void declaration
     */
    protected void updateAcmeConfigService(AcmeConfigService acmeConfigService, Map<String, Object> properties) {
        try {
            if (this.acmeCertChecker == null) {
                this.acmeCertChecker = new AcmeCertCheckerTask(this);
            }
            acmeConfig = new AcmeConfig(properties);
            acmeClient = new AcmeClient(acmeConfig);
            boolean dirURIChanged = this.acmeHistory.directoryURIChanged(acmeConfig.getDirectoryURI(), this.wslocation, acmeConfig.isDisableRenewOnNewHistory());
            this.checkAndInstallCertificate(dirURIChanged, null, null, null);
            if (dirURIChanged) {
                this.acmeHistory.updateAcmeFile(AcmeProviderImpl.getLeafCertificate(this.getConfiguredDefaultCertificateChain()), acmeConfig.getDirectoryURI(), acmeClient.getAccount().getLocation().toString(), this.wslocation);
            }
            acmeClient.updateAccount();
        }
        catch (AcmeCaException dirURIChanged) {
            void e;
            FFDCFilter.processException((Throwable)dirURIChanged, (String)"com.ibm.ws.security.acme.internal.AcmeProviderImpl", (String)"1018", (Object)this, (Object[])new Object[]{acmeConfigService, properties});
            Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setAcmeApplicationStateListener(AcmeApplicationStateListener acmeApplicationStateListener) {
        applicationStateListenerRef.set(acmeApplicationStateListener);
    }

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class, target="(deferrable=false)")
    protected void setScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecutorServiceRef.setReference(ref);
    }

    protected void unsetScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        if (this.acmeCertChecker != null) {
            this.acmeCertChecker.stop();
        }
        this.scheduledExecutorServiceRef.unsetReference(ref);
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return (ScheduledExecutorService)this.scheduledExecutorServiceRef.getService();
    }

    @Trivial
    void acquireWriteLock() {
        this.rwRenewCertLock.writeLock().lock();
    }

    @Trivial
    void releaseWriteLock() {
        this.rwRenewCertLock.writeLock().unlock();
    }

    @Override
    public void checkCertificateRenewAllowed() throws CertificateRenewRequestBlockedException {
        long timeDiff = System.currentTimeMillis() - this.lastCertificateRenewalTimestamp;
        if (acmeConfig.isDisableMinRenewWindow() || this.lastCertificateRenewalTimestamp == -1L || timeDiff >= acmeConfig.getRenewCertMin()) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Too soon to renew, last certificate renewal was " + this.lastCertificateRenewalTimestamp), (Object[])new Object[0]);
        }
        CertificateRenewRequestBlockedException cr = new CertificateRenewRequestBlockedException("Too soon to renew, last certificate renewal was " + this.lastCertificateRenewalTimestamp, acmeConfig.getRenewCertMin() - timeDiff);
        throw cr;
    }
}

