/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.acme.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.acme.AcmeCaException;
import com.ibm.ws.security.acme.internal.AcmeConfig;
import com.ibm.ws.security.acme.internal.AcmeProviderImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class CertificateRevocationChecker {
    private static final TraceComponent tc = Tr.register(CertificateRevocationChecker.class, (String)"ACME", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
    private final AcmeConfig acmeConfig;
    static final long serialVersionUID = -3855423418008706060L;

    CertificateRevocationChecker(AcmeConfig acmeConfig) {
        this.acmeConfig = acmeConfig;
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> getCrlDistributionPoints(X509Certificate certificate) {
        byte[] octetBytes = certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (octetBytes == null) {
            return null;
        }
        try {
            ASN1InputStream oAsnInStream = new ASN1InputStream(new ByteArrayInputStream(octetBytes));
            ASN1Primitive derObjCrlDP = oAsnInStream.readObject();
            DEROctetString dosCrlDP = (DEROctetString)derObjCrlDP;
            oAsnInStream.close();
            byte[] crldpExtOctets = dosCrlDP.getOctets();
            ASN1InputStream oAsnInStream2 = new ASN1InputStream(new ByteArrayInputStream(crldpExtOctets));
            ASN1Primitive derObj2 = oAsnInStream2.readObject();
            CRLDistPoint distPoint = CRLDistPoint.getInstance(derObj2);
            oAsnInStream2.close();
            ArrayList<String> crlUrls = null;
            for (DistributionPoint dp : distPoint.getDistributionPoints()) {
                DistributionPointName dpn = dp.getDistributionPoint();
                if (dpn == null || dpn.getType() != 0) continue;
                GeneralName[] genNames = GeneralNames.getInstance(dpn.getName()).getNames();
                for (int j = 0; j < genNames.length; ++j) {
                    if (genNames[j].getTagNo() != 6) continue;
                    String url = DERIA5String.getInstance(genNames[j].getName()).getString();
                    if (crlUrls == null) {
                        crlUrls = new ArrayList<String>();
                    }
                    crlUrls.add(url);
                }
            }
            return crlUrls;
        }
        catch (IOException oAsnInStream) {
            void e;
            FFDCFilter.processException((Throwable)oAsnInStream, (String)"com.ibm.ws.security.acme.internal.CertificateRevocationChecker", (String)"150", null, (Object[])new Object[]{certificate});
            Tr.error((TraceComponent)tc, (String)"CWPKI2061E", (Object[])new Object[]{certificate.getSerialNumber().toString(16), e.getMessage()});
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getOcspUrl(X509Certificate certificate) {
        byte[] octetBytes = certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (octetBytes == null) {
            return null;
        }
        DLSequence dlSequence = null;
        ASN1Encodable asn1Encodable = null;
        try {
            int i;
            ASN1Primitive fromExtensionValue = JcaX509ExtensionUtils.parseExtensionValue(octetBytes);
            if (!(fromExtensionValue instanceof DLSequence)) {
                return null;
            }
            dlSequence = (DLSequence)fromExtensionValue;
            for (i = 0; i < dlSequence.size() && !((asn1Encodable = dlSequence.getObjectAt(i)) instanceof DLSequence); ++i) {
            }
            if (!(asn1Encodable instanceof DLSequence)) {
                return null;
            }
            dlSequence = (DLSequence)asn1Encodable;
            for (i = 0; i < dlSequence.size() && !((asn1Encodable = dlSequence.getObjectAt(i)) instanceof DERTaggedObject); ++i) {
            }
            if (!(asn1Encodable instanceof DERTaggedObject)) {
                return null;
            }
            DERTaggedObject derTaggedObject = (DERTaggedObject)asn1Encodable;
            byte[] encoded = derTaggedObject.getEncoded();
            if (derTaggedObject.getTagNo() == 6) {
                byte len = encoded[1];
                return new String(encoded, 2, (int)len);
            }
            return null;
        }
        catch (IOException fromExtensionValue) {
            void e;
            FFDCFilter.processException((Throwable)fromExtensionValue, (String)"com.ibm.ws.security.acme.internal.CertificateRevocationChecker", (String)"229", null, (Object[])new Object[]{certificate});
            Tr.error((TraceComponent)tc, (String)"CWPKI2060E", (Object[])new Object[]{certificate.getSerialNumber().toString(16), e.getMessage()});
            return null;
        }
    }

    public static X509Certificate getSignerCertificate(List<X509Certificate> certificateChain) {
        int size;
        if (certificateChain != null && (size = certificateChain.size()) > 1) {
            return certificateChain.get(size - 1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={CertPathValidatorException.class})
    boolean isRevoked(List<X509Certificate> certificateChain) throws AcmeCaException {
        if (!this.acmeConfig.isRevocationCheckerEnabled().booleanValue()) {
            return false;
        }
        X509Certificate leafCertificate = AcmeProviderImpl.getLeafCertificate(certificateChain);
        X509Certificate signerCertificate = CertificateRevocationChecker.getSignerCertificate(certificateChain);
        if (signerCertificate == null) {
            return false;
        }
        if (CertificateRevocationChecker.getOcspUrl(leafCertificate) == null && CertificateRevocationChecker.getCrlDistributionPoints(leafCertificate) == null) {
            return false;
        }
        CertPath certPath = null;
        CertPathValidator cpv = null;
        PKIXParameters params = null;
        PKIXRevocationChecker rc = null;
        try {
            KeyStore cacerts = KeyStore.getInstance(KeyStore.getDefaultType());
            cacerts.load(null);
            cacerts.setCertificateEntry("signer", signerCertificate);
            CertPathBuilder cpb = CertPathBuilder.getInstance("PKIX");
            rc = (PKIXRevocationChecker)cpb.getRevocationChecker();
            HashSet<PKIXRevocationChecker.Option> options = new HashSet<PKIXRevocationChecker.Option>();
            options.add(PKIXRevocationChecker.Option.SOFT_FAIL);
            if (this.acmeConfig.isDisableFallback().booleanValue()) {
                options.add(PKIXRevocationChecker.Option.NO_FALLBACK);
            }
            if (this.acmeConfig.isPreferCrls().booleanValue()) {
                options.add(PKIXRevocationChecker.Option.PREFER_CRLS);
            }
            rc.setOptions(options);
            URI oscpResponderUrl = this.acmeConfig.getOcspResponderUrl();
            if (oscpResponderUrl != null) {
                rc.setOcspResponder(oscpResponderUrl);
            }
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            certs.add(leafCertificate);
            certPath = CertificateFactory.getInstance("X.509").generateCertPath(certs);
            params = new PKIXParameters(cacerts);
            params.addCertPathChecker(rc);
            cpv = CertPathValidator.getInstance("PKIX");
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | CertificateException cacerts) {
            void e;
            FFDCFilter.processException((Throwable)cacerts, (String)"com.ibm.ws.security.acme.internal.CertificateRevocationChecker", (String)"363", (Object)this, (Object[])new Object[]{certificateChain});
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2057E", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
        try {
            cpv.validate(certPath, params);
            if (!rc.getSoftFailExceptions().isEmpty()) {
                Tr.warning((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2058W", (Object[])new Object[]{rc.getSoftFailExceptions()}), (Object[])new Object[0]);
            }
            return false;
        }
        catch (CertPathValidatorException e) {
            Tr.info((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2059I", (Object[])new Object[]{leafCertificate.getSerialNumber().toString(16)}), (Object[])new Object[0]);
            return true;
        }
        catch (InvalidAlgorithmParameterException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.acme.internal.CertificateRevocationChecker", (String)"385", (Object)this, (Object[])new Object[]{certificateChain});
            throw new AcmeCaException("Invalid algorithm parameter passed into CertPathValidator.validate(...) method.", e);
        }
    }
}

