/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.acme.internal.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.acme.AcmeCaException;
import com.ibm.ws.security.acme.AcmeProvider;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@WebServlet(value={"*"})
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class AcmeAuthorizationServlet
extends HttpServlet {
    private static final long serialVersionUID = -8515248242091988849L;
    public static final String APP_NAME = "com.ibm.ws.security.acme";
    private static final TraceComponent tc = Tr.register(AcmeAuthorizationServlet.class, (String)"ACME", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
    private static final AtomicReference<AcmeProvider> acmeProviderRef = new AtomicReference();
    private static final String NOT_FOUND = "NOT FOUND";

    /*
     * WARNING - void declaration
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String token;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Processing challenge token request '" + request.getRequestURI() + "' from '" + request.getRemoteAddr() + "'"), (Object[])new Object[0]);
        }
        if ((token = request.getRequestURI().replace("/.well-known/acme-challenge/", "")) == null || token.trim().isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No challenge token found in URI.", (Object[])new Object[0]);
            }
            response.sendError(404, NOT_FOUND);
            return;
        }
        AcmeProvider acmeProvider = acmeProviderRef.get();
        if (acmeProvider == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The servlet has no AcmeProvider.", (Object[])new Object[0]);
            }
            response.sendError(404, NOT_FOUND);
            return;
        }
        try {
            String authorization = acmeProvider.getHttp01Authorization(token);
            if (authorization == null || authorization.trim().isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The AcmeProvider did not find an authorization for the challange token '" + token + "'."), (Object[])new Object[0]);
                }
                response.sendError(404, NOT_FOUND);
                return;
            }
            response.resetBuffer();
            response.getWriter().write(authorization);
            response.getWriter().close();
            response.getWriter().flush();
        }
        catch (AcmeCaException authorization) {
            FFDCFilter.processException((Throwable)authorization, (String)"com.ibm.ws.security.acme.internal.web.AcmeAuthorizationServlet", (String)"111", (Object)((Object)this), (Object[])new Object[]{request, response});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Error encountered from AcmeProvider: ", (Object[])new Object[]{e});
            }
            response.sendError(404, NOT_FOUND);
            return;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC)
    protected void setAcmeProvider(AcmeProvider acmeProvider) {
        acmeProviderRef.set(acmeProvider);
    }

    protected void unsetAcmeProvider(AcmeProvider acmeProvider) {
        acmeProviderRef.compareAndSet(acmeProvider, null);
    }
}

