/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.acme.internal.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.acme.AcmeCaException;
import com.ibm.ws.security.acme.AcmeProvider;
import com.ibm.ws.security.acme.internal.AcmeClient;
import com.ibm.ws.security.acme.internal.exceptions.CertificateRenewRequestBlockedException;
import com.ibm.ws.security.acme.internal.exceptions.IllegalRevocationReasonException;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jose4j.json.JsonUtil;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.jose4j.lang.JoseException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.root=/acmeca", "com.ibm.wsspi.rest.handler.custom.security=true"})
public class AcmeCaRestHandler
implements RESTHandler {
    private static final TraceComponent tc = Tr.register(AcmeCaRestHandler.class, (String)"ACME", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
    private final AtomicReference<AcmeProvider> acmeProviderRef = new AtomicReference();
    private final AtomicReference<KeyStoreService> keyStoreServiceRef = new AtomicReference();
    public static final String PATH_ROOT = "/acmeca";
    public static final String PATH_ACCOUNT = "/acmeca/account";
    public static final String PATH_CERTIFICATE = "/acmeca/certificate";
    private static final String HTTP_GET = "GET";
    private static final String HTTP_POST = "POST";
    public static final String OP_KEY = "operation";
    public static final String REASON_KEY = "reason";
    public static final String OP_RENEW_CERT = "renewCertificate";
    public static final String OP_REVOKE_CERT = "revokeCertificate";
    public static final String OP_RENEW_ACCT_KEY_PAIR = "renewAccountKeyPair";
    static final long serialVersionUID = -5234712359171257951L;

    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        String path = request.getPath();
        if (PATH_ROOT.equals(path)) {
            this.handleRoot(request, response);
        } else if (PATH_ACCOUNT.equals(path)) {
            this.handleAccount(request, response);
        } else if (PATH_CERTIFICATE.equals(path)) {
            this.handleCertificate(request, response);
        } else {
            response.sendError(404, "Not Found");
            return;
        }
    }

    private void handleRoot(RESTRequest request, RESTResponse response) throws IOException {
        String method = request.getMethod();
        if (!HTTP_GET.equalsIgnoreCase(method)) {
            AcmeCaRestHandler.commitJsonResponse(response, 405, Tr.formatMessage((TraceComponent)tc, (String)"REST_METHOD_NOT_SUPPORTED", (Object[])new Object[]{method}));
            return;
        }
        if (!AcmeCaRestHandler.hasReadRole(request, response)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        this.appendAccountText(sb);
        this.appendCertificateText(sb);
        sb.append("</body></html>");
        response.setStatus(200);
        response.setContentType("text/html");
        response.setContentLength(sb.length());
        response.getOutputStream().write(sb.toString().getBytes());
    }

    /*
     * WARNING - void declaration
     */
    private void handleAccount(RESTRequest request, RESTResponse response) throws IOException {
        String method = request.getMethod();
        if (HTTP_GET.equalsIgnoreCase(method)) {
            if (!AcmeCaRestHandler.hasReadRole(request, response)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body>");
            this.appendAccountText(sb);
            sb.append("</body></html>");
            response.setStatus(200);
            response.setContentType("text/html");
            response.setContentLength(sb.length());
            response.getOutputStream().write(sb.toString().getBytes());
            return;
        }
        if (HTTP_POST.equalsIgnoreCase(method)) {
            if (!AcmeCaRestHandler.hasAdminRole(request, response)) {
                return;
            }
            String contentType = request.getContentType();
            if (contentType == null || !contentType.contains("application/json")) {
                AcmeCaRestHandler.commitJsonResponse(response, 415, Tr.formatMessage((TraceComponent)tc, (String)"REST_INVALID_CONTENT_TYPE", (Object[])new Object[0]));
                return;
            }
            Map<String, Object> jsonMap = AcmeCaRestHandler.getContentAsJsonMap(request);
            String operation = AcmeCaRestHandler.getOperation(jsonMap);
            if (operation == null) {
                AcmeCaRestHandler.commitJsonResponse(response, 400, Tr.formatMessage((TraceComponent)tc, (String)"REST_MISSING_OPERATION", (Object[])new Object[0]));
                return;
            }
            if (OP_RENEW_ACCT_KEY_PAIR.equals(operation)) {
                AcmeProvider acmeProvider = this.getAcmeProvider(response);
                if (acmeProvider == null) {
                    return;
                }
                try {
                    acmeProvider.renewAccountKeyPair();
                    AcmeCaRestHandler.commitJsonResponse(response, 200, null);
                    return;
                }
                catch (AcmeCaException acmeCaException) {
                    void e;
                    FFDCFilter.processException((Throwable)acmeCaException, (String)"com.ibm.ws.security.acme.internal.web.AcmeCaRestHandler", (String)"234", (Object)this, (Object[])new Object[]{request, response});
                    AcmeCaRestHandler.commitJsonResponse(response, 500, e.getMessage());
                    return;
                }
            }
            AcmeCaRestHandler.commitJsonResponse(response, 400, Tr.formatMessage((TraceComponent)tc, (String)"REST_OPERATION_NOT_SUPPORTED", (Object[])new Object[]{operation}));
            return;
        }
        AcmeCaRestHandler.commitJsonResponse(response, 405, Tr.formatMessage((TraceComponent)tc, (String)"REST_METHOD_NOT_SUPPORTED", (Object[])new Object[]{method}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={AcmeCaException.class, IllegalRevocationReasonException.class, CertificateRenewRequestBlockedException.class})
    private void handleCertificate(RESTRequest request, RESTResponse response) throws IOException {
        String method = request.getMethod();
        if (HTTP_GET.equalsIgnoreCase(method)) {
            if (!AcmeCaRestHandler.hasReadRole(request, response)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body>");
            this.appendCertificateText(sb);
            sb.append("</body></html>");
            response.setStatus(200);
            response.setContentType("text/html");
            response.setContentLength(sb.length());
            response.getOutputStream().write(sb.toString().getBytes());
            return;
        }
        if (!HTTP_POST.equalsIgnoreCase(method)) {
            AcmeCaRestHandler.commitJsonResponse(response, 405, Tr.formatMessage((TraceComponent)tc, (String)"REST_METHOD_NOT_SUPPORTED", (Object[])new Object[]{method}));
            return;
        }
        if (!AcmeCaRestHandler.hasAdminRole(request, response)) {
            return;
        }
        String contentType = request.getContentType();
        if (contentType == null || !contentType.contains("application/json")) {
            AcmeCaRestHandler.commitJsonResponse(response, 415, Tr.formatMessage((TraceComponent)tc, (String)"REST_INVALID_CONTENT_TYPE", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> jsonMap = AcmeCaRestHandler.getContentAsJsonMap(request);
        String operation = AcmeCaRestHandler.getOperation(jsonMap);
        if (operation == null) {
            AcmeCaRestHandler.commitJsonResponse(response, 400, Tr.formatMessage((TraceComponent)tc, (String)"REST_MISSING_OPERATION", (Object[])new Object[0]));
            return;
        }
        if (OP_RENEW_CERT.equalsIgnoreCase(operation)) {
            AcmeProvider acmeProvider = this.getAcmeProvider(response);
            if (acmeProvider == null) {
                return;
            }
            try {
                acmeProvider.checkCertificateRenewAllowed();
                acmeProvider.renewCertificate();
                AcmeCaRestHandler.commitJsonResponse(response, 200, null);
                return;
            }
            catch (CertificateRenewRequestBlockedException cr) {
                AcmeCaRestHandler.commitJsonResponse(response, 429, Tr.formatMessage((TraceComponent)tc, (String)"REST_TOO_MANY_REQUESTS", (Object[])new Object[]{cr.getTimeLeftForBlackout() + "ms"}));
                return;
            }
            catch (AcmeCaException e) {
                AcmeCaRestHandler.commitJsonResponse(response, 500, e.getMessage());
                return;
            }
        }
        if (!OP_REVOKE_CERT.equalsIgnoreCase(operation)) {
            AcmeCaRestHandler.commitJsonResponse(response, 400, Tr.formatMessage((TraceComponent)tc, (String)"REST_OPERATION_NOT_SUPPORTED", (Object[])new Object[]{operation}));
            return;
        }
        AcmeProvider acmeProvider = this.getAcmeProvider(response);
        if (acmeProvider == null) {
            return;
        }
        String reason = AcmeCaRestHandler.getRevocationReason(jsonMap);
        try {
            acmeProvider.revokeCertificate(reason);
            AcmeCaRestHandler.commitJsonResponse(response, 200, null);
            return;
        }
        catch (IllegalRevocationReasonException e) {
            AcmeCaRestHandler.commitJsonResponse(response, 400, e.getMessage());
            return;
        }
        catch (AcmeCaException e) {
            AcmeCaRestHandler.commitJsonResponse(response, 500, e.getMessage());
            return;
        }
    }

    @FFDCIgnore(value={AcmeCaException.class})
    private void appendAccountText(StringBuilder sb) {
        sb.append("<br/><hr>");
        sb.append("<h1>ACME CA Account Details</h1>");
        sb.append("<hr>");
        try {
            AcmeClient.AcmeAccount account = this.acmeProviderRef.get().getAccount();
            sb.append("<pre>");
            sb.append("Location:                  ").append(account.getLocation()).append("\n");
            sb.append("Status:                    ").append(account.getStatus()).append("\n");
            sb.append("Contacts:                  ").append("\n");
            if (account.getContacts() != null && !account.getContacts().isEmpty()) {
                for (URI contact : account.getContacts()) {
                    sb.append("    ").append(contact).append("\n");
                }
            } else {
                sb.append("    ").append("NONE");
            }
            sb.append("\n");
            sb.append("Orders:                    ").append("\n");
            if (account.getOrders() != null && !account.getOrders().isEmpty()) {
                for (String order : account.getOrders()) {
                    sb.append("    ").append(order).append("\n");
                }
            } else {
                sb.append("    ").append("NONE");
            }
            sb.append("\n");
            sb.append("</pre>");
        }
        catch (AcmeCaException e) {
            sb.append("<pre>Unable to load certificate chain: ").append(e.getMessage()).append("</pre>");
        }
    }

    @FFDCIgnore(value={KeyStoreException.class})
    private void appendCertificateText(StringBuilder sb) {
        sb.append("<br/><hr>");
        sb.append("<h1>Active Certificate Chain</h1>");
        sb.append("<hr>");
        try {
            Certificate[] chain = this.keyStoreServiceRef.get().getCertificateChainFromKeyStore("defaultKeyStore", "default");
            sb.append("<pre>");
            sb.append(Arrays.asList(chain));
            sb.append("</pre>");
        }
        catch (KeyStoreException | CertificateException e) {
            sb.append("<br/><h1>Unable to load certificate chain: ").append(e.getMessage()).append("</h1>");
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={JoseException.class})
    private static Map<String, Object> getContentAsJsonMap(RESTRequest request) throws IOException {
        try {
            int length;
            InputStream inputStream = request.getInputStream();
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String jsonString = result.toString(StandardCharsets.UTF_8.name());
            return JsonUtil.parseJson(jsonString);
        }
        catch (UnsupportedEncodingException inputStream) {
            void e;
            FFDCFilter.processException((Throwable)inputStream, (String)"com.ibm.ws.security.acme.internal.web.AcmeCaRestHandler", (String)"481", null, (Object[])new Object[]{request});
            throw new IOException("Unsupported content payload encoding: " + e.getMessage(), (Throwable)e);
        }
        catch (JoseException e) {
            return Collections.emptyMap();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.acme.internal.web.AcmeCaRestHandler", (String)"488", null, (Object[])new Object[]{request});
            throw new IOException("Error loading request payload: " + e.getMessage(), e);
        }
    }

    @FFDCIgnore(value={ClassCastException.class})
    private static String getOperation(Map<String, Object> jsonMap) {
        try {
            return (String)jsonMap.get(OP_KEY);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @FFDCIgnore(value={ClassCastException.class})
    private static String getRevocationReason(Map<String, Object> jsonMap) {
        try {
            return (String)jsonMap.get(REASON_KEY);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private static void commitJsonResponse(RESTResponse response, int statusCode, String errorMessage) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("{\"httpCode\":").append(String.valueOf(statusCode));
        if (errorMessage != null) {
            sb.append(", \"message\":\"").append(JSONObject.escape(errorMessage)).append("\"");
        }
        sb.append("}");
        response.setStatus(statusCode);
        response.setContentType("application/json");
        response.setContentLength(sb.length());
        response.getOutputStream().write(sb.toString().getBytes());
    }

    private AcmeProvider getAcmeProvider(RESTResponse response) throws IOException {
        AcmeProvider acmeProvider = this.acmeProviderRef.get();
        if (acmeProvider == null) {
            AcmeCaRestHandler.commitJsonResponse(response, 500, Tr.formatMessage((TraceComponent)tc, (String)"REST_NO_ACME_SERVICE", (Object[])new Object[0]));
            return null;
        }
        return acmeProvider;
    }

    private static boolean hasAdminRole(RESTRequest request, RESTResponse response) throws IOException {
        boolean hasAdminRole = request.isUserInRole("Administrator");
        if (!hasAdminRole) {
            AcmeCaRestHandler.commitJsonResponse(response, 403, Tr.formatMessage((TraceComponent)tc, (String)"REST_FORBIDDEN", (Object[])new Object[0]));
        }
        return hasAdminRole;
    }

    private static boolean hasReadRole(RESTRequest request, RESTResponse response) throws IOException {
        boolean hasReadRole;
        boolean bl = hasReadRole = request.isUserInRole("Administrator") || request.isUserInRole("Reader");
        if (!hasReadRole) {
            AcmeCaRestHandler.commitJsonResponse(response, 403, Tr.formatMessage((TraceComponent)tc, (String)"REST_FORBIDDEN", (Object[])new Object[0]));
        }
        return hasReadRole;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC)
    protected void setAcmeProvider(AcmeProvider acmeProvider) {
        this.acmeProviderRef.set(acmeProvider);
    }

    protected void unsetAcmeProvider(AcmeProvider acmeProvider) {
        this.acmeProviderRef.compareAndSet(acmeProvider, null);
    }

    @Reference(name="keyStoreService", service=KeyStoreService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setKeyStoreService(KeyStoreService keyStoreService) {
        this.keyStoreServiceRef.set(keyStoreService);
    }

    protected void unsetKeyStoreService(KeyStoreService keyStoreService) {
        this.keyStoreServiceRef.compareAndSet(keyStoreService, null);
    }
}

