/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

@ParametersAreNonnullByDefault
public class KeyPairUtils {
    private KeyPairUtils() {
    }

    public static KeyPair createKeyPair(int keysize) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(keysize);
            return keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static KeyPair createECKeyPair(String name) {
        try {
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec(name);
            KeyPairGenerator g = KeyPairGenerator.getInstance("ECDSA", "BC");
            g.initialize(ecSpec, new SecureRandom());
            return g.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("Invalid curve name " + name, ex);
        }
        catch (NoSuchProviderException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static KeyPair readKeyPair(@WillClose Reader r) throws IOException {
        KeyPair keyPair;
        PEMParser parser = new PEMParser(r);
        try {
            PEMKeyPair keyPair2 = (PEMKeyPair)parser.readObject();
            keyPair = new JcaPEMKeyConverter().getKeyPair(keyPair2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (PEMException ex) {
                throw new IOException("Invalid PEM file", ex);
            }
        }
        parser.close();
        return keyPair;
    }

    public static void writeKeyPair(KeyPair keypair, @WillClose Writer w) throws IOException {
        try (JcaPEMWriter jw = new JcaPEMWriter(w);){
            jw.writeObject(keypair);
        }
    }
}

