/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigMergeException;
import com.ibm.ws.config.xml.internal.ConfigVariable;
import com.ibm.ws.config.xml.internal.ConfigurationList;
import com.ibm.ws.config.xml.internal.FactoryElement;
import com.ibm.ws.config.xml.internal.SimpleElement;
import com.ibm.ws.config.xml.internal.SingletonElement;
import com.ibm.ws.config.xml.internal.XMLConfigParser;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class BaseConfiguration {
    private static final TraceComponent tc = Tr.register(BaseConfiguration.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private String description;
    protected long lastModified = -1L;
    private final List<WsResource> includes = new ArrayList<WsResource>();
    protected final Map<String, List<ConfigVariable>> variables = new HashMap<String, List<ConfigVariable>>();
    protected final Map<String, ConfigurationList<SimpleElement>> configurationMap = new ConcurrentHashMap<String, ConfigurationList<SimpleElement>>();
    static final long serialVersionUID = -7115606292779428284L;

    protected ConfigurationList<SimpleElement> getConfigurationList(String name) {
        ConfigurationList<SimpleElement> list = this.configurationMap.get(name);
        if (list == null) {
            list = new ConfigurationList();
            this.configurationMap.put(name, list);
        }
        return list;
    }

    public void addConfigElement(SimpleElement configElement) {
        ConfigurationList<SimpleElement> list = this.getConfigurationList(configElement.getNodeName());
        list.add(configElement);
    }

    public void append(BaseConfiguration in) {
        this.add(in);
    }

    public void add(BaseConfiguration in) {
        if (in != null) {
            for (Map.Entry<String, ConfigurationList<SimpleElement>> entry : in.configurationMap.entrySet()) {
                ConfigurationList<SimpleElement> list = this.getConfigurationList(entry.getKey());
                list.add(entry.getValue());
            }
            for (Map.Entry<String, Object> entry : in.variables.entrySet()) {
                this.getVariableEntry(entry.getKey()).addAll((Collection)entry.getValue());
            }
        }
    }

    public void remove(BaseConfiguration in) {
        if (in != null) {
            for (Map.Entry<String, ConfigurationList<SimpleElement>> entry : in.configurationMap.entrySet()) {
                ConfigurationList<SimpleElement> list = this.getConfigurationList(entry.getKey());
                list.remove(entry.getValue());
            }
            for (Map.Entry<String, Object> entry : in.variables.entrySet()) {
                this.getVariableEntry(entry.getKey()).removeAll((Collection)entry.getValue());
            }
        }
    }

    public boolean remove(String name, String id) {
        ConfigurationList<SimpleElement> list = this.getConfigurationList(name);
        return list.remove(id);
    }

    public Set<String> getConfigurationNames() {
        HashSet<String> names = new HashSet<String>();
        this.getConfigurationNames(names);
        this.getDefaultConfigurationNames(names);
        return names;
    }

    void getDefaultConfigurationNames(Set<String> names) {
    }

    void getConfigurationNames(Set<String> names) {
        for (Map.Entry<String, ConfigurationList<SimpleElement>> entry : this.configurationMap.entrySet()) {
            ConfigurationList<SimpleElement> list = entry.getValue();
            if (list.isEmpty()) continue;
            names.add(entry.getKey());
        }
    }

    public boolean hasId(String pid) {
        ConfigurationList<SimpleElement> list = this.configurationMap.get(pid);
        if (list == null || !list.hasId()) {
            return this.defaultConfigurationHasId(pid);
        }
        return true;
    }

    boolean defaultConfigurationHasId(String pid) {
        return false;
    }

    void getSingletonNames(Set<String> singletons) {
        for (Map.Entry<String, ConfigurationList<SimpleElement>> entry : this.configurationMap.entrySet()) {
            ConfigurationList<SimpleElement> list = entry.getValue();
            if (list.isEmpty() || list.hasId()) continue;
            singletons.add(entry.getKey());
        }
    }

    void getFactoryNames(Set<String> singletons) {
        for (Map.Entry<String, ConfigurationList<SimpleElement>> entry : this.configurationMap.entrySet()) {
            ConfigurationList<SimpleElement> list = entry.getValue();
            if (list.isEmpty() || !list.hasId()) continue;
            singletons.add(entry.getKey());
        }
    }

    List<SimpleElement> getSingletonElements(String pid, String alias) {
        if (pid == null) {
            throw new IllegalArgumentException("pid cannot be null");
        }
        List<SimpleElement> elements = null;
        ConfigurationList<SimpleElement> list = null;
        list = this.configurationMap.get(pid);
        if (list != null) {
            elements = list.collectElements(elements);
        }
        if (alias != null && (list = this.configurationMap.get(alias)) != null) {
            elements = list.collectElements(elements);
        }
        return elements == null ? Collections.emptyList() : elements;
    }

    public SingletonElement getSingleton(String pid, String alias) throws ConfigMergeException {
        return this.getSingleton(pid, alias, true);
    }

    public SingletonElement getSingleton(String pid, String alias, boolean includeOverrides) throws ConfigMergeException {
        List<SimpleElement> elements = this.getSingletonElements(pid, alias);
        if (elements.isEmpty()) {
            return null;
        }
        if (!includeOverrides) {
            boolean found = false;
            for (SimpleElement element : elements) {
                if (element.mergeBehavior == XMLConfigParser.MergeBehavior.MERGE_WHEN_EXISTS) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        }
        return new SingletonElement(elements, pid);
    }

    List<SimpleElement> getFactoryElements(String pid, String alias, String id) {
        if (pid == null) {
            throw new IllegalArgumentException("pid cannot be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        List<SimpleElement> elements = null;
        ConfigurationList<SimpleElement> list = null;
        list = this.configurationMap.get(pid);
        if (list != null) {
            elements = list.collectElementsWithId(id, elements);
        }
        if (alias != null && (list = this.configurationMap.get(alias)) != null) {
            elements = list.collectElementsWithId(id, elements);
        }
        return elements == null ? Collections.emptyList() : elements;
    }

    public FactoryElement getFactoryInstance(String pid, String alias, String id) throws ConfigMergeException {
        return this.getFactoryInstance(pid, alias, id, true);
    }

    public FactoryElement getFactoryInstance(String pid, String alias, String id, boolean includeOverrides) throws ConfigMergeException {
        List<SimpleElement> elements = this.getFactoryElements(pid, alias, id);
        if (elements.isEmpty()) {
            return null;
        }
        if (!includeOverrides) {
            boolean found = false;
            for (SimpleElement element : elements) {
                if (element.mergeBehavior == XMLConfigParser.MergeBehavior.MERGE_WHEN_EXISTS) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        }
        return new FactoryElement(elements, pid, id);
    }

    Map<ConfigID, List<SimpleElement>> getAllFactoryElements(String pid, String alias, String defaultId) {
        if (pid == null) {
            throw new IllegalArgumentException("pid cannot be null");
        }
        Map<ConfigID, List<Object>> map = null;
        ConfigurationList<SimpleElement> list = null;
        list = this.configurationMap.get(pid);
        if (list != null) {
            map = list.collectElementsById(map, defaultId, pid);
        }
        if (alias != null && (list = this.configurationMap.get(alias)) != null) {
            map = list.collectElementsById(map, defaultId, pid);
        }
        return map == null ? Collections.emptyMap() : map;
    }

    public Map<ConfigID, FactoryElement> getFactoryInstances(String pid, String alias) throws ConfigMergeException {
        return this.getFactoryInstancesUsingDefaultId(pid, alias, null);
    }

    public Map<ConfigID, FactoryElement> getFactoryInstancesUsingDefaultId(String pid, String alias, String defaultId) throws ConfigMergeException {
        Object merged;
        ConfigID elementId;
        Map<ConfigID, List<SimpleElement>> defaultFactories = this.defaultConfigurationFactories(pid, alias, defaultId);
        Map<ConfigID, List<SimpleElement>> factories = this.getAllFactoryElements(pid, alias, defaultId);
        HashMap<ConfigID, FactoryElement> mergedMap = new HashMap<ConfigID, FactoryElement>();
        for (Map.Entry<ConfigID, List<SimpleElement>> entry : factories.entrySet()) {
            elementId = entry.getKey();
            List<SimpleElement> defaultElements = defaultFactories.remove(elementId);
            if (defaultElements == null) {
                FactoryElement merged2 = new FactoryElement(entry.getValue(), pid, elementId.getId());
                mergedMap.put(elementId, merged2);
                continue;
            }
            Iterator<SimpleElement> iter = defaultElements.iterator();
            while (iter.hasNext()) {
                SimpleElement element = iter.next();
                if (element.mergeBehavior != XMLConfigParser.MergeBehavior.MERGE_WHEN_MISSING) continue;
                iter.remove();
            }
            if (!defaultElements.isEmpty()) {
                merged = new FactoryElement(defaultElements, pid, elementId.getId());
                if (defaultElements.get(0).isUsingNonDefaultId() && !entry.getValue().get(0).isUsingNonDefaultId()) {
                    ((FactoryElement)merged).attributes.remove("id");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Removing default id from list of attributes", (Object[])new Object[0]);
                    }
                }
                ((ConfigElement)merged).merge(entry.getValue());
                mergedMap.put(elementId, (FactoryElement)merged);
                continue;
            }
            merged = new FactoryElement(entry.getValue(), pid, elementId.getId());
            mergedMap.put(elementId, (FactoryElement)merged);
        }
        for (Map.Entry<ConfigID, List<SimpleElement>> entry : defaultFactories.entrySet()) {
            elementId = entry.getKey();
            List<SimpleElement> elements = entry.getValue();
            boolean found = false;
            for (SimpleElement element : elements) {
                if (element.mergeBehavior == XMLConfigParser.MergeBehavior.MERGE_WHEN_EXISTS) continue;
                found = true;
            }
            if (!found) continue;
            merged = new FactoryElement(elements, pid, elementId.getId());
            mergedMap.put(elementId, (FactoryElement)merged);
        }
        return mergedMap;
    }

    Map<ConfigID, List<SimpleElement>> defaultConfigurationFactories(String pid, String alias, String defaultId) {
        return Collections.emptyMap();
    }

    public void addVariable(@Sensitive ConfigVariable variable) {
        this.getVariableEntry(variable.getName()).add(variable);
    }

    private List<ConfigVariable> getVariableEntry(String name) {
        List<ConfigVariable> variableList = this.variables.get(name);
        if (variableList == null) {
            variableList = new ArrayList<ConfigVariable>(1);
            this.variables.put(name, variableList);
        }
        return variableList;
    }

    @Sensitive
    public Map<String, ConfigVariable> getVariables() {
        HashMap<String, ConfigVariable> variableMap = new HashMap<String, ConfigVariable>();
        for (Map.Entry<String, List<ConfigVariable>> entry : this.variables.entrySet()) {
            String variableName = entry.getKey();
            List<ConfigVariable> variableList = entry.getValue();
            if (variableList.isEmpty()) continue;
            ConfigVariable toReturn = null;
            for (ConfigVariable var : variableList) {
                if (toReturn == null) {
                    if (var.getMergeBehavior() == XMLConfigParser.MergeBehavior.MERGE_WHEN_EXISTS) continue;
                    toReturn = var;
                    continue;
                }
                switch (var.getMergeBehavior()) {
                    case REPLACE: 
                    case MERGE: 
                    case MERGE_WHEN_EXISTS: {
                        toReturn = var;
                        break;
                    }
                }
            }
            if (toReturn == null) continue;
            variableMap.put(variableName, toReturn);
        }
        return variableMap;
    }

    void updateLastModified(long lastModified) {
        if (lastModified > this.lastModified) {
            this.lastModified = lastModified;
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public List<WsResource> getIncludes() {
        return this.includes;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("configurations: ").append(this.configurationMap);
        return builder.toString();
    }
}

