/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.xml.internal.XMLConfigParser;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ConfigVariable {
    private final String name;
    private final String value;
    private final String defaultValue;
    private final XMLConfigParser.MergeBehavior mergeBehavior;
    private final String location;
    private final boolean sensitive;
    final Pattern obscuredValuePattern = Pattern.compile("(\\{aes\\}|\\{xor\\}).*");
    final String OBSCURED_VALUE = "*****";
    final String ENCRYPTION_KEY = "wlp.password.encryption.key";
    static final long serialVersionUID = 4880923594979596831L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ConfigVariable(String name, @Sensitive String value, String variableDefault, XMLConfigParser.MergeBehavior mb, String l, boolean isSensitive) {
        this.name = name;
        this.value = value;
        this.defaultValue = variableDefault;
        this.mergeBehavior = mb;
        this.location = l;
        this.sensitive = isSensitive;
    }

    public String getName() {
        return this.name;
    }

    @Sensitive
    public String getValue() {
        return this.value;
    }

    @Sensitive
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public XMLConfigParser.MergeBehavior getMergeBehavior() {
        return this.mergeBehavior;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConfigVariable[");
        builder.append("name=").append(this.name).append(", ");
        builder.append("value=").append(this.getObscuredValue(this.name, this.value));
        builder.append("]");
        return builder.toString();
    }

    protected String getObscuredValue(String name, @Sensitive Object o) {
        if (this.isSensitive()) {
            return "*****";
        }
        if ("wlp.password.encryption.key".equals(name)) {
            return "*****";
        }
        String value = String.valueOf(o);
        if (this.obscuredValuePattern.matcher(value).matches()) {
            return "*****";
        }
        return value;
    }

    public String getDocumentLocation() {
        return this.location;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.ConfigVariable", ConfigVariable.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    }
}

