/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ErrorHandler;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinitionImpl;
import com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinition;
import com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinitionImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
final class MetaTypeRegistry {
    private static final TraceComponent tc = Tr.register(MetaTypeRegistry.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    public static final String MTP_REMOVED_TOPIC = "internal_mtp_removed";
    public static final String MTP_ADDED_TOPIC = "internal_mtp_added";
    public static final String UPDATED_PIDS = "internal_mtp_updated_pids";
    public static final String BUNDLE = "internal_mtp_bundle";
    public static final String MTP_INFO = "internal_mtp_info";
    private final Map<String, RegistryEntry> entryMap = new ConcurrentHashMap<String, RegistryEntry>();
    private final Map<String, RegistryEntry> aliasMap = new ConcurrentHashMap<String, RegistryEntry>();
    private final Map<String, Collection<RegistryEntry>> invalidEntryMap = new ConcurrentHashMap<String, Collection<RegistryEntry>>();
    private final Map<String, Map<String, RegistryEntry>> childAliasMap = new ConcurrentHashMap<String, Map<String, RegistryEntry>>();
    private final Map<String, Map<String, RegistryEntry>> childPidMap = new ConcurrentHashMap<String, Map<String, RegistryEntry>>();
    private final Map<String, List<RegistryEntry>> serviceToObjectClassMap = new ConcurrentHashMap<String, List<RegistryEntry>>();
    private final Map<String, List<RegistryEntry>> serviceToServicesMap = new ConcurrentHashMap<String, List<RegistryEntry>>();
    private final ConcurrentHashMap<Bundle, MetaTypeInformation> bundleMap = new ConcurrentHashMap();
    private ServiceTracker<MetaTypeService, MetaTypeService> metaTypeTracker = null;
    private ServiceTracker<MetaTypeProvider, MetaTypeProvider> mtpTracker = null;
    static final long serialVersionUID = -2893456135787297566L;

    MetaTypeRegistry() {
    }

    void start(BundleContext bc) {
        this.metaTypeTracker = new ServiceTracker(bc, MetaTypeService.class.getName(), null);
        this.metaTypeTracker.open();
    }

    void stop(BundleContext context) {
        if (null != this.metaTypeTracker) {
            this.metaTypeTracker.close();
            this.metaTypeTracker = null;
        }
        if (null != this.mtpTracker) {
            this.mtpTracker.close();
            this.mtpTracker = null;
        }
    }

    Set<RegistryEntry> addMetaType(Bundle bundle) {
        MetaTypeService metaTypeService = (MetaTypeService)this.metaTypeTracker.getService();
        if (metaTypeService != null) {
            MetaTypeInformation metaTypeInformation = metaTypeService.getMetaTypeInformation(bundle);
            if (metaTypeInformation != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Adding metatype for bundle {0}", (Object[])new Object[]{bundle});
                }
                return this.addMetaType(metaTypeInformation);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No metatype found for bundle {0}", (Object[])new Object[]{bundle});
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The metatype service was not available", (Object[])new Object[0]);
        }
        return Collections.emptySet();
    }

    RegistryEntry getRegistryEntry(String pid) {
        if (pid == null) {
            return null;
        }
        return this.entryMap.get(pid);
    }

    RegistryEntry getRegistryEntryByAlias(String pid) {
        return this.aliasMap.get(pid);
    }

    RegistryEntry getRegistryEntryByPidOrAlias(String id) {
        if (id == null) {
            return null;
        }
        RegistryEntry re = this.entryMap.get(id);
        if (re == null) {
            re = this.aliasMap.get(id);
        }
        return re;
    }

    Collection<String> getRegistryEntryPids() {
        return this.entryMap.keySet();
    }

    Collection<RegistryEntry> getAllRegistryEntries() {
        return this.entryMap.values();
    }

    MetaTypeInformation getMetaTypeInformation(Bundle bundle) {
        return this.bundleMap.get(bundle);
    }

    synchronized Set<RegistryEntry> addMetaType(MetaTypeInformation information) {
        MetaTypeInformation existingInfo;
        HashSet<RegistryEntry> updatedRegistryEntries = new HashSet<RegistryEntry>();
        boolean newEntries = this.addMetaTypeDefinition(information, information.getPids(), false, updatedRegistryEntries);
        if ((newEntries |= this.addMetaTypeDefinition(information, information.getFactoryPids(), true, updatedRegistryEntries)) && (existingInfo = this.bundleMap.putIfAbsent(information.getBundle(), information)) != null && existingInfo != information) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"addMetaType: bundleMap.putIfAbsent", (Object[])new Object[]{information, existingInfo});
            }
            throw new IllegalStateException("addMetaType");
        }
        return updatedRegistryEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMetaTypeDefinition(MetaTypeInformation info, String pid, boolean isFactory, Set<RegistryEntry> updatedRegistryEntries) {
        RegistryEntry pidEntry = this.entryMap.get(pid);
        if (pidEntry == null) {
            ExtendedObjectClassDefinitionImpl ocd = ExtendedObjectClassDefinitionImpl.newExtendedObjectClassDefinition(info.getObjectClassDefinition(pid, null), info.getBundle().getLocation());
            ocd.setPid(pid);
            boolean invalid = false;
            if (isFactory) {
                if (ocd.getExtends() == null && ocd.getExtendsAlias() != null) {
                    Tr.error((TraceComponent)tc, (String)"error.ExtendsAliasMustExtend", (Object[])new Object[]{pid, ocd.getExtendsAlias()});
                    invalid = true;
                }
            } else {
                if (ocd.getExtends() != null) {
                    Tr.error((TraceComponent)tc, (String)"error.factoryOnly", (Object[])new Object[]{pid, ocd.getExtends()});
                    invalid = true;
                }
                if (ocd.getExtendsAlias() != null) {
                    Tr.error((TraceComponent)tc, (String)"error.factoryOnly.extendsAlias", (Object[])new Object[]{pid, ocd.getExtendsAlias()});
                    invalid = true;
                }
            }
            if (ocd.getParentPID() != null && ocd.getChildAlias() == null) {
                Tr.error((TraceComponent)tc, (String)"error.parentpid.and.childalias", (Object[])new Object[]{pid, "ibm:parentPid", ocd.getParentPID(), "ibm:childAlias"});
            } else if (ocd.getParentPID() == null && ocd.getChildAlias() != null) {
                Tr.error((TraceComponent)tc, (String)"error.parentpid.and.childalias", (Object[])new Object[]{pid, "ibm:childAlias", ocd.getChildAlias(), "ibm:parentPid"});
            }
            if (invalid) {
                return true;
            }
            pidEntry = new RegistryEntry(pid, isFactory, info.getBundle(), ocd, this);
            Map<String, Collection<RegistryEntry>> map = this.invalidEntryMap;
            synchronized (map) {
                if (pidEntry.isValid()) {
                    updatedRegistryEntries.add(pidEntry);
                    this.addValidRegistryEntry(pidEntry, updatedRegistryEntries);
                } else {
                    String extendsPid = pidEntry.getExtends();
                    if (extendsPid == null) {
                        throw new IllegalStateException("invalid RegistryEntry that does not extend " + pid);
                    }
                    Collection<RegistryEntry> invalids = this.invalidEntryMap.get(extendsPid);
                    if (invalids == null) {
                        invalids = new ArrayList<RegistryEntry>();
                        this.invalidEntryMap.put(extendsPid, invalids);
                    }
                    invalids.add(pidEntry);
                }
            }
            return true;
        }
        if (info.getBundle().getBundleId() != pidEntry.getBundleId()) {
            this.warnCollision(pid, null, pidEntry, info.getBundle().getBundleId(), info.getObjectClassDefinition(pid, null).getID());
        }
        return false;
    }

    private void addValidRegistryEntry(RegistryEntry pidEntry, Set<RegistryEntry> updatedRegistryEntries) {
        List<String> objectClass;
        String childAlias;
        updatedRegistryEntries.add(pidEntry);
        this.entryMap.put(pidEntry.getPid(), pidEntry);
        Collection<RegistryEntry> invalids = this.invalidEntryMap.remove(pidEntry.getPid());
        if (invalids != null) {
            for (RegistryEntry invalid : invalids) {
                invalid.complete(pidEntry, this);
                if (!invalid.isValid()) continue;
                this.addValidRegistryEntry(invalid, updatedRegistryEntries);
            }
        }
        this.processReferencedTypes(pidEntry);
        String alias = pidEntry.getAlias();
        if (alias != null) {
            RegistryEntry aliasEntry = this.aliasMap.get(alias);
            if (aliasEntry == null) {
                this.aliasMap.put(alias, pidEntry);
            } else if (pidEntry != aliasEntry) {
                this.warnCollision(pidEntry.getPid(), alias, pidEntry, aliasEntry.getBundleId(), aliasEntry.getObjectClassDefinition().getID());
            }
        }
        if ((childAlias = pidEntry.getChildAlias()) != null) {
            String parentPid;
            Map<String, RegistryEntry> parentMap = this.childAliasMap.get(childAlias);
            if (parentMap == null) {
                parentMap = new HashMap<String, RegistryEntry>();
                this.childAliasMap.put(childAlias, parentMap);
            }
            if ((parentPid = pidEntry.getObjectClassDefinition().getParentPID()) == null) {
                Tr.error((TraceComponent)tc, (String)"error.specify.parentpid", (Object[])new Object[]{pidEntry.getPid()});
            } else {
                RegistryEntry parentEntry = parentMap.get(parentPid);
                if (parentEntry == null) {
                    parentMap.put(parentPid, pidEntry);
                    this.childPidMap.put(pidEntry.getPid(), parentMap);
                } else {
                    this.warnCollision(pidEntry.getPid(), childAlias, pidEntry, parentEntry.getBundleId(), parentEntry.getObjectClassDefinition().getID());
                }
            }
        }
        if ((objectClass = pidEntry.getObjectClassDefinition().getObjectClass()) != null) {
            for (String service : objectClass) {
                List<RegistryEntry> exposers = this.serviceToObjectClassMap.get(service);
                if (exposers == null) {
                    exposers = new CopyOnWriteArrayList<RegistryEntry>();
                    this.serviceToObjectClassMap.put(service, exposers);
                }
                exposers.add(pidEntry);
            }
        }
    }

    private boolean addMetaTypeDefinition(MetaTypeInformation information, String[] pids, boolean isFactory, Set<RegistryEntry> updatedRegistryEntries) {
        boolean newEntries = false;
        if (pids != null) {
            for (String pid : pids) {
                if (pid == null) continue;
                newEntries |= this.addMetaTypeDefinition(information, pid, isFactory, updatedRegistryEntries);
            }
        }
        return newEntries;
    }

    private void processReferencedTypes(RegistryEntry pidEntry) {
        RegistryEntry other;
        for (ExtendedAttributeDefinition ad : pidEntry.getAttributeMap().values()) {
            if (ad.getType() != 1001) continue;
            if (ad.getReferencePid() != null) {
                RegistryEntry other2 = this.getRegistryEntry(ad.getReferencePid());
                if (other2 == null) continue;
                PidReference ref = new PidReference(other2, pidEntry, ad.getID(), true);
                other2.addReferencingEntry(ref);
                pidEntry.addReferencedEntry(ref);
                continue;
            }
            if (ad.getService() == null) continue;
            this.addServiceUse(ad.getService(), pidEntry);
        }
        if (pidEntry.getObjectClassDefinition().getParentPID() != null && (other = this.getRegistryEntry(pidEntry.getObjectClassDefinition().getParentPID())) != null) {
            pidEntry.addReferencingEntry(new PidReference(pidEntry, other, pidEntry.getChildAlias(), false));
        }
        for (RegistryEntry other3 : this.entryMap.values()) {
            if (pidEntry.getPid().equals(other3.getObjectClassDefinition().getParentPID())) {
                other3.addReferencingEntry(new PidReference(other3, pidEntry, other3.getChildAlias(), false));
            }
            for (ExtendedAttributeDefinition ad : other3.getAttributeMap().values()) {
                if (ad.getType() != 1001 || !pidEntry.getPid().equals(ad.getReferencePid())) continue;
                pidEntry.addReferencingEntry(new PidReference(pidEntry, other3, ad.getID(), true));
            }
        }
    }

    private void addServiceUse(String service, RegistryEntry entry) {
        List<RegistryEntry> serviceUsers = this.serviceToServicesMap.get(service);
        if (serviceUsers == null) {
            serviceUsers = new CopyOnWriteArrayList<RegistryEntry>();
            this.serviceToServicesMap.put(service, serviceUsers);
        }
        serviceUsers.add(entry);
    }

    List<RegistryEntry> getEntriesExposingService(String service) {
        return this.serviceToObjectClassMap.get(service);
    }

    List<RegistryEntry> getEntriesUsingService(RegistryEntry entry) {
        List<String> objectClass = entry.getObjectClassDefinition().getObjectClass();
        if (objectClass != null) {
            ArrayList<RegistryEntry> references = new ArrayList<RegistryEntry>();
            for (String service : objectClass) {
                List<RegistryEntry> users = this.serviceToServicesMap.get(service);
                if (users == null) continue;
                references.addAll(users);
            }
            return references;
        }
        return Collections.emptyList();
    }

    public Collection<RegistryEntry> getReferencedEntries(ExtendedAttributeDefinition attrDef) {
        if (attrDef == null) {
            throw new NullPointerException("attrDef");
        }
        if (attrDef.getType() != 1001) {
            throw new IllegalArgumentException("Must be pid type, not " + attrDef.getType());
        }
        if (attrDef.getReferencePid() != null) {
            RegistryEntry entry = this.getRegistryEntry(attrDef.getReferencePid());
            if (entry == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(entry);
        }
        return this.serviceToObjectClassMap.get(attrDef.getService());
    }

    private void warnCollision(String pid, String alias, RegistryEntry entry1, long bundleId2, String ocdId2) {
        Object pidAlias = pid;
        if (alias != null) {
            pidAlias = Arrays.asList(pid, alias);
        }
        List<String> ids = Arrays.asList(entry1.getBundleId() + ":" + entry1.getObjectClassDefinition().getID(), bundleId2 + ":" + ocdId2);
        Tr.error((TraceComponent)tc, (String)"error.alias.collision", (Object[])new Object[]{pidAlias, ids});
    }

    MetaTypeInformation removeMetaType(Bundle bundle) {
        MetaTypeInformation information = this.bundleMap.remove(bundle);
        if (information != null) {
            Set<RegistryEntry> removed = this.removeMetaTypeDefinitions(information, information.getPids());
            removed.addAll(this.removeMetaTypeDefinitions(information, information.getFactoryPids()));
            for (RegistryEntry entry : removed) {
                for (PidReference ref : entry.getReferencedEntries()) {
                    RegistryEntry other = ref.getReferencedEntry();
                    if (other == null) continue;
                    other.removeReferencingEntry(ref);
                }
                entry.removeAllReferences();
            }
        }
        return information;
    }

    synchronized Set<RegistryEntry> removeMetaTypeDefinitions(MetaTypeInformation information, String[] pids) {
        HashSet<RegistryEntry> removedRegistryEntries = new HashSet<RegistryEntry>();
        if (pids != null) {
            for (String pid : pids) {
                RegistryEntry aliasEntry;
                RegistryEntry pidEntry = this.entryMap.remove(pid);
                if (pidEntry == null) {
                    block1: for (Map.Entry<String, Collection<RegistryEntry>> entry : this.invalidEntryMap.entrySet()) {
                        for (RegistryEntry test : entry.getValue()) {
                            if (!test.getPid().equals(pid)) continue;
                            pidEntry = test;
                            entry.getValue().remove(test);
                            if (!entry.getValue().isEmpty()) continue block1;
                            this.invalidEntryMap.remove(entry.getKey());
                            continue block1;
                        }
                    }
                }
                if (pidEntry == null) continue;
                removedRegistryEntries.add(pidEntry);
                if (pidEntry.getAlias() != null && (aliasEntry = this.aliasMap.get(pidEntry.getAlias())) == pidEntry) {
                    this.aliasMap.remove(pidEntry.getAlias());
                }
                if (pidEntry.getChildAlias() != null) {
                    Map<String, RegistryEntry> parentMap = this.childAliasMap.get(pidEntry.getChildAlias());
                    String parentPid = pidEntry.getObjectClassDefinition().getParentPID();
                    if (parentPid != null) {
                        parentMap.remove(parentPid);
                    }
                    this.childPidMap.remove(pidEntry.getPid());
                }
                if (pidEntry.getObjectClassDefinition().getObjectClass() != null) {
                    for (String service : pidEntry.getObjectClassDefinition().getObjectClass()) {
                        List<RegistryEntry> exposers = this.serviceToObjectClassMap.get(service);
                        if (exposers == null) continue;
                        exposers.remove(pidEntry);
                        if (!exposers.isEmpty()) continue;
                        this.serviceToObjectClassMap.remove(service);
                    }
                }
                for (ExtendedAttributeDefinition ad : pidEntry.getObjectClassDefinition().getAttributeMap().values()) {
                    List<RegistryEntry> uses;
                    if (ad.getService() == null || (uses = this.serviceToServicesMap.get(ad.getService())) == null) continue;
                    uses.remove(pidEntry);
                    if (!uses.isEmpty()) continue;
                    this.serviceToServicesMap.remove(ad.getService());
                }
                pidEntry.unextend(this);
                this.invalidEntryMap.remove(pid);
            }
        }
        return removedRegistryEntries;
    }

    RegistryEntry getRegistryEntry(RegistryEntry parentEntry, String childNodeName) {
        Map<String, RegistryEntry> parentMap = this.childAliasMap.get(childNodeName);
        if (parentMap == null) {
            parentMap = this.childPidMap.get(childNodeName);
        }
        if (parentMap == null) {
            return null;
        }
        while (parentEntry != null) {
            RegistryEntry childEntry = parentMap.get(parentEntry.getPid());
            if (childEntry != null) {
                return childEntry;
            }
            parentEntry = this.getRegistryEntry(parentEntry.getExtends());
        }
        return null;
    }

    RegistryEntry getRegistryEntry(ConfigElement element) {
        if (element.getParent() == null || element.childAttributeName == null) {
            return this.getRegistryEntryByPidOrAlias(element.getNodeName());
        }
        Map<String, RegistryEntry> parentMap = this.childAliasMap.get(element.childAttributeName);
        if (parentMap == null) {
            return null;
        }
        return parentMap.get(element.getParent().getNodeName());
    }

    Map<String, ExtendedAttributeDefinition> getHierarchyCompleteAttributeMap(String factoryPid) {
        RegistryEntry entry = this.getRegistryEntry(factoryPid);
        if (entry != null) {
            return entry.getAttributeMap();
        }
        return null;
    }

    Integer getAttributeCardinality(String pid, String attributeID) {
        Map<String, ExtendedAttributeDefinition> attributeMap;
        RegistryEntry ent = this.getRegistryEntryByPidOrAlias(pid);
        if (ent != null && (attributeMap = ent.getAttributeMap()) != null) {
            ExtendedAttributeDefinition id;
            ExtendedObjectClassDefinition ocd;
            if (attributeMap.containsKey(attributeID)) {
                return attributeMap.get(attributeID).getCardinality();
            }
            Map<String, RegistryEntry> map = this.childAliasMap.get(attributeID);
            if (map != null && (ent = map.get(pid)) != null && (ocd = ent.getObjectClassDefinition()) != null && (attributeMap = ocd.getAttributeMap()) != null && (id = attributeMap.get("id")).isFinal()) {
                return -1;
            }
        }
        return null;
    }

    String getAttributeName(String pid, String attributeID) {
        Map<String, ExtendedAttributeDefinition> attributeMap;
        RegistryEntry ent = this.getRegistryEntryByPidOrAlias(pid);
        if (ent != null && (attributeMap = ent.getAttributeMap()) != null && attributeMap.containsKey(attributeID)) {
            return attributeMap.get(attributeID).getName();
        }
        return null;
    }

    String getElementName(String pid) {
        ExtendedObjectClassDefinition ocd;
        RegistryEntry ent = this.getRegistryEntryByPidOrAlias(pid);
        if (ent != null && (ocd = ent.getObjectClassDefinition()) != null) {
            return ocd.getName();
        }
        return null;
    }

    List<AttributeDefinition> getRequiredAttributesForHierarchy(String factoryPid) {
        RegistryEntry entry = this.getRegistryEntry(factoryPid);
        if (entry != null) {
            ArrayList<AttributeDefinition> ads = new ArrayList<AttributeDefinition>();
            Map<String, ExtendedAttributeDefinition> attributeMap = entry.getAttributeMap();
            for (String name : entry.getRequiredAttributeNames()) {
                ads.add(attributeMap.get(name));
            }
            return ads;
        }
        return null;
    }

    RegistryEntry getRegistryEntry(String parentPid, String childNodeName) {
        Map<String, RegistryEntry> parentMap = this.childAliasMap.get(childNodeName);
        if (parentMap == null) {
            return null;
        }
        return parentMap.get(parentPid);
    }

    void missingPid(String pid) throws ConfigUpdateException {
        block0: for (Collection<RegistryEntry> entries : this.invalidEntryMap.values()) {
            for (RegistryEntry entry : entries) {
                if (!entry.getPid().equals(pid)) continue;
                String superPid = entry.getExtends();
                if (this.getRegistryEntry(superPid) != null) continue block0;
                Tr.error((TraceComponent)tc, (String)"error.missingSuper", (Object[])new Object[]{pid, superPid});
                if (!ErrorHandler.INSTANCE.fail()) continue block0;
                throw new ConfigUpdateException(Tr.formatMessage((TraceComponent)tc, (String)"error.missingSuper", (Object[])new Object[]{pid, superPid}));
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static final class RegistryEntry {
        private final String pid;
        private String rootPid;
        private final boolean factory;
        private final ExtendedObjectClassDefinition ocd;
        private final long bundleId;
        private final String bundleName;
        private boolean valid;
        private final Map<String, ExtendedAttributeDefinition> effectiveAttributes = new LinkedHashMap<String, ExtendedAttributeDefinition>();
        private final Set<String> requiredAttributeNames = new HashSet<String>();
        private List<RegistryEntry> extenders;
        private List<PidReference> referencingPids;
        private List<PidReference> referencedPids;
        private RegistryEntry extendedRegistryEntry;
        static final long serialVersionUID = 1243369296034567876L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RegistryEntry(String pid, boolean isFactory, Bundle bundle, ExtendedObjectClassDefinition ocd, MetaTypeRegistry metatypeRegistry) {
            if (pid == null) {
                throw new NullPointerException("pid");
            }
            if (bundle == null) {
                throw new NullPointerException("bundle");
            }
            if (ocd == null) {
                throw new NullPointerException("ocd");
            }
            this.bundleId = bundle.getBundleId();
            this.bundleName = bundle.getSymbolicName();
            this.pid = pid;
            this.factory = isFactory;
            this.ocd = ocd;
            if (this.ocd.getExtends() != null) {
                RegistryEntry extendedEntry = metatypeRegistry.getRegistryEntry(this.ocd.getExtends());
                if (extendedEntry != null) {
                    this.complete(extendedEntry, metatypeRegistry);
                }
            } else {
                this.valid = true;
                this.rootPid = pid;
                this.computeEffectiveAttributes(this.ocd, this.effectiveAttributes, this.requiredAttributeNames, metatypeRegistry);
            }
        }

        public void complete(RegistryEntry extendedEntry, MetaTypeRegistry metatypeRegistry) {
            if (!extendedEntry.isFactory()) {
                Tr.error((TraceComponent)tc, (String)"error.superFactoryOnly", (Object[])new Object[]{extendedEntry.getPid(), this.getPid()});
                return;
            }
            this.rootPid = extendedEntry.getRootPid();
            this.extendedRegistryEntry = extendedEntry;
            this.effectiveAttributes.putAll(extendedEntry.effectiveAttributes);
            this.requiredAttributeNames.addAll(extendedEntry.requiredAttributeNames);
            this.valid = this.computeEffectiveAttributes(this.ocd, this.effectiveAttributes, this.requiredAttributeNames, metatypeRegistry);
            if (this.valid) {
                this.valid = extendedEntry.addExtender(this, metatypeRegistry);
            }
        }

        private boolean addExtender(RegistryEntry extender, MetaTypeRegistry metatypeRegistry) {
            if (this.top().check(extender)) {
                if (this.extenders == null) {
                    this.extenders = new ArrayList<RegistryEntry>();
                }
                this.extenders.add(extender);
                return true;
            }
            return false;
        }

        private RegistryEntry top() {
            if (this.extendedRegistryEntry == null) {
                return this;
            }
            return this.extendedRegistryEntry.top();
        }

        private boolean check(RegistryEntry extender) {
            if (extender.getExtendsAlias() == null) {
                return true;
            }
            if (extender.getExtendsAlias().equals(this.getExtendsAlias())) {
                Tr.error((TraceComponent)tc, (String)"error.extendsAlias.collision", (Object[])new Object[]{extender.getPid(), this.getPid(), this.getExtendsAlias()});
                return false;
            }
            if (this.extenders != null) {
                for (RegistryEntry existing : this.extenders) {
                    if (existing.check(extender)) continue;
                    return false;
                }
            }
            return true;
        }

        private void unextend(final MetaTypeRegistry metatypeRegistry) {
            RegistryEntry extended;
            String extendsPid = this.getExtends();
            if (extendsPid != null && (extended = metatypeRegistry.getRegistryEntry(extendsPid)) != null) {
                extended.removeExtender(metatypeRegistry, this);
            }
            this.traverseHierarchyWithRoot(new EntryAction<Void>(){
                static final long serialVersionUID = -4302582588174459544L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public boolean entry(RegistryEntry registryEntry) {
                    registryEntry.effectiveAttributes.clear();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"List of effective attributes cleared for {0}", (Object[])new Object[]{registryEntry});
                    }
                    if (registryEntry.extenders != null) {
                        if (!metatypeRegistry.invalidEntryMap.containsKey(registryEntry.getPid())) {
                            metatypeRegistry.invalidEntryMap.put(registryEntry.getPid(), registryEntry.extenders);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Setting extenders to null for registry entry {0}", (Object[])new Object[]{registryEntry});
                        }
                        registryEntry.extenders = null;
                    }
                    return true;
                }

                @Override
                public Void getResult() {
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.MetaTypeRegistry$RegistryEntry$1", 1.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
                }
            });
        }

        private void removeExtender(MetaTypeRegistry metatypeRegistry, RegistryEntry extender) {
            Collection<RegistryEntry> extendersToCleanup = this.extenders;
            if (this.extenders == null) {
                extendersToCleanup = (Collection)metatypeRegistry.invalidEntryMap.get(this.getPid());
            }
            extendersToCleanup.remove(extender);
            if (extendersToCleanup.isEmpty()) {
                if (this.extenders == null) {
                    metatypeRegistry.invalidEntryMap.remove(this.getPid());
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Setting extenders to null for extender {0}", (Object[])new Object[]{extender});
                    }
                    this.extenders = null;
                }
            }
        }

        private synchronized void addReferencingEntry(PidReference ref) {
            if (ref.getReferencingEntry() == this) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Circular RegistryEntry reference detected: ", (Object[])new Object[]{this});
                }
                return;
            }
            if (this.referencingPids == null) {
                this.referencingPids = new CopyOnWriteArrayList<PidReference>();
                this.referencingPids.add(ref);
            } else if (!this.referencingPids.contains(ref)) {
                this.referencingPids.add(ref);
            }
        }

        public void addReferencedEntry(PidReference ref) {
            if (this.referencedPids == null) {
                this.referencedPids = new CopyOnWriteArrayList<PidReference>();
            }
            if (!this.referencedPids.contains(ref)) {
                this.referencedPids.add(ref);
            }
        }

        private synchronized void removeReferencingEntry(PidReference ref) {
            if (this.referencingPids != null) {
                this.referencingPids.remove(ref);
            }
        }

        synchronized List<PidReference> getReferencingEntries() {
            if (this.referencingPids == null) {
                return Collections.emptyList();
            }
            return this.referencingPids;
        }

        synchronized List<PidReference> getReferencedEntries() {
            if (this.referencedPids == null) {
                return Collections.emptyList();
            }
            return this.referencedPids;
        }

        private synchronized void removeAllReferences() {
            if (this.referencedPids != null) {
                this.referencedPids.clear();
            }
            if (this.referencingPids != null) {
                this.referencingPids.clear();
            }
        }

        public <T> T traverseHierarchyPreOrder(EntryAction<T> action) {
            this.traverseHierarchy(action, false, true);
            return action.getResult();
        }

        public <T> T traverseHierarchyWithRootPreOrder(EntryAction<T> action) {
            this.traverseHierarchy(action, true, true);
            return action.getResult();
        }

        public <T> T traverseHierarchy(EntryAction<T> action) {
            this.traverseHierarchy(action, false, false);
            return action.getResult();
        }

        public <T> T traverseHierarchyWithRoot(EntryAction<T> action) {
            this.traverseHierarchy(action, true, false);
            return action.getResult();
        }

        private <T> boolean traverseHierarchy(EntryAction<T> action, boolean includeRoot, boolean pre) {
            if (pre && includeRoot && !action.entry(this)) {
                return false;
            }
            if (this.extenders != null) {
                for (RegistryEntry extender : this.extenders) {
                    if (extender.traverseHierarchy(action, true, pre)) continue;
                    return false;
                }
            }
            if (!pre && includeRoot) {
                return action.entry(this);
            }
            return true;
        }

        private boolean computeEffectiveAttributes(ExtendedObjectClassDefinition ocd, Map<String, ExtendedAttributeDefinition> map, Set<String> requiredAttributeNames, MetaTypeRegistry metatypeRegistry) {
            HashSet<String> alreadyRenamed = new HashSet<String>();
            boolean valid = this.processAttributes(ocd.getAttributeDefinitions(1), true, map, requiredAttributeNames, alreadyRenamed, metatypeRegistry);
            return valid &= this.processAttributes(ocd.getAttributeDefinitions(2), false, map, requiredAttributeNames, alreadyRenamed, metatypeRegistry);
        }

        private boolean processAttributes(AttributeDefinition[] attrDefs, boolean required, Map<String, ExtendedAttributeDefinition> map, Set<String> requiredAttributeNames, Set<String> alreadyRenamed, MetaTypeRegistry metatypeRegistry) {
            boolean valid = true;
            if (attrDefs != null) {
                for (AttributeDefinition attrDef : attrDefs) {
                    ExtendedAttributeDefinitionImpl extendedAttrDef = new ExtendedAttributeDefinitionImpl(attrDef);
                    String key = extendedAttrDef.getID();
                    String rename = extendedAttrDef.getRename();
                    ExtendedAttributeDefinition existing = null;
                    if (rename != null) {
                        existing = map.remove(rename);
                        if (existing == null) {
                            if (alreadyRenamed.contains(rename)) {
                                Tr.error((TraceComponent)tc, (String)"error.conflicting.rename.attribute", (Object[])new Object[]{extendedAttrDef.getID(), rename, this.ocd.getID()});
                            } else {
                                Tr.error((TraceComponent)tc, (String)"error.rename.attribute.missing", (Object[])new Object[]{this.ocd.getID(), rename, extendedAttrDef.getID()});
                            }
                            valid = false;
                            continue;
                        }
                        alreadyRenamed.add(rename);
                        requiredAttributeNames.remove(rename);
                    } else {
                        existing = map.get(extendedAttrDef.getID());
                    }
                    if (existing != null) {
                        if (existing.isFinal()) {
                            RegistryEntry re = this;
                            boolean found = false;
                            block1: while (!found) {
                                AttributeDefinition[] ads;
                                if (re.getExtends() == null) {
                                    throw new IllegalStateException("should not happen: " + re.toString());
                                }
                                re = metatypeRegistry.getRegistryEntry(re.getExtends());
                                for (AttributeDefinition ad : ads = re.getObjectClassDefinition().getAttributeDefinitions(-1)) {
                                    if (!ad.getID().equals(existing.getID())) continue;
                                    found = true;
                                    continue block1;
                                }
                            }
                            Tr.error((TraceComponent)tc, (String)"error.final.override", (Object[])new Object[]{extendedAttrDef.getID(), this.pid, re.getPid()});
                            valid = false;
                            continue;
                        }
                        requiredAttributeNames.remove(existing.getID());
                    }
                    map.put(key, extendedAttrDef);
                    if (!required) continue;
                    requiredAttributeNames.add(key);
                }
            }
            return valid;
        }

        public Map<String, ExtendedAttributeDefinition> getAttributeMap() {
            return this.effectiveAttributes;
        }

        public Collection<String> getRequiredAttributeNames() {
            return this.requiredAttributeNames;
        }

        public String getDefaultId() {
            ExtendedAttributeDefinition id = this.getAttributeMap().get("id");
            if (id != null) {
                String[] values = id.getDefaultValue();
                if (values == null) {
                    return null;
                }
                if (values.length > 1) {
                    throw new IllegalStateException("The id attribute can not have multiple values");
                }
                return values[0];
            }
            return null;
        }

        @Trivial
        public String getPid() {
            return this.pid;
        }

        public String getRootPid() {
            return this.rootPid;
        }

        public String getAlias() {
            return this.ocd.getAlias();
        }

        public String getChildAlias() {
            return this.ocd.getChildAlias();
        }

        public String getExtendsAlias() {
            return this.ocd.getExtendsAlias();
        }

        public String getEffectiveAD(String ad) {
            String extendsAlias = this.getExtendsAlias();
            if (extendsAlias == null) {
                return null;
            }
            if (extendsAlias.length() == 0) {
                return ad;
            }
            if (extendsAlias.startsWith("!")) {
                return extendsAlias.substring(1);
            }
            return MessageFormat.format("{0}.{1}", ad, extendsAlias);
        }

        public ExtendedObjectClassDefinition getObjectClassDefinition() {
            return this.ocd;
        }

        public boolean isFactory() {
            return this.factory;
        }

        public boolean isSingleton() {
            return !this.factory;
        }

        long getBundleId() {
            return this.bundleId;
        }

        String getBundleName() {
            return this.bundleName;
        }

        public String getExtends() {
            return this.ocd.getExtends();
        }

        public RegistryEntry getExtendedRegistryEntry() {
            return this.extendedRegistryEntry;
        }

        public boolean supportsExtensions() {
            return this.ocd.supportsExtensions() || this.extendedRegistryEntry != null && this.extendedRegistryEntry.supportsExtensions();
        }

        boolean supportsHiddenExtensions() {
            return this.ocd.supportsHiddenExtensions();
        }

        boolean isValid() {
            return this.valid;
        }

        @Trivial
        public String toString() {
            return super.toString() + "[" + this.pid + "]";
        }

        public boolean isObscuredAttribute(final String key) {
            return this.traverseHierarchy(new EntryAction<Boolean>(){
                boolean result = false;
                static final long serialVersionUID = -1747210086421162332L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public boolean entry(RegistryEntry registryEntry) {
                    ExtendedAttributeDefinition ad = registryEntry.getAttributeMap().get(key);
                    if (ad != null && (ad.isObscured() || ad.getType() == 1003 || ad.getType() == 1008)) {
                        this.result = true;
                    }
                    return true;
                }

                @Override
                public Boolean getResult() {
                    return this.result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.MetaTypeRegistry$RegistryEntry$2", 2.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
                }
            });
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.MetaTypeRegistry$RegistryEntry", RegistryEntry.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    }

    public static interface EntryAction<T> {
        public boolean entry(RegistryEntry var1);

        public T getResult();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class ServiceUse {
        private final String service;
        private final RegistryEntry registryEntry;
        private final String attribute;
        static final long serialVersionUID = -758609386963391937L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ServiceUse(String service, RegistryEntry registryEntry, String attribute) {
            this.service = service;
            this.registryEntry = registryEntry;
            this.attribute = attribute;
        }

        public String getService() {
            return this.service;
        }

        public RegistryEntry getRegistryEntry() {
            return this.registryEntry;
        }

        public String getAttribute() {
            return this.attribute;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.MetaTypeRegistry$ServiceUse", ServiceUse.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class PidReference {
        private final RegistryEntry referencingEntry;
        private final String baseAccessor;
        private final RegistryEntry referencedEntry;
        private final boolean isParentFirst;
        static final long serialVersionUID = 4794636731061385482L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        PidReference(RegistryEntry referencedEntry, RegistryEntry referencingEntry, String ad, boolean isParentFirst) {
            this.referencedEntry = referencedEntry;
            this.referencingEntry = referencingEntry;
            this.baseAccessor = ad;
            this.isParentFirst = isParentFirst;
        }

        public String getAccessor() {
            return this.baseAccessor;
        }

        public RegistryEntry getReferencedEntry() {
            return this.referencedEntry;
        }

        public RegistryEntry getReferencingEntry() {
            return this.referencingEntry;
        }

        public boolean isParentFirst() {
            return this.isParentFirst;
        }

        @Trivial
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.baseAccessor == null ? 0 : this.baseAccessor.hashCode());
            result = 31 * result + (this.referencedEntry == null ? 0 : this.referencedEntry.getPid().hashCode());
            result = 31 * result + (this.referencingEntry == null ? 0 : this.referencingEntry.getPid().hashCode());
            return result;
        }

        @Trivial
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PidReference other = (PidReference)obj;
            if (this.baseAccessor == null ? other.baseAccessor != null : !this.baseAccessor.equals(other.baseAccessor)) {
                return false;
            }
            if (this.referencedEntry == null ? other.referencedEntry != null : !this.referencedEntry.getPid().equals(other.referencedEntry.getPid())) {
                return false;
            }
            return !(this.referencingEntry == null ? other.referencingEntry != null : !this.referencingEntry.getPid().equals(other.referencingEntry.getPid()));
        }

        @Trivial
        public String toString() {
            return super.toString() + "[parent: " + this.referencingEntry.getPid() + ", child: " + this.referencedEntry.getPid() + ", accessed by: " + this.getAccessor() + (this.isParentFirst ? ", parent-first" : ", child-first") + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.MetaTypeRegistry$PidReference", PidReference.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    }
}

