/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.Constants;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.H2HttpInboundLinkWrap;
import com.ibm.ws.http.channel.h2internal.H2MuxTCPReadCallback;
import com.ibm.ws.http.channel.h2internal.H2MuxTCPWriteCallback;
import com.ibm.ws.http.channel.h2internal.H2RateState;
import com.ibm.ws.http.channel.h2internal.H2StreamProcessor;
import com.ibm.ws.http.channel.h2internal.H2VirtualConnectionImpl;
import com.ibm.ws.http.channel.h2internal.H2WorkQInterface;
import com.ibm.ws.http.channel.h2internal.H2WriteQEntry;
import com.ibm.ws.http.channel.h2internal.H2WriteTree;
import com.ibm.ws.http.channel.h2internal.StreamState;
import com.ibm.ws.http.channel.h2internal.exceptions.FlowControlException;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderTable;
import com.ibm.ws.http.channel.h2internal.priority.Node;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundChannel;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class H2InboundLink
extends HttpInboundLink {
    private static final TraceComponent tc = Tr.register(H2InboundLink.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    LINK_STATUS linkStatus = LINK_STATUS.INIT;
    private ScheduledFuture<?> closeFuture = null;
    private H2ConnectionTimeout connTimeout = null;
    Object linkStatusSync = new Object(){};
    READ_LINK_STATUS readLinkStatus = READ_LINK_STATUS.NOT_READING;
    Object readLinkStatusSync = new Object(){};
    private int configuredInactivityTimeout = 0;
    private long lastWriteTime = 0L;
    private int OutstandingWriteCount = 0;
    private final Object OutstandingWriteCountSync = new Object(){};
    private final int closeWaitForWritesWatchDogTimer = 5000;
    private final int closeWaitForReadWatchDogTimer = 5000;
    private final int STREAM_CLOSE_DELAY = 2000;
    private int highestClientStreamId = 0;
    private int highestLocalStreamId = -1;
    private int goawayPromisedStreamId = 0;
    private int openPushStreams = 0;
    private final Object streamOpenCloseSync = new Object(){};
    private int activeClientStreams = 0;
    private final Object streamCounterSync = new Object(){};
    boolean connection_preface_sent = false;
    boolean connection_preface_string_rcvd = false;
    public volatile CountDownLatch initLock = new CountDownLatch(1){};
    volatile long initialWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    volatile long connectionReadWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    private final Object readWindowSync = new Object(){};
    volatile long maxReadWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    FrameReadProcessor frameReadProcessor = null;
    H2MuxTCPReadCallback h2MuxReadCallback = null;
    TCPReadRequestContext h2MuxTCPReadContext = null;
    H2MuxTCPWriteCallback h2MuxWriteCallback = null;
    TCPWriteRequestContext h2MuxTCPWriteContext = null;
    WsByteBuffer slicedBuffer = null;
    ConcurrentHashMap<Integer, H2StreamProcessor> streamTable = new ConcurrentHashMap();
    ConcurrentLinkedQueue<H2StreamProcessor> closedStreams = new ConcurrentLinkedQueue();
    HttpInboundLink initialHttpInboundLink = null;
    VirtualConnection initialVC = null;
    HttpInboundChannel httpInboundChannel = null;
    TCPConnectionContext h2MuxTCPConnectionContext = null;
    HttpInboundServiceContextImpl h2MuxServiceContextImpl = null;
    private H2ConnectionSettings localConnectionSettings;
    private H2ConnectionSettings remoteConnectionSettings;
    H2WorkQInterface writeQ = null;
    int h2NextPromisedStreamId = 0;
    private String authority = null;
    private H2HeaderTable readContextTable = null;
    private H2HeaderTable writeContextTable = null;
    HttpChannelConfig config = null;
    private int readStackDepthCount = 0;
    private static final int READ_STACK_DEPTH_LIMIT = 64;
    int hcDebug = 0;
    private boolean continuationFrameExpected = false;
    private boolean writeContinuationFrameExpected = false;
    private final Object oneTimeEntrySync = new Object(){};
    private boolean oneTimeEntry = false;
    private final H2RateState rateState = new H2RateState();
    private boolean freeBufferOnError = false;

    public H2RateState getH2RateState() {
        return this.rateState;
    }

    public boolean isContinuationExpected() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isContinuationExpected: " + this.continuationFrameExpected), (Object[])new Object[0]);
        }
        return this.continuationFrameExpected;
    }

    public void setContinuationExpected(boolean expected) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setContinuationExpected: " + expected), (Object[])new Object[0]);
        }
        this.continuationFrameExpected = expected;
    }

    public boolean isWriteContinuationExpected() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isWriteContinuationExpected: " + this.writeContinuationFrameExpected), (Object[])new Object[0]);
        }
        return this.writeContinuationFrameExpected;
    }

    public void setWriteContinuationExpected(boolean expected) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setWriteContinuationExpected: " + expected), (Object[])new Object[0]);
        }
        this.writeContinuationFrameExpected = expected;
    }

    public H2InboundLink(HttpInboundChannel channel, VirtualConnection vc, TCPConnectionContext tcc) {
        super(channel, vc);
        this.initialVC = vc;
        this.httpInboundChannel = channel;
        this.frameReadProcessor = new FrameReadProcessor(this);
        this.h2MuxReadCallback = new H2MuxTCPReadCallback();
        this.h2MuxWriteCallback = new H2MuxTCPWriteCallback();
        this.h2MuxReadCallback.setConnLinkCallback(this);
        this.h2MuxTCPConnectionContext = tcc;
        this.h2MuxTCPReadContext = tcc.getReadInterface();
        this.h2MuxTCPWriteContext = tcc.getWriteInterface();
        this.config = channel.getHttpConfig();
        this.localConnectionSettings = new H2ConnectionSettings();
        this.localConnectionSettings.setMaxConcurrentStreams(this.config.getH2MaxConcurrentStreams());
        this.localConnectionSettings.setMaxFrameSize(this.config.getH2MaxFrameSize());
        this.configuredInactivityTimeout = this.config.getH2ConnectionIdleTimeout();
        this.remoteConnectionSettings = new H2ConnectionSettings();
        this.h2MuxServiceContextImpl = (HttpInboundServiceContextImpl)this.getChannelAccessor();
        this.connectionReadWindowSize = this.maxReadWindowSize = (long)this.config.getH2ConnReadWindowSize();
        this.writeQ = new H2WriteTree();
        this.writeQ.init(this.h2MuxTCPWriteContext, this.h2MuxWriteCallback);
        this.readContextTable = new H2HeaderTable();
        this.writeContextTable = new H2HeaderTable();
        this.hcDebug = ((Object)((Object)this)).hashCode();
        this.initialVC.getStateMap().put("UpgradedWebConnectionNeedsClose", "true");
        this.initialVC.getStateMap().put("h2_frame_size", this.getRemoteConnectionSettings().getMaxFrameSize());
    }

    public synchronized long getInitialWindowSize() {
        return this.initialWindowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H2StreamProcessor createNewInboundLink(Integer streamID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createNewInboundLink entry: stream-id: " + streamID), (Object[])new Object[0]);
        }
        if (streamID % 2 == 0 && streamID != 0) {
            Object object = this.streamOpenCloseSync;
            synchronized (object) {
                int maxPushStreams = this.getRemoteConnectionSettings().getMaxConcurrentStreams();
                if (maxPushStreams >= 0 && this.openPushStreams > maxPushStreams) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("createNewInboundLink cannot open a new push stream; maximum number of open push streams reached" + this.openPushStreams), (Object[])new Object[0]);
                    }
                    return null;
                }
                ++this.openPushStreams;
            }
        }
        H2VirtualConnectionImpl h2VC = new H2VirtualConnectionImpl(this.initialVC);
        h2VC.getStateMap().remove("HttpDispatcherLink");
        H2HttpInboundLinkWrap link = new H2HttpInboundLinkWrap(this.httpInboundChannel, h2VC, streamID, this);
        H2StreamProcessor stream = new H2StreamProcessor(streamID, link, this);
        this.writeQ.addNewNodeToQ(streamID, Node.ROOT_STREAM_ID, Node.DEFAULT_NODE_PRIORITY, false);
        this.streamTable.put(streamID, stream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createNewInboundLink exit: returning stream: " + streamID + " " + stream), (Object[])new Object[0]);
        }
        return stream;
    }

    public TCPConnectionContext getTCPConnectionContext() {
        return this.h2MuxTCPConnectionContext;
    }

    public void processConnectionPrefaceMagic() throws Http2Exception {
        this.connection_preface_string_rcvd = true;
        H2StreamProcessor controlStream = this.createNewInboundLink(0);
        controlStream.completeConnectionPreface();
        this.connection_preface_sent = true;
    }

    @Override
    public void ready(VirtualConnection inVC) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ready called illegally!", (Object[])new Object[0]);
        }
    }

    @Override
    protected void processRequest() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"processRequest called illegally!", (Object[])new Object[0]);
        }
    }

    public boolean handleHTTP2DirectConnect(HttpInboundLink link) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2DirectConnect entry", (Object[])new Object[0]);
        }
        this.initialHttpInboundLink = link;
        Integer streamID = new Integer(0);
        H2VirtualConnectionImpl h2VC = new H2VirtualConnectionImpl(this.initialVC);
        h2VC.getStateMap().remove("HttpDispatcherLink");
        H2HttpInboundLinkWrap wrap = new H2HttpInboundLinkWrap(this.httpInboundChannel, h2VC, streamID, this);
        H2StreamProcessor streamProcessor = new H2StreamProcessor(streamID, wrap, this, StreamState.OPEN);
        this.streamTable.put(streamID, streamProcessor);
        this.writeQ.addNewNodeToQ(streamID, Node.ROOT_STREAM_ID, Node.DEFAULT_NODE_PRIORITY, false);
        this.setDeviceLink((ConnectionLink)this.myTSC);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2DirectConnect, exit", (Object[])new Object[0]);
        }
        return true;
    }

    public boolean handleHTTP2UpgradeRequest(Map<String, String> headers, HttpInboundLink link) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest entry", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest, sending 101 response", (Object[])new Object[0]);
        }
        link.getHTTPContext().send101SwitchingProtocol("h2c");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest, sent 101 response", (Object[])new Object[0]);
        }
        Integer streamID = new Integer(1);
        H2VirtualConnectionImpl h2VC = new H2VirtualConnectionImpl(this.initialVC);
        h2VC.getStateMap().remove("HttpDispatcherLink");
        H2HttpInboundLinkWrap wrap = new H2HttpInboundLinkWrap(this.httpInboundChannel, h2VC, streamID, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest, creating stream processor", (Object[])new Object[0]);
        }
        H2StreamProcessor streamProcessor = new H2StreamProcessor(streamID, wrap, this, StreamState.HALF_CLOSED_REMOTE);
        this.incrementActiveClientStreams();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleHTTP2UpgradeRequest, created stream processor : " + streamProcessor), (Object[])new Object[0]);
        }
        this.writeQ.addNewNodeToQ(streamID, Node.ROOT_STREAM_ID, Node.DEFAULT_NODE_PRIORITY, false);
        this.streamTable.put(streamID, streamProcessor);
        this.highestClientStreamId = streamID;
        this.goawayPromisedStreamId = streamID;
        streamID = 0;
        streamProcessor = new H2StreamProcessor(streamID, wrap, this, StreamState.OPEN);
        this.streamTable.put(streamID, streamProcessor);
        String settings = headers.get("HTTP2-Settings");
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("handleHTTP2UpgradeRequest, processing upgrade header settings : " + settings), (Object[])new Object[0]);
            }
            this.getRemoteConnectionSettings().processUpgradeHeaderSettings(settings);
        }
        catch (Http2Exception e1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest an error occurred processing the settings during connection initialization", (Object[])new Object[0]);
            }
            return false;
        }
        this.initialHttpInboundLink = link;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleHTTP2UpgradeRequest, reinit the link : " + (Object)((Object)link)), (Object[])new Object[0]);
        }
        link.reinit(wrap.getConnectionContext(), wrap.getVirtualConnection(), wrap);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest, exit", (Object[])new Object[0]);
        }
        return true;
    }

    protected void updateHighestStreamId(int proposedHighestStreamId) throws ProtocolException {
        if ((proposedHighestStreamId & 1) == 0) {
            if (proposedHighestStreamId > this.highestLocalStreamId) {
                this.highestLocalStreamId = proposedHighestStreamId;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("highestLocalStreamId set to stream-id: " + proposedHighestStreamId), (Object[])new Object[0]);
                }
            } else if (proposedHighestStreamId < this.highestLocalStreamId) {
                throw new ProtocolException("received a new stream with a lower ID than previous; current stream-id: " + proposedHighestStreamId + " highest stream-id: " + this.highestLocalStreamId);
            }
        } else if (proposedHighestStreamId > this.highestClientStreamId) {
            this.highestClientStreamId = proposedHighestStreamId;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("highestClientStreamId set to stream-id: " + proposedHighestStreamId), (Object[])new Object[0]);
            }
        } else if (proposedHighestStreamId < this.highestClientStreamId) {
            throw new ProtocolException("received a new stream with a lower ID than previous; current stream-id: " + proposedHighestStreamId + " highest stream-id: " + this.highestClientStreamId);
        }
    }

    protected void updateGoawayPromisedStreamId(int id) {
        this.goawayPromisedStreamId = id;
    }

    protected int getGoawayPromisedStreamId() {
        return this.goawayPromisedStreamId;
    }

    public void startAsyncRead(boolean newFrame) {
        this.startAsyncRead(newFrame, this.configuredInactivityTimeout);
    }

    protected boolean getFreeBufferOnError() {
        return this.freeBufferOnError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAsyncRead(boolean newFrame, int readTimeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("startAsyncRead entry; newframe = " + newFrame + " readTimeout: " + readTimeout), (Object[])new Object[0]);
        }
        if (newFrame) {
            this.frameReadProcessor.reset(true);
        }
        this.freeBufferOnError = false;
        if (this.slicedBuffer == null) {
            WsByteBufferPoolManager mgr = HttpDispatcher.getBufferManager();
            WsByteBuffer buf = mgr.allocate(8192);
            this.h2MuxTCPReadContext.setBuffer(buf);
            this.freeBufferOnError = true;
            boolean forceQueue = true;
            int numBytes = 1;
            this.readStackDepthCount = 0;
            Object object = this.readLinkStatusSync;
            synchronized (object) {
                this.readLinkStatus = READ_LINK_STATUS.READ_OUTSTANDING;
            }
            try {
                int timeout = -1;
                if (readTimeout != 0) {
                    timeout = readTimeout;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"startAsyncRead do read on channel below ", (Object[])new Object[0]);
                }
                this.h2MuxTCPReadContext.read((long)numBytes, (TCPReadCompletedCallback)this.h2MuxReadCallback, forceQueue, timeout);
            }
            catch (Throwable up) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("startAsyncRead read caught throwable: " + up), (Object[])new Object[0]);
                }
                buf.release();
                this.setReadLinkStatusToNotReadingAndNotify();
                throw up;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("startAsyncRead reading slicedBuffer length: " + this.slicedBuffer.limit()), (Object[])new Object[0]);
        }
        this.slicedBuffer.position(this.slicedBuffer.limit());
        this.h2MuxTCPReadContext.setBuffer(this.slicedBuffer);
        this.slicedBuffer = null;
        if (this.readStackDepthCount < 64) {
            ++this.readStackDepthCount;
            this.h2MuxReadCallback.complete(this.initialVC, this.h2MuxTCPReadContext);
        } else {
            ExecutorService executorService = CHFWBundle.getExecutorService();
            AsyncCallback ac = new AsyncCallback();
            this.readStackDepthCount = 0;
            executorService.execute(ac);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"startAsyncRead exit", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setReadLinkStatusToNotReadingAndNotify() {
        Object object = this.readLinkStatusSync;
        synchronized (object) {
            this.readLinkStatus = READ_LINK_STATUS.NOT_READING;
            this.readLinkStatusSync.notify();
        }
    }

    public void processRead(VirtualConnection vc, TCPReadRequestContext rrc) {
        this.processRead(vc, rrc, this.configuredInactivityTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRead(VirtualConnection vc, TCPReadRequestContext rrc, int readTimeout) {
        boolean readForNewFrame = true;
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processRead: :linkStatus: " + (Object)((Object)this.linkStatus) + " H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
            }
            if (this.linkStatus == LINK_STATUS.CLOSING || this.linkStatus == LINK_STATUS.GOAWAY_SENDING) {
                return;
            }
            if (this.closeFuture != null) {
                boolean result = this.closeFuture.cancel(false);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processRead: closeFuture detected while processing a read :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                if (!result) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processRead: could not cancel closeFuture :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processRead: cancelled successful, remove closeFuture :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                this.closeFuture = null;
                this.connTimeout = null;
            }
        }
        int frameReadStatus = 0;
        WsByteBuffer nextBuffer = rrc.getBuffer();
        nextBuffer.flip();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processRead: next buffer length: " + nextBuffer.limit()), (Object[])new Object[0]);
            }
            if ((frameReadStatus = this.frameReadProcessor.processNextBuffer(nextBuffer)) == -2) {
                readForNewFrame = false;
            } else {
                if (frameReadStatus > 0) {
                    int oldPosition = nextBuffer.position();
                    this.slicedBuffer = nextBuffer.position(frameReadStatus).slice();
                    nextBuffer.position(oldPosition);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processRead: process complete frame", (Object[])new Object[0]);
                }
                this.frameReadProcessor.processCompleteFrame();
            }
        }
        catch (Http2Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processRead: an error occurred processing a frame: " + e.getErrorString()), (Object[])new Object[0]);
            }
            this.close(vc, e);
        }
        finally {
            boolean doRead = false;
            Object object2 = this.linkStatusSync;
            synchronized (object2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processRead: check to arm read: :linkStatus: " + (Object)((Object)this.linkStatus) + " H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                if (this.linkStatus != LINK_STATUS.CLOSING && this.linkStatus != LINK_STATUS.GOAWAY_SENDING) {
                    doRead = true;
                }
            }
            if (doRead) {
                this.startAsyncRead(readForNewFrame, readTimeout);
            }
        }
    }

    public H2StreamProcessor getStreamProcessor(Integer sID) {
        H2StreamProcessor p = null;
        p = this.streamTable.get(sID);
        return p;
    }

    public void destroy() {
        this.httpInboundChannel.stop(50L);
        this.initialVC = null;
        this.frameReadProcessor = null;
        this.h2MuxReadCallback = null;
        this.h2MuxTCPConnectionContext = null;
        this.h2MuxTCPReadContext = null;
        this.h2MuxTCPWriteContext = null;
        this.localConnectionSettings = null;
        this.remoteConnectionSettings = null;
        this.readContextTable = null;
        this.writeContextTable = null;
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReadsAndWritesToClear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("waitForReadsAndWritesToClear - wait for reads to clear. :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
        }
        Object object = this.readLinkStatusSync;
        synchronized (object) {
            if (this.readLinkStatus == READ_LINK_STATUS.READ_OUTSTANDING) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("waitForReadsAndWritesToClear - cancel outstanding read. :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                this.h2MuxTCPReadContext.read(1L, null, true, -2);
                try {
                    this.readLinkStatusSync.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("waitForReadsAndWritesToClear - wait for writes to clear. :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
        }
        object = this.OutstandingWriteCountSync;
        synchronized (object) {
            if (this.OutstandingWriteCount > 0) {
                try {
                    this.OutstandingWriteCountSync.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSync(WsByteBuffer buf, WsByteBuffer[] bufs, long numBytes, int timeout, FrameTypes fType, int payloadLength, int streamID) throws IOException, FlowControlException {
        Object object;
        H2WorkQInterface.WRITE_ACTION action = H2WorkQInterface.WRITE_ACTION.NOT_SET;
        if (buf != null && bufs != null) {
            IOException up = new IOException("Internal error - incorrect buffers specified");
            throw up;
        }
        LINK_STATUS up = this.linkStatus;
        synchronized (up) {
            if (this.linkStatus == LINK_STATUS.CLOSING) {
                FlowControlException up2 = new FlowControlException("Connection Closing");
                throw up2;
            }
            object = this.OutstandingWriteCountSync;
            synchronized (object) {
                ++this.OutstandingWriteCount;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("writeSync - incremented write count to: " + this.OutstandingWriteCount + " H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
            }
        }
        try {
            H2WriteQEntry e = new H2WriteQEntry(buf, bufs, numBytes, timeout, fType, payloadLength, streamID);
            e.armWriteCompleteLatch();
            action = this.writeQ.writeOrAddToQ(e);
            if (action == H2WorkQInterface.WRITE_ACTION.QUEUED) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"writeSync - call entry.waitWriteCompleteLatch", (Object[])new Object[0]);
                }
                e.waitWriteCompleteLatch();
            }
            if (this.configuredInactivityTimeout != 0) {
                object = this.OutstandingWriteCountSync;
                synchronized (object) {
                    this.lastWriteTime = System.nanoTime();
                }
            }
            if (e.getIOException() != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("writeSync - IOException recived while writing: " + e), (Object[])new Object[0]);
                }
                throw e.getIOException();
            }
        }
        finally {
            Object object2 = this.OutstandingWriteCountSync;
            synchronized (object2) {
                --this.OutstandingWriteCount;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("writeSync - decremented write count to: " + this.OutstandingWriteCount + " lastWriteTime: " + this.lastWriteTime + " H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                if (this.OutstandingWriteCount == 0) {
                    this.OutstandingWriteCountSync.notify();
                }
            }
        }
    }

    public synchronized int getNextPromisedStreamId() {
        this.h2NextPromisedStreamId += 2;
        return this.h2NextPromisedStreamId;
    }

    public H2HeaderTable getReadTable() {
        return this.readContextTable;
    }

    public H2HeaderTable getWriteTable() {
        return this.writeContextTable;
    }

    public H2WorkQInterface getWorkQ() {
        return this.writeQ;
    }

    public void incrementConnectionWindowUpdateLimit(int x) throws FlowControlException {
        if (!this.checkIfGoAwaySendingOrClosing()) {
            this.writeQ.incrementConnectionWindowUpdateLimit(x);
            for (Integer i : this.streamTable.keySet()) {
                H2StreamProcessor stream = this.streamTable.get(i);
                if (stream == null) continue;
                stream.connectionWindowSizeUpdated();
            }
        }
    }

    public synchronized void changeInitialWindowSizeAllStreams(int newSize) throws FlowControlException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("changeInitialWindowSizeAllStreams entry: newSize: " + newSize), (Object[])new Object[0]);
        }
        this.initialWindowSize = newSize;
        for (Integer i : this.streamTable.keySet()) {
            H2StreamProcessor stream = this.streamTable.get(i);
            stream.updateInitialWindowsUpdateSize(newSize);
        }
    }

    public H2ConnectionSettings getLocalConnectionSettings() {
        return this.localConnectionSettings;
    }

    public H2ConnectionSettings getRemoteConnectionSettings() {
        return this.remoteConnectionSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"destroy entry", (Object[])new Object[0]);
        }
        for (Integer i : this.streamTable.keySet()) {
            H2StreamProcessor stream;
            H2StreamProcessor h2StreamProcessor = stream = this.streamTable.get(i);
            synchronized (h2StreamProcessor) {
                stream.notifyAll();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("destroying " + stream + ", " + stream.getId()), (Object[])new Object[0]);
            }
            if (stream.getId() == 0) continue;
            stream.getWrappedInboundLink().destroy(e);
        }
        this.initialVC = null;
        this.frameReadProcessor = null;
        this.h2MuxReadCallback = null;
        this.h2MuxTCPConnectionContext = null;
        this.h2MuxTCPReadContext = null;
        this.h2MuxTCPWriteContext = null;
        this.localConnectionSettings = null;
        this.remoteConnectionSettings = null;
        this.readContextTable = null;
        this.writeContextTable = null;
        super.destroy(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStatusLinkToGoAwaySending() {
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (this.linkStatus != LINK_STATUS.CLOSING) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setStatusLinkToGoAwaySending: setting :linkStatus: to GOAWAY_SENDING:close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                this.linkStatus = LINK_STATUS.GOAWAY_SENDING;
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setStatusLinkToGoAwaySending: return without setting status since :linkstatus: is " + (Object)((Object)this.linkStatus) + " :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
            }
            return false;
        }
    }

    public void closeConnectionLink(Exception exceptionForCloseFromHere) {
        this.closeConnectionLink(exceptionForCloseFromHere, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnectionLink(Exception exceptionForCloseFromHere, boolean attemptGoAway) {
        block36: {
            Object object = this.oneTimeEntrySync;
            synchronized (object) {
                if (this.oneTimeEntry) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: re-entered so exiting :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                    }
                    return;
                }
                this.oneTimeEntry = true;
            }
            object = this.linkStatusSync;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: :linkstatus: is: " + (Object)((Object)this.linkStatus) + " :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                if (this.linkStatus == LINK_STATUS.CLOSING) {
                    return;
                }
            }
            HttpDispatcherLink hdLink = (HttpDispatcherLink)this.initialVC.getStateMap().get("HttpDispatcherLink");
            if (hdLink != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("HttpDispatcherLink found: " + hdLink), (Object[])new Object[0]);
                }
                try {
                    hdLink.close(this.initialVC, exceptionForCloseFromHere);
                }
                catch (Exception consume) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block36;
                    Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: consuming exception: " + consume), (Object[])new Object[0]);
                }
            }
        }
        Object consume = this.linkStatusSync;
        synchronized (consume) {
            if (this.closeFuture != null && !this.closeFuture.isDone()) {
                boolean closeFutureCancel = this.closeFuture.cancel(false);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: closeFuture.cancel returned: " + closeFutureCancel + " :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
            }
            if (!attemptGoAway) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: close the device link now. setting :linkStatus: to CLOSING :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                this.linkStatus = LINK_STATUS.CLOSING;
            }
        }
        if (attemptGoAway) {
            block37: {
                try {
                    this.streamTable.get(0).sendGOAWAYFrame(new Http2Exception(exceptionForCloseFromHere.getMessage()));
                }
                catch (Http2Exception x) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block37;
                    Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: exeception received while sending GOAWAY :close: H2InboundLink hc: " + this.hcDebug + " " + x), (Object[])new Object[0]);
                }
            }
            Object x = this.linkStatusSync;
            synchronized (x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: close the device link now after sending GOAWAY. setting :linkStatus: to CLOSING :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                this.linkStatus = LINK_STATUS.CLOSING;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: tell WriteQ to Draing an quit. :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
        }
        this.writeQ.setToQuit(true);
        this.waitForReadsAndWritesToClear();
        ConnectionLink deviceLink = this.initialHttpInboundLink.getDeviceLink();
        if (deviceLink != null) {
            try {
                deviceLink.close(this.initialVC, exceptionForCloseFromHere);
            }
            catch (Exception x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: could not close, :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode() + " device link close caught: " + x), (Object[])new Object[0]);
                    StringBuffer sb = new StringBuffer();
                    StackTraceElement[] trace = x.getStackTrace();
                    for (int i = 0; i < trace.length; ++i) {
                        sb.append(" " + trace[i] + "\r\n");
                    }
                    sb.append("");
                    String s = sb.toString();
                    Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: " + s), (Object[])new Object[0]);
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("closeConnectionLink: could not close, device link was null :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfGoAwaySendingOrClosing() {
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (this.linkStatus != LINK_STATUS.CLOSING && this.linkStatus != LINK_STATUS.GOAWAY_SENDING) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkifGoAwaySending() returning false :linkstatus: " + (Object)((Object)this.linkStatus)), (Object[])new Object[0]);
                }
                return false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkifGoAwaySending() returning true :linkstatus: " + (Object)((Object)this.linkStatus)), (Object[])new Object[0]);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkInitAndOpen() {
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (this.linkStatus == LINK_STATUS.INIT) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkInitAndOpen: connection preface completed, set :linkStatus: to OPEN H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                this.linkStatus = LINK_STATUS.OPEN;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(VirtualConnection inVC, Exception e) {
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close(vc,e): :linkstatus: is: " + (Object)((Object)this.linkStatus) + " :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode() + "exception: " + e), (Object[])new Object[0]);
            }
            if (this.linkStatus == LINK_STATUS.CLOSING || this.linkStatus == LINK_STATUS.GOAWAY_SENDING || this.linkStatus == LINK_STATUS.WAIT_TO_SEND_GOAWAY) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("close(vc,e): returning: close of muxLink is being done on a differnt thread :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                }
                return;
            }
            if (e == null) {
                for (Integer i : this.streamTable.keySet()) {
                    H2StreamProcessor stream = this.streamTable.get(i);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("close(vc,e): looking at stream: " + stream.getId()), (Object[])new Object[0]);
                    }
                    if (stream.getId() != 0 && !stream.isHalfClosed() && !stream.isStreamClosed() && this.highestLocalStreamId > -1) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("close(vc,e): stream not ready to close: " + stream.getId() + " :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
                    }
                    return;
                }
            }
            this.linkStatus = LINK_STATUS.WAIT_TO_SEND_GOAWAY;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close(vc,e): loading up the wait to close timeout :close: H2InboundLink hc: " + ((Object)((Object)this)).hashCode()), (Object[])new Object[0]);
            }
            ScheduledExecutorService scheduler = CHFWBundle.getScheduledExecutorService();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close : scheduler : " + scheduler + " config : " + this.config), (Object[])new Object[0]);
            }
            this.connTimeout = new H2ConnectionTimeout(e);
            if (e == null) {
                this.closeFuture = scheduler.schedule(this.connTimeout, this.config.getH2ConnCloseTimeout(), TimeUnit.SECONDS);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("close(vc,e): close on link called with exception: " + e), (Object[])new Object[0]);
                }
                this.connTimeout.run();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("close(vc,e): initLock count is : " + this.initLock.getCount()), (Object[])new Object[0]);
                }
                if (0L < this.initLock.getCount()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"close(vc,e): wake up the initLock countDownLatch", (Object[])new Object[0]);
                    }
                    this.initLock.countDown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveClientStreams() {
        Object object = this.streamCounterSync;
        synchronized (object) {
            return this.activeClientStreams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementActiveClientStreams() {
        Object object = this.streamCounterSync;
        synchronized (object) {
            ++this.activeClientStreams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementActiveClientStreams() {
        Object object = this.streamCounterSync;
        synchronized (object) {
            --this.activeClientStreams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStream(H2StreamProcessor p) {
        Object object = this.streamOpenCloseSync;
        synchronized (object) {
            if (p.getId() != 0) {
                this.writeQ.removeNodeFromQ(p.getId());
                this.closedStreams.add(p);
                if (p.getId() % 2 == 0) {
                    --this.openPushStreams;
                } else {
                    this.decrementActiveClientStreams();
                }
            }
            long currentTime = System.currentTimeMillis();
            while (this.closedStreams.peek() != null && currentTime - this.closedStreams.peek().getCloseTime() > 2000L) {
                this.streamTable.remove(((H2StreamProcessor)this.closedStreams.remove()).getId());
            }
        }
    }

    public H2StreamProcessor getStream(int streamID) {
        H2StreamProcessor streamProcessor = null;
        streamProcessor = this.streamTable.get(streamID);
        return streamProcessor;
    }

    public int getHighestClientStreamId() {
        return this.highestClientStreamId;
    }

    public int getHighestServerStreamId() {
        return this.highestLocalStreamId;
    }

    protected void setAuthority(String a) {
        this.authority = a;
    }

    public String getAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLastWriteTime() {
        Object object = this.OutstandingWriteCountSync;
        synchronized (object) {
            return this.lastWriteTime;
        }
    }

    protected int getconfiguredInactivityTimeout() {
        return this.configuredInactivityTimeout;
    }

    protected Object getReadWindowSync() {
        return this.readWindowSync;
    }

    private class H2ConnectionTimeout
    implements Runnable {
        private final Exception e;

        public H2ConnectionTimeout(Exception inE) {
            this.e = inE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = H2InboundLink.this.linkStatusSync;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("H2ConnectionTimeout-run: timeout has elapsed, look to close connection. :linkStatus: " + (Object)((Object)H2InboundLink.this.linkStatus) + " :close: H2InboundLink hc: " + H2InboundLink.this.hcDebug), (Object[])new Object[0]);
                }
                if (H2InboundLink.this.linkStatus != LINK_STATUS.WAIT_TO_SEND_GOAWAY) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("H2ConnectionTimeout-run: timeout too late - close being handled on another thread :close: H2InboundLink hc: " + H2InboundLink.this.hcDebug), (Object[])new Object[0]);
                    }
                    return;
                }
                H2InboundLink.this.linkStatus = LINK_STATUS.GOAWAY_SENDING;
            }
            try {
                if (this.e instanceof IOException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("H2ConnectionTimeout-run: IOException encountered, close immediately :close: H2InboundLink hc: " + H2InboundLink.this.hcDebug), (Object[])new Object[0]);
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("H2ConnectionTimeout-run: sending GOAWAY Frame :close: H2InboundLink hc: " + H2InboundLink.this.hcDebug), (Object[])new Object[0]);
                    }
                    if (this.e == null) {
                        H2InboundLink.this.streamTable.get(0).sendGOAWAYFrame(new Http2Exception("the http2 connection has timed out"));
                    } else if (this.e instanceof Http2Exception) {
                        H2InboundLink.this.streamTable.get(0).sendGOAWAYFrame((Http2Exception)this.e);
                    } else {
                        H2InboundLink.this.streamTable.get(0).sendGOAWAYFrame(new Http2Exception(this.e.getMessage()));
                    }
                }
            }
            catch (Exception x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("H2ConnectionTimeout-run: exeception received while sending GOAWAY:  :close: H2InboundLink hc: " + H2InboundLink.this.hcDebug + " " + x), (Object[])new Object[0]);
                }
            }
            finally {
                H2InboundLink.this.closeConnectionLink(this.e);
            }
        }
    }

    protected class AsyncCallback
    implements Runnable {
        protected AsyncCallback() {
        }

        @Override
        public void run() {
            block3: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"doing async callback internally on a new thread", (Object[])new Object[0]);
                }
                try {
                    H2InboundLink.this.h2MuxReadCallback.complete(H2InboundLink.this.initialVC, H2InboundLink.this.h2MuxTCPReadContext);
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("caught a Throwable. log and leave: " + t), (Object[])new Object[0]);
                }
            }
        }
    }

    public static enum READ_LINK_STATUS {
        NOT_READING,
        READ_OUTSTANDING;

    }

    public static enum LINK_STATUS {
        INIT,
        OPEN,
        WAIT_TO_SEND_GOAWAY,
        GOAWAY_SENDING,
        CLOSING;

    }
}

