/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.TypeResolver;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.FetchSchemaDirectiveWiring;
import graphql.schema.idl.NoopWiringFactory;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaGeneratorPostProcessing;
import graphql.schema.idl.TypeRuntimeWiring;
import graphql.schema.idl.WiringFactory;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

@PublicApi
public class RuntimeWiring {
    private final Map<String, Map<String, DataFetcher>> dataFetchers;
    private final Map<String, DataFetcher> defaultDataFetchers;
    private final Map<String, GraphQLScalarType> scalars;
    private final Map<String, TypeResolver> typeResolvers;
    private final Map<String, SchemaDirectiveWiring> registeredDirectiveWiring;
    private final List<SchemaDirectiveWiring> directiveWiring;
    private final WiringFactory wiringFactory;
    private final Map<String, EnumValuesProvider> enumValuesProviders;
    private final Collection<SchemaGeneratorPostProcessing> schemaGeneratorPostProcessings;
    private final GraphqlFieldVisibility fieldVisibility;
    private final GraphQLCodeRegistry codeRegistry;
    private final GraphqlTypeComparatorRegistry comparatorRegistry;

    private RuntimeWiring(Builder builder) {
        this.dataFetchers = builder.dataFetchers;
        this.defaultDataFetchers = builder.defaultDataFetchers;
        this.scalars = builder.scalars;
        this.typeResolvers = builder.typeResolvers;
        this.registeredDirectiveWiring = builder.registeredDirectiveWiring;
        this.directiveWiring = builder.directiveWiring;
        this.wiringFactory = builder.wiringFactory;
        this.enumValuesProviders = builder.enumValuesProviders;
        this.schemaGeneratorPostProcessings = builder.schemaGeneratorPostProcessings;
        this.fieldVisibility = builder.fieldVisibility;
        this.codeRegistry = builder.codeRegistry;
        this.comparatorRegistry = builder.comparatorRegistry;
    }

    public static Builder newRuntimeWiring() {
        return new Builder();
    }

    public GraphQLCodeRegistry getCodeRegistry() {
        return this.codeRegistry;
    }

    public Map<String, GraphQLScalarType> getScalars() {
        return new LinkedHashMap<String, GraphQLScalarType>(this.scalars);
    }

    public Map<String, Map<String, DataFetcher>> getDataFetchers() {
        return this.dataFetchers;
    }

    public Map<String, DataFetcher> getDataFetcherForType(String typeName) {
        return this.dataFetchers.computeIfAbsent(typeName, k -> new LinkedHashMap());
    }

    public DataFetcher getDefaultDataFetcherForType(String typeName) {
        return this.defaultDataFetchers.get(typeName);
    }

    public Map<String, TypeResolver> getTypeResolvers() {
        return this.typeResolvers;
    }

    public Map<String, EnumValuesProvider> getEnumValuesProviders() {
        return this.enumValuesProviders;
    }

    public WiringFactory getWiringFactory() {
        return this.wiringFactory;
    }

    public GraphqlFieldVisibility getFieldVisibility() {
        return this.fieldVisibility;
    }

    public Map<String, SchemaDirectiveWiring> getRegisteredDirectiveWiring() {
        return this.registeredDirectiveWiring;
    }

    public List<SchemaDirectiveWiring> getDirectiveWiring() {
        return this.directiveWiring;
    }

    public Collection<SchemaGeneratorPostProcessing> getSchemaGeneratorPostProcessings() {
        return this.schemaGeneratorPostProcessings;
    }

    public GraphqlTypeComparatorRegistry getComparatorRegistry() {
        return this.comparatorRegistry;
    }

    @PublicApi
    public static class Builder {
        private final Map<String, Map<String, DataFetcher>> dataFetchers = new LinkedHashMap<String, Map<String, DataFetcher>>();
        private final Map<String, DataFetcher> defaultDataFetchers = new LinkedHashMap<String, DataFetcher>();
        private final Map<String, GraphQLScalarType> scalars = new LinkedHashMap<String, GraphQLScalarType>();
        private final Map<String, TypeResolver> typeResolvers = new LinkedHashMap<String, TypeResolver>();
        private final Map<String, EnumValuesProvider> enumValuesProviders = new LinkedHashMap<String, EnumValuesProvider>();
        private final Map<String, SchemaDirectiveWiring> registeredDirectiveWiring = new LinkedHashMap<String, SchemaDirectiveWiring>();
        private final List<SchemaDirectiveWiring> directiveWiring = new ArrayList<SchemaDirectiveWiring>();
        private final Collection<SchemaGeneratorPostProcessing> schemaGeneratorPostProcessings = new ArrayList<SchemaGeneratorPostProcessing>();
        private WiringFactory wiringFactory = new NoopWiringFactory();
        private GraphqlFieldVisibility fieldVisibility = DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
        private GraphQLCodeRegistry codeRegistry = GraphQLCodeRegistry.newCodeRegistry().build();
        private GraphqlTypeComparatorRegistry comparatorRegistry = GraphqlTypeComparatorRegistry.AS_IS_REGISTRY;

        private Builder() {
            ScalarInfo.STANDARD_SCALARS.forEach(this::scalar);
            this.registeredDirectiveWiring.put("fetch", new FetchSchemaDirectiveWiring());
        }

        public Builder wiringFactory(WiringFactory wiringFactory) {
            Assert.assertNotNull(wiringFactory, "You must provide a wiring factory", new Object[0]);
            this.wiringFactory = wiringFactory;
            return this;
        }

        public Builder codeRegistry(GraphQLCodeRegistry codeRegistry) {
            this.codeRegistry = Assert.assertNotNull(codeRegistry);
            return this;
        }

        public Builder codeRegistry(GraphQLCodeRegistry.Builder codeRegistry) {
            this.codeRegistry = Assert.assertNotNull(codeRegistry).build();
            return this;
        }

        public Builder scalar(GraphQLScalarType scalarType) {
            this.scalars.put(scalarType.getName(), scalarType);
            return this;
        }

        public Builder fieldVisibility(GraphqlFieldVisibility fieldVisibility) {
            this.fieldVisibility = Assert.assertNotNull(fieldVisibility);
            return this;
        }

        public Builder type(TypeRuntimeWiring.Builder builder) {
            return this.type(builder.build());
        }

        public Builder type(String typeName, UnaryOperator<TypeRuntimeWiring.Builder> builderFunction) {
            TypeRuntimeWiring.Builder builder = (TypeRuntimeWiring.Builder)builderFunction.apply(TypeRuntimeWiring.newTypeWiring(typeName));
            return this.type(builder.build());
        }

        public Builder type(TypeRuntimeWiring typeRuntimeWiring) {
            EnumValuesProvider enumValuesProvider;
            String typeName = typeRuntimeWiring.getTypeName();
            Map typeDataFetchers = this.dataFetchers.computeIfAbsent(typeName, k -> new LinkedHashMap());
            typeRuntimeWiring.getFieldDataFetchers().forEach(typeDataFetchers::put);
            this.defaultDataFetchers.put(typeName, typeRuntimeWiring.getDefaultDataFetcher());
            TypeResolver typeResolver = typeRuntimeWiring.getTypeResolver();
            if (typeResolver != null) {
                this.typeResolvers.put(typeName, typeResolver);
            }
            if ((enumValuesProvider = typeRuntimeWiring.getEnumValuesProvider()) != null) {
                this.enumValuesProviders.put(typeName, enumValuesProvider);
            }
            return this;
        }

        public Builder directive(String directiveName, SchemaDirectiveWiring schemaDirectiveWiring) {
            this.registeredDirectiveWiring.put(directiveName, schemaDirectiveWiring);
            return this;
        }

        public Builder directiveWiring(SchemaDirectiveWiring schemaDirectiveWiring) {
            this.directiveWiring.add(schemaDirectiveWiring);
            return this;
        }

        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            this.comparatorRegistry = comparatorRegistry;
            return this;
        }

        public Builder transformer(SchemaGeneratorPostProcessing schemaGeneratorPostProcessing) {
            this.schemaGeneratorPostProcessings.add(Assert.assertNotNull(schemaGeneratorPostProcessing));
            return this;
        }

        public RuntimeWiring build() {
            return new RuntimeWiring(this);
        }
    }
}

