/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.KeyAlgorithmChecker;
import com.ibm.ws.security.common.jwk.impl.JWKProvider;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.internal.JwtConfigUtil;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.webcontainer.security.jwk.JSONWebKey;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import javax.management.DynamicMBean;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JwtConfig.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.security.jwt.builder"}, name="jwtConfig", property={"service.vendor=IBM"})
public class JwtComponent
implements JwtConfig {
    private static final TraceComponent tc = Tr.register(JwtComponent.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private String issuer = null;
    private String issuerUrl = null;
    private long valid;
    private long expiresInSeconds;
    private boolean isJwkEnabled;
    private boolean jti;
    private List<String> audiences;
    private String sigAlg;
    private List<String> claims;
    private String scope;
    private String sharedKey;
    private String keyStoreRef;
    private String trustStoreRef;
    private String keyAlias;
    private String trustedAlias;
    private long jwkRotationTime;
    private int jwkSigningKeySize;
    private long elapsedNbfTime;
    private PublicKey publicKey = null;
    private PrivateKey privateKey = null;
    private JWKProvider jwkProvider = null;
    private DynamicMBean httpsendpointInfoMBean;
    private DynamicMBean httpendpointInfoMBean;
    private ServerInfoMBean serverInfoMBean;
    private List<String> amrAttributes;
    private final KeyAlgorithmChecker keyAlgChecker = new KeyAlgorithmChecker();
    static final long serialVersionUID = -8894093627755180727L;

    @Reference(target="(jmx.objectname=WebSphere:feature=channelfw,type=endpoint,name=defaultHttpEndpoint)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        this.httpendpointInfoMBean = endpointInfoMBean;
    }

    protected void unsetEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        if (this.httpendpointInfoMBean == endpointInfoMBean) {
            this.httpendpointInfoMBean = null;
        }
    }

    @Reference(target="(jmx.objectname=WebSphere:feature=channelfw,type=endpoint,name=defaultHttpEndpoint-ssl)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setHttpsEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        this.httpsendpointInfoMBean = endpointInfoMBean;
    }

    protected void unsetHttpsEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        if (this.httpsendpointInfoMBean == endpointInfoMBean) {
            this.httpsendpointInfoMBean = null;
        }
    }

    @Reference(target="(jmx.objectname=WebSphere:feature=kernel,name=ServerInfo)", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setServerInfoMBean(ServerInfoMBean serverInfoMBean) {
        this.serverInfoMBean = serverInfoMBean;
    }

    protected void unsetServerInfoMBean(ServerInfoMBean serverInfoMBean) {
        if (this.serverInfoMBean == serverInfoMBean) {
            this.serverInfoMBean = null;
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties, ComponentContext cc) {
        this.process(properties);
    }

    @Modified
    protected void modify(Map<String, Object> properties) {
        this.process(properties);
    }

    @Deactivate
    protected void deactivate(int reason, ComponentContext cc) {
    }

    private void process(Map<String, Object> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        this.issuer = JwtUtils.trimIt((String)props.get("id"));
        this.issuerUrl = JwtUtils.trimIt((String)props.get("issuer"));
        this.isJwkEnabled = (Boolean)props.get("jwkEnabled");
        this.jti = (Boolean)props.get("jti");
        this.valid = (Long)props.get("expiry");
        this.expiresInSeconds = (Long)props.get("expiresInSeconds");
        this.sigAlg = JwtUtils.trimIt((String)props.get("signatureAlgorithm"));
        this.audiences = JwtUtils.trimIt((String[])props.get("audiences"));
        this.scope = JwtUtils.trimIt((String)props.get("scope"));
        this.claims = JwtUtils.trimIt((String[])props.get("claims"));
        this.sharedKey = JwtConfigUtil.processProtectedString(props, "sharedKey");
        this.keyStoreRef = JwtUtils.trimIt((String)props.get("keyStoreRef"));
        this.keyAlias = JwtUtils.trimIt((String)props.get("keyAlias"));
        this.trustStoreRef = JwtUtils.trimIt((String)props.get("trustStoreRef"));
        this.trustedAlias = JwtUtils.trimIt((String)props.get("trustedAlias"));
        this.jwkRotationTime = (Long)props.get("jwkRotationTime");
        this.jwkRotationTime = this.jwkRotationTime * 60L * 1000L;
        this.jwkSigningKeySize = ((Long)props.get("jwkSigningKeySize")).intValue();
        this.elapsedNbfTime = (Long)props.get("elapsedNBF");
        this.amrAttributes = JwtUtils.trimIt((String[])props.get("amrInclude"));
        if (this.isJwkCapableSigAlgorithm()) {
            this.initializeJwkProvider(this);
        }
        this.valid = this.expiresInSeconds > -1L ? this.expiresInSeconds : (this.valid *= 3600L);
    }

    private boolean isJwkCapableSigAlgorithm() {
        if (this.sigAlg == null) {
            return false;
        }
        return this.keyAlgChecker.isRSAlgorithm(this.sigAlg) || this.keyAlgChecker.isESAlgorithm(this.sigAlg);
    }

    private void initializeJwkProvider(JwtConfig jwtConfig) {
        if (jwtConfig == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No config object found", (Object[])new Object[0]);
            }
            return;
        }
        if (jwtConfig.isJwkEnabled()) {
            this.jwkProvider = new JWKProvider(jwtConfig.getJwkSigningKeySize(), jwtConfig.getSignatureAlgorithm(), jwtConfig.getJwkRotationTime());
        }
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getId() {
        return this.issuer;
    }

    @Override
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    @Override
    public long getValidTime() {
        return this.valid;
    }

    @Override
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    public String getSignatureAlgorithm() {
        return this.sigAlg;
    }

    @Override
    public List<String> getClaims() {
        return this.claims;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public boolean getJti() {
        return this.jti;
    }

    @Override
    public String getTrustStoreRef() {
        return this.trustStoreRef;
    }

    @Override
    public String getKeyStoreRef() {
        return this.keyStoreRef;
    }

    @Override
    public String getKeyAlias() {
        return this.keyAlias;
    }

    @Override
    public String getTrustedAlias() {
        return this.trustedAlias;
    }

    @Override
    @Sensitive
    public String getSharedKey() {
        return this.sharedKey;
    }

    @Override
    public String getJwkJsonString() {
        if (!this.isJwkEnabled() && this.jwkProvider == null) {
            try {
                this.privateKey = JwtUtils.getPrivateKey(this.keyAlias, this.keyStoreRef);
                this.publicKey = JwtUtils.getPublicKey(this.keyAlias, this.keyStoreRef);
            }
            catch (KeyStoreException keyStoreException) {
                FFDCFilter.processException((Throwable)keyStoreException, (String)"com.ibm.ws.security.jwt.internal.JwtComponent", (String)"301", (Object)this, (Object[])new Object[0]);
            }
            catch (CertificateException certificateException) {
                FFDCFilter.processException((Throwable)certificateException, (String)"com.ibm.ws.security.jwt.internal.JwtComponent", (String)"303", (Object)this, (Object[])new Object[0]);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.internal.JwtComponent", (String)"305", (Object)this, (Object[])new Object[0]);
            }
            if (this.publicKey != null && this.privateKey != null) {
                this.jwkProvider = new JWKProvider(this.getJwkSigningKeySize(), this.getSignatureAlgorithm(), this.getJwkRotationTime(), this.publicKey, this.privateKey);
            }
        }
        return this.jwkProvider != null ? this.jwkProvider.getJwkSetString() : null;
    }

    @Override
    public JSONWebKey getJSONWebKey() {
        return this.jwkProvider != null ? this.jwkProvider.getJWK() : null;
    }

    @Override
    public long getJwkRotationTime() {
        return this.jwkRotationTime;
    }

    @Override
    public int getJwkSigningKeySize() {
        return this.jwkSigningKeySize;
    }

    @Override
    public boolean isJwkEnabled() {
        return this.isJwkEnabled;
    }

    @Override
    public String getResolvedHostAndPortUrl() {
        if (this.httpsendpointInfoMBean != null) {
            try {
                String host = this.resolveHost((String)this.httpsendpointInfoMBean.getAttribute("Host"));
                int port = (Integer)this.httpsendpointInfoMBean.getAttribute("Port");
                return "https://" + host + ":" + port;
            }
            catch (Exception host) {
                FFDCFilter.processException((Throwable)host, (String)"com.ibm.ws.security.jwt.internal.JwtComponent", (String)"344", (Object)this, (Object[])new Object[0]);
            }
        }
        if (this.httpendpointInfoMBean != null) {
            try {
                String host = this.resolveHost((String)this.httpendpointInfoMBean.getAttribute("Host"));
                int port = (Integer)this.httpendpointInfoMBean.getAttribute("Port");
                return "http://" + host + ":" + port;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.internal.JwtComponent", (String)"353", (Object)this, (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public long getElapsedNbfTime() {
        return this.elapsedNbfTime;
    }

    protected String resolveHost(String host) {
        if ("*".equals(host)) {
            if (this.serverInfoMBean != null) {
                host = this.serverInfoMBean.getDefaultHostname();
                if (host == null || host.equals("localhost")) {
                    host = this.getLocalHostIpAddress();
                }
            } else {
                host = this.getLocalHostIpAddress();
            }
        }
        return host == null || host.trim().isEmpty() ? "localhost" : host;
    }

    protected String getLocalHostIpAddress() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                static final long serialVersionUID = -1428599966923050645L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getHostAddress();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.internal.JwtComponent$1", 1.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.jwt.internal.JwtComponent", (String)"405", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    @Override
    public List<String> getAMRAttributes() {
        return this.amrAttributes;
    }
}

