/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.jwt.InvalidTokenException;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.KeyAlgorithmChecker;
import com.ibm.ws.security.common.jwk.impl.JWKProvider;
import com.ibm.ws.security.common.jwk.impl.JwkKidBuilder;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.internal.BuilderImpl;
import com.ibm.ws.security.jwt.internal.JwtTokenException;
import com.ibm.ws.security.jwt.utils.JwtDataConfig;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.webcontainer.security.jwk.JSONWebKey;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import org.jose4j.keys.HmacKey;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwtData {
    private static final TraceComponent tc = Tr.register(JwtData.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private static final String SIGNATURE_ALG_HS256 = "HS256";
    private static final String SIGNATURE_ALG_RS256 = "RS256";
    private static final String SIGNATURE_ALG_NONE = "none";
    public static final String TYPE_JWT_TOKEN = "Json Web Token";
    boolean bIdToken = false;
    boolean bJwtToken = false;
    private Key _signingKey = null;
    private String _keyId = null;
    JwtConfig jwtConfig = null;
    JwtDataConfig jwtDataConfig = null;
    String tokenType = "Json Web Token";
    JWKProvider jwkProvider = null;
    String signatureAlgorithm = null;
    JwtTokenException noKeyException = null;
    private final KeyAlgorithmChecker keyAlgChecker = new KeyAlgorithmChecker();
    static final long serialVersionUID = 3344461220527799599L;

    public JwtData(BuilderImpl jwtBuilder, JwtConfig jwtConfig, String tokenType) throws JwtTokenException {
        this.jwtConfig = jwtConfig;
        this.tokenType = tokenType;
        this.signatureAlgorithm = jwtBuilder.getAlgorithm();
        this.bJwtToken = TYPE_JWT_TOKEN.equals(tokenType);
        String sharedKey = jwtBuilder.getSharedKey();
        sharedKey = JwtUtils.isNullEmpty(sharedKey) ? jwtConfig.getSharedKey() : sharedKey;
        this.jwtDataConfig = new JwtDataConfig(jwtBuilder.getAlgorithm(), jwtConfig.getJSONWebKey(), sharedKey, jwtBuilder.getKey(), jwtConfig.getKeyAlias(), jwtConfig.getKeyStoreRef(), tokenType, jwtConfig.isJwkEnabled());
        this.initSigningKey(this.jwtDataConfig);
    }

    public JwtData(JwtDataConfig config) throws JwtTokenException {
        this.tokenType = config.tokenType;
        this.jwtDataConfig = config;
        this.signatureAlgorithm = config.signatureAlgorithm;
        this.bJwtToken = TYPE_JWT_TOKEN.equals(this.tokenType);
        this.initSigningKey(this.jwtDataConfig);
    }

    public JwtConfig getConfig() {
        return this.jwtConfig;
    }

    @FFDCIgnore(value={Exception.class})
    protected void initSigningKey(JwtDataConfig config) throws JwtTokenException {
        String keyType = "x509";
        try {
            if (this.isJwkSignatureAlgorithmType(config)) {
                this.initSigningKeyUsingJwk(config);
            } else if (this.keyAlgChecker.isHSAlgorithm(this.signatureAlgorithm)) {
                this.initSigningKeyUsingHSAlgorithm(config);
            } else if (this.isSignatureAlgorithmUsingKeyStore()) {
                this.initSigningKeyUsingKeyStore(config, keyType);
            }
        }
        catch (Exception e) {
            Object[] objs = new Object[]{this.signatureAlgorithm, this.jwtDataConfig.isJwkEnabled, e.getLocalizedMessage()};
            JwtTokenException jte = JwtTokenException.newInstance(false, "JWT_NO_SIGNING_KEY_WITH_ERROR", objs);
            jte.initCause(e);
            throw jte;
        }
        if (this._signingKey == null && !this.signatureAlgorithm.equals(SIGNATURE_ALG_NONE)) {
            Object[] objs = new Object[]{this.signatureAlgorithm, this.jwtDataConfig.isJwkEnabled, ""};
            throw JwtTokenException.newInstance(true, "JWT_NO_SIGNING_KEY_WITH_ERROR", objs);
        }
    }

    boolean isJwkSignatureAlgorithmType(JwtDataConfig config) {
        return config.isJwkEnabled && (this.keyAlgChecker.isRSAlgorithm(config.signatureAlgorithm) || this.keyAlgChecker.isESAlgorithm(config.signatureAlgorithm));
    }

    boolean isSignatureAlgorithmUsingKeyStore() {
        return this.keyAlgChecker.isRSAlgorithm(this.signatureAlgorithm) || this.keyAlgChecker.isESAlgorithm(this.signatureAlgorithm);
    }

    void initSigningKeyUsingJwk(JwtDataConfig config) {
        JSONWebKey jwk;
        String keyType = "jwk";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JWK + RS256 Signing key type is " + keyType), (Object[])new Object[0]);
        }
        if ((jwk = config.jwk) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Did not succcessfully build a JWK", (Object[])new Object[0]);
            }
            this._signingKey = null;
            this._keyId = null;
        } else {
            this._signingKey = jwk.getPrivateKey();
            this._keyId = jwk.getKeyID();
        }
    }

    void initSigningKeyUsingHSAlgorithm(JwtDataConfig config) throws UnsupportedEncodingException {
        String sharedKey;
        String keyType = "shared secret";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("hs256 Signing key type is " + keyType), (Object[])new Object[0]);
        }
        this._signingKey = (sharedKey = config.sharedKey) != null && !sharedKey.isEmpty() ? new HmacKey(sharedKey.getBytes("UTF-8")) : null;
    }

    void initSigningKeyUsingKeyStore(JwtDataConfig config, String keyType) throws KeyStoreException, CertificateException, InvalidTokenException {
        this._signingKey = config.signingKey;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Signing key type is " + keyType), (Object[])new Object[0]);
        }
        if (this._signingKey == null) {
            String keyAlias = null;
            String keyStoreRef = null;
            keyAlias = config.keyAlias;
            keyStoreRef = config.keyStoreRef;
            this._signingKey = JwtUtils.getPrivateKey(keyAlias, keyStoreRef);
            this._keyId = this.buildKidFromPublicKey(JwtUtils.getPublicKey(keyAlias, keyStoreRef));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Key alias: " + keyAlias + ", Keystore: " + keyStoreRef + ", kid: " + this._keyId), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("RSAPrivateKey: " + (this._signingKey instanceof RSAPrivateKey)), (Object[])new Object[0]);
        }
        if (!this.keyAlgChecker.isPrivateKeyValidType(this._signingKey, this.signatureAlgorithm)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"clear _signingKey and _keyId", (Object[])new Object[0]);
            }
            this._signingKey = null;
            this._keyId = null;
        }
    }

    private String buildKidFromPublicKey(PublicKey cert) {
        JwkKidBuilder kidbuilder = new JwkKidBuilder();
        return kidbuilder.buildKeyId(cert);
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Sensitive
    public JwtData(Key key, String id) {
        this._signingKey = key;
        this._keyId = id;
    }

    @Sensitive
    public Key getSigningKey() {
        return this._signingKey;
    }

    public String getKeyID() {
        return this._keyId;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public JwtTokenException getNoKeyException() {
        if (this.noKeyException != null) {
            return this.noKeyException;
        }
        return new JwtTokenException("No signing key found");
    }

    public boolean isJwt() {
        return this.bJwtToken;
    }
}

